/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.swing;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.Store;
import com.floreantpos.model.TableStatus;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.services.TicketService;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.PasswordEntryDialog;
import java.awt.Color;
import java.util.Date;
import javax.swing.BorderFactory;
import org.apache.commons.lang.StringUtils;

public class ShopTableButton
extends PosButton {
    private ShopTable shopTable;
    private User user;
    private Ticket ticket;
    int pressedX;
    int pressedY;

    public ShopTableButton(ShopTable shopTable) {
        this.shopTable = shopTable;
        this.putClientProperty("Plastic.is3D", false);
        this.setBorder(BorderFactory.createLineBorder(new Color(150, 0, 0, 127), 1, true));
        this.setBounds(shopTable.getX(), shopTable.getY(), TerminalConfig.getFloorButtonWidth(), TerminalConfig.getFloorButtonHeight());
        this.setBackground(shopTable.getFloor().getForegroundColor());
        this.update();
    }

    public int getId() {
        return this.shopTable.getId();
    }

    public void setShopTable(ShopTable shopTable) {
        this.shopTable = shopTable;
    }

    public ShopTable getShopTable() {
        return this.shopTable;
    }

    public String getTicketId() {
        return this.shopTable.getTicketId();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ShopTableButton)) {
            return false;
        }
        ShopTableButton that = (ShopTableButton)obj;
        return this.shopTable.equals(that.shopTable);
    }

    public int hashCode() {
        return this.shopTable.hashCode();
    }

    @Override
    public String toString() {
        return this.shopTable.toString();
    }

    public void update() {
        this.update(DataProvider.get().getStore());
    }

    public void update(Store store) {
        int priSize = PosUIManager.getSize(store.getTablePrimaryFontSize());
        int secFontSize = PosUIManager.getSize(store.getTableSecondaryFontSize());
        Color seatForeColor = store.getTableSeatForeColor();
        Color seatBgColor = store.getTableSeatBGColor();
        Color servingForeColor = store.getTableServingForeColor();
        Color servingBgColor = store.getTableServingBGColor();
        Color bookForeColor = store.getTableBookForeColor();
        Color bookBgColor = store.getTableBookBGColor();
        Color freeForeColor = store.getTableFreeForeColor();
        Color freeBgColor = store.getTableFreeBGColor();
        this.setBackground(freeBgColor);
        this.setForeground(freeForeColor);
        String ticketId = this.shopTable.getTicketId();
        StringBuilder buttonInfo = new StringBuilder("<html><center>");
        this.appendBookingInfo(store, secFontSize, buttonInfo);
        this.appendTableNumber(store, priSize, buttonInfo);
        this.appendTokenNumber(store, secFontSize, buttonInfo, ticketId);
        this.appendTableStatusAndShopTableColor(store, secFontSize, seatForeColor, seatBgColor, servingForeColor, servingBgColor, bookForeColor, bookBgColor, buttonInfo);
        this.appendServerInfo(store, secFontSize, seatForeColor, seatBgColor, buttonInfo, ticketId);
        this.appendCustomerName(store, secFontSize, buttonInfo);
        this.appendShopTableStatus(secFontSize, buttonInfo);
        buttonInfo.append("</center></html>");
        this.setText(buttonInfo.toString());
        this.setBounds(this.shopTable.getX(), this.shopTable.getY(), PosUIManager.getSize(store.getTableBtnWidth()), PosUIManager.getSize(store.getTableBtnHeight()));
    }

    private void appendTableNumber(Store store, int priSize, StringBuilder buttonInfo) {
        buttonInfo.append(String.format("<div style='font-size: %spx; font-weight: bold;'>", priSize));
        buttonInfo.append(this.shopTable.getNameOrNumber());
        buttonInfo.append("</div>");
    }

    private void appendBookingInfo(Store store, int secFontSize, StringBuilder buttonInfo) {
        String reservationNo;
        if (this.shopTable.getCurrentBookingId() != null && store.isShowResIdOnTable() && StringUtils.isNotEmpty((String)(reservationNo = this.shopTable.getProperty("RES_NO")))) {
            reservationNo = reservationNo.substring(4, reservationNo.length());
            StringBuilder reservationInfo = new StringBuilder(reservationNo);
            reservationInfo.insert(2, '-');
            int margin = 0;
            int padding = 0;
            if (!this.shopTable.getTableStatus().equals((Object)TableStatus.Serving)) {
                margin = 16;
                padding = 15;
            }
            buttonInfo.append(String.format("<div style='font-size: %spx; margin-top: -%spx; padding-bottom: -%spx;'>", secFontSize, PosUIManager.getSize(margin), PosUIManager.getSize(padding)));
            buttonInfo.append(String.format("R# %s", reservationInfo.toString()));
            buttonInfo.append("</div>");
        }
    }

    private void appendTokenNumber(Store store, int secFontSize, StringBuilder buttonInfo, String ticketId) {
        if (StringUtils.isNotEmpty((String)ticketId) && store.isShowTokenNumberOnTable()) {
            buttonInfo.append(String.format("<div style='font-size: %spx;'>", secFontSize));
            buttonInfo.append(String.format(Messages.getString("ShopTableButton.7") + "#: %s", this.shopTable.getTicketShortId()));
            buttonInfo.append("</div>");
        }
    }

    private void appendTableStatusAndShopTableColor(Store store, int secFontSize, Color seatForeColor, Color seatBgColor, Color servingForeColor, Color servingBgColor, Color bookForeColor, Color bookBgColor, StringBuilder buttonInfo) {
        if (this.shopTable.getTableStatus().equals((Object)TableStatus.Booked)) {
            if (store.isShowTableStatusOnTable()) {
                buttonInfo.append(String.format("<div style='font-size: %spx;'>", secFontSize));
                buttonInfo.append(POSConstants.BOOKED);
                buttonInfo.append("</div>");
            }
            this.setEnabled(true);
            this.setOpaque(true);
            this.setBackground(bookBgColor);
            this.setForeground(bookForeColor);
        } else if (this.shopTable.getTableStatus().equals((Object)TableStatus.Seat)) {
            if (store.isShowTableStatusOnTable()) {
                buttonInfo.append(String.format("<div style='font-size: %spx;'>", secFontSize));
                buttonInfo.append(POSConstants.SEAT);
                buttonInfo.append("</div>");
            }
            this.setEnabled(true);
            this.setOpaque(true);
            this.setBackground(seatBgColor);
            this.setForeground(seatForeColor);
        } else if (this.shopTable.getTableStatus().equals((Object)TableStatus.Serving)) {
            if (store.isShowTableStatusOnTable()) {
                buttonInfo.append(String.format("<div style='font-size: %spx;'>", secFontSize));
                buttonInfo.append(POSConstants.SERVING);
                buttonInfo.append("</div>");
            }
            this.setBackground(servingBgColor);
            this.setForeground(servingForeColor);
        }
    }

    private void appendShopTableStatus(int secFontSize, StringBuilder buttonInfo) {
        Date ticketCreateTime = this.shopTable.getTicketCreateTime();
        if (ticketCreateTime != null && !this.shopTable.isShowStatus()) {
            buttonInfo.append(String.format("<div style='font-size: %spx;'>", secFontSize));
            buttonInfo.append(DateUtil.getElapsedTime(ticketCreateTime, new Date()));
            buttonInfo.append("</div>");
        } else if (this.shopTable.isShowStatus()) {
            int availableCap = this.shopTable.getCapacity() - this.shopTable.getGuestNumber();
            buttonInfo.append(String.format("<div style='font-size: %spx;'>", secFontSize));
            buttonInfo.append(String.format(Messages.getString("ShopTableButton.19") + ": %s", availableCap));
            buttonInfo.append("</div>");
            buttonInfo.append(String.format("<div style='font-size: %spx;'>", secFontSize));
            buttonInfo.append(String.format(Messages.getString("ShopTableButton.23") + ": %s", this.shopTable.getCapacity()));
            buttonInfo.append("</div>");
        }
    }

    private void appendCustomerName(Store store, int secFontSize, StringBuilder buttonInfo) {
        String customerName = this.shopTable.getCustomerName();
        if (StringUtils.isNotEmpty((String)customerName) && store.isShowCustomerNameOnTable()) {
            buttonInfo.append(String.format("<div style='font-size: %spx;'>", secFontSize));
            buttonInfo.append(String.format(Messages.getString("ShopTableButton.27") + ": %s", customerName));
            buttonInfo.append("</div>");
        }
    }

    private void appendServerInfo(Store store, int secFontSize, Color seatForeColor, Color seatBgColor, StringBuilder buttonInfo, String ticketId) {
        if (ticketId != null && StringUtils.isNotEmpty((String)this.shopTable.getUserId())) {
            User currentUser;
            if (store.isShowServerNameOnTable()) {
                buttonInfo.append(String.format("<div style='font-size: %spx;'>", secFontSize));
                buttonInfo.append(String.format(Messages.getString("ShopTableButton.31") + ": %s", this.shopTable.getUserName()));
                buttonInfo.append("</div>");
            }
            if ((currentUser = Application.getCurrentUser()) == null) {
                return;
            }
            if (!currentUser.getId().equals(this.shopTable.getUserId())) {
                if (this.shopTable.getShopTableStatus().hasMultipleTickets()) {
                    this.setBackground(seatBgColor != null ? seatBgColor : new Color(255, 102, 102));
                    this.setForeground(seatForeColor != null ? seatForeColor : Color.BLACK);
                } else {
                    this.setBackground(new Color(139, 0, 139));
                    this.setForeground(Color.WHITE);
                }
            }
        }
    }

    public void setUser(User user) {
        if (user != null) {
            this.user = user;
        }
    }

    public User getUser() {
        return this.user;
    }

    public boolean hasUserAccess() {
        String ticketUserId;
        if (this.shopTable.getShopTableStatus().hasMultipleTickets()) {
            return true;
        }
        if (this.user == null) {
            return true;
        }
        User currentUser = Application.getCurrentUser();
        String currentUserId = currentUser.getId();
        if (currentUserId.equals(ticketUserId = this.user.getId())) {
            return true;
        }
        if (currentUser.hasPermission(UserPermission.PERFORM_MANAGER_TASK) || currentUser.hasPermission(UserPermission.PERFORM_ADMINISTRATIVE_TASK)) {
            return true;
        }
        String password = PasswordEntryDialog.show(Application.getPosWindow(), Messages.getString("PosAction.0"));
        if (StringUtils.isEmpty((String)password)) {
            return false;
        }
        String inputUserId = UserDAO.getInstance().findUserBySecretKey(password).getId();
        if (inputUserId.equals(this.user.getId())) {
            POSMessageDialog.showError(Application.getPosWindow(), "Incorrect password");
            return false;
        }
        return true;
    }

    public void initializeUser() {
        String userId = this.shopTable.getUserId();
        if (StringUtils.isEmpty((String)userId)) {
            return;
        }
        if (this.user != null && this.user.getId().equals(userId)) {
            return;
        }
        this.user = UserDAO.getInstance().get(this.shopTable.getUserId());
    }

    public void initializeTicket() {
        String ticketId = this.shopTable.getTicketId();
        if (StringUtils.isEmpty((String)ticketId)) {
            return;
        }
        if (this.shopTable.getTicketId() == null) {
            return;
        }
        if (this.ticket != null && this.ticket.getId().equals(ticketId)) {
            return;
        }
        this.ticket = TicketService.getTicket(this.shopTable.getTicketId());
    }

    public Ticket getTicket() {
        return this.ticket;
    }

    public void setTicket(Ticket ticket) {
        this.ticket = ticket;
    }
}

