/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.swing;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;

public class VerticalTouchScrollPanel
extends JPanel
implements MouseListener,
MouseMotionListener {
    private int lastY;
    private int distY;
    private double speedY;
    private boolean scroll = false;
    private boolean dragged = false;

    public VerticalTouchScrollPanel() {
    }

    public VerticalTouchScrollPanel(LayoutManager layout) {
        super(layout);
    }

    public boolean wasDragged() {
        return this.dragged;
    }

    private JScrollPane getParentScrollPane(Component p) {
        if (p instanceof JScrollPane) {
            return (JScrollPane)p;
        }
        if (p == null) {
            return null;
        }
        return this.getParentScrollPane(p.getParent());
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        JScrollPane scrollPane = this.getParentScrollPane(this.getParent());
        if (scrollPane != null) {
            JScrollBar vbar = scrollPane.getVerticalScrollBar();
            int currentY = e.getYOnScreen();
            this.distY = this.lastY - currentY;
            this.dragged = true;
            if (this.scroll) {
                int vScroll = this.distY + vbar.getValue();
                vbar.setValue(vScroll);
                if (Math.abs(this.distY) > 1) {
                    this.speedY = this.distY + this.distY;
                }
            }
            this.lastY = currentY;
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() == 1) {
            this.lastY = e.getYOnScreen();
            this.scroll = true;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getButton() == 1) {
            this.scroll = false;
        }
        if (Math.abs(this.speedY) <= 4.0) {
            return;
        }
        JScrollPane scrollPane = this.getParentScrollPane(this.getParent());
        if (scrollPane != null) {
            JScrollBar vbar = scrollPane.getVerticalScrollBar();
            int max = vbar.getMaximum();
            double brakingforce = 1.04;
            for (int count = 1000; count > 0; --count) {
                int val;
                this.speedY /= brakingforce;
                if (Math.abs(this.speedY) < 1.5) {
                    brakingforce = 1.02;
                }
                if (Math.abs(this.speedY) < 1.0 || (val = vbar.getValue()) < 0 || val > max) break;
                vbar.setValue((int)this.speedY + val);
                if (!this.dragged) continue;
                e.consume();
                this.dragged = false;
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public Component add(Component comp) {
        this.addListener(comp);
        return super.add(comp);
    }

    @Override
    public void add(Component comp, Object constraints) {
        this.addListener(comp);
        this.addImpl(comp, constraints, -1);
    }

    @Override
    public void removeAll() {
        if (this.getComponentCount() > 0) {
            for (int i = 0; i < this.getComponentCount(); ++i) {
                Component component = this.getComponent(i);
                this.removeListener(component);
            }
        }
        super.removeAll();
    }

    @Override
    public void remove(Component comp) {
        this.removeListener(comp);
        super.remove(comp);
    }

    private void addListener(Component comp) {
        JPanel panel;
        comp.addMouseListener(this);
        comp.addMouseMotionListener(this);
        if (comp instanceof JPanel && (panel = (JPanel)comp).getComponentCount() > 0) {
            for (int i = 0; i < panel.getComponentCount(); ++i) {
                Component component = panel.getComponent(i);
                this.addListener(component);
            }
        }
    }

    private void removeListener(Component comp) {
        JPanel panel;
        comp.removeMouseListener(this);
        comp.removeMouseMotionListener(this);
        if (comp instanceof JPanel && (panel = (JPanel)comp).getComponentCount() > 0) {
            for (int i = 0; i < panel.getComponentCount(); ++i) {
                Component component = panel.getComponent(i);
                this.removeListener(component);
            }
        }
    }
}

