/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.orocube.common.util.TerminalUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextPane;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class AboutDialog
extends POSDialog {
    private AbstractButton chkCheckUpdateOnStartUp;

    public AboutDialog() {
        super(POSUtil.getFocusedWindow(), Messages.getString("AboutDialog.0"));
    }

    @Override
    protected void initUI() {
        JPanel contentPanel = new JPanel(new BorderLayout(20, 20));
        contentPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        JLabel logoLabel = new JLabel(IconFactory.getIcon("/ui_icons/", "fpos_blue.jpg"));
        contentPanel.add((Component)logoLabel, "North");
        JTextPane l = new JTextPane();
        l.setContentType("text/html");
        l.setEditable(false);
        l.setText("<html><center><h2>" + Messages.getString("AboutDialog.4") + Application.getInstance().getProductVersion() + "</h2><h2>" + Messages.getString("AboutDialog.10") + TerminalUtil.getSystemUID() + "</h2></center></html>");
        contentPanel.add(l);
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("center"));
        PosButton btnOk = new PosButton(Messages.getString("AboutDialog.5"));
        btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TerminalConfig.setCheckUpdateOnStartUp(AboutDialog.this.chkCheckUpdateOnStartUp.isSelected());
                AboutDialog.this.dispose();
            }
        });
        this.chkCheckUpdateOnStartUp = new JCheckBox(Messages.getString("AboutDialog.1"));
        this.chkCheckUpdateOnStartUp.setSelected(TerminalConfig.isCheckUpdateOnStartUp());
        this.chkCheckUpdateOnStartUp.setFocusable(false);
        buttonPanel.add((Component)this.chkCheckUpdateOnStartUp, "wrap");
        PosButton btnCheckForUpdate = new PosButton(Messages.getString("AboutDialog.17"));
        btnCheckForUpdate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AboutDialog.this.checkForUpdate();
            }
        });
        btnCheckForUpdate.setPreferredSize(PosUIManager.getSize(100, 40));
        buttonPanel.add((Component)btnCheckForUpdate, "split 3");
        PosButton btnUpdateSettings = new PosButton(Messages.getString("AboutDialog.19"));
        btnUpdateSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AboutDialog.this.doUpdateSettings();
            }
        });
        btnUpdateSettings.setPreferredSize(PosUIManager.getSize(100, 40));
        buttonPanel.add(btnUpdateSettings);
        btnOk.setPreferredSize(PosUIManager.getSize(100, 40));
        buttonPanel.add(btnOk);
        contentPanel.add((Component)buttonPanel, "South");
        this.add(contentPanel);
    }

    private void doUpdateSettings() {
        try {
            JPasswordField tfPassword = new JPasswordField(20);
            int option = JOptionPane.showConfirmDialog(this, tfPassword, Messages.getString("AboutDialog.20"), 2, -1);
            if (option != 0) {
                return;
            }
            String password = new String(tfPassword.getPassword());
            if (StringUtils.isEmpty((String)password)) {
                POSMessageDialog.showMessage(this, Messages.getString("AboutDialog.21"));
                return;
            }
            Date date = new Date();
            String currentDate = new SimpleDateFormat("yyyyMMdd").format(date);
            if (!password.equals(currentDate)) {
                POSMessageDialog.showMessage(this, Messages.getString("AboutDialog.21"));
                return;
            }
            Store store = DataProvider.get().getStore();
            String serverUrl = JOptionPane.showInputDialog(this, Messages.getString("AboutDialog.3"), store.getServerUrl());
            if (serverUrl == null) {
                return;
            }
            store.addProperty("update_server_url", serverUrl);
            StoreDAO.getInstance().update(store);
            DataProvider.get().refreshStore();
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage(), e);
        }
    }

    private void checkForUpdate() {
        try {
            if (!Application.getInstance().checkForUpdate(true)) {
                POSMessageDialog.showMessage(Messages.getString("NoUpdateFound"));
            }
        }
        catch (PosException e2) {
            POSMessageDialog.showError(e2.getMessage());
        }
        catch (Exception e2) {
            POSMessageDialog.showError(e2.getMessage(), e2);
        }
    }
}

