/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.main.Application;
import com.floreantpos.model.AttendenceHistory;
import com.floreantpos.model.EmployeeInOutHistory;
import com.floreantpos.model.Shift;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.AttendenceHistoryDAO;
import com.floreantpos.model.dao.EmployeeInOutHistoryDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.ShiftUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadableInstant;

public class AttendanceDialog
extends POSDialog {
    private SimpleDateFormat dateFormat = new SimpleDateFormat("MMM,dd  hh:mm a");
    private JXTable table;
    private User currentUser;
    private static final SimpleDateFormat formatter = new SimpleDateFormat("hh:mm:ss");
    private Timer clockTimer = new Timer(1000, new ClockTimerHandler());
    private TitlePanel titlePanel;

    public AttendanceDialog(User user) {
        this.currentUser = user;
        this.setLayout((LayoutManager)new MigLayout("fill"));
        this.setTitle(Messages.getString("AttendanceDialog.2"));
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.setBorder(new EmptyBorder(5, 10, 5, 10));
        this.table = new JXTable((TableModel)new AttendenceHistoryTableModel(AttendenceHistoryDAO.getInstance().findAll()));
        contentPanel.add(new PosScrollPane((Component)this.table));
        this.table.getSelectionModel().setSelectionMode(0);
        this.table.setRowHeight(45);
        this.table.setDefaultRenderer(Object.class, (TableCellRenderer)new PosTableRenderer());
        this.table.getTableHeader().setPreferredSize(PosUIManager.getSize(0, 40));
        JPanel bottomPanel = new JPanel((LayoutManager)new MigLayout("center,hidemode 3,ins 5 0 5 0"));
        this.titlePanel = new TitlePanel();
        this.titlePanel.setTitle("");
        this.add((Component)this.titlePanel, "grow,wrap");
        JLabel clockInStatus = new JLabel();
        clockInStatus.setFont(new Font(this.getFont().getName(), 1, 20));
        bottomPanel.add((Component)clockInStatus, "grow");
        PosButton btnClockIn = new PosButton(Messages.getString("ClockInOutAction.5"));
        btnClockIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AttendanceDialog.this.performClockIn(AttendanceDialog.this.currentUser);
            }
        });
        PosButton btnClockOut = new PosButton(Messages.getString("ClockInOutAction.6"));
        btnClockOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AttendanceDialog.this.performClockOut(AttendanceDialog.this.currentUser);
            }
        });
        PosButton btnDriverIn = new PosButton(Messages.getString("AttendanceDialog.1"));
        btnDriverIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AttendanceDialog.this.performDriverIn(AttendanceDialog.this.currentUser);
            }
        });
        PosButton btnDriverOut = new PosButton(Messages.getString("AttendanceDialog.3"));
        btnDriverOut.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AttendanceDialog.this.performDriverOut(AttendanceDialog.this.currentUser);
            }
        });
        if (user.isClockedIn().booleanValue()) {
            bottomPanel.add(btnClockOut);
        } else {
            bottomPanel.add(btnClockIn);
        }
        if (user.isDriver().booleanValue() && user.isClockedIn().booleanValue()) {
            if (user.isAvailableForDelivery().booleanValue()) {
                bottomPanel.add(btnDriverOut);
            } else {
                bottomPanel.add(btnDriverIn);
            }
        }
        PosButton btnCancel = new PosButton(Messages.getString("CANCEL"));
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AttendanceDialog.this.dispose();
            }
        });
        PosButton btnPrint = new PosButton(Messages.getString("AttendanceDialog.4"));
        btnPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    String title = "- " + Messages.getString("AttendanceDialog.6") + AttendanceDialog.this.currentUser.getFullName() + " (#" + AttendanceDialog.this.currentUser.getId() + ")";
                    String data = Messages.getString("AttendanceDialog.9") + AttendanceDialog.this.dateFormat.format(AttendanceDialog.this.currentUser.getLastClockInTime()) + "\n " + Messages.getString("AttendanceDialog.12") + AttendanceDialog.this.dateFormat.format(new Date());
                    ReceiptPrintService.printGenericReport(title, data);
                }
                catch (Exception ee) {
                    POSMessageDialog.showError(Application.getPosWindow(), ee.getMessage(), ee);
                }
            }
        });
        bottomPanel.add(btnPrint);
        bottomPanel.add(btnCancel);
        bottomPanel.add((Component)new JSeparator(), "newline,span");
        contentPanel.add((Component)bottomPanel, "South");
        this.add((Component)contentPanel, "grow");
        this.showAttendanceTime();
        this.viewReport();
        this.clockTimer.start();
    }

    private void viewReport() {
        try {
            Date fromDate = this.currentUser.getLastClockInTime();
            Date toDate = DateUtil.endOfDay(new Date());
            AttendenceHistoryDAO dao = new AttendenceHistoryDAO();
            List<AttendenceHistory> historyList = dao.findAttendanceHistory(fromDate, toDate, this.currentUser);
            AttendenceHistoryTableModel model = (AttendenceHistoryTableModel)this.table.getModel();
            model.setRows(historyList);
        }
        catch (Exception e) {
            BOMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, e);
        }
    }

    @Override
    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
        if (aFlag) {
            this.clockTimer.start();
        } else {
            this.clockTimer.stop();
        }
    }

    public void showAttendanceTime() {
        Date lastClockedInTime = this.currentUser.getLastClockInTime();
        Date currentTime = new Date();
        DateTime startFrom = new DateTime((Object)lastClockedInTime);
        DateTime endTo = new DateTime((Object)currentTime);
        Period p = new Period((ReadableInstant)startFrom, (ReadableInstant)endTo);
        int hours = p.getHours();
        int minutes = p.getMinutes();
        int seconds = p.getMinutes();
        String userString = Messages.getString("AttendanceDialog.11") + this.currentUser.getFullName() + "(#" + this.currentUser.getId() + ")";
        String status = Messages.getString("AttendanceDialog.0");
        if (hours > 0) {
            status = hours > 1 ? status + hours + Messages.getString("AttendanceDialog.15") : status + hours + Messages.getString("AttendanceDialog.16");
        }
        status = minutes > 1 ? status + minutes + Messages.getString("AttendanceDialog.17") : status + minutes + Messages.getString("AttendanceDialog.18");
        if (this.currentUser.isClockedIn().booleanValue()) {
            this.titlePanel.setTitle("<html><h3 style='color:gray'>" + userString + "<br>" + status + "</h3></html>");
        } else {
            this.titlePanel.setTitle("<html>" + userString + "<br></html>");
        }
    }

    private void performClockIn(User user) {
        try {
            if (user == null) {
                return;
            }
            if (user.isClockedIn() != null && user.isClockedIn().booleanValue()) {
                POSMessageDialog.showMessage(Messages.getString("USER") + user.getFirstName() + " " + user.getLastName() + Messages.getString("ClockInOutAction.13"));
                return;
            }
            Shift currentShift = ShiftUtil.getCurrentShift();
            Calendar currentTime = Calendar.getInstance();
            user.doClockIn(Application.getInstance().getTerminal(), currentShift, currentTime);
            POSMessageDialog.showMessage(Messages.getString("USER") + user.getFirstName() + " " + user.getLastName() + Messages.getString("ClockInOutAction.16"));
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
    }

    private void performClockOut(User user) {
        try {
            if (user == null) {
                return;
            }
            AttendenceHistoryDAO attendenceHistoryDAO = new AttendenceHistoryDAO();
            AttendenceHistory attendenceHistory = attendenceHistoryDAO.findHistoryByClockedInTime(user);
            if (attendenceHistory == null) {
                attendenceHistory = new AttendenceHistory();
                Date lastClockInTime = user.getLastClockInTime();
                Calendar c = Calendar.getInstance();
                c.setTime(lastClockInTime);
                attendenceHistory.setClockInTime(lastClockInTime);
                attendenceHistory.setClockInHour((short)c.get(10));
                attendenceHistory.setUser(user);
                attendenceHistory.setTerminal(Application.getInstance().getTerminal());
                attendenceHistory.setShift(user.getCurrentShift());
            }
            Shift shift = user.getCurrentShift();
            Calendar calendar = Calendar.getInstance();
            user.doClockOut(attendenceHistory, shift, calendar);
            POSMessageDialog.showMessage(Messages.getString("USER") + user.getFirstName() + " " + user.getLastName() + Messages.getString("ClockInOutAction.10"));
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
    }

    public void performDriverOut(User user) {
        try {
            if (user == null) {
                return;
            }
            Shift currentShift = ShiftUtil.getCurrentShift();
            Terminal terminal = Application.getInstance().getTerminal();
            Calendar currentTime = Calendar.getInstance();
            user.setAvailableForDelivery(false);
            user.setLastClockOutTime(currentTime.getTime());
            LogFactory.getLog(Application.class).info((Object)("terminal id befor saving clockIn=" + terminal.getId()));
            EmployeeInOutHistory attendenceHistory = new EmployeeInOutHistory();
            attendenceHistory.setOutTime(currentTime.getTime());
            attendenceHistory.setOutHour((short)currentTime.get(11));
            attendenceHistory.setClockOut(true);
            attendenceHistory.setUser(user);
            attendenceHistory.setTerminal(terminal);
            attendenceHistory.setShift(currentShift);
            UserDAO.getInstance().saveDriverOut(user, attendenceHistory, currentShift, currentTime);
            POSMessageDialog.showMessage(Messages.getString("AttendanceDialog.13") + user.getFirstName() + " " + user.getLastName() + Messages.getString("AttendanceDialog.19"));
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
    }

    public void performDriverIn(User user) {
        try {
            if (user == null) {
                return;
            }
            if (!user.isClockedIn().booleanValue()) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("ClockInOutAction.2"));
                return;
            }
            EmployeeInOutHistoryDAO attendenceHistoryDAO = new EmployeeInOutHistoryDAO();
            EmployeeInOutHistory attendenceHistory = attendenceHistoryDAO.findDriverHistoryByClockedInTime(user);
            if (attendenceHistory == null) {
                attendenceHistory = new EmployeeInOutHistory();
                Date lastClockOutTime = user.getLastClockOutTime();
                Calendar c = Calendar.getInstance();
                c.setTime(lastClockOutTime);
                attendenceHistory.setOutTime(lastClockOutTime);
                attendenceHistory.setOutHour((short)c.get(10));
                attendenceHistory.setUser(user);
                attendenceHistory.setTerminal(Application.getInstance().getTerminal());
                attendenceHistory.setShift(user.getCurrentShift());
            }
            Shift shift = user.getCurrentShift();
            Calendar calendar = Calendar.getInstance();
            user.setAvailableForDelivery(true);
            attendenceHistory.setClockOut(false);
            attendenceHistory.setInTime(calendar.getTime());
            attendenceHistory.setInHour((short)calendar.get(11));
            UserDAO.getInstance().saveDriverIn(user, attendenceHistory, shift, calendar);
            POSMessageDialog.showMessage(Messages.getString("AttendanceDialog.20") + user.getFirstName() + " " + user.getLastName() + Messages.getString("AttendanceDialog.22"));
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
    }

    class AttendenceHistoryTableModel
    extends ListTableModel {
        String[] columnNames = new String[]{Messages.getString("AttendanceHistoryExplorer.7"), Messages.getString("AttendanceHistoryExplorer.8"), Messages.getString("AttendanceHistoryExplorer.9"), Messages.getString("AttendanceHistoryExplorer.10"), Messages.getString("AttendanceHistoryExplorer.11"), Messages.getString("AttendanceHistoryExplorer.12"), Messages.getString("AttendanceHistoryExplorer.13")};

        AttendenceHistoryTableModel(List<AttendenceHistory> list) {
            this.setRows(list);
            this.setColumnNames(this.columnNames);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            AttendenceHistory history = (AttendenceHistory)this.rows.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return history.getUser().getId();
                }
                case 1: {
                    return history.getUser().getFirstName() + " " + history.getUser().getLastName();
                }
                case 2: {
                    Date date = history.getClockInTime();
                    if (date != null) {
                        return AttendanceDialog.this.dateFormat.format(date);
                    }
                    return "";
                }
                case 3: {
                    Date date2 = history.getClockOutTime();
                    if (date2 != null) {
                        return AttendanceDialog.this.dateFormat.format(date2);
                    }
                    return "";
                }
                case 4: {
                    return history.isClockedOut();
                }
                case 5: {
                    if (history.getShift() == null) {
                        return "";
                    }
                    return history.getShift().getId();
                }
                case 6: {
                    return history.getTerminal().getId();
                }
            }
            return null;
        }
    }

    private class ClockTimerHandler
    implements ActionListener {
        private ClockTimerHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!AttendanceDialog.this.isShowing()) {
                AttendanceDialog.this.clockTimer.stop();
                return;
            }
            AttendanceDialog.this.showAttendanceTime();
        }
    }
}

