/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.util.DateTimePicker;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class DateSelectionDialog
extends OkCancelOptionDialog {
    private DateTimePicker dpDate = new DateTimePicker();
    private DateTimePicker dpPostDate = new DateTimePicker();
    private Date date = new Date();
    private Date postDate = new Date();
    private PosButton btnClearDate;
    private JLabel labelPostDate;
    private boolean isEnableLowerBound = Boolean.FALSE;
    private JLabel lblSelectDate;

    public DateSelectionDialog() {
        super(POSUtil.getFocusedWindow());
        this.initComponents();
    }

    public DateSelectionDialog(Date date) {
        super(POSUtil.getFocusedWindow());
        this.date = date;
        this.initComponents();
    }

    public DateSelectionDialog(Date date, Date postDate, boolean isEnableLowerBound) {
        super(POSUtil.getFocusedWindow());
        this.postDate = postDate;
        this.date = date;
        this.isEnableLowerBound = isEnableLowerBound;
        this.initComponents();
    }

    private void initComponents() {
        JPanel panel = this.getContentPanel();
        panel.setLayout((LayoutManager)new MigLayout("center"));
        this.dpDate.setFormats(new String[]{"dd-MM-yyyy HH:mm:ss"});
        this.labelPostDate = new JLabel(Messages.getString("DateSelectionDialog.0"));
        this.dpPostDate.setFormats(new String[]{"dd-MM-yyyy HH:mm:ss"});
        if (this.isEnableLowerBound) {
            this.dpDate.setLowerBound(this.postDate);
            this.dpPostDate.setLowerBound(this.postDate);
        }
        this.dpDate.setDate(this.date);
        this.dpPostDate.setDate(this.postDate);
        panel.add(this.labelPostDate);
        panel.add((Component)((Object)this.dpPostDate), "grow, wrap");
        this.setPostDateVisible(Boolean.FALSE);
        this.lblSelectDate = new JLabel(Messages.getString("DateSelectionDialog.2"));
        panel.add(this.lblSelectDate);
        panel.add((Component)((Object)this.dpDate), "grow, wrap");
        TransparentPanel buttonPanel = this.getButtonPanel();
        this.btnClearDate = new PosButton(Messages.getString("DateSelectionDialog.4"));
        this.btnClearDate.addActionListener(e -> this.dpDate.setDate(null));
        buttonPanel.add((Component)this.btnClearDate, 0);
        this.btnClearDate.setVisible(false);
    }

    public void setLblSelectDateCaption(String caption) {
        this.lblSelectDate.setText(caption);
    }

    public Date getPostDate() {
        return this.dpPostDate.getDate();
    }

    public Date getSelectedDate() {
        return this.dpDate.getDate();
    }

    public void setClearDateVisible(boolean isVisible) {
        this.btnClearDate.setVisible(isVisible);
    }

    public void setPostDateVisible(boolean isVisible) {
        this.labelPostDate.setVisible(isVisible);
        this.dpPostDate.setVisible(isVisible);
    }

    @Override
    public void doOk() {
        this.setCanceled(false);
        this.dispose();
    }
}

