/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PrinterGroup;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemSeat;
import com.floreantpos.model.dao.PrinterGroupDAO;
import com.floreantpos.model.dao.TaxGroupDAO;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.PosComboRenderer;
import com.floreantpos.swing.QwertyKeyPad;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.OrderView;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class MiscTicketItemDialog
extends OkCancelOptionDialog {
    private TicketItem ticketItem;
    private JComboBox cbTaxGroup;
    private FixedLengthTextField tfItemName;
    private DoubleTextField tfItemPrice;
    private JComboBox cbPrinterGroup;
    private JLabel lblTax;
    private OrderType orderType;

    public MiscTicketItemDialog() {
        super((Frame)Application.getPosWindow(), true);
        this.setTitle(Messages.getString("MiscTicketItemDialog.0"));
        this.initComponents();
    }

    private void initComponents() {
        JPanel contentPane = new JPanel((LayoutManager)new MigLayout("inset 0, fillx", "", ""));
        this.setTitle(Messages.getString("MiscTicketItemDialog.4"));
        this.setCaption(Messages.getString("MiscTicketItemDialog.4"));
        JLabel lblName = new JLabel(Messages.getString("MiscTicketItemDialog.6"));
        contentPane.add((Component)lblName, "newline,alignx trailing");
        this.tfItemName = new FixedLengthTextField();
        this.tfItemName.setLength(120);
        contentPane.add((Component)this.tfItemName, "grow, span, h 40");
        JLabel lblPrice = new JLabel(Messages.getString("MiscTicketItemDialog.9"));
        contentPane.add((Component)lblPrice, "newline,alignx trailing");
        this.tfItemPrice = new DoubleTextField();
        contentPane.add((Component)this.tfItemPrice, "grow, w 120, h 40");
        this.lblTax = new JLabel(Messages.getString("MiscTicketItemDialog.2"));
        contentPane.add((Component)this.lblTax, "alignx trailing");
        PosComboRenderer comboRenderer = new PosComboRenderer();
        comboRenderer.setEnableDefaultValueShowing(false);
        this.cbTaxGroup = new JComboBox();
        this.cbTaxGroup.setRenderer(comboRenderer);
        contentPane.add((Component)this.cbTaxGroup, "w 200!, h 40");
        contentPane.add((Component)new JLabel(Messages.getString("MiscTicketItemDialog.15")), "alignx trailing");
        this.cbPrinterGroup = new JComboBox();
        this.cbPrinterGroup.setRenderer(comboRenderer);
        contentPane.add((Component)this.cbPrinterGroup, "w 200!, h 40");
        QwertyKeyPad keyPad = new QwertyKeyPad();
        contentPane.add((Component)((Object)keyPad), "newline, grow, span, gaptop 10");
        this.getContentPanel().add(contentPane);
        this.initData();
    }

    private void initData() {
        List<TaxGroup> taxGroups = TaxGroupDAO.getInstance().findAll();
        this.cbTaxGroup.addItem(null);
        for (TaxGroup tax : taxGroups) {
            this.cbTaxGroup.addItem(tax);
        }
        String defaultTaxId = TerminalConfig.getMiscItemDefaultTaxId();
        if (!defaultTaxId.equals("-1")) {
            for (int i = 0; i < taxGroups.size(); ++i) {
                TaxGroup tax = taxGroups.get(i);
                if (!tax.getId().equals(defaultTaxId)) continue;
                this.cbTaxGroup.setSelectedIndex(i);
                break;
            }
        }
        List<PrinterGroup> printerGroups = PrinterGroupDAO.getInstance().findAll();
        this.cbPrinterGroup.addItem(null);
        for (PrinterGroup printerGroup : printerGroups) {
            this.cbPrinterGroup.addItem(printerGroup);
            if (!printerGroup.isIsDefault()) continue;
            this.cbPrinterGroup.setSelectedItem(printerGroup);
        }
    }

    @Override
    public void doCancel() {
        this.setCanceled(true);
        this.ticketItem = null;
        this.dispose();
    }

    @Override
    public void doOk() {
        String itemName = this.tfItemName.getText();
        if (StringUtils.isBlank((String)itemName)) {
            POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("MiscTicketItemDialog.1"));
            return;
        }
        if (StringUtils.isEmpty((String)this.tfItemPrice.getText())) {
            POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("MiscTicketItemDialog.3"));
            return;
        }
        double amount = this.tfItemPrice.getDoubleOrZero();
        this.setCanceled(false);
        this.ticketItem = new TicketItem();
        this.ticketItem.setTaxIncluded(Application.getInstance().isPriceIncludesTax());
        this.ticketItem.setQuantity(1.0);
        this.ticketItem.setUnitPrice(amount);
        this.ticketItem.setName(itemName.trim());
        this.ticketItem.setMenuItemId("0");
        this.ticketItem.setCategoryName(POSConstants.MISC_BUTTON_TEXT);
        this.ticketItem.setGroupName(POSConstants.MISC_BUTTON_TEXT);
        this.ticketItem.setShouldPrintToKitchen(true);
        OrderView orderView = OrderView.getInstance();
        Object selectedSeat = orderView.getSelectedSeatNumber();
        if (selectedSeat instanceof Integer) {
            this.ticketItem.setSeatNumber((Integer)selectedSeat);
        } else if (selectedSeat instanceof TicketItemSeat) {
            TicketItemSeat seat = (TicketItemSeat)orderView.getSelectedSeatNumber();
            this.ticketItem.setSeat(seat);
            this.ticketItem.setSeatNumber(seat.getSeatNumber());
        }
        TaxGroup selectedObject = (TaxGroup)this.cbTaxGroup.getSelectedItem();
        MenuItem.setItemTaxes(this.ticketItem, selectedObject, this.getOrderType());
        PrinterGroup printerGroup = (PrinterGroup)this.cbPrinterGroup.getSelectedItem();
        if (printerGroup != null) {
            this.ticketItem.setPrinterGroup(printerGroup);
        }
        this.dispose();
    }

    public TicketItem getTicketItem() {
        return this.ticketItem;
    }

    public OrderType getOrderType() {
        return this.orderType;
    }

    public void setOrderType(OrderType orderType) {
        this.orderType = orderType;
    }
}

