/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.TipsCashoutReport;
import com.floreantpos.model.TipsCashoutReportData;
import com.floreantpos.model.TipsCashoutReportTableModel;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.GratuityDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.print.PosPrintService;
import com.floreantpos.swing.ListComboBoxModel;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.ui.views.TicketReceiptView;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JasperPrint;
import org.jdesktop.swingx.JXDatePicker;

public class TipsCashoutReportDialog
extends OkCancelOptionDialog
implements ActionListener {
    private TipsCashoutReport report;
    private JPanel reportPanel;
    private JXDatePicker fromDatePicker;
    private JXDatePicker toDatePicker;
    private User user;
    private JComboBox cbSessionReport = new JComboBox();
    private JComboBox cbUserList = new JComboBox();

    public TipsCashoutReportDialog(TipsCashoutReport report) {
        this(report, null, null, false);
    }

    public TipsCashoutReportDialog(TipsCashoutReport tipsReport, ListComboBoxModel userListModel, User selectedUser, boolean showFilterPanel) {
        super(POSUtil.getFocusedWindow());
        this.setTitle(POSConstants.SERVER_TIPS_REPORT);
        this.setOkButtonText(Messages.getString("TipsCashoutReportDialog.8"));
        this.report = tipsReport;
        this.user = selectedUser;
        JPanel contentPanel = this.getContentPanel();
        if (showFilterPanel) {
            JPanel filterPanel = new JPanel((LayoutManager)new MigLayout("ins 10"));
            this.fromDatePicker = UiUtil.getCurrentMonthStart();
            this.toDatePicker = UiUtil.getCurrentMonthEnd();
            StoreSession currentData = DataProvider.get().getStoreSession();
            this.fromDatePicker.setDate(currentData.getOpenTime());
            this.cbUserList.setModel(userListModel);
            if (selectedUser == null) {
                this.cbUserList.setSelectedIndex(0);
            } else {
                this.cbUserList.setSelectedItem(selectedUser);
            }
            this.cbSessionReport.addItem(Messages.getString("TipsCashoutReportDialog.10"));
            this.cbSessionReport.addItem(Messages.getString("TipsCashoutReportDialog.11"));
            this.cbSessionReport.setSelectedIndex(0);
            this.cbSessionReport.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    TipsCashoutReportDialog.this.fromDatePicker.setEnabled(TipsCashoutReportDialog.this.cbSessionReport.getSelectedIndex() == 0);
                    TipsCashoutReportDialog.this.toDatePicker.setEnabled(TipsCashoutReportDialog.this.cbSessionReport.getSelectedIndex() == 0);
                }
            });
            int width = PosUIManager.getSize(200);
            filterPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10), BorderFactory.createTitledBorder("")));
            filterPanel.add(new JLabel(Messages.getString("USER")));
            filterPanel.add((Component)this.cbUserList, "w " + width + "!");
            filterPanel.add(this.cbSessionReport);
            filterPanel.add(new JLabel(POSConstants.FROM + ":"));
            filterPanel.add((Component)this.fromDatePicker);
            filterPanel.add(new JLabel(POSConstants.TO_));
            filterPanel.add((Component)this.toDatePicker);
            JButton btnGo = new JButton(Messages.getString("TipsCashoutReportDialog.14"));
            btnGo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TipsCashoutReportDialog.this.reportPanel.removeAll();
                    GratuityDAO gratuityDAO = new GratuityDAO();
                    int selectedIndex = TipsCashoutReportDialog.this.cbSessionReport.getSelectedIndex();
                    Object selectedItem = TipsCashoutReportDialog.this.cbUserList.getSelectedItem();
                    if (selectedItem instanceof User) {
                        TipsCashoutReportDialog.this.user = (User)selectedItem;
                    } else {
                        TipsCashoutReportDialog.this.user = null;
                    }
                    TipsCashoutReportDialog.this.report = gratuityDAO.createReport(TipsCashoutReportDialog.this.fromDatePicker.getDate(), TipsCashoutReportDialog.this.toDatePicker.getDate(), TipsCashoutReportDialog.this.user, selectedIndex == 1);
                    TipsCashoutReportDialog.this.createReport();
                    TipsCashoutReportDialog.this.reportPanel.revalidate();
                    TipsCashoutReportDialog.this.reportPanel.repaint();
                }
            });
            filterPanel.add(btnGo);
            this.add((Component)filterPanel, "North");
            GratuityDAO gratuityDAO = new GratuityDAO();
            this.report = gratuityDAO.createReport(this.fromDatePicker.getDate(), this.toDatePicker.getDate(), this.user, false);
        }
        this.reportPanel = new JPanel((LayoutManager)new MigLayout("wrap 1, ax 50%", "", ""));
        TipsCashoutReportTableModel model = new TipsCashoutReportTableModel();
        if (this.report != null) {
            List<TipsCashoutReportData> datas = this.report.getDatas();
            model.setRows(datas);
        }
        JTable table = new JTable(model);
        table.setDefaultRenderer(Object.class, new PosTableRenderer());
        PosScrollPane scrollPane = new PosScrollPane(this.reportPanel);
        scrollPane.getVerticalScrollBar().setUnitIncrement(20);
        this.createReport();
        contentPanel.add(scrollPane);
    }

    private void createReport() {
        try {
            if (this.report == null) {
                return;
            }
            JasperPrint jasperPrint = PosPrintService.createServerTipsReport(this.report);
            TicketReceiptView receiptView = new TicketReceiptView(jasperPrint);
            this.reportPanel.add(receiptView.getReportPanel());
        }
        catch (Exception x) {
            PosLog.error(this.getClass(), x);
            POSMessageDialog.showError(this, Messages.getString("TipsCashoutReportDialog.32") + x.getMessage());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public void doOk() {
        try {
            PosPrintService.printServerTipsReport(this.report);
        }
        catch (Exception x) {
            PosLog.error(this.getClass(), x);
            POSMessageDialog.showError(this, Messages.getString("TipsCashoutReportDialog.32") + x.getMessage());
        }
    }
}

