/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.model.Attribute;
import com.floreantpos.model.AttributeGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.dao.AttributeDAO;
import com.floreantpos.swing.ButtonColumn;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.AttributesSelectionDialog;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.model.AttributeEntryForm;
import com.floreantpos.util.NumericGlobalIdGenerator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import javax.accessibility.Accessible;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXTable;

public class VariantAttributesSelectionDialog
extends OkCancelOptionDialog {
    private JXTable attributeTable = new JXTable();
    private VariantAttributeModel tableModel = new VariantAttributeModel();
    private List<AttributeGroup> groups;
    private JButton btnAddNew;
    private List<MenuItem> existingVariants = new ArrayList<MenuItem>();
    private List<MenuItem> variants;
    List<Attribute> attributes = new ArrayList<Attribute>();
    private final List<Attribute> attributeList;
    private MenuItem parentMenuItem;
    private JComboBox cbAttributes;

    public VariantAttributesSelectionDialog(List<MenuItem> variants) {
        this.existingVariants = variants;
        this.attributeList = AttributeDAO.getInstance().findAll();
        this.createUI();
        this.setTitle(Messages.getString("VariantAttributesSelectionDialog.0"));
        this.setCaption(Messages.getString("VariantAttributesSelectionDialog.0"));
        this.attributeTable.setModel((TableModel)this.tableModel);
        this.updateView();
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = Integer.parseInt(e.getActionCommand());
                Attribute attribute = (Attribute)VariantAttributesSelectionDialog.this.tableModel.getRowData(row);
                VariantAttributesSelectionDialog.this.tableModel.deleteItem(attribute);
                VariantAttributesSelectionDialog.this.tableModel.fireTableRowsDeleted(row, row);
            }
        };
        ButtonColumn buttonColumn = new ButtonColumn((JTable)this.attributeTable, action, 1){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                PosButton button = (PosButton)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                button.setIcon(IconFactory.getIcon("/ui_icons/", "delete-icon.png"));
                button.setOpaque(false);
                button.setBorder(null);
                return button;
            }

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                return super.getTableCellEditorComponent(table, value, false, row, column);
            }
        };
        this.resizeTableColumns();
    }

    private void updateView() {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        if (this.existingVariants != null) {
            for (MenuItem variant : this.existingVariants) {
                if (variant.getAttributes() == null) continue;
                for (Attribute att : variant.getAttributes()) {
                    if (attributes.contains(att)) continue;
                    attributes.add(att);
                }
            }
        }
        Collections.sort(attributes, new Comparator<Attribute>(){

            @Override
            public int compare(Attribute o1, Attribute o2) {
                return o1.getGroup().getName().compareTo(o2.getGroup().getName());
            }
        });
        this.tableModel.setRows(attributes);
    }

    public void setParentMenuItem(MenuItem parent) {
        this.parentMenuItem = parent;
    }

    private void createUI() {
        JPanel contentPanel = this.getContentPanel();
        contentPanel.setLayout((LayoutManager)new MigLayout("aligny top,ins 0 10 0 10", "[100%]", ""));
        JPanel topPanel = new JPanel((LayoutManager)new MigLayout("fillx,ins 2"));
        this.cbAttributes = new JComboBox(new ComboBoxModel(new ArrayList()));
        this.cbAttributes.setOpaque(false);
        this.cbAttributes.setBorder(null);
        this.cbAttributes.setEditable(true);
        this.cbAttributes.setEditor(new CustomComboBoxEditor());
        this.cbAttributes.setRenderer(new ColorCellRenderer());
        this.cbAttributes.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    // empty if block
                }
            }
        });
        this.cbAttributes.setUI(new BasicComboBoxUI(){

            @Override
            protected JButton createArrowButton() {
                return new JButton(){

                    @Override
                    public int getWidth() {
                        return 0;
                    }
                };
            }
        });
        this.cbAttributes.remove(this.getComponent(0));
        this.addPopupMouseListener();
        topPanel.add((Component)new JLabel(Messages.getString("VariantAttributesSelectionDialog.8")), "split 3,h 30!");
        topPanel.add((Component)this.cbAttributes, "growx,h 30!");
        JButton btnSelect = new JButton(Messages.getString("SELECT"));
        btnSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VariantAttributesSelectionDialog.this.doSelectAttribute();
            }
        });
        topPanel.add((Component)btnSelect, "h 30!");
        JPanel attributeListPanel = new JPanel((LayoutManager)new MigLayout("fill"));
        attributeListPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("VariantAttributesSelectionDialog.14")));
        this.attributeTable.setTableHeader(null);
        this.attributeTable.setRowHeight(30);
        this.attributeTable.setRowSelectionAllowed(false);
        this.attributeTable.setCellSelectionEnabled(false);
        attributeListPanel.add((Component)new JScrollPane((Component)this.attributeTable), "grow,span,wrap");
        contentPanel.add((Component)topPanel, "growx,span 2,aligny top,wrap");
        contentPanel.add((Component)attributeListPanel, "grow,aligny top");
    }

    private void resizeTableColumns() {
        this.attributeTable.setAutoResizeMode(4);
        this.setColumnWidth(1, PosUIManager.getSize(50));
    }

    private void setColumnWidth(int columnNumber, int width) {
        TableColumn column = this.attributeTable.getColumnModel().getColumn(columnNumber);
        column.setPreferredWidth(width);
        column.setMaxWidth(width);
        column.setMinWidth(width);
    }

    private void doSelectAttribute() {
        AttributesSelectionDialog dialog = new AttributesSelectionDialog(this.tableModel.getRows());
        dialog.setSize(PosUIManager.getSize(500, 440));
        dialog.open();
        if (dialog.isCanceled()) {
            return;
        }
        List<Attribute> attributes = dialog.getSelectedAttributeList();
        if (attributes == null) {
            return;
        }
        Collections.sort(attributes, new Comparator<Attribute>(){

            @Override
            public int compare(Attribute o1, Attribute o2) {
                return o1.getGroup().getName().compareTo(o2.getGroup().getName());
            }
        });
        this.tableModel.setRows(attributes);
    }

    private void doCreateNewAttribute() {
        Attribute att = new Attribute();
        CustomComboBoxEditor editor = (CustomComboBoxEditor)this.cbAttributes.getEditor();
        String name = ((CustomComboBoxEditor.AttributePanel)editor.getEditorComponent()).getText();
        att.setName(name);
        AttributeEntryForm inventoryUnitFormTree = new AttributeEntryForm(att);
        BeanEditorDialog dialog = new BeanEditorDialog(inventoryUnitFormTree);
        dialog.setPreferredSize(PosUIManager.getSize(500, 400));
        dialog.open();
        if (dialog.isCanceled()) {
            return;
        }
        Attribute newAtt = (Attribute)inventoryUnitFormTree.getBean();
        this.tableModel.addItem(newAtt);
    }

    @Override
    public void doOk() {
        List<Attribute> attributes = this.tableModel.getRows();
        if (attributes == null || attributes.isEmpty()) {
            this.variants = new ArrayList<MenuItem>();
        } else {
            String str;
            List<Attribute> exstingsAttributes;
            LinkedHashMap<String, MenuItem> itemMap = new LinkedHashMap<String, MenuItem>();
            this.variants = this.generatedPossibleVariants(attributes);
            if (this.existingVariants != null) {
                for (MenuItem item : this.existingVariants) {
                    item.setName(item.getVariantName());
                    exstingsAttributes = item.getAttributes();
                    Collections.sort(exstingsAttributes, new Comparator<Attribute>(){

                        @Override
                        public int compare(Attribute o1, Attribute o2) {
                            return o1.getId().compareTo(o2.getId());
                        }
                    });
                    str = "";
                    for (Attribute att : exstingsAttributes) {
                        str = str + att.getName() + "-";
                    }
                    itemMap.put(str, item);
                }
            }
            if (this.variants != null) {
                for (MenuItem item : this.variants) {
                    item.setName(item.getVariantName());
                    exstingsAttributes = item.getAttributes();
                    Collections.sort(exstingsAttributes, new Comparator<Attribute>(){

                        @Override
                        public int compare(Attribute o1, Attribute o2) {
                            return o1.getId().compareTo(o2.getId());
                        }
                    });
                    str = "";
                    for (Attribute att : exstingsAttributes) {
                        str = str + att.getName() + "-";
                    }
                    MenuItem mapItem = (MenuItem)itemMap.get(str);
                    if (mapItem != null) {
                        item.setBarcode(mapItem.getBarcode());
                        item.setPrice(mapItem.getPrice());
                        item.setVisible(mapItem.isVisible());
                    }
                    Collections.sort(exstingsAttributes, new Comparator<Attribute>(){

                        @Override
                        public int compare(Attribute o1, Attribute o2) {
                            return o1.getGroup().getId().compareTo(o2.getGroup().getId());
                        }
                    });
                }
            }
        }
        this.setCanceled(false);
        this.dispose();
    }

    private List<MenuItem> generatedPossibleVariants(List<Attribute> attributes) {
        HashMap<AttributeGroup, ArrayList<Attribute>> itemMap = new HashMap<AttributeGroup, ArrayList<Attribute>>();
        for (Attribute attribute : attributes) {
            ArrayList<Attribute> attributeList = (ArrayList<Attribute>)itemMap.get(attribute.getGroup());
            if (attributeList == null) {
                attributeList = new ArrayList<Attribute>();
                itemMap.put(attribute.getGroup(), attributeList);
            }
            attributeList.add(attribute);
        }
        for (AttributeGroup group : itemMap.keySet()) {
            if (group.getAttributes() == null) continue;
        }
        Object[] arr = attributes.toArray();
        ArrayList<MenuItem> variants = new ArrayList<MenuItem>();
        int r = itemMap.size();
        int n = arr.length;
        this.generateCombination(variants, arr, n, r);
        return variants;
    }

    private void addPopupMouseListener() {
        try {
            Field popupInBasicComboBoxUI = BasicComboBoxUI.class.getDeclaredField("popup");
            popupInBasicComboBoxUI.setAccessible(true);
            BasicComboPopup popup = (BasicComboPopup)popupInBasicComboBoxUI.get(this.cbAttributes.getUI());
            Field scrollerInBasicComboPopup = BasicComboPopup.class.getDeclaredField("scroller");
            scrollerInBasicComboPopup.setAccessible(true);
            JScrollPane scroller = (JScrollPane)scrollerInBasicComboPopup.get(popup);
            scroller.getViewport().getView().addMouseListener(new MouseListener(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    Object selectedItem = VariantAttributesSelectionDialog.this.cbAttributes.getSelectedItem();
                    if (selectedItem instanceof Attribute) {
                        Attribute attribute = (Attribute)selectedItem;
                        if (attribute.getId() != null) {
                            if (VariantAttributesSelectionDialog.this.tableModel.getRows().contains(attribute)) {
                                return;
                            }
                            VariantAttributesSelectionDialog.this.tableModel.addItem(attribute);
                        } else {
                            VariantAttributesSelectionDialog.this.doCreateNewAttribute();
                        }
                    }
                    VariantAttributesSelectionDialog.this.cbAttributes.hidePopup();
                    CustomComboBoxEditor editor = (CustomComboBoxEditor)VariantAttributesSelectionDialog.this.cbAttributes.getEditor();
                    ((CustomComboBoxEditor.AttributePanel)editor.getEditorComponent()).selectAll();
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                }
            });
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    void combinationUtil(List variants, Object[] arr, int n, int r, int index, Object[] data, int i) {
        if (index == r) {
            ArrayList<String> groups = new ArrayList<String>();
            ArrayList<Attribute> attributes = new ArrayList<Attribute>();
            for (int j = 0; j < r; ++j) {
                Attribute att = (Attribute)data[j];
                if (groups.contains(att.getGroup().getId())) {
                    return;
                }
                groups.add(att.getGroup().getId());
                attributes.add(att);
            }
            MenuItem variant = new MenuItem();
            variant.setName(this.parentMenuItem.getName());
            variant.setParentMenuItem(this.parentMenuItem);
            variant.setMenuGroupId(this.parentMenuItem.getMenuGroupId());
            variant.setMenuGroupName(this.parentMenuItem.getMenuGroupName());
            variant.setMenuCategoryId(this.parentMenuItem.getMenuCategoryId());
            variant.setMenuCategoryName(this.parentMenuItem.getMenuCategoryName());
            variant.setUnit(this.parentMenuItem.getUnit());
            variant.setVariant(true);
            variant.setInventoryItem(this.parentMenuItem.isInventoryItem());
            variant.setAttributes(attributes);
            String generateGlobalId = NumericGlobalIdGenerator.generateGlobalId();
            variant.setBarcode(generateGlobalId);
            variant.setSku(generateGlobalId);
            variants.add(variant);
            return;
        }
        if (i >= n) {
            return;
        }
        data[index] = arr[i];
        this.combinationUtil(variants, arr, n, r, index + 1, data, i + 1);
        this.combinationUtil(variants, arr, n, r, index, data, i + 1);
    }

    void generateCombination(List variants, Object[] arr, int n, int r) {
        Object[] data = new Object[r];
        this.combinationUtil(variants, arr, n, r, 0, data, 0);
    }

    public List<MenuItem> getVariants() {
        return this.variants;
    }

    class CustomComboBoxEditor
    implements ComboBoxEditor {
        AttributePanel panel = new AttributePanel();

        @Override
        public void setItem(Object anObject) {
            if (anObject != null) {
                this.panel.setText(anObject.toString());
            }
        }

        @Override
        public Component getEditorComponent() {
            return this.panel;
        }

        @Override
        public Object getItem() {
            return this.panel.getText();
        }

        @Override
        public void selectAll() {
            this.panel.selectAll();
        }

        @Override
        public void addActionListener(ActionListener l) {
        }

        @Override
        public void removeActionListener(ActionListener l) {
        }

        class AttributePanel
        extends JPanel {
            JTextField textField;

            public AttributePanel() {
                this.setLayout(new BorderLayout());
                this.textField = new JTextField("");
                this.textField.setColumns(20);
                this.textField.setRequestFocusEnabled(true);
                this.textField.requestFocus();
                this.textField.addKeyListener(new KeyListener(){

                    @Override
                    public void keyTyped(KeyEvent e) {
                    }

                    @Override
                    public void keyReleased(KeyEvent e) {
                        if (e.getKeyCode() == 27) {
                            return;
                        }
                        if (e.getKeyCode() == 40 || e.getKeyCode() == 38) {
                            if (!VariantAttributesSelectionDialog.this.cbAttributes.isPopupVisible()) {
                                VariantAttributesSelectionDialog.this.cbAttributes.showPopup();
                            }
                            return;
                        }
                        String txt = (String)CustomComboBoxEditor.this.getItem();
                        AttributePanel.this.comboFilter(txt);
                    }

                    @Override
                    public void keyPressed(KeyEvent e) {
                    }
                });
                this.textField.addFocusListener(new FocusListener(){

                    @Override
                    public void focusLost(FocusEvent e) {
                    }

                    @Override
                    public void focusGained(FocusEvent e) {
                        AttributePanel.this.selectAll();
                    }
                });
                this.textField.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Object selectedItem = VariantAttributesSelectionDialog.this.cbAttributes.getSelectedItem();
                        if (selectedItem instanceof Attribute) {
                            Attribute attribute = (Attribute)selectedItem;
                            if (attribute.getId() != null) {
                                if (!VariantAttributesSelectionDialog.this.tableModel.getRows().contains(attribute)) {
                                    VariantAttributesSelectionDialog.this.tableModel.addItem(attribute);
                                }
                            } else {
                                VariantAttributesSelectionDialog.this.doCreateNewAttribute();
                            }
                        }
                        AttributePanel.this.setText("");
                        VariantAttributesSelectionDialog.this.cbAttributes.hidePopup();
                    }
                });
                this.add(this.textField);
            }

            public void comboFilter(String enteredText) {
                if (enteredText.isEmpty() && VariantAttributesSelectionDialog.this.cbAttributes.isPopupVisible()) {
                    VariantAttributesSelectionDialog.this.cbAttributes.hidePopup();
                    return;
                }
                ArrayList<Attribute> filterArray = new ArrayList<Attribute>();
                for (Attribute attribute : VariantAttributesSelectionDialog.this.attributeList) {
                    if (!attribute.getName().toLowerCase().startsWith(enteredText.toLowerCase())) continue;
                    filterArray.add(attribute);
                }
                Attribute newAtt = new Attribute();
                newAtt.setName(Messages.getString("VariantAttributesSelectionDialog.30"));
                newAtt.setGroup(new AttributeGroup());
                filterArray.add(newAtt);
                if (filterArray.size() > 0) {
                    ComboBoxModel model = (ComboBoxModel)VariantAttributesSelectionDialog.this.cbAttributes.getModel();
                    model.removeAllElements();
                    for (Object e : filterArray) {
                        model.addElement(e);
                    }
                    this.setText(enteredText);
                }
                if (!VariantAttributesSelectionDialog.this.cbAttributes.isPopupVisible()) {
                    VariantAttributesSelectionDialog.this.cbAttributes.showPopup();
                }
                this.resize();
            }

            public void resize() {
                Accessible child = VariantAttributesSelectionDialog.this.cbAttributes.getAccessibleContext().getAccessibleChild(0);
                BasicComboPopup popup = (BasicComboPopup)child;
                JList<Object> list = popup.getList();
                Dimension preferred = list.getPreferredSize();
                preferred.width = this.textField.getWidth() + 20;
                int rowHeight = preferred.height / VariantAttributesSelectionDialog.this.cbAttributes.getItemCount();
                int maxHeight = VariantAttributesSelectionDialog.this.cbAttributes.getMaximumRowCount() * rowHeight;
                preferred.height = Math.min(preferred.height, maxHeight);
                Container c = SwingUtilities.getAncestorOfClass(JScrollPane.class, list);
                JScrollPane scrollPane = (JScrollPane)c;
                scrollPane.setPreferredSize(preferred);
                scrollPane.setMaximumSize(preferred);
                Dimension popupSize = popup.getSize();
                popupSize.width = this.textField.getWidth();
                popupSize.height = preferred.height + 2;
                Container parent = popup.getParent();
                parent.setSize(popupSize);
                ((Component)parent).validate();
                parent.repaint();
                Window mainFrame = SwingUtilities.windowForComponent(VariantAttributesSelectionDialog.this.cbAttributes);
                Window popupWindow = SwingUtilities.windowForComponent(popup);
                if (popupWindow != mainFrame) {
                    popupWindow.pack();
                }
            }

            public void setText(String s) {
                if (s.equals(Messages.getString("VariantAttributesSelectionDialog.30"))) {
                    return;
                }
                this.textField.setText(s);
            }

            public String getText() {
                return this.textField.getText();
            }

            public void setIcon(Icon i) {
                this.repaint();
            }

            public void selectAll() {
                this.textField.selectAll();
            }

            public void addActionListener(ActionListener l) {
            }

            public void removeActionListener(ActionListener l) {
            }
        }
    }

    public class VariantAttributeModel
    extends ListTableModel<Attribute> {
        public VariantAttributeModel() {
            super(new String[]{"Name", ""});
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Attribute data = (Attribute)this.rows.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return data.getGroup() + " : " + data.getName();
                }
                case 1: {
                    return "";
                }
            }
            return null;
        }
    }

    class ColorCellRenderer
    implements ListCellRenderer {
        protected DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();
        private Dimension preferredSize = new Dimension(0, 30);
        Border emptyBorder = new EmptyBorder(5, 30, 5, 5);

        ColorCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel renderer = (JLabel)this.defaultRenderer.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            renderer.setBackground(Color.WHITE);
            renderer.setBorder(this.emptyBorder);
            renderer.setHorizontalAlignment(2);
            if (value instanceof Attribute && ((Attribute)value).getId() != null) {
                Attribute attribute = (Attribute)value;
                renderer.setText("  " + attribute.getGroup() + ": " + attribute.getName());
                if (cellHasFocus || isSelected) {
                    renderer.setBackground(new Color(0.0f, 0.0f, 0.0f, 0.1f));
                    renderer.setBorder(new LineBorder(Color.DARK_GRAY));
                    renderer.setForeground(Color.BLUE);
                } else {
                    renderer.setForeground(Color.BLACK);
                    renderer.setBorder(null);
                }
            } else {
                renderer.setForeground(new Color(201, 244, 236));
                renderer.setBorder(null);
                renderer.setHorizontalAlignment(0);
                renderer.setFont(new Font(renderer.getFont().getName(), 1, 12));
                renderer.setBackground(Color.GRAY);
            }
            renderer.setPreferredSize(this.preferredSize);
            return renderer;
        }
    }
}

