/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.main.Application;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.VoidReason;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.dao.VoidReasonDAO;
import com.floreantpos.services.PosTransactionService;
import com.floreantpos.swing.ListComboBoxModel;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.dialog.NotesDialog;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.hibernate.StaleStateException;

public class VoidTicketDialog
extends OkCancelOptionDialog
implements RefreshableView {
    private JComboBox cbVoidReasons;
    private POSToggleButton btnItemWasted;
    private Ticket ticket;

    public VoidTicketDialog() {
        this(POSUtil.getFocusedWindow(), (Ticket)null);
    }

    public VoidTicketDialog(Window window, Ticket ticket) {
        super(window, "");
        this.ticket = ticket;
        this.initComponents();
        this.initialize();
        this.setDefaultCloseOperation(0);
    }

    public void setTicket(Ticket ticket) {
        this.ticket = ticket;
    }

    private void initComponents() {
        this.setCaption(Messages.getString("SELECT_VOID_REASON"));
        this.setOkButtonText(POSConstants.SAVE_BUTTON_TEXT);
        this.setDefaultCloseOperation(2);
        Font font2 = new Font("Tahoma", 1, PosUIManager.getFontSize(16));
        JLabel lblReason = new JLabel();
        this.btnItemWasted = new POSToggleButton(POSConstants.ITEMS_WASTED);
        lblReason.setText(Messages.getString("LBL_VOID_REASON"));
        Dimension size = PosUIManager.getSize(300, 35);
        this.cbVoidReasons = new JComboBox();
        this.cbVoidReasons.setPreferredSize(size);
        this.cbVoidReasons.setFont(font2);
        PosButton btnNewVoidReason = new PosButton();
        btnNewVoidReason.setText("+");
        btnNewVoidReason.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VoidTicketDialog.this.doAddNewVoidReason();
            }
        });
        JPanel inputPanel = new JPanel((LayoutManager)new MigLayout("fill,ins 0 5 2 5,hidemode 3", "[grow]", "[][][grow]"));
        inputPanel.add((Component)lblReason, "grow,wrap");
        inputPanel.add((Component)this.cbVoidReasons, "grow,split 3");
        inputPanel.add((Component)btnNewVoidReason, "growy");
        inputPanel.add((Component)this.btnItemWasted, "h 50!,growy,wrap");
        this.getContentPanel().add(inputPanel);
    }

    public void initialize() {
        try {
            VoidReasonDAO dao = new VoidReasonDAO();
            List<VoidReason> voidReasons = dao.findAll();
            this.cbVoidReasons.setModel(new ListComboBoxModel(voidReasons));
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.CANNOT_LOAD_VOID_REASONS, e);
        }
    }

    private void doAddNewVoidReason() {
        try {
            NotesDialog dialog = new NotesDialog();
            dialog.setTitle(POSConstants.ENTER_VOID_REASON);
            dialog.pack();
            dialog.open();
            if (!dialog.isCanceled()) {
                String newVoidReason = dialog.getNote();
                VoidReason voidReason = new VoidReason();
                voidReason.setReasonText(newVoidReason);
                VoidReasonDAO dao = new VoidReasonDAO();
                dao.save(voidReason);
                if (this.cbVoidReasons.getModel() instanceof ListComboBoxModel) {
                    ListComboBoxModel model = (ListComboBoxModel)this.cbVoidReasons.getModel();
                    model.addElement(voidReason);
                    this.cbVoidReasons.setSelectedItem(voidReason);
                }
            }
        }
        catch (Throwable e) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, e);
        }
    }

    @Override
    public void doOk() {
        try {
            if (this.ticket.isVoided().booleanValue()) {
                POSMessageDialog.showMessage(Application.getPosWindow(), Messages.getString("VoidTicketDialog.1"));
                this.canceled = false;
                this.dispose();
                return;
            }
            if (this.ticket.getPaidAmount() > 0.0) {
                POSMessageDialog.showMessage(Application.getPosWindow(), Messages.getString("VoidTicketDialog.2"));
                return;
            }
            if (this.ticket.getRefundAmount() > 0.0) {
                POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("VoidTicketDialog.2"));
                return;
            }
            VoidReason voidReason = (VoidReason)this.cbVoidReasons.getSelectedItem();
            if (voidReason != null) {
                this.ticket.setVoidReason(voidReason.getReasonText());
            }
            this.ticket.setWasted(this.btnItemWasted.isSelected());
            PosTransactionService.getInstance().voidTicket(this.ticket, Application.getCurrentUser());
            this.canceled = false;
            this.dispose();
        }
        catch (StaleStateException e) {
            POSMessageDialog.showMessageDialogWithReloadButton(this, this);
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, e);
        }
    }

    @Override
    public void refresh() {
        this.ticket = TicketDAO.getInstance().loadFullTicket(this.ticket.getId());
    }
}

