/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.export_import.service;

import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.model.base.BaseMenuItem;
import com.floreantpos.model.base.BaseMenuModifier;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.MenuModifierDAO;
import com.floreantpos.model.dao.ModifierGroupDAO;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;

public class ExcelImporterService {
    private static final ExcelImporterService instance = new ExcelImporterService();

    public static ExcelImporterService getInstance() {
        return instance;
    }

    public void doImportMenuItemFromXLSX(List<Object> objectList, MenuCategory menuCategory, MenuGroup menuGroup, XSSFSheet menuItemSheet) throws Exception {
        Iterator rows = menuItemSheet.rowIterator();
        while (rows.hasNext()) {
            boolean rowEmpty;
            XSSFRow xlsxRow = (XSSFRow)rows.next();
            if (xlsxRow.getRowNum() == 0) continue;
            if (xlsxRow.getRowNum() == 1 && (rowEmpty = this.isRowEmpty((Row)xlsxRow))) break;
            Iterator cellIterator = xlsxRow.cellIterator();
            BaseMenuItem menuItem = null;
            while (cellIterator.hasNext()) {
                Cell xlsxCell = (Cell)cellIterator.next();
                String stringValue = "";
                double doubleValue = 0.0;
                switch (xlsxCell.getCellType()) {
                    case 1: {
                        stringValue = xlsxCell.getStringCellValue();
                        break;
                    }
                    case 0: {
                        doubleValue = xlsxCell.getNumericCellValue();
                    }
                }
                String colValue = menuItemSheet.getRow(0).getCell(xlsxCell.getColumnIndex()).getStringCellValue();
                if (colValue.equals("Product Category")) {
                    menuCategory = MenuCategoryDAO.getInstance().findCategoriesByName(stringValue);
                    if (menuCategory != null) continue;
                    menuCategory = new MenuCategory();
                    menuCategory.setName(stringValue);
                    menuCategory.setVisible(true);
                    MenuCategoryDAO.getInstance().save(menuCategory);
                    continue;
                }
                if (colValue.equals("Product Group")) {
                    menuGroup = MenuGroupDAO.getInstance().findMenuGroupByName(stringValue);
                    if (menuGroup != null) continue;
                    menuGroup = new MenuGroup();
                    menuGroup.setName(stringValue);
                    menuGroup.setVisible(true);
                    menuCategory = MenuCategoryDAO.getInstance().initialize(menuCategory);
                    menuGroup.setMenuCategoryId(menuCategory.getId());
                    MenuGroupDAO.getInstance().saveOrUpdate(menuGroup);
                    menuCategory.addTomenuGroups(menuGroup);
                    MenuCategoryDAO.getInstance().update(menuCategory);
                    continue;
                }
                if (colValue.equals("Product Name")) {
                    menuItem = new MenuItem();
                    menuItem.setName(stringValue);
                    menuItem.setMenuCategoryId(menuCategory.getId());
                    menuItem.setMenuGroupId(menuGroup.getId());
                    menuItem.setMenuGroupName(menuGroup.getName());
                    menuItem.setMenuCategoryName(menuCategory.getName());
                    menuItem.setDescription("");
                    menuItem.setPrice(0.0);
                    menuItem.setCost(0.0);
                    menuItem.setSku("");
                    menuItem.setBarcode("");
                    continue;
                }
                if (colValue.equals("Product Description")) {
                    menuItem.setDescription(stringValue);
                    continue;
                }
                if (colValue.equals("Price")) {
                    menuItem.setPrice(this.doubleValue(stringValue, doubleValue));
                    continue;
                }
                if (colValue.equals("Cost")) {
                    menuItem.setCost(this.doubleValue(stringValue, doubleValue));
                    continue;
                }
                if (colValue.equals("SKU")) {
                    menuItem.setSku(stringValue);
                    continue;
                }
                if (colValue.equals("Barcode")) {
                    menuItem.setBarcode(stringValue);
                    continue;
                }
                if (colValue.equals("Active")) {
                    menuItem.setVisible(this.booleanValue(stringValue));
                    continue;
                }
                if (colValue.equals("Fractional Unit")) {
                    menuItem.setFractionalUnit(this.booleanValue(stringValue));
                    continue;
                }
                if (colValue.equals("Inventory Item")) {
                    menuItem.setInventoryItem(this.booleanValue(stringValue));
                    continue;
                }
                if (!colValue.equals("Allow Price Override")) continue;
                menuItem.setEditablePrice(this.booleanValue(stringValue));
            }
            if (menuItem == null || !StringUtils.isNotBlank((String)menuItem.getName())) continue;
            objectList.add(menuItem);
        }
    }

    public void doImportMenuModifierFromXLSX(List<Object> objectList, ModifierGroup menuModifierGroup, XSSFSheet menuModifierSheet) throws Exception {
        Iterator rows = menuModifierSheet.rowIterator();
        while (rows.hasNext()) {
            boolean rowEmpty;
            XSSFRow xlsxRow = (XSSFRow)rows.next();
            if (xlsxRow.getRowNum() == 0) continue;
            if (xlsxRow.getRowNum() == 1 && (rowEmpty = this.isRowEmpty((Row)xlsxRow))) break;
            Iterator cellIterator = xlsxRow.cellIterator();
            BaseMenuModifier menuModifier = null;
            while (cellIterator.hasNext()) {
                Cell xlsxCell = (Cell)cellIterator.next();
                String stringValue = "";
                double doubleValue = 0.0;
                switch (xlsxCell.getCellType()) {
                    case 1: {
                        stringValue = xlsxCell.getStringCellValue();
                        break;
                    }
                    case 0: {
                        doubleValue = xlsxCell.getNumericCellValue();
                    }
                }
                String colValue = menuModifierSheet.getRow(0).getCell(xlsxCell.getColumnIndex()).getStringCellValue();
                if (colValue.equals("Modifier Group")) {
                    menuModifierGroup = ModifierGroupDAO.getInstance().findModifierGroupByName(stringValue);
                    if (menuModifierGroup != null) continue;
                    menuModifierGroup = new ModifierGroup();
                    menuModifierGroup.setName(stringValue);
                    ModifierGroupDAO.getInstance().saveOrUpdate(menuModifierGroup);
                    continue;
                }
                if (colValue.equals("Modifiers Name")) {
                    menuModifier = MenuModifierDAO.getInstance().findName(stringValue);
                    if (menuModifier == null) {
                        menuModifier = new MenuModifier();
                        menuModifier.setName(stringValue);
                        menuModifierGroup.addTomodifiers((MenuModifier)menuModifier);
                        continue;
                    }
                    menuModifier.setPrice(0.0);
                    continue;
                }
                if (colValue.equals("Price")) {
                    menuModifier.setPrice(this.doubleValue(stringValue, doubleValue));
                    continue;
                }
                if (colValue.equals("Active")) {
                    menuModifier.setEnable(this.booleanValue(stringValue));
                    continue;
                }
                if (!colValue.equals("Pizza Modifier")) continue;
                menuModifier.setPizzaModifier(this.booleanValue(stringValue));
            }
            if (menuModifier == null || !StringUtils.isNotBlank((String)menuModifier.getName())) continue;
            objectList.add(menuModifier);
        }
    }

    public void doImportMenuItemFromXLS(List<Object> menuItemList, MenuCategory menuCategory, MenuGroup menuGroup, HSSFSheet menuItemSheet) throws Exception {
        Iterator rows = menuItemSheet.rowIterator();
        while (rows.hasNext()) {
            boolean rowEmpty;
            HSSFRow xlsRow = (HSSFRow)rows.next();
            if (xlsRow.getRowNum() == 0) continue;
            if (xlsRow.getRowNum() == 1 && (rowEmpty = this.isRowEmpty((Row)xlsRow))) break;
            Iterator cellIterator = xlsRow.cellIterator();
            BaseMenuItem menuItem = null;
            while (cellIterator.hasNext()) {
                Cell xlsCell = (Cell)cellIterator.next();
                String stringValue = "";
                double doubleValue = 0.0;
                switch (xlsCell.getCellType()) {
                    case 1: {
                        stringValue = xlsCell.getStringCellValue();
                        break;
                    }
                    case 0: {
                        doubleValue = xlsCell.getNumericCellValue();
                    }
                }
                String colValue = menuItemSheet.getRow(0).getCell(xlsCell.getColumnIndex()).getStringCellValue();
                if (colValue.equals("Product Category")) {
                    menuCategory = MenuCategoryDAO.getInstance().findCategoriesByName(stringValue);
                    if (menuCategory != null) continue;
                    menuCategory = new MenuCategory();
                    menuCategory.setName(stringValue);
                    menuCategory.setVisible(true);
                    continue;
                }
                if (colValue.equals("Product Group")) {
                    menuGroup = MenuGroupDAO.getInstance().findMenuGroupByName(stringValue);
                    if (menuGroup != null) continue;
                    menuGroup = new MenuGroup();
                    menuGroup.setName(stringValue);
                    menuGroup.setVisible(true);
                    menuCategory = MenuCategoryDAO.getInstance().initialize(menuCategory);
                    menuGroup.setMenuCategoryId(menuCategory.getId());
                    menuCategory.addTomenuGroups(menuGroup);
                    MenuCategoryDAO.getInstance().update(menuCategory);
                    continue;
                }
                if (colValue.equals("Product Name")) {
                    menuItem = new MenuItem();
                    menuItem.setName(stringValue);
                    menuItem.setMenuCategoryId(menuCategory.getId());
                    menuItem.setMenuGroupId(menuGroup.getId());
                    menuItem.setMenuGroupName(menuGroup.getName());
                    menuItem.setMenuCategoryName(menuCategory.getName());
                    menuItem.setDescription("");
                    menuItem.setPrice(0.0);
                    menuItem.setCost(0.0);
                    menuItem.setSku("");
                    menuItem.setBarcode("");
                    continue;
                }
                if (colValue.equals("Product Description")) {
                    menuItem.setDescription(stringValue);
                    continue;
                }
                if (colValue.equals("Price")) {
                    menuItem.setPrice(doubleValue);
                    continue;
                }
                if (colValue.equals("Cost")) {
                    menuItem.setCost(doubleValue);
                    continue;
                }
                if (colValue.equals("SKU")) {
                    menuItem.setSku(stringValue);
                    continue;
                }
                if (colValue.equals("Barcode")) {
                    menuItem.setBarcode(stringValue);
                    continue;
                }
                if (colValue.equals("Active")) {
                    menuItem.setVisible(this.booleanValue(stringValue));
                    continue;
                }
                if (colValue.equals("Fractional Unit")) {
                    menuItem.setFractionalUnit(this.booleanValue(stringValue));
                    continue;
                }
                if (colValue.equals("Inventory Item")) {
                    menuItem.setInventoryItem(this.booleanValue(stringValue));
                    continue;
                }
                if (!colValue.equals("Allow Price Override")) continue;
                menuItem.setEditablePrice(this.booleanValue(stringValue));
            }
            if (menuItem == null || !StringUtils.isNotBlank((String)menuItem.getName())) continue;
            menuItemList.add(menuItem);
        }
    }

    public void doImportMenuModifierFromXLS(List<Object> objectList, ModifierGroup menuModifierGroup, HSSFSheet menuModifierSheet) throws Exception {
        Iterator rows = menuModifierSheet.rowIterator();
        while (rows.hasNext()) {
            boolean rowEmpty;
            HSSFRow xlsRow = (HSSFRow)rows.next();
            if (xlsRow.getRowNum() == 0) continue;
            if (xlsRow.getRowNum() == 1 && (rowEmpty = this.isRowEmpty((Row)xlsRow))) break;
            Iterator cellIterator = xlsRow.cellIterator();
            BaseMenuModifier menuModifier = null;
            while (cellIterator.hasNext()) {
                Cell xlsCell = (Cell)cellIterator.next();
                String stringValue = "";
                double doubleValue = 0.0;
                switch (xlsCell.getCellType()) {
                    case 1: {
                        stringValue = xlsCell.getStringCellValue();
                        break;
                    }
                    case 0: {
                        doubleValue = xlsCell.getNumericCellValue();
                    }
                }
                String colValue = menuModifierSheet.getRow(0).getCell(xlsCell.getColumnIndex()).getStringCellValue();
                if (colValue.equals("Modifier Group")) {
                    menuModifierGroup = ModifierGroupDAO.getInstance().findModifierGroupByName(stringValue);
                    if (menuModifierGroup != null) continue;
                    menuModifierGroup = new ModifierGroup();
                    menuModifierGroup.setName(stringValue);
                    ModifierGroupDAO.getInstance().saveOrUpdate(menuModifierGroup);
                    continue;
                }
                if (colValue.equals("Modifiers Name")) {
                    menuModifier = MenuModifierDAO.getInstance().findName(stringValue);
                    if (menuModifier == null) {
                        menuModifier = new MenuModifier();
                        menuModifier.setName(stringValue);
                        menuModifierGroup.addTomodifiers((MenuModifier)menuModifier);
                        continue;
                    }
                    menuModifier.setPrice(0.0);
                    continue;
                }
                if (colValue.equals("Price")) {
                    menuModifier.setPrice(this.doubleValue(stringValue, doubleValue));
                    continue;
                }
                if (colValue.equals("Active")) {
                    menuModifier.setEnable(this.booleanValue(stringValue));
                    continue;
                }
                if (!colValue.equals("Pizza Modifier")) continue;
                menuModifier.setPizzaModifier(this.booleanValue(stringValue));
            }
            if (menuModifier == null || !StringUtils.isNotBlank((String)menuModifier.getName())) continue;
            objectList.add(menuModifier);
        }
    }

    private double doubleValue(String stringValue, double doubleValue) {
        double parseValue = 0.0;
        try {
            parseValue = Double.parseDouble(stringValue);
        }
        catch (Exception e) {
            parseValue = doubleValue;
        }
        return parseValue;
    }

    private boolean booleanValue(String stringValue) {
        if (StringUtils.isEmpty((String)stringValue)) {
            return false;
        }
        return stringValue.equalsIgnoreCase("yes");
    }

    public boolean isRowEmpty(Row row) {
        for (int c = row.getFirstCellNum(); c < row.getLastCellNum(); ++c) {
            Cell cell = row.getCell(c);
            if (cell == null || cell.getCellType() == 3) continue;
            return false;
        }
        return true;
    }

    public boolean checkImporteMenuItemIsDublicate(List<MenuItem> menuItems) {
        if (menuItems == null) {
            return false;
        }
        ArrayList<String> barcodes = new ArrayList<String>();
        ArrayList<String> skus = new ArrayList<String>();
        for (MenuItem item : menuItems) {
            barcodes.add(item.getBarcode());
            skus.add(item.getSku());
            boolean barcodeAlreadyExists = MenuItemDAO.getInstance().hasByBarcodeOrSKU(item.getBarcode(), item.getSku());
            if (!barcodeAlreadyExists) continue;
            return true;
        }
        HashSet setOfBarcode = new HashSet(barcodes);
        if (setOfBarcode.size() < barcodes.size()) {
            return true;
        }
        HashSet setOfSkus = new HashSet(skus);
        return setOfSkus.size() < skus.size();
    }

    public MenuItem checkImporteMenuItemIsDublicate2(List<MenuItem> menuItems) {
        if (menuItems == null) {
            return null;
        }
        ArrayList<String> barcodes = new ArrayList<String>();
        ArrayList<String> skus = new ArrayList<String>();
        for (MenuItem item : menuItems) {
            barcodes.add(item.getBarcode());
            skus.add(item.getSku());
            MenuItem hasByBarcodeOrSKU = MenuItemDAO.getInstance().getMenuItemByBarcodeAndSKU(item.getBarcode(), item.getSku());
            if (hasByBarcodeOrSKU == null) continue;
            return hasByBarcodeOrSKU;
        }
        return null;
    }
}

