/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.floorplan;

import com.floreantpos.Messages;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.dao.ShopTableDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.floorplan.ShopTableForm;
import com.floreantpos.ui.floorplan.ShopTableModelBrowser;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableColumn;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;

public class ShopTableBrowser
extends ShopTableModelBrowser<ShopTable> {
    private JTextField tfSearchSubject;

    public ShopTableBrowser() {
        super(new ShopTableForm());
        this.initTableComponants();
        this.add((Component)this.createSearchPanel(), "North");
    }

    private void initTableComponants() {
        BeanTableModel tableModel = new BeanTableModel(ShopTable.class);
        tableModel.addColumn(Messages.getString("ShopTableBrowser.0"), ShopTable.PROP_ID);
        tableModel.addColumn(Messages.getString("ShopTableBrowser.6"), ShopTable.PROP_NAME);
        tableModel.addColumn(Messages.getString("ShopTableBrowser.1"), ShopTable.PROP_CAPACITY);
        tableModel.addColumn(Messages.getString("ShopTableBrowser.2"), ShopTable.PROP_DESCRIPTION);
        this.init(tableModel);
        this.setColumnWidth(0, 80);
        this.setColumnWidth(1, 60);
    }

    @Override
    public void refreshTable() {
        List<ShopTable> tables = ShopTableDAO.getInstance().findAll();
        BeanTableModel tableModel = (BeanTableModel)this.browserTable.getModel();
        tableModel.removeAll();
        tableModel.addRows(tables);
    }

    private void setColumnWidth(int columnNumber, int width) {
        TableColumn column = this.browserTable.getColumnModel().getColumn(columnNumber);
        column.setPreferredWidth(width);
        column.setMaxWidth(width);
        column.setMinWidth(width);
    }

    private JPanel createSearchPanel() {
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("", "[][]15[][]15[][]15[]", "[]5[]"));
        Border loweredetched = BorderFactory.createEtchedBorder(1);
        TitledBorder title = BorderFactory.createTitledBorder(loweredetched, Messages.getString("Search"));
        title.setTitleJustification(1);
        panel.setBorder(title);
        JLabel lblSearch = new JLabel(Messages.getString("ShopTableBrowser.26"));
        this.tfSearchSubject = new JTextField(15);
        JButton btnSearch = new JButton(Messages.getString("Search"));
        JButton btnReset = new JButton(Messages.getString("ShopTableBrowser.28"));
        JButton btnRefresh = new JButton(Messages.getString("Refresh"));
        this.tfSearchSubject.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShopTableBrowser.this.doSearchTable();
            }
        });
        btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShopTableBrowser.this.doSearchTable();
            }
        });
        btnReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShopTableBrowser.this.tfSearchSubject.setText("");
                ShopTableBrowser.this.doRefreshTable();
            }
        });
        btnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShopTableBrowser.this.tfSearchSubject.setText("");
                ShopTableBrowser.this.doRefreshTable();
            }
        });
        panel.add((Component)lblSearch, "grow");
        panel.add((Component)this.tfSearchSubject, "grow");
        panel.add((Component)btnSearch, "grow");
        panel.add((Component)btnRefresh, "grow");
        return panel;
    }

    private void doSearchTable() {
        String searchSubject = this.tfSearchSubject.getText();
        if (StringUtils.isEmpty((CharSequence)searchSubject)) {
            return;
        }
        List<ShopTable> searchedTables = ShopTableDAO.getInstance().findByCapacity(searchSubject);
        if (searchedTables == null || searchedTables.size() == 0) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("ShopTableBrowser.36"));
            return;
        }
        BeanTableModel tableModel = (BeanTableModel)this.browserTable.getModel();
        tableModel.removeAll();
        tableModel.addRows(searchedTables);
    }

    public void doRefreshTable() {
        List<ShopTable> tables = ShopTableDAO.getInstance().findAllWithTypes();
        Collections.sort(tables, (table1, table2) -> table1.getTableNumber() - table2.getTableNumber());
        BeanTableModel tableModel = (BeanTableModel)this.browserTable.getModel();
        tableModel.removeAll();
        tableModel.addRows(tables);
    }
}

