/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.forms;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.CreditBook;
import com.floreantpos.model.dao.CreditBookDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.util.IllegalModelStateException;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.jdesktop.swingx.JXDatePicker;

public class CreditBookForm
extends BeanEditor<CreditBook> {
    private FixedLengthTextField tfName;
    private JXDatePicker dpExpiredDate;
    private JCheckBox chkExpired;
    private DoubleTextField tfAmount;
    private DoubleTextField tfBalance;

    public CreditBookForm() {
        this(new CreditBook());
    }

    public CreditBookForm(CreditBook creditBook) {
        this.initComponents();
        this.initData(creditBook);
        this.setBean(creditBook);
    }

    public void initData(CreditBook creditBook) {
        if (creditBook == null) {
            return;
        }
        this.tfName.setText(creditBook.getName());
        this.dpExpiredDate.setDate(creditBook.getExpiryDate());
        this.tfAmount.setText(String.valueOf(creditBook.getAmount()));
        this.tfBalance.setText(String.valueOf(creditBook.getBalance()));
        this.chkExpired.setSelected(creditBook.isExpired());
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        JLabel lblName = new JLabel(POSConstants.NAME + ": ");
        this.tfName = new FixedLengthTextField(20, 62);
        JLabel lblExpiredDate = new JLabel(POSConstants.EXPIRY_DATE + ": ");
        this.dpExpiredDate = UiUtil.getCurrentMonthStart();
        JLabel lblAmount = new JLabel(POSConstants.AMOUNT + ": ");
        this.tfAmount = new DoubleTextField(20, 10);
        this.tfAmount.setEditable(false);
        JLabel lblBalance = new JLabel("Balance: ");
        this.tfBalance = new DoubleTextField(20, 10);
        this.tfBalance.setEditable(false);
        this.chkExpired = new JCheckBox(Messages.getString("CreditBookForm.2"));
        JPanel centerPanel = new JPanel((LayoutManager)new MigLayout("fillx, center", "[][]", ""));
        centerPanel.add((Component)lblName, "trailing");
        centerPanel.add((Component)this.tfName, "wrap");
        centerPanel.add((Component)lblExpiredDate, "trailing");
        centerPanel.add((Component)this.dpExpiredDate, "wrap");
        centerPanel.add((Component)lblAmount, "trailing");
        centerPanel.add((Component)this.tfAmount, "wrap");
        centerPanel.add((Component)lblBalance, "trailing");
        centerPanel.add((Component)this.tfBalance, "wrap");
        centerPanel.add((Component)this.chkExpired, "skip 1, wrap");
        this.add((Component)centerPanel, "Center");
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            CreditBookDAO.getInstance().saveOrUpdate((CreditBook)this.bean);
            this.updateView();
        }
        catch (IllegalModelStateException e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
        return true;
    }

    @Override
    protected void updateView() {
        CreditBook creditBook = (CreditBook)this.getBean();
        if (creditBook.getId() == null) {
            return;
        }
        this.initData(creditBook);
    }

    @Override
    protected boolean updateModel() throws IllegalModelStateException {
        String name = this.tfName.getText();
        if (StringUtils.isEmpty((String)name)) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.NAME_REQUIRED);
            return false;
        }
        CreditBook creditBook = (CreditBook)this.getBean();
        creditBook.setName(name.trim());
        creditBook.setExpiryDate(this.dpExpiredDate.getDate());
        creditBook.setLastModifiedDate(StoreDAO.getServerTimestamp());
        creditBook.setAmount(this.tfAmount.getDoubleOrZero());
        creditBook.setBalance(this.tfBalance.getDoubleOrZero());
        creditBook.setExpired(this.chkExpired.isSelected());
        return true;
    }

    @Override
    public String getDisplayText() {
        CreditBook promotion = (CreditBook)this.getBean();
        if (promotion.getId() == null) {
            return Messages.getString("CreditBookForm.15");
        }
        return Messages.getString("CreditBookForm.16");
    }
}

