/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.forms;

import com.floreantpos.config.AppProperties;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.util.JsonUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class MemberUnUsedMinSpendInfoDialog
extends POSDialog {
    private BeanTableModel<UnUsedMinSpendData> tableModel;

    public MemberUnUsedMinSpendInfoDialog(JsonArray memberMinSpendArray) throws Exception {
        super(POSUtil.getFocusedWindow(), AppProperties.getAppName());
        this.setModal(true);
        this.setSize(PosUIManager.getSize(700, 500));
        this.initComponents();
        this.initData(memberMinSpendArray);
    }

    private void initData(JsonArray memberMinSpendArray) throws Exception {
        ArrayList<UnUsedMinSpendData> dataList = new ArrayList<UnUsedMinSpendData>();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        if (memberMinSpendArray == null) {
            return;
        }
        for (JsonObject itemObject : memberMinSpendArray) {
            String name = JsonUtil.getStringValue((JsonValue)itemObject.get((Object)"name"));
            double remainingAmount = JsonUtil.getDoubleValue((JsonValue)itemObject.get((Object)"remainingAmount"));
            double amount = JsonUtil.getDoubleValue((JsonValue)itemObject.get((Object)"amount"));
            String startDateStr = JsonUtil.getStringValue((JsonValue)itemObject.get((Object)"startDate"));
            String endDateStr = JsonUtil.getStringValue((JsonValue)itemObject.get((Object)"endDate"));
            Date startDate = StringUtils.isNotEmpty((String)startDateStr) ? dateFormat.parse(startDateStr) : null;
            Date endDate = StringUtils.isNotEmpty((String)endDateStr) ? dateFormat.parse(endDateStr) : null;
            UnUsedMinSpendData minSpendData = new UnUsedMinSpendData();
            minSpendData.setName(name);
            minSpendData.setRemainingAmnt(remainingAmount);
            minSpendData.setAmount(amount);
            minSpendData.setStartDate(startDate);
            minSpendData.setEndDate(endDate);
            dataList.add(minSpendData);
        }
        this.tableModel.setRows(dataList);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout(5, 5));
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle("Unused min spend data");
        this.add((Component)titlePanel, "North");
        this.tableModel = new BeanTableModel(UnUsedMinSpendData.class, 20);
        this.tableModel.addColumn("NAME", "name");
        this.tableModel.addColumn("REMAINING AMOUNT", "remainingAmnt", 11, BeanTableModel.DataType.MONEY);
        this.tableModel.addColumn("AMOUNT", "amount", 11, BeanTableModel.DataType.MONEY);
        this.tableModel.addColumn("START DATE", "startDate");
        this.tableModel.addColumn("END DATE", "endDate");
        JTable table = new JTable(this.tableModel);
        table.setRowHeight(PosUIManager.getSize(30));
        JPanel centerPanel = new JPanel((LayoutManager)new MigLayout("fill, ins 10"));
        centerPanel.add((Component)new JScrollPane(table), "grow");
        this.add(centerPanel);
        JPanel bottomPanel = new JPanel((LayoutManager)new MigLayout("center"));
        PosButton btnClose = new PosButton("CLOSE");
        btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MemberUnUsedMinSpendInfoDialog.this.setCanceled(false);
                MemberUnUsedMinSpendInfoDialog.this.dispose();
            }
        });
        bottomPanel.add(btnClose);
        this.add((Component)bottomPanel, "South");
    }

    public class UnUsedMinSpendData {
        public static final String PROP_NAME = "name";
        public static final String PROP_REM_AMNT = "remainingAmnt";
        public static final String PROP_AMOUNT = "amount";
        public static final String PROP_START_DATE = "startDate";
        public static final String PROP_END_DATE = "endDateame";
        private String name;
        private double remainingAmnt;
        private Date startDate;
        private Date endDate;
        private double amount;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public double getRemainingAmnt() {
            return this.remainingAmnt;
        }

        public void setRemainingAmnt(double remainingAmnt) {
            this.remainingAmnt = remainingAmnt;
        }

        public Date getStartDate() {
            return this.startDate;
        }

        public void setStartDate(Date startDate) {
            this.startDate = startDate;
        }

        public Date getEndDate() {
            return this.endDate;
        }

        public void setEndDate(Date endDate) {
            this.endDate = endDate;
        }

        public double getAmount() {
            return this.amount;
        }

        public void setAmount(double amount) {
            this.amount = amount;
        }
    }
}

