/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.forms;

import com.floreantpos.Messages;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.dao.ShopTableDAO;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.SoftReference;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public class ShopTableSelectionDialog
extends POSDialog {
    private JComboBox<ShopTable> cbTables;
    private SoftReference<ShopTableSelectionDialog> instance;
    private JSeparator jSeparator1;
    private JPanel buttonPanel;

    public ShopTableSelectionDialog() {
        super(POSUtil.getBackOfficeWindow(), Messages.getString("ShopTableSelectionDialog.0"), true);
    }

    @Override
    protected void initUI() {
        this.getContentPane().setLayout(new BorderLayout(0, 0));
        GridLayout experimentLayout = new GridLayout(0, 3, 5, 0);
        this.buttonPanel = new JPanel(experimentLayout);
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.getContentPane().add((Component)this.buttonPanel, "South");
        JButton btnOk = new JButton(Messages.getString("OK"));
        btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShopTableSelectionDialog.this.setCanceled(false);
                ShopTableSelectionDialog.this.dispose();
            }
        });
        this.buttonPanel.add(btnOk);
        JButton btnCancel = new JButton(Messages.getString("CANCEL"));
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShopTableSelectionDialog.this.setCanceled(true);
                ShopTableSelectionDialog.this.dispose();
            }
        });
        this.buttonPanel.add(btnCancel);
        JPanel contentPanel = new JPanel();
        contentPanel.setPreferredSize(new Dimension(132, 65));
        this.getContentPane().add((Component)contentPanel, "North");
        JLabel lblSelectTable = new JLabel(Messages.getString("ShopTableSelectionDialog.3"));
        contentPanel.add(lblSelectTable);
        this.cbTables = new JComboBox();
        this.cbTables.setPreferredSize(new Dimension(132, 24));
        contentPanel.add(this.cbTables);
        this.jSeparator1 = new JSeparator();
        this.getContentPane().add((Component)this.jSeparator1, "Center");
    }

    public ShopTable getSelectedTable() {
        if (this.isCanceled()) {
            return null;
        }
        return (ShopTable)this.cbTables.getSelectedItem();
    }

    public ShopTableSelectionDialog getInstance(List<ShopTable> tables) {
        if (this.instance == null || this.instance.get() == null) {
            this.instance = new SoftReference<ShopTableSelectionDialog>(new ShopTableSelectionDialog());
        }
        ShopTableSelectionDialog shopTableSelectionDialog = this.instance.get();
        if (tables == null) {
            shopTableSelectionDialog.cbTables.setModel(new ComboBoxModel(ShopTableDAO.getInstance().getAllUnassigned()));
        } else {
            shopTableSelectionDialog.cbTables.setModel(new ComboBoxModel(tables));
        }
        return shopTableSelectionDialog;
    }

    public JPanel getButtonPanel() {
        return this.buttonPanel;
    }

    public void addTotables(ShopTable table) {
        ComboBoxModel model = (ComboBoxModel)this.cbTables.getModel();
        model.addElement(table);
        model.setSelectedItem(table);
    }
}

