/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.forms;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.Store;
import com.floreantpos.model.User;
import com.floreantpos.model.UserType;
import com.floreantpos.model.dao.ImageResourceDAO;
import com.floreantpos.model.dao.OrderTypeDAO;
import com.floreantpos.model.dao.OutletDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.dao.UserTypeDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.IllegalModelStateException;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.FixedLengthDocument;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.MultiSelectComboBox;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.ImageGalleryDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.forms.GeneratePasswordDialog;
import com.floreantpos.ui.forms.ScrollableContainer;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import net.miginfocom.swing.MigLayout;

public class UserForm
extends BeanEditor
implements ScrollableContainer {
    private FixedLengthTextField tfFirstName;
    private FixedLengthTextField tfId;
    private FixedLengthTextField tfLastName;
    private JPasswordField tfPassword;
    private FixedLengthTextField tfSsn;
    private FixedLengthTextField tfPhone;
    private JComboBox cbUserType;
    private JLabel lblImagePreview;
    private DoubleTextField tfCostPerHour;
    private JCheckBox chkDriver;
    private JCheckBox chkStaffBank;
    private JCheckBox chkAutoStartStaffBank;
    private JCheckBox chkAllowReceiveTips;
    private JCheckBox chkBlindAccountableAmount;
    private ImageResource imageResource;
    private JCheckBox chkActive;
    private JCheckBox chkAllowClockOutWithOpenTickets;
    private JComboBox cbOutlet = new JComboBox();
    private MultiSelectComboBox<OrderType> cbMultiOrderType;
    private boolean editMode;
    private DoubleTextField tfOTRatePerHour;
    private JButton btnViewPass;

    public UserForm() {
        this.initComponents();
        UserTypeDAO dao = new UserTypeDAO();
        List<UserType> userTypes = dao.findAll();
        DefaultComboBoxModel<Object> userTypeModel = new DefaultComboBoxModel<Object>(userTypes.toArray());
        userTypeModel.insertElementAt(null, 0);
        this.cbUserType.setModel(userTypeModel);
        this.cbOutlet.setModel(this.getComboModel(OutletDAO.getInstance().findAll()));
    }

    private ComboBoxModel getComboModel(List items) {
        ArrayList<String> dataList = new ArrayList<String>();
        dataList.add("");
        dataList.addAll(items);
        return new ComboBoxModel(dataList);
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("hidemode 3", "[134px][204px,grow][][]", ""));
        JLabel lblUserType = new JLabel(Messages.getString("UserForm.31"));
        JLabel lblCostPerHour = new JLabel(Messages.getString("UserForm.28"));
        JLabel lblId = new JLabel(Messages.getString("UserForm.7"));
        JLabel lblSSN = new JLabel(Messages.getString("UserForm.4"));
        JLabel lblFirstName = new JLabel(Messages.getString("UserForm.14"));
        JLabel lblLastName = new JLabel(Messages.getString("UserForm.16"));
        JLabel lblSecretKey = new JLabel(Messages.getString("UserForm.18"));
        JLabel lblPhone = new JLabel(Messages.getString("UserForm.9"));
        JLabel lblOrderType = new JLabel(POSConstants.ORDER_TYPE);
        this.tfPhone = new FixedLengthTextField();
        this.tfPhone.setLength(20);
        this.tfPhone.setColumns(20);
        this.tfPassword = new JPasswordField(new FixedLengthDocument(16), "", 10);
        this.tfPassword.setEditable(false);
        this.tfPassword.setBorder(null);
        this.btnViewPass = new JButton("View pass");
        this.btnViewPass.addActionListener(e -> this.doViewPassword());
        JPanel passwordPanel = new JPanel(new BorderLayout(0, 0));
        Border lowered_bevelborder = BorderFactory.createEtchedBorder();
        passwordPanel.setBorder(lowered_bevelborder);
        passwordPanel.add((Component)this.tfPassword, "Center");
        passwordPanel.add((Component)this.btnViewPass, "East");
        this.tfId = new FixedLengthTextField(128);
        this.tfSsn = new FixedLengthTextField();
        this.tfSsn.setLength(30);
        this.tfSsn.setColumns(30);
        this.tfFirstName = new FixedLengthTextField();
        this.tfFirstName.setColumns(30);
        this.tfFirstName.setLength(30);
        this.tfLastName = new FixedLengthTextField();
        this.tfLastName.setLength(30);
        this.tfLastName.setColumns(30);
        this.tfCostPerHour = new DoubleTextField();
        this.tfOTRatePerHour = new DoubleTextField();
        this.cbUserType = new JComboBox();
        this.cbMultiOrderType = new MultiSelectComboBox();
        this.cbMultiOrderType.setItems(OrderTypeDAO.getInstance().findAll());
        this.lblImagePreview = new JLabel("");
        this.lblImagePreview.setHorizontalAlignment(0);
        this.lblImagePreview.setBorder(BorderFactory.createTitledBorder(null, Messages.getString("UserForm.5"), 2, 2));
        this.lblImagePreview.setPreferredSize(new Dimension(150, 160));
        JButton createPassBtn = new JButton(Messages.getString("UserForm.6"));
        createPassBtn.addActionListener(e -> this.doOpenGenPassDialog());
        JButton btnSelectImage = new JButton(Messages.getString("UserForm.2"));
        JButton btnClearImage = new JButton(Messages.getString("MenuItemForm.34"));
        btnClearImage.setHorizontalAlignment(11);
        btnSelectImage.addActionListener(e -> this.doSelectImageFile());
        btnClearImage.addActionListener(e -> this.doClearImage());
        this.add((Component)lblId, "cell 1 0 ,alignx trailing,aligny center");
        this.add((Component)this.tfId, "cell 2 0");
        this.add((Component)lblPhone, "cell 1 1,alignx trailing");
        this.add((Component)this.tfPhone, "cell 2 1,growx,aligny center");
        this.add((Component)lblSSN, "cell 1 2,alignx trailing,aligny center");
        this.add((Component)this.tfSsn, "cell 2 2,growx,aligny center");
        this.add((Component)lblFirstName, "cell 1 3,alignx trailing,aligny center");
        this.add((Component)this.tfFirstName, "cell 2 3,growx,aligny center");
        this.add((Component)lblLastName, "cell 1 4, alignx trailing,aligny center");
        this.add((Component)this.tfLastName, "cell 2 4,growx,aligny center");
        this.add((Component)lblSecretKey, "cell 1 5,alignx trailing,aligny center");
        this.add((Component)passwordPanel, "cell 2 5,growx,aligny center");
        this.add((Component)lblCostPerHour, "cell 1 6,alignx trailing,aligny center");
        this.add((Component)this.tfCostPerHour, "cell 2 6,growx,aligny center");
        this.add((Component)new JLabel(Messages.getString("UserForm.3")), "cell 1 7,gapleft 80,alignx trailing,aligny center");
        this.add((Component)this.tfOTRatePerHour, "cell 2 7,growx,aligny center");
        this.add((Component)lblUserType, "cell 1 8,alignx trailing,aligny center");
        this.cbUserType.setModel(new DefaultComboBoxModel<String>(new String[]{Messages.getString("UserForm.33"), Messages.getString("UserForm.34"), Messages.getString("UserForm.35")}));
        this.add((Component)this.cbUserType, "cell 2 8,growx,aligny center");
        this.add((Component)new JLabel(Messages.getString("UserForm.8")), "cell 1 9,alignx trailing,aligny center");
        this.add((Component)this.cbOutlet, "cell 2 9,growx,aligny center");
        int comboWidth = PosUIManager.getSize(340);
        this.add((Component)lblOrderType, "cell 1 10,alignx trailing,aligny center");
        this.add(this.cbMultiOrderType, "cell 2 10,w " + comboWidth + "!,aligny center");
        this.chkDriver = new JCheckBox(Messages.getString("UserForm.0"));
        this.chkStaffBank = new JCheckBox(Messages.getString("UserForm.10"));
        this.chkAutoStartStaffBank = new JCheckBox(Messages.getString("UserForm.12"));
        this.chkAllowReceiveTips = new JCheckBox(Messages.getString("UserForm.15"));
        this.chkBlindAccountableAmount = new JCheckBox(Messages.getString("UserForm.19"));
        this.chkStaffBank.addActionListener(e -> {
            this.chkAutoStartStaffBank.setEnabled(this.chkStaffBank.isSelected());
            this.chkBlindAccountableAmount.setEnabled(this.chkStaffBank.isSelected());
        });
        this.chkAutoStartStaffBank.setEnabled(this.chkStaffBank.isSelected());
        this.chkBlindAccountableAmount.setEnabled(this.chkStaffBank.isSelected());
        this.add((Component)this.chkDriver, "cell 2 11");
        this.add((Component)this.chkStaffBank, "cell 2 12");
        this.add((Component)this.chkAutoStartStaffBank, "cell 2 13");
        this.add((Component)this.chkBlindAccountableAmount, "cell 2 14");
        this.add((Component)this.chkAllowReceiveTips, "cell 2 15");
        this.chkActive = new JCheckBox(Messages.getString("ACTIVE"));
        this.add((Component)this.chkActive, "cell 2 16");
        this.chkAllowClockOutWithOpenTickets = new JCheckBox(Messages.getString("UserForm.21"));
        this.add((Component)this.chkAllowClockOutWithOpenTickets, "cell 2 17");
        this.add((Component)this.lblImagePreview, "cell 0 0 8 8,growy");
        this.add((Component)btnSelectImage, "cell 0 8 ,center");
        this.add((Component)btnClearImage, "cell 0 8 ,center");
        this.add((Component)createPassBtn, "cell 3 5 ,center");
    }

    private void doViewPassword() {
        this.tfPassword.setEchoChar(!this.tfPassword.echoCharIsSet() ? ((Character)UIManager.get("PasswordField.echoChar")).charValue() : (char)'\u0000');
        this.btnViewPass.setText(this.tfPassword.getEchoChar() != '\u0000' ? "View pass" : "Hide pass");
    }

    @Override
    public String getDisplayText() {
        if (this.isEditMode()) {
            return Messages.getString("UserForm.37");
        }
        return Messages.getString("UserForm.38");
    }

    @Override
    public boolean save() {
        try {
            this.updateModel();
        }
        catch (IllegalModelStateException e) {
            POSMessageDialog.showError(this, e.getMessage());
            return false;
        }
        User user = (User)this.getBean();
        UserDAO userDAO = UserDAO.getInstance();
        if (!this.editMode && userDAO.isUserExist(user.getId())) {
            POSMessageDialog.showError(this, Messages.getString("UserForm.39") + user.getId() + " " + Messages.getString("UserForm.1"));
            return false;
        }
        try {
            userDAO.saveOrUpdate(user, this.editMode);
        }
        catch (PosException x) {
            POSMessageDialog.showError(this, x.getMessage(), x);
            PosLog.error(this.getClass(), x);
            return false;
        }
        catch (Exception x) {
            POSMessageDialog.showError(this, Messages.getString("UserForm.41"), x);
            PosLog.error(this.getClass(), x);
            return false;
        }
        return true;
    }

    @Override
    protected boolean updateModel() throws IllegalModelStateException {
        Object selectedOutlet;
        User user = null;
        user = !(this.getBean() instanceof User) ? new User() : (User)this.getBean();
        String id = this.tfId.getText();
        String ssn = this.tfSsn.getText();
        String firstName = this.tfFirstName.getText();
        String lastName = this.tfLastName.getText();
        String secretKey1 = new String(this.tfPassword.getPassword());
        if (POSUtil.isBlankOrNull(id)) {
            throw new IllegalModelStateException(Messages.getString("UserForm.50"));
        }
        if (POSUtil.isBlankOrNull(firstName)) {
            throw new IllegalModelStateException(Messages.getString("UserForm.43"));
        }
        if (POSUtil.isBlankOrNull(secretKey1)) {
            throw new IllegalModelStateException(Messages.getString("UserForm.45"));
        }
        User userBySecretKey = UserDAO.getInstance().findUserBySecretKey(secretKey1);
        if (userBySecretKey != null && !userBySecretKey.equals(user)) {
            throw new IllegalModelStateException(Messages.getString("UserForm.48"));
        }
        double costPerHour = this.tfCostPerHour.getDoubleOrZero();
        double overtimeRatePerHour = this.tfOTRatePerHour.getDoubleOrZero();
        if (overtimeRatePerHour == 0.0) {
            overtimeRatePerHour = costPerHour;
        }
        if ((selectedOutlet = this.cbOutlet.getSelectedItem()) instanceof Outlet) {
            user.setOutletId(((Outlet)selectedOutlet).getId());
        } else {
            user.setOutletId(null);
        }
        Store store = DataProvider.get().getStore();
        double overtimeMarkup = store.getOvertimeMarkup();
        if (costPerHour > 0.0 && overtimeMarkup > 0.0 && overtimeRatePerHour == 0.0) {
            overtimeRatePerHour = costPerHour + costPerHour * (overtimeMarkup / 100.0);
        }
        user.setPropOrderTypes(this.cbMultiOrderType.getSelectedItems());
        UserType selectedRole = (UserType)this.cbUserType.getSelectedItem();
        user.setType(selectedRole);
        user.setRoot(true);
        user.setCostPerHour(costPerHour);
        user.setSsn(ssn);
        user.setId(id);
        user.setFirstName(firstName);
        user.setLastName(lastName);
        user.setPhoneNo(this.tfPhone.getText());
        user.setEncryptedPassword(secretKey1);
        user.setDriver(this.chkDriver.isSelected());
        user.setStaffBank(this.chkStaffBank.isSelected());
        user.setActive(this.chkActive.isSelected());
        user.setAllowClockOutWithOpenTickets(this.chkAllowClockOutWithOpenTickets.isSelected());
        user.setOvertimeRatePerHour(overtimeRatePerHour);
        user.setAllowReceiveTips(this.chkAllowReceiveTips.isSelected());
        if (this.chkStaffBank.isSelected()) {
            user.setAutoStartStaffBank(this.chkAutoStartStaffBank.isSelected());
            user.setBlindAccountableAmount(this.chkBlindAccountableAmount.isSelected());
        } else {
            user.setAutoStartStaffBank(false);
            user.setBlindAccountableAmount(false);
        }
        try {
            List<User> linkedUserList = user.getLinkedUser();
            if (linkedUserList == null || linkedUserList.isEmpty()) {
                user.setParentUser(user);
                user.setRoot(true);
            }
            if (linkedUserList != null) {
                for (User linkedUser : linkedUserList) {
                    if (user.getId() != null || !linkedUser.getType().getName().equals(selectedRole.getName())) continue;
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("UserForm.13"));
                    return false;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.imageResource != null) {
            user.setImageId(this.imageResource.getId());
        } else {
            user.setImageId(null);
        }
        this.setBean(user);
        return true;
    }

    @Override
    protected void updateView() {
        if (!(this.getBean() instanceof User)) {
            return;
        }
        User user = (User)this.getBean();
        this.setData(user);
    }

    private void setData(User user) {
        if (user.getId() != null) {
            this.tfId.setText(String.valueOf(user.getId()));
        } else {
            this.tfId.setText("");
        }
        if (user.getSsn() != null) {
            this.tfSsn.setText(user.getSsn());
        } else {
            this.tfSsn.setText("");
        }
        this.tfFirstName.setText(user.getFirstName());
        this.tfLastName.setText(user.getLastName());
        this.tfPassword.setText(user.getPasswordAsPlainText());
        this.tfPhone.setText(user.getPhoneNo());
        this.cbUserType.setSelectedItem(user.getType());
        Double costPerHour = user.getCostPerHour();
        if (costPerHour == null) {
            costPerHour = 0.0;
        }
        List<OrderType> orderTypes = user.getPropOrderTypes();
        this.cbMultiOrderType.unselectAllItems();
        this.cbMultiOrderType.setSelectedItems(orderTypes);
        this.tfCostPerHour.setText(String.valueOf(costPerHour));
        this.chkDriver.setSelected(user.isDriver());
        this.chkStaffBank.setSelected(user.isStaffBank());
        this.chkAutoStartStaffBank.setSelected(user.isAutoStartStaffBank());
        this.chkBlindAccountableAmount.setSelected(user.isBlindAccountableAmount());
        this.chkActive.setSelected(user.isActive());
        this.chkAllowClockOutWithOpenTickets.setSelected(user.isAllowClockOutWithOpenTickets());
        this.chkAllowReceiveTips.setSelected(user.isAllowReceiveTips());
        this.imageResource = ImageResourceDAO.getInstance().findById(user.getImageId());
        if (this.imageResource != null) {
            this.lblImagePreview.setIcon(this.imageResource.getButtonBigImage());
        }
        this.chkAutoStartStaffBank.setEnabled(this.chkStaffBank.isSelected());
        this.chkBlindAccountableAmount.setEnabled(this.chkStaffBank.isSelected());
        this.cbOutlet.setSelectedItem(user.getOutletId() == null ? "" : OutletDAO.getInstance().get(user.getOutletId()));
        if (user.getOvertimeRatePerHour() != null) {
            this.tfOTRatePerHour.setText(String.valueOf(user.getOvertimeRatePerHour()));
        }
    }

    public boolean isEditMode() {
        return this.editMode;
    }

    public void setEditMode(boolean editMode) {
        this.editMode = editMode;
        if (editMode) {
            this.tfId.setEditable(false);
        } else {
            this.tfId.setEditable(true);
        }
    }

    public void setId(Integer id) {
        if (id != null) {
            this.tfId.setText(String.valueOf(id));
        }
    }

    protected void doSelectImageFile() {
        ImageGalleryDialog dialog = ImageGalleryDialog.getInstance();
        dialog.setSelectBtnVisible(true);
        dialog.setTitle(Messages.getString("UserForm.17"));
        dialog.setSize(PosUIManager.getSize(650, 600));
        dialog.setResizable(false);
        dialog.open();
        if (dialog.isCanceled()) {
            return;
        }
        this.imageResource = dialog.getImageResource();
        if (this.imageResource != null) {
            this.lblImagePreview.setIcon(this.imageResource.getButtonBigImage());
        }
    }

    protected void doClearImage() {
        this.lblImagePreview.setIcon(null);
        this.imageResource = null;
    }

    private void doOpenGenPassDialog() {
        GeneratePasswordDialog generatePassDialog = new GeneratePasswordDialog();
        generatePassDialog.setSize(530, 340);
        generatePassDialog.open();
        if (generatePassDialog.isCanceled()) {
            return;
        }
        this.tfPassword.setText(generatePassDialog.getGenPassword());
    }
}

