/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.menuitem;

import com.floreantpos.Messages;
import com.floreantpos.PosLog;
import com.floreantpos.model.InventoryVendorItems;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.dao.InventoryVendorItemsDAO;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.POSTextField;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.menuitem.VendorSelectionDialog;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import net.miginfocom.swing.MigLayout;

public class InventoryPanel
extends TransparentPanel {
    private POSTextField tfSku;
    private DoubleTextField tfReorderLevel;
    private DoubleTextField tfReplenishLevel;
    private JCheckBox chkDisableStockCount;
    private JLabel lblSku;
    private JList<InventoryVendorItems> listVendorItems;
    private MenuItem menuItem;
    private DefaultListModel model;

    public InventoryPanel(MenuItem menuItem) {
        this.menuItem = menuItem;
        this.initComponents();
        this.initData();
    }

    private void initData() {
        if (this.menuItem != null) {
            this.tfSku.setText(this.menuItem.getSku());
            this.tfReorderLevel.setText(this.menuItem.getReorderLevel() + "");
            this.tfReplenishLevel.setText(this.menuItem.getReplenishLevel() + "");
            this.chkDisableStockCount.setSelected(this.menuItem.isDisableWhenStockAmountIsZero());
            this.initVendors();
        }
    }

    private void initVendors() {
        if (this.menuItem == null) {
            return;
        }
        List<InventoryVendorItems> vendorItems = InventoryVendorItemsDAO.getInstance().findByItem(this.menuItem);
        if (vendorItems != null) {
            for (InventoryVendorItems inventoryVendorItems : vendorItems) {
                this.model.addElement(inventoryVendorItems);
            }
        }
    }

    public void setMenuItem(MenuItem menuItem) {
        if (menuItem == null) {
            return;
        }
        this.tfSku.setText(menuItem.getSku());
        this.tfReorderLevel.setText(menuItem.getReorderLevel() + "");
        this.tfReplenishLevel.setText(menuItem.getReplenishLevel() + "");
        this.chkDisableStockCount.setSelected(menuItem.isDisableWhenStockAmountIsZero());
        this.initVendors();
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("hidemode 3,insets 20", "[][]", ""));
        this.lblSku = new JLabel(Messages.getString("MenuItemForm.59"));
        this.tfSku = new POSTextField();
        JLabel lblReorderLevel = new JLabel(Messages.getString("InventoryPanel.8"));
        this.tfReorderLevel = new DoubleTextField(20);
        JLabel lblReplenishLevel = new JLabel(Messages.getString("InventoryPanel.9"));
        this.tfReplenishLevel = new DoubleTextField(20);
        this.chkDisableStockCount = new JCheckBox(Messages.getString("MenuItemForm.18"));
        JLabel lblVendor = new JLabel(Messages.getString("InventoryPanel.11"));
        lblVendor.setVerticalAlignment(1);
        lblVendor.setHorizontalAlignment(11);
        this.listVendorItems = new JList();
        this.listVendorItems.setSelectionMode(0);
        this.model = new DefaultListModel();
        this.listVendorItems.setModel(this.model);
        JButton btnAdd = new JButton(Messages.getString("InventoryPanel.12"));
        JButton btnDelete = new JButton(Messages.getString("InventoryPanel.13"));
        btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InventoryPanel.this.doAddVendor();
            }
        });
        btnDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InventoryPanel.this.doDeleteVendor();
            }
        });
        this.add((Component)this.lblSku, "alignx right");
        this.add((Component)this.tfSku, "wrap");
        this.add((Component)lblReorderLevel, "alignx right");
        this.add((Component)this.tfReorderLevel, "wrap");
        this.add((Component)lblReplenishLevel, "alignx right");
        this.add((Component)this.tfReplenishLevel, "wrap");
        this.add((Component)lblVendor, "right, grow");
        JScrollPane scrollPane = new JScrollPane(this.listVendorItems);
        scrollPane.setPreferredSize(PosUIManager.getSize(220, 300));
        this.add((Component)scrollPane, "grow, wrap");
        this.add((Component)btnAdd, "skip 1,split 2, grow");
        this.add((Component)btnDelete, "grow, wrap");
        this.add((Component)this.chkDisableStockCount, "skip 1, wrap");
    }

    public String getSku() {
        return this.tfSku.getText();
    }

    public void setSku(String sku) {
        this.tfSku.setText(sku);
    }

    public double getReOrderLevel() {
        return this.tfReorderLevel.getDouble();
    }

    public void setReOrderLevel(double reOrderLevel) {
        this.tfReorderLevel.setText(String.valueOf(reOrderLevel));
    }

    public double getReplenishLevel() {
        return this.tfReplenishLevel.getDouble();
    }

    public void setReplenishLevel(double replenishLevel) {
        this.tfReplenishLevel.setText(String.valueOf(replenishLevel));
    }

    public boolean isCbDisableStockCount() {
        return this.chkDisableStockCount.isSelected();
    }

    public void setCbDisableStockCount(boolean isSelected) {
        this.chkDisableStockCount.setSelected(isSelected);
    }

    public void setSkuInvisible() {
        this.lblSku.setVisible(false);
        this.tfSku.setVisible(false);
    }

    public List<InventoryVendorItems> getVendorItems() {
        ArrayList<InventoryVendorItems> vendorItems = new ArrayList<InventoryVendorItems>();
        ListModel<InventoryVendorItems> listModel = this.listVendorItems.getModel();
        for (int i = 0; i < listModel.getSize(); ++i) {
            vendorItems.add(listModel.getElementAt(i));
        }
        return vendorItems;
    }

    private void doAddVendor() {
        try {
            VendorSelectionDialog dialog = new VendorSelectionDialog();
            dialog.setMenuItem(this.menuItem);
            dialog.setDefaultCloseOperation(2);
            dialog.setSize(PosUIManager.getSize(500, 550));
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            List<InventoryVendorItems> vendorItems = dialog.getVendorItems();
            for (InventoryVendorItems inventoryVendorItems : vendorItems) {
                boolean exists = false;
                if (this.model.getSize() > 0) {
                    for (int i = 0; i < this.model.getSize(); ++i) {
                        InventoryVendorItems item = (InventoryVendorItems)this.model.getElementAt(i);
                        if (!item.getVendor().getId().equals(inventoryVendorItems.getVendor().getId())) continue;
                        exists = true;
                        break;
                    }
                }
                if (exists) continue;
                this.model.addElement(inventoryVendorItems);
            }
        }
        catch (Exception e) {
            PosLog.error(InventoryPanel.class, e.getMessage(), e);
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("InventoryPanel.18"));
        }
    }

    private void doDeleteVendor() {
        try {
            InventoryVendorItems selectedVendorItems = this.listVendorItems.getSelectedValue();
            if (selectedVendorItems == null) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("InventoryPanel.19"));
                return;
            }
            int option = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("InventoryPanel.20"), Messages.getString("InventoryPanel.21"));
            if (option != 0) {
                return;
            }
            this.model.removeElement(selectedVendorItems);
            if (selectedVendorItems.getId() != null) {
                InventoryVendorItemsDAO.getInstance().delete(selectedVendorItems);
            }
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("InventoryPanel.22"));
        }
        catch (Exception e) {
            PosLog.error(InventoryPanel.class, e.getMessage(), e);
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("InventoryPanel.23"));
        }
    }
}

