/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.model.Attribute;
import com.floreantpos.model.AttributeGroup;
import com.floreantpos.model.dao.AttributeDAO;
import com.floreantpos.model.dao.AttributeGroupDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.util.IllegalModelStateException;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class AttributeEntryForm
extends BeanEditor<Attribute> {
    private FixedLengthTextField tfName = new FixedLengthTextField(30);
    private IntegerTextField tfFactor = new IntegerTextField(10);
    private JComboBox<AttributeGroup> cbGroups = new JComboBox();
    private List<AttributeGroup> groups;
    private JButton btnAddNew;
    private JCheckBox chkDefaultAttribute;

    public AttributeEntryForm() {
        this(new Attribute());
    }

    public AttributeEntryForm(Attribute unit) {
        this.createUI();
        this.loadAttributeGroups();
        this.setBean(unit);
    }

    private void loadAttributeGroups() {
        this.groups = AttributeGroupDAO.getInstance().findAll();
        if (this.groups != null) {
            this.cbGroups.setModel(new ComboBoxModel(this.groups));
        }
    }

    private void createUI() {
        this.setLayout((LayoutManager)new MigLayout("fillx"));
        this.add(new JLabel(Messages.getString("NAME")));
        this.add((Component)this.tfName, "grow, wrap");
        this.add(new JLabel(Messages.getString("AttributeEntryForm.3")));
        this.add((Component)this.tfFactor, "wrap,grow");
        this.add(new JLabel(Messages.getString("AttributeEntryForm.5")));
        this.add(this.cbGroups, "split 2,grow");
        this.btnAddNew = new JButton(Messages.getString("AttributeEntryForm.7"));
        this.btnAddNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    AttributeGroup group = new AttributeGroup();
                    String groupName = JOptionPane.showInputDialog(POSUtil.getFocusedWindow(), (Object)Messages.getString("AttributeEntryForm.8"));
                    if (groupName == null) {
                        return;
                    }
                    if (groupName.length() > 30) {
                        BOMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("AttributeEntryForm.9"));
                        return;
                    }
                    GenericDAO.getInstance().checkIdOrNameExists(group.getId(), groupName, AttributeGroup.class);
                    group.setName(groupName);
                    AttributeGroupDAO.getInstance().saveOrUpdate(group);
                    AttributeEntryForm.this.groups.add(group);
                    AttributeEntryForm.this.cbGroups.setModel(new ComboBoxModel(AttributeEntryForm.this.groups));
                    AttributeEntryForm.this.cbGroups.setSelectedItem(group);
                }
                catch (PosException exception) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage());
                }
            }
        });
        this.add((Component)this.btnAddNew, "wrap");
        this.chkDefaultAttribute = new JCheckBox(Messages.getString("AttributeEntryForm.11"));
        this.add((Component)this.chkDefaultAttribute, "skip 1,wrap");
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            Attribute selectedUnit = (Attribute)this.getBean();
            boolean baseUnit = selectedUnit.isDefaultAttribute();
            AttributeGroup unitGroup = selectedUnit.getGroup();
            if (baseUnit) {
                if (unitGroup.getAttributes() != null) {
                    for (Attribute unit : unitGroup.getAttributes()) {
                        unit.setDefaultAttribute(false);
                    }
                }
                selectedUnit.setDefaultAttribute(true);
            }
            ArrayList<Attribute> newAttributes = new ArrayList<Attribute>();
            List<Attribute> units = unitGroup.getAttributes();
            if (units != null) {
                if (units.contains(selectedUnit)) {
                    for (Attribute attribute : units) {
                        if (attribute.getId().equals(selectedUnit.getId())) {
                            attribute = selectedUnit;
                        }
                        newAttributes.add(attribute);
                    }
                    unitGroup.setAttributes(newAttributes);
                } else {
                    unitGroup.addToattributes(selectedUnit);
                }
            } else {
                unitGroup.addToattributes(selectedUnit);
            }
            AttributeGroupDAO.getInstance().saveOrUpdate(unitGroup);
            return true;
        }
        catch (PosException e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage());
        }
        catch (IllegalModelStateException e) {
            POSMessageDialog.showError(this, e.getMessage());
        }
        return false;
    }

    @Override
    public void createNew() {
        this.setBean(new Attribute());
        this.clearFields();
    }

    @Override
    public void setFieldsEnable(boolean enable) {
        this.tfName.setEnabled(enable);
        this.tfFactor.setEnabled(enable);
        this.cbGroups.setEnabled(enable);
        this.btnAddNew.setEnabled(enable);
        this.chkDefaultAttribute.setEnabled(enable);
    }

    @Override
    public void clearFields() {
        this.tfName.setText("");
        this.tfFactor.setText("");
    }

    @Override
    protected void updateView() {
        Attribute attribute = (Attribute)this.getBean();
        if (attribute == null) {
            return;
        }
        this.tfName.setText(attribute.getName());
        this.tfFactor.setText(attribute.getSortOrder() + "");
        this.cbGroups.setSelectedItem(attribute.getGroup());
        this.chkDefaultAttribute.setSelected(attribute.isDefaultAttribute());
    }

    @Override
    protected boolean updateModel() throws IllegalModelStateException {
        Attribute attribute = (Attribute)this.getBean();
        String name = this.tfName.getText().trim();
        Integer conversionRate = this.tfFactor.getInteger();
        AttributeGroup group = (AttributeGroup)this.cbGroups.getSelectedItem();
        if (group == null) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), Messages.getString("AttributeEntryForm.16"));
            return false;
        }
        GenericDAO.getInstance().checkIdOrNameExists(attribute.getId(), name, Attribute.class);
        attribute.setName(name);
        attribute.setSortOrder(conversionRate);
        attribute.setGroup(group);
        attribute.setDefaultAttribute(this.chkDefaultAttribute.isSelected());
        return true;
    }

    @Override
    public boolean delete() {
        try {
            Attribute attribute = (Attribute)this.getBean();
            if (attribute == null) {
                return false;
            }
            int option = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), Messages.getString("AttributeEntryForm.17"), Messages.getString("CONFIRM"));
            if (option != 0) {
                return false;
            }
            AttributeDAO.getInstance().delete(attribute);
            this.clearFields();
            return true;
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), e.getMessage(), e);
            return false;
        }
    }

    @Override
    public String getDisplayText() {
        return Messages.getString("AttributeEntryForm.19");
    }

    @Override
    public void refresh() {
        this.loadAttributeGroups();
        Attribute attribute = (Attribute)this.getBean();
        if (attribute != null && StringUtils.isNotBlank((String)attribute.getId())) {
            attribute = AttributeDAO.getInstance().get(attribute.getId());
            if (attribute.getDeleted().booleanValue()) {
                String message = Messages.getString("AttributeEntryForm.0");
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), message);
                BeanEditorDialog dialog = this.getEditorDialog();
                if (dialog != null) {
                    dialog.setCancel(Boolean.FALSE);
                    dialog.dispose();
                }
            }
            this.setBean(attribute, Boolean.TRUE);
        }
    }
}

