/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.main.Application;
import com.floreantpos.model.ComboGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.PosButton;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.MenuItemSelectionView;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;

public class ComboGroupItemSelectionDialog
extends POSDialog
implements ActionListener {
    private MenuItemSelectionView menuSelectorPanel;
    private IntegerTextField tfMaxQuantity = new IntegerTextField(10);
    private JLabel lblMinQuantity = new JLabel(Messages.getString("ComboGroupItemSelectionDialog.0"));
    private JLabel lblMaxQuantity = new JLabel(Messages.getString("ComboGroupItemSelectionDialog.1"));
    private IntegerTextField tfMinQuantity = new IntegerTextField();
    private FixedLengthTextField tfComboGroupName = new FixedLengthTextField();
    private ComboGroup comboGroup;
    private MenuItem menuItem;
    private boolean editMode;

    public ComboGroupItemSelectionDialog(MenuItem menuItem, ComboGroup comboGroup) {
        this(menuItem, comboGroup, false);
    }

    public ComboGroupItemSelectionDialog(MenuItem menuItem, ComboGroup comboGroup, boolean editMode) {
        super(POSUtil.getFocusedWindow(), "");
        this.comboGroup = comboGroup;
        this.menuItem = menuItem;
        this.editMode = editMode;
        this.init();
        this.tfComboGroupName.setText(comboGroup.getName());
        Integer maxQuantity = comboGroup.getMaxQuantity() == 0 ? 1 : comboGroup.getMaxQuantity();
        this.tfMaxQuantity.setText(String.valueOf(maxQuantity));
        this.tfMinQuantity.setText(String.valueOf(comboGroup.getMinQuantity()));
    }

    private void init() {
        this.setLayout(new BorderLayout(10, 10));
        this.setIconImage(Application.getPosWindow().getIconImage());
        JPanel contentPane = new JPanel((LayoutManager)new MigLayout("fill,hidemode 3,inset 0 10 0 10"));
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle(Messages.getString("ComboGroupItemSelectionDialog.4"));
        this.add((Component)titlePanel, "North");
        this.menuSelectorPanel = new MenuItemSelectionView(this.comboGroup.getItems(), false);
        this.menuSelectorPanel.setShowVariantParent(false);
        this.menuSelectorPanel.setShowVariant(true);
        this.menuSelectorPanel.setShowComboItem(false);
        this.menuSelectorPanel.setParentMenuItem(this.menuItem, this.editMode);
        this.menuSelectorPanel.setEnableSearch(false);
        contentPane.add(new JLabel(Messages.getString("ComboGroupItemSelectionDialog.5")));
        contentPane.add((Component)this.tfComboGroupName, "grow,wrap");
        contentPane.add(this.lblMinQuantity);
        contentPane.add((Component)this.tfMinQuantity, "grow,wrap");
        contentPane.add(this.lblMaxQuantity);
        contentPane.add((Component)this.tfMaxQuantity, "grow,wrap");
        contentPane.add((Component)this.menuSelectorPanel, "grow,span,wrap");
        PosButton btnOk = new PosButton(POSConstants.OK);
        btnOk.setFocusable(false);
        btnOk.addActionListener(this);
        PosButton btnCancel = new PosButton(POSConstants.CANCEL);
        btnCancel.setFocusable(false);
        btnCancel.addActionListener(this);
        JPanel footerPanel = new JPanel((LayoutManager)new MigLayout("center,ins 0 5 5 5", "", ""));
        footerPanel.add(btnOk);
        footerPanel.add(btnCancel);
        this.add((Component)footerPanel, "South");
        this.add(contentPane);
        this.pack();
    }

    public void setQuantity(Integer quantity) {
        this.tfMaxQuantity.setText(String.valueOf(quantity));
    }

    private void doOk() {
        int maxQuantity;
        List<MenuItem> menuItems = this.menuSelectorPanel.getSelectedMenuItemList();
        if (menuItems == null || menuItems.isEmpty()) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("ComboGroupItemSelectionDialog.13"));
            return;
        }
        String groupName = this.tfComboGroupName.getText().trim();
        if (StringUtils.isEmpty((CharSequence)groupName)) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("ComboGroupItemSelectionDialog.14"));
            return;
        }
        int minQuantity = this.tfMinQuantity.getInteger();
        if (minQuantity > (maxQuantity = this.tfMaxQuantity.getInteger())) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("ComboGroupItemSelectionDialog.15"));
            return;
        }
        if (maxQuantity == 0) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("ComboGroupItemSelectionDialog.16"));
            return;
        }
        if (this.menuItem.getComboGroups() != null) {
            for (ComboGroup comboGroup : this.menuItem.getComboGroups()) {
                if (comboGroup == this.comboGroup) continue;
                if (comboGroup.getName().equals(groupName)) {
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("ComboGroupItemSelectionDialog.17"));
                    return;
                }
                if (!this.doCheckDuplicateItems(comboGroup, menuItems)) continue;
                return;
            }
        }
        this.comboGroup.setName(groupName);
        this.comboGroup.setMinQuantity(minQuantity);
        this.comboGroup.setMaxQuantity(maxQuantity);
        this.comboGroup.setItems(menuItems);
        this.setCanceled(false);
        this.dispose();
    }

    private boolean doCheckDuplicateItems(ComboGroup comboGroup, List<MenuItem> menuItems) {
        if (menuItems == null || menuItems.isEmpty()) {
            return false;
        }
        List<MenuItem> existedItems = comboGroup.getItems();
        if (existedItems == null || existedItems.isEmpty()) {
            return false;
        }
        for (MenuItem existedItem : existedItems) {
            if (existedItem == null || StringUtils.isEmpty((CharSequence)existedItem.getId())) continue;
            for (MenuItem menuItem : menuItems) {
                if (menuItem == null || !StringUtils.isNotEmpty((CharSequence)menuItem.getId()) || !existedItem.getId().equals(menuItem.getId())) continue;
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("ComboGroupItemSelectionDialog.18"));
                return true;
            }
        }
        return false;
    }

    private void doCancel() {
        this.setCanceled(true);
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (POSConstants.CANCEL.equalsIgnoreCase(actionCommand)) {
            this.doCancel();
        } else if (POSConstants.OK.equalsIgnoreCase(actionCommand)) {
            this.doOk();
        }
    }
}

