/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.Discount;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.dao.DiscountDAO;
import com.floreantpos.model.dao.ForeteesMenuItemDAO;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.swing.CheckBoxList;
import com.floreantpos.swing.CheckBoxListModel;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.MessageDialog;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.MenuCategorySelectionDialog;
import com.floreantpos.ui.dialog.MenuGroupSelectionDialog;
import com.floreantpos.ui.dialog.MenuItemSelectionDialog;
import com.floreantpos.ui.dialog.OrderTypeSelectionDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerDateModel;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXDatePicker;

public class CouponForm
extends POSDialog
implements ItemListener {
    private JPanel contentPane;
    private FixedLengthTextField tfCouponName;
    private FixedLengthTextField tfBarcode;
    private JComboBox cbQualificationType;
    private JComboBox cbCouponType;
    private JLabel lblCouponValue;
    private DoubleTextField tfCouponValue;
    private JCheckBox chkEnabled;
    private JCheckBox chkModifiable;
    private JCheckBox chkAutoApply;
    private JCheckBox chkNeverExpire;
    private JXDatePicker endDatePickExperation;
    private JXDatePicker startDatePickExperation;
    private JLabel lblMinimum;
    private DoubleTextField tfMinimumQua;
    private DoubleTextField tfMaxUnit = new DoubleTextField();
    private JScrollPane itemScrollPane;
    private CheckBoxList<MenuItem> addedListItems;
    private CheckBoxList<MenuGroup> addedListGroups;
    private CheckBoxList<MenuCategory> addedListCategory;
    private JSpinner spStartTime;
    private JSpinner spEndTime;
    private JCheckBox chbApplyToSundayOnly;
    private JCheckBox chbApplyToMondayOnly;
    private JCheckBox chbApplyToTuesdayOnly;
    private JCheckBox chbApplyToWednesdayOnly;
    private JCheckBox chbApplyToThursdayOnly;
    private JCheckBox chbApplyToFridayOnly;
    private JCheckBox chbApplyToSaturdayOnly;
    private JScrollPane groupScrollPane;
    private JScrollPane categoryScrollPane;
    private JPanel selectionPanel;
    private JTextField txtSearchGroup;
    private JTextField txtSearchCategory;
    private JTextField txtSearchItem;
    private SpinnerDateModel dateModelStart;
    private SpinnerDateModel dateModelEnd;
    private Discount coupon;
    private boolean isItemBasedCoupon;
    private CheckBoxList addedListOrderType;
    private JScrollPane orderTypeScrollPane;

    public CouponForm() {
        this(new Discount(), true);
    }

    public CouponForm(Discount coupon, boolean isItemBasedCoupon) {
        super((Frame)POSUtil.getBackOfficeWindow(), "");
        this.setDefaultCloseOperation(2);
        this.coupon = coupon;
        this.isItemBasedCoupon = isItemBasedCoupon;
        this.initializeComponent();
        this.initData();
        this.updateView();
        this.setVisibility();
    }

    private void setVisibility() {
        TitlePanel titlePanel = new TitlePanel();
        this.add((Component)titlePanel, "North");
        if (this.isItemBasedCoupon) {
            this.selectionPanel.setVisible(this.isItemBasedCoupon);
            titlePanel.setTitle(Messages.getString("CouponForm.14"));
        } else {
            titlePanel.setTitle(Messages.getString("CouponForm.20"));
            this.add((Component)this.contentPane, "Center");
        }
    }

    private void initData() {
        this.cbCouponType.setModel(new DefaultComboBoxModel<String>(Discount.COUPON_TYPE_NAMES));
        this.cbCouponType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (CouponForm.this.cbCouponType.getSelectedItem() == Discount.COUPON_TYPE_NAMES[2]) {
                    CouponForm.this.tfMinimumQua.setEnabled(false);
                    CouponForm.this.tfMaxUnit.setEnabled(false);
                    CouponForm.this.lblCouponValue.setVisible(false);
                    CouponForm.this.tfCouponValue.setVisible(false);
                    CouponForm.this.tfCouponValue.setText(String.valueOf(0.0));
                } else if (CouponForm.this.cbCouponType.getSelectedItem() == Discount.COUPON_TYPE_NAMES[4]) {
                    CouponForm.this.tfMinimumQua.setEnabled(false);
                    CouponForm.this.tfMaxUnit.setEnabled(false);
                    CouponForm.this.lblCouponValue.setVisible(true);
                    CouponForm.this.tfCouponValue.setVisible(true);
                    CouponForm.this.tfMinimumQua.setText(String.valueOf(0.0));
                    CouponForm.this.tfMaxUnit.setText(String.valueOf(0.0));
                } else {
                    CouponForm.this.tfMinimumQua.setEnabled(true);
                    CouponForm.this.tfMaxUnit.setEnabled(true);
                    CouponForm.this.lblCouponValue.setVisible(true);
                    CouponForm.this.tfCouponValue.setVisible(true);
                }
                CouponForm.this.chkModifiable.setSelected(false);
            }
        });
        this.cbQualificationType.setModel(new DefaultComboBoxModel<String>(Discount.COUPON_QUALIFICATION_NAMES));
        this.cbCouponType.addItemListener(this);
        this.cbQualificationType.setSelectedItem(this.isItemBasedCoupon ? Discount.COUPON_QUALIFICATION_NAMES[0] : Discount.COUPON_QUALIFICATION_NAMES[1]);
    }

    private void initializeComponent() {
        this.contentPane = new JPanel();
        this.contentPane.setLayout((LayoutManager)new MigLayout("fillx, hidemode 3"));
        this.contentPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), null));
        this.contentPane.setPreferredSize(new Dimension(400, 0));
        JLabel lblCouponName = new JLabel(Messages.getString("CouponForm.0") + ":");
        JLabel lblEndDate = new JLabel(Messages.getString("CouponForm.9") + ":");
        JLabel lblCouponType = new JLabel(Messages.getString("CouponForm.11") + ":");
        this.lblCouponValue = new JLabel(Messages.getString("CouponForm.13") + ":");
        JLabel lblCouponBarCode = new JLabel(Messages.getString("CouponForm.12"));
        JLabel lblDiscountOn = new JLabel(Messages.getString("CouponForm.7"));
        this.lblMinimum = this.isItemBasedCoupon ? new JLabel(Messages.getString("CouponForm.26")) : new JLabel(Messages.getString("CouponForm.27"));
        JLabel lblStartDate = new JLabel(Messages.getString("CouponForm.22") + ":");
        JLabel lblStartTime = new JLabel(Messages.getString("CouponForm.23") + ":");
        JLabel lblEndTime = new JLabel(Messages.getString("CouponForm.24") + ":");
        this.tfCouponName = new FixedLengthTextField(120);
        this.tfBarcode = new FixedLengthTextField(120);
        this.cbCouponType = new JComboBox();
        this.cbQualificationType = new JComboBox();
        this.startDatePickExperation = UiUtil.getDeafultDate();
        this.endDatePickExperation = UiUtil.getDeafultDate();
        this.dateModelStart = new SpinnerDateModel();
        this.dateModelEnd = new SpinnerDateModel();
        this.spStartTime = new JSpinner(this.dateModelStart);
        this.spStartTime.setEditor(new JSpinner.DateEditor(this.spStartTime, "h:mm a"));
        this.spEndTime = new JSpinner(this.dateModelEnd);
        this.spEndTime.setEditor(new JSpinner.DateEditor(this.spEndTime, "h:mm a"));
        this.startDatePickExperation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Date date = CouponForm.this.startDatePickExperation.getDate();
                if (date != null) {
                    CouponForm.this.spStartTime.setValue(date);
                }
            }
        });
        this.endDatePickExperation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Date date = CouponForm.this.endDatePickExperation.getDate();
                if (date != null) {
                    CouponForm.this.spEndTime.setValue(date);
                }
            }
        });
        this.tfCouponValue = new DoubleTextField();
        this.tfMinimumQua = new DoubleTextField();
        this.chkEnabled = new JCheckBox(POSConstants.ENABLED);
        this.chkModifiable = new JCheckBox("Modifiable Amount");
        this.chkAutoApply = new JCheckBox(Messages.getString("CouponForm.6"));
        this.chkNeverExpire = new JCheckBox(Messages.getString("CouponForm.16"));
        this.chbApplyToSundayOnly = new JCheckBox(Messages.getString("SUNDAY"));
        this.chbApplyToMondayOnly = new JCheckBox(Messages.getString("MONDAY"));
        this.chbApplyToTuesdayOnly = new JCheckBox(Messages.getString("TUESDAY"));
        this.chbApplyToWednesdayOnly = new JCheckBox(Messages.getString("WEDNESDAY"));
        this.chbApplyToThursdayOnly = new JCheckBox(Messages.getString("THURSDAY"));
        this.chbApplyToFridayOnly = new JCheckBox(Messages.getString("FRIDAY"));
        this.chbApplyToSaturdayOnly = new JCheckBox(Messages.getString("SATURDAY"));
        this.contentPane.add(lblCouponName);
        this.contentPane.add((Component)this.tfCouponName, "grow, wrap");
        this.contentPane.add(lblStartDate);
        this.contentPane.add((Component)this.startDatePickExperation, "grow, wrap");
        this.contentPane.add(lblStartTime);
        this.contentPane.add((Component)this.spStartTime, "grow, wrap");
        this.contentPane.add(lblEndDate);
        this.contentPane.add((Component)this.endDatePickExperation, "grow, wrap");
        this.contentPane.add(lblEndTime);
        this.contentPane.add((Component)this.spEndTime, "grow, wrap");
        this.contentPane.add(lblCouponBarCode);
        this.contentPane.add((Component)this.tfBarcode, "grow, wrap");
        this.contentPane.add(lblDiscountOn);
        this.contentPane.add((Component)this.cbQualificationType, "grow, wrap");
        this.contentPane.add(this.lblMinimum);
        this.contentPane.add((Component)this.tfMinimumQua, "grow, wrap");
        this.contentPane.add(new JLabel("Maximum Unit:"));
        this.contentPane.add((Component)this.tfMaxUnit, "grow, wrap");
        this.contentPane.add(lblCouponType);
        this.contentPane.add((Component)this.cbCouponType, "grow, wrap");
        this.contentPane.add(this.lblCouponValue);
        this.contentPane.add((Component)this.tfCouponValue, "grow, wrap");
        this.contentPane.add((Component)new JSeparator(), "span 2, grow,wrap");
        this.contentPane.add(this.chkEnabled);
        this.contentPane.add((Component)this.chkAutoApply, "wrap");
        this.contentPane.add(this.chkNeverExpire);
        this.contentPane.add(this.chkModifiable);
        this.contentPane.add((Component)new JSeparator(), "newline, span, grow,wrap");
        this.contentPane.add((Component)new JLabel(Messages.getString("CouponForm.32") + ":-"), "grow, wrap");
        this.cbQualificationType.setEnabled(false);
        JPanel dayPanel = new JPanel((LayoutManager)new MigLayout("fillx,ins 5 5 0 0"));
        dayPanel.add((Component)this.chbApplyToMondayOnly, "grow");
        dayPanel.add((Component)this.chbApplyToFridayOnly, "grow,wrap");
        dayPanel.add((Component)this.chbApplyToTuesdayOnly, "grow");
        dayPanel.add((Component)this.chbApplyToSaturdayOnly, "grow,wrap");
        dayPanel.add((Component)this.chbApplyToWednesdayOnly, "grow");
        dayPanel.add((Component)this.chbApplyToSundayOnly, "grow,wrap");
        dayPanel.add((Component)this.chbApplyToThursdayOnly, "grow");
        this.contentPane.add((Component)dayPanel, "span 2,growx");
        this.selectionPanel = new JPanel((LayoutManager)new MigLayout("fill", "", "[][][]"));
        this.selectionPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5), null));
        this.selectionPanel.add((Component)this.createItemPanel(), "cell 0 0,grow, wrap");
        this.selectionPanel.add((Component)this.createGroupPanel(), "cell 0 1,grow, wrap");
        this.selectionPanel.add((Component)this.createCategoryPanel(), "cell 0 2,grow, wrap");
        this.selectionPanel.add((Component)this.createOrderTypePanel(), "cell 0 3,grow");
        this.add((Component)this.contentPane, "West");
        this.add((Component)this.selectionPanel, "Center");
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("al center,fillx", "sg", ""));
        JButton btnOk = new JButton(POSConstants.OK);
        buttonPanel.add((Component)new JSeparator(), "grow,span");
        buttonPanel.add((Component)btnOk, "split 2,center");
        btnOk.addActionListener(e -> this.doOk());
        JButton btnCancel = new JButton(POSConstants.CANCEL);
        buttonPanel.add(btnCancel);
        btnCancel.addActionListener(e -> {
            this.setCanceled(true);
            this.dispose();
        });
        this.chkNeverExpire.addItemListener(e -> this.stagedChenged(this.chkNeverExpire.isSelected()));
        this.add((Component)buttonPanel, "South");
    }

    private void stagedChenged(boolean selected) {
        this.endDatePickExperation.setEditable(!selected);
        if (selected) {
            this.endDatePickExperation.setDate(null);
        } else {
            this.endDatePickExperation.getEditor().setEditable(false);
        }
    }

    private JPanel createItemPanel() {
        JPanel itemPanel = new JPanel(new BorderLayout(5, 5));
        TitledBorder centerBorder = BorderFactory.createTitledBorder(Messages.getString("CouponForm.52"));
        centerBorder.setTitleJustification(2);
        itemPanel.setBorder(centerBorder);
        itemPanel.add((Component)this.createItemSearchPanel(), "East");
        String[] colNames = new String[]{"-", POSConstants.NAME};
        this.addedListItems = new CheckBoxList();
        this.addedListItems.setModel(new ArrayList(), colNames);
        this.itemScrollPane = new JScrollPane(this.addedListItems);
        this.itemScrollPane.setPreferredSize(PosUIManager.getSize(0, 100));
        itemPanel.add((Component)this.itemScrollPane, "Center");
        return itemPanel;
    }

    private JPanel createGroupPanel() {
        JPanel groupPanel = new JPanel(new BorderLayout(5, 5));
        TitledBorder centerBorder = BorderFactory.createTitledBorder(Messages.getString("CouponForm.53"));
        centerBorder.setTitleJustification(2);
        groupPanel.setBorder(centerBorder);
        groupPanel.add((Component)this.createGroupSearchPanel(), "East");
        String[] colNames = new String[]{"-", POSConstants.NAME};
        this.addedListGroups = new CheckBoxList();
        this.addedListGroups.setModel(new ArrayList(), colNames);
        this.groupScrollPane = new JScrollPane(this.addedListGroups);
        this.groupScrollPane.setPreferredSize(PosUIManager.getSize(0, 100));
        groupPanel.add((Component)this.groupScrollPane, "Center");
        return groupPanel;
    }

    private JPanel createCategoryPanel() {
        JPanel categoryPanel = new JPanel(new BorderLayout(5, 5));
        TitledBorder centerBorder = BorderFactory.createTitledBorder(Messages.getString("CouponForm.54"));
        centerBorder.setTitleJustification(2);
        categoryPanel.setBorder(centerBorder);
        categoryPanel.add((Component)this.createCategorySearchPanel(), "East");
        String[] colNames = new String[]{"-", POSConstants.NAME};
        this.addedListCategory = new CheckBoxList();
        this.addedListCategory.setModel(new ArrayList(), colNames);
        this.categoryScrollPane = new JScrollPane(this.addedListCategory);
        this.categoryScrollPane.setPreferredSize(PosUIManager.getSize(0, 100));
        categoryPanel.add((Component)this.categoryScrollPane, "Center");
        return categoryPanel;
    }

    private JPanel createOrderTypePanel() {
        JPanel orderTypePanel = new JPanel(new BorderLayout(5, 5));
        TitledBorder centerBorder = BorderFactory.createTitledBorder(Messages.getString("ORDER_TYPE"));
        centerBorder.setTitleJustification(2);
        orderTypePanel.setBorder(centerBorder);
        orderTypePanel.add((Component)this.createOrderTypeSearchPanel(), "East");
        String[] colNames = new String[]{"-", POSConstants.NAME};
        this.addedListOrderType = new CheckBoxList();
        this.addedListOrderType.setModel(new ArrayList(), colNames);
        this.orderTypeScrollPane = new JScrollPane(this.addedListOrderType);
        this.orderTypeScrollPane.setPreferredSize(PosUIManager.getSize(0, 100));
        orderTypePanel.add((Component)this.orderTypeScrollPane, "Center");
        return orderTypePanel;
    }

    private JPanel createItemSearchPanel() {
        JPanel itemSearchPanel = new JPanel();
        itemSearchPanel.setLayout(new BorderLayout(5, 5));
        JButton btnSearch = new JButton(Messages.getString("CouponForm.25"));
        btnSearch.addActionListener(e -> this.showMenuItemSelectionDialog());
        itemSearchPanel.add((Component)btnSearch, "East");
        return itemSearchPanel;
    }

    private JPanel createCategorySearchPanel() {
        JPanel categorySearchPanel = new JPanel();
        categorySearchPanel.setLayout(new BorderLayout(5, 5));
        JButton btnSearch = new JButton(Messages.getString("CouponForm.25"));
        btnSearch.addActionListener(e -> this.showCategorySelectionDialog());
        categorySearchPanel.add((Component)btnSearch, "East");
        return categorySearchPanel;
    }

    private JPanel createOrderTypeSearchPanel() {
        JPanel orderTypeSearchPanel = new JPanel();
        orderTypeSearchPanel.setLayout(new BorderLayout(5, 5));
        JButton btnSearch = new JButton(Messages.getString("CouponForm.25"));
        btnSearch.addActionListener(e -> this.showOrderTypeSelectionDialog());
        orderTypeSearchPanel.add((Component)btnSearch, "East");
        return orderTypeSearchPanel;
    }

    private JPanel createGroupSearchPanel() {
        JPanel groupSearchPanel = new JPanel();
        groupSearchPanel.setLayout(new BorderLayout(5, 5));
        JButton btnSearch = new JButton(Messages.getString("CouponForm.25"));
        btnSearch.addActionListener(e -> this.showGroupSelectionDialog());
        groupSearchPanel.add((Component)btnSearch, "East");
        return groupSearchPanel;
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        if (event.getItem() == Discount.COUPON_TYPE_NAMES[0]) {
            this.chkModifiable.setVisible(true);
        } else {
            this.chkModifiable.setVisible(false);
        }
    }

    public void save() {
        try {
            if (!this.updateModel()) {
                return;
            }
            DiscountDAO.getInstance().saveOrUpdate(this.coupon);
            this.setCanceled(false);
            this.dispose();
        }
        catch (Exception e) {
            MessageDialog.showError(POSConstants.SAVE_ERROR, e);
            return;
        }
    }

    protected void updateView() {
        if (this.coupon.getId() == null) {
            this.chkEnabled.setSelected(true);
            this.tfMinimumQua.setText("0");
            this.cbCouponType.setSelectedIndex(1);
            this.startDatePickExperation.setDate(new Date());
            return;
        }
        DiscountDAO.getInstance().initialize(this.coupon);
        this.tfCouponName.setText(this.coupon.getName());
        this.tfMinimumQua.setText(this.coupon.getMinimumBuy().toString());
        this.tfMaxUnit.setText(this.coupon.getMaximumOff().toString());
        this.tfCouponValue.setText(String.valueOf(this.coupon.getValue()));
        this.cbCouponType.setSelectedIndex(this.coupon.getType());
        this.cbQualificationType.setSelectedIndex(this.coupon.getQualificationType());
        if (this.coupon.getStartDate() != null) {
            this.startDatePickExperation.setDate(this.coupon.getStartDate());
            this.dateModelStart.setValue(this.coupon.getStartDate());
        }
        if (this.coupon.getExpiryDate() != null) {
            this.endDatePickExperation.setDate(this.coupon.getExpiryDate());
            this.dateModelEnd.setValue(this.coupon.getExpiryDate());
        }
        this.tfBarcode.setText(this.coupon.getBarcode());
        this.chkEnabled.setSelected(this.coupon.isEnabled());
        this.chkModifiable.setSelected(this.coupon.isModifiable());
        this.chkAutoApply.setSelected(this.coupon.isAutoApply());
        this.chkNeverExpire.setSelected(this.coupon.isNeverExpire());
        if (this.coupon.getQualificationType() == 0) {
            List<OrderType> orderTypes;
            List<MenuCategory> menuCategories;
            List<MenuGroup> menuGroups;
            String[] colNames = new String[]{"-", POSConstants.NAME};
            List<MenuItem> menuItems = this.coupon.getMenuItems();
            if (menuItems != null) {
                this.addedListItems.setModel(menuItems, colNames);
                this.addedListItems.selectItems(menuItems);
            }
            if ((menuGroups = this.coupon.getMenuGroups()) != null) {
                this.addedListGroups.setModel(menuGroups, colNames);
                this.addedListGroups.selectItems(menuGroups);
            }
            if ((menuCategories = this.coupon.getMenuCategories()) != null) {
                this.addedListCategory.setModel(menuCategories, colNames);
                this.addedListCategory.selectItems(menuCategories);
            }
            if ((orderTypes = this.coupon.getOrderTypes()) != null) {
                this.addedListOrderType.setModel(orderTypes, colNames);
                this.addedListOrderType.selectItems(orderTypes);
            }
        }
        this.chbApplyToFridayOnly.setSelected(this.coupon.isApplyToFridayOnly());
        this.chbApplyToSaturdayOnly.setSelected(this.coupon.isApplyToSaturdayOnly());
        this.chbApplyToSundayOnly.setSelected(this.coupon.isApplyToSundayOnly());
        this.chbApplyToMondayOnly.setSelected(this.coupon.isApplyToMondayOnly());
        this.chbApplyToThursdayOnly.setSelected(this.coupon.isApplyToThursdayOnly());
        this.chbApplyToWednesdayOnly.setSelected(this.coupon.isApplyToWednesdayOnly());
        this.chbApplyToTuesdayOnly.setSelected(this.coupon.isApplyToTuesdayOnly());
    }

    protected boolean updateModel() {
        String name = this.tfCouponName.getText();
        String barcode = this.tfBarcode.getText();
        double couponValue = 0.0;
        couponValue = this.tfCouponValue.getDoubleOrZero();
        double couponMinimumQua = this.tfMinimumQua.getDoubleOrZero();
        int couponType = this.cbCouponType.getSelectedIndex();
        Date startDate = this.startDatePickExperation.getDate();
        Date startTime = (Date)this.spStartTime.getValue();
        Date expiryDate = this.endDatePickExperation.getDate();
        Date expiryTime = (Date)this.spEndTime.getValue();
        boolean enabled = this.chkEnabled.isSelected();
        boolean modifiable = this.chkModifiable.isSelected();
        boolean autoApply = this.chkAutoApply.isSelected();
        boolean neverExpire = this.chkNeverExpire.isSelected();
        int qualificationType = this.cbQualificationType.getSelectedIndex();
        if (name == null || name.trim().equals("")) {
            POSMessageDialog.showError(null, Messages.getString("CouponForm.1"));
            return false;
        }
        if (Double.isNaN(couponValue)) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("CouponForm.55"));
            return false;
        }
        if (this.cbCouponType.getSelectedItem() != Discount.COUPON_TYPE_NAMES[2] && !this.chkModifiable.isSelected() && couponValue <= 0.0) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("CouponForm.2"));
            return false;
        }
        if (qualificationType == 0 && this.couponValueOverflow()) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("CouponForm.10"));
            return false;
        }
        if (startDate == null) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("CouponForm.56"));
            return false;
        }
        if (!this.chkNeverExpire.isSelected() && expiryDate == null) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("CouponForm.57"));
            return false;
        }
        if (!this.chkNeverExpire.isSelected() && startDate.after(expiryDate)) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("CouponForm.58"));
            return false;
        }
        Date startDateTime = this.dateTime(startDate, startTime);
        this.coupon.setStartDate(startDateTime);
        if (!this.chkNeverExpire.isSelected()) {
            Date expiryDateTime = this.dateTime(expiryDate, expiryTime);
            this.coupon.setExpiryDate(expiryDateTime);
        }
        double couponMaximunUnit = this.tfMaxUnit.getDoubleOrZero();
        this.coupon.setName(name);
        this.coupon.setMinimumBuy(couponMinimumQua);
        this.coupon.setMaximumOff(couponMaximunUnit);
        this.coupon.setValue(couponValue);
        this.coupon.setBarcode(barcode);
        this.coupon.setType(couponType);
        this.coupon.setQualificationType(qualificationType);
        this.coupon.setEnabled(enabled);
        this.coupon.setModifiable(modifiable);
        this.coupon.setAutoApply(autoApply);
        this.coupon.setNeverExpire(neverExpire);
        if (qualificationType == 0) {
            if (this.addedListItems.getCheckedValues().size() > 0) {
                this.coupon.setMenuItems(this.addedListItems.getCheckedValues());
                this.coupon.setApplyToAll(false);
            } else {
                this.coupon.setMenuItems(null);
                this.coupon.setApplyToAll(true);
            }
        }
        if (this.addedListGroups.getCheckedValues().size() > 0) {
            this.coupon.setMenuGroups(this.addedListGroups.getCheckedValues());
        } else {
            this.coupon.setMenuGroups(null);
        }
        if (this.addedListCategory.getCheckedValues().size() > 0) {
            this.coupon.setMenuCategories(this.addedListCategory.getCheckedValues());
        } else {
            this.coupon.setMenuCategories(null);
        }
        if (this.addedListOrderType.getCheckedValues().size() > 0) {
            this.coupon.setOrderTypes(this.addedListOrderType.getCheckedValues());
        } else {
            this.coupon.setOrderTypes(null);
        }
        this.coupon.setApplyToSundayOnly(this.chbApplyToSundayOnly.isSelected());
        this.coupon.setApplyToMondayOnly(this.chbApplyToMondayOnly.isSelected());
        this.coupon.setApplyToTuesdayOnly(this.chbApplyToTuesdayOnly.isSelected());
        this.coupon.setApplyToWednesdayOnly(this.chbApplyToWednesdayOnly.isSelected());
        this.coupon.setApplyToThursdayOnly(this.chbApplyToThursdayOnly.isSelected());
        this.coupon.setApplyToFridayOnly(this.chbApplyToFridayOnly.isSelected());
        this.coupon.setApplyToSaturdayOnly(this.chbApplyToSaturdayOnly.isSelected());
        return true;
    }

    private boolean couponValueOverflow() {
        List<MenuItem> menuItems = this.addedListItems.getCheckedValues();
        double couponValue = Double.parseDouble(this.tfCouponValue.getText());
        if (this.cbCouponType.getSelectedIndex() == 1) {
            couponValue /= 100.0;
        }
        if (this.tfMinimumQua.getDouble() > 0.0) {
            double minimumQua = this.tfMinimumQua.getDouble();
            for (MenuItem menuItem : menuItems) {
                if (!(couponValue > menuItem.getPrice() * minimumQua)) continue;
                return true;
            }
        } else {
            for (MenuItem menuItem : menuItems) {
                if (!(couponValue > menuItem.getPrice())) continue;
                return true;
            }
        }
        return false;
    }

    public Date dateTime(Date date, Date time) {
        Calendar cdate = Calendar.getInstance();
        Calendar ctime = Calendar.getInstance();
        cdate.setTime(date);
        ctime.setTime(time);
        int hour = ctime.get(10);
        int min = ctime.get(12);
        int sec = ctime.get(13);
        int ap = ctime.get(9);
        cdate.set(10, hour);
        cdate.set(12, min);
        cdate.set(13, sec);
        cdate.set(9, ap);
        Date setDate = new Date(cdate.getTimeInMillis());
        return setDate;
    }

    public void doOk() {
        this.save();
    }

    public Discount getBean() {
        return this.coupon;
    }

    private void doItemSearchByNameOrBarcode() {
        try {
            if (this.txtSearchItem.getText().equals("")) {
                POSMessageDialog.showMessage(Messages.getString("CouponForm.8"));
                return;
            }
            MenuItem menuItem = ForeteesMenuItemDAO.getInstance().getMenuItemByBarcodeOrName(this.txtSearchItem.getText());
            if (menuItem == null) {
                return;
            }
            CheckBoxListModel model = (CheckBoxListModel)this.addedListItems.getModel();
            if (!model.hasContain(menuItem)) {
                model.addItem(menuItem);
                this.addedListItems.selectItem(menuItem);
            }
            this.txtSearchItem.setText("");
        }
        catch (Exception ex) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), ex.getMessage(), ex);
        }
    }

    private void showMenuItemSelectionDialog() {
        try {
            MenuItemSelectionDialog dialog = new MenuItemSelectionDialog(this.addedListItems.getCheckedValues());
            dialog.setSize(PosUIManager.getSize(800, 600));
            dialog.setShowVariantParent(false);
            dialog.doSearch("");
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            List<MenuItem> selectedItems = dialog.getSelectedItems();
            CheckBoxListModel model = (CheckBoxListModel)this.addedListItems.getModel();
            model.setRows(selectedItems);
            this.addedListItems.selectItems(selectedItems);
        }
        catch (Exception ex) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), ex.getMessage(), ex);
        }
    }

    private void doSearchCategory() {
        try {
            if (this.txtSearchCategory.getText().equals("")) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("CouponForm.59"));
                return;
            }
            MenuCategory menuCategory = MenuCategoryDAO.getInstance().get(this.txtSearchCategory.getText());
            if (menuCategory == null) {
                return;
            }
            CheckBoxListModel model = (CheckBoxListModel)this.addedListCategory.getModel();
            if (!model.hasContain(menuCategory)) {
                model.addItem(menuCategory);
                this.addedListCategory.selectItem(menuCategory);
            }
            this.txtSearchCategory.setText("");
        }
        catch (Exception ex) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), ex.getMessage(), ex);
        }
    }

    private void showCategorySelectionDialog() {
        try {
            MenuCategorySelectionDialog dialog = new MenuCategorySelectionDialog(this.addedListCategory.getCheckedValues());
            dialog.setSize(PosUIManager.getSize(800, 600));
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            List<MenuCategory> selectedItems = dialog.getSelectedCategories();
            CheckBoxListModel model = (CheckBoxListModel)this.addedListCategory.getModel();
            model.setRows(selectedItems);
            this.addedListCategory.selectItems(selectedItems);
        }
        catch (Exception ex) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), ex.getMessage(), ex);
        }
    }

    private void showOrderTypeSelectionDialog() {
        try {
            OrderTypeSelectionDialog dialog = new OrderTypeSelectionDialog(this.addedListOrderType.getCheckedValues());
            dialog.setSize(PosUIManager.getSize(700, 600));
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            List<OrderType> orderTypes = dialog.getSelectedOrderTypes();
            CheckBoxListModel model = (CheckBoxListModel)this.addedListOrderType.getModel();
            model.setRows(orderTypes);
            this.addedListOrderType.selectItems(orderTypes);
        }
        catch (Exception ex) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), ex.getMessage(), ex);
        }
    }

    private void doSearchByGroup() {
        try {
            if (this.txtSearchGroup.getText().equals("")) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("CouponForm.60"));
                return;
            }
            MenuGroup menuGroup = MenuGroupDAO.getInstance().get(this.txtSearchGroup.getText());
            if (menuGroup == null) {
                return;
            }
            CheckBoxListModel model = (CheckBoxListModel)this.addedListGroups.getModel();
            if (!model.hasContain(menuGroup)) {
                model.addItem(menuGroup);
                this.addedListGroups.selectItem(menuGroup);
            }
            this.txtSearchGroup.setText("");
        }
        catch (Exception ex) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), ex.getMessage(), ex);
        }
    }

    private void showGroupSelectionDialog() {
        try {
            MenuGroupSelectionDialog dialog = new MenuGroupSelectionDialog(this.addedListGroups.getCheckedValues());
            dialog.setSize(PosUIManager.getSize(800, 600));
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            List<MenuGroup> selectedMenuGroups = dialog.getSelectedMenuGroups();
            CheckBoxListModel model = (CheckBoxListModel)this.addedListGroups.getModel();
            model.setRows(selectedMenuGroups);
            this.addedListGroups.selectItems(selectedMenuGroups);
        }
        catch (Exception ex) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), ex.getMessage(), ex);
        }
    }
}

