/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.Tag;
import com.floreantpos.model.dao.MenuModifierDAO;
import com.floreantpos.model.dao.TagDAO;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXTable;

public class MenuItemModifierGroupForm
extends BeanEditor {
    private JLabel lblName;
    private JLabel lblTranslatedName;
    private JLabel lblMin;
    private JLabel lblMax;
    private JLabel lblTag;
    private JLabel lblEnabled;
    private JLabel lblSortOrder;
    private FixedLengthTextField tfName = new FixedLengthTextField(60);
    private FixedLengthTextField tfTranslatedName = new FixedLengthTextField(60);
    private IntegerTextField tfMaxQuantity = new IntegerTextField();
    private IntegerTextField tfMinQuantity = new IntegerTextField();
    private IntegerTextField tfSortOrder = new IntegerTextField();
    private JCheckBox ckbEnable;
    private List<MenuItemModifierSpec> menuItemModifierGroupsList;
    private JXTable modifierSelectionTable;
    private ModifierTableModel modifierTableModel;
    private JComboBox cbTag;
    private JCheckBox ckbJump;
    private JLabel lblJump;

    public MenuItemModifierGroupForm(List<MenuItemModifierSpec> menuItemModifierGroupsList) {
        this(new MenuItemModifierSpec(), menuItemModifierGroupsList);
    }

    public MenuItemModifierGroupForm(MenuItemModifierSpec modifierGroup, List<MenuItemModifierSpec> menuItemModifierGroupsList) {
        this.initComponents();
        this.menuItemModifierGroupsList = menuItemModifierGroupsList;
        this.initList();
        this.setBean(modifierGroup);
    }

    private void initList() {
        TagDAO tagDao = new TagDAO();
        List<Tag> tagList = tagDao.findAll();
        this.cbTag.setModel(new ComboBoxModel(tagList));
        this.cbTag.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                this.searchItem();
            }

            private void searchItem() {
                Tag selectedType = (Tag)MenuItemModifierGroupForm.this.cbTag.getSelectedItem();
                List<MenuModifier> menuModifierList = MenuModifierDAO.getInstance().getModifierList(selectedType.getName());
                MenuItemModifierGroupForm.this.modifierTableModel.setRows(menuModifierList);
            }
        });
        List<MenuModifier> findAll = MenuModifierDAO.getInstance().findAll();
        this.modifierTableModel = new ModifierTableModel();
        this.modifierTableModel.setRows(findAll);
        this.modifierSelectionTable = new JXTable((TableModel)this.modifierTableModel);
        this.modifierSelectionTable.setRowHeight(PosUIManager.getSize(30));
        this.add((Component)new JScrollPane((Component)this.modifierSelectionTable), "span 2, grow,newline");
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("fillx", "[grow][grow]", ""));
        this.lblName = new JLabel(Messages.getString("NAME"));
        this.lblTranslatedName = new JLabel(Messages.getString("MenuItemModifierGroupForm.5"));
        this.lblMin = new JLabel(Messages.getString("MenuItemModifierGroupForm.6"));
        this.lblMax = new JLabel(Messages.getString("MenuItemModifierGroupForm.7"));
        this.lblTag = new JLabel(Messages.getString("MenuItemModifierGroupForm.8"));
        this.lblEnabled = new JLabel(Messages.getString("MenuItemModifierGroupForm.10"));
        this.lblSortOrder = new JLabel(Messages.getString("MenuItemModifierGroupForm.11"));
        this.lblJump = new JLabel(Messages.getString("MenuItemModifierGroupForm.12"));
        this.ckbEnable = new JCheckBox();
        this.ckbJump = new JCheckBox();
        this.cbTag = new JComboBox();
        this.cbTag.setPreferredSize(new Dimension(198, 0));
        this.tfName.setColumns(20);
        this.tfTranslatedName.setColumns(20);
        this.tfMinQuantity.setColumns(10);
        this.tfMaxQuantity.setColumns(10);
        this.tfSortOrder.setColumns(10);
        this.add(this.lblName);
        this.add(this.tfName);
        this.add((Component)this.lblTranslatedName, "newline");
        this.add(this.tfTranslatedName);
        this.add((Component)this.lblMin, "newline");
        this.add(this.tfMinQuantity);
        this.add((Component)this.lblMax, "newline");
        this.add(this.tfMaxQuantity);
        this.add((Component)this.lblEnabled, "newline");
        this.add(this.ckbEnable);
        this.add((Component)this.lblSortOrder, "newline");
        this.add(this.tfSortOrder);
        this.add((Component)this.lblJump, "newline");
        this.add(this.ckbJump);
        this.add((Component)this.lblTag, "newline");
        this.add(this.cbTag);
    }

    @Override
    public boolean save() {
        return this.updateModel();
    }

    @Override
    protected void updateView() {
        MenuItemModifierSpec menuItemModifierGroup = this.getBean();
        if (menuItemModifierGroup == null) {
            return;
        }
        this.tfName.setText(menuItemModifierGroup.getName());
        this.tfTranslatedName.setText(menuItemModifierGroup.getTranslatedName());
        this.tfMinQuantity.setText(String.valueOf(menuItemModifierGroup.getMinQuantity()));
        this.tfMaxQuantity.setText(String.valueOf(menuItemModifierGroup.getMaxQuantity()));
        this.ckbEnable.setSelected(menuItemModifierGroup.isEnable());
        this.tfSortOrder.setText(String.valueOf(menuItemModifierGroup.getSortOrder()));
        this.ckbJump.setSelected(menuItemModifierGroup.isJumpGroup());
    }

    @Override
    protected boolean updateModel() {
        String name = this.tfName.getText();
        String translatedName = this.tfTranslatedName.getText();
        int minQuantity = this.tfMinQuantity.getInteger();
        int maxQuantity = this.tfMaxQuantity.getInteger();
        boolean selected = this.ckbEnable.isSelected();
        int sortOrder = this.tfSortOrder.getInteger();
        boolean jumpSelected = this.ckbJump.isSelected();
        MenuItemModifierSpec modifierGroup = this.getBean();
        if (this.menuItemModifierGroupsList != null) {
            for (MenuItemModifierSpec pc : this.menuItemModifierGroupsList) {
                if (modifierGroup == pc || !pc.getName().equalsIgnoreCase(name)) continue;
                POSMessageDialog.showMessage(this, Messages.getString("MenuItemModifierGroupForm.20"));
                return false;
            }
        }
        modifierGroup.setName(name);
        modifierGroup.setTranslatedName(translatedName);
        modifierGroup.setMinQuantity(minQuantity);
        modifierGroup.setMaxQuantity(maxQuantity);
        modifierGroup.setEnable(selected);
        modifierGroup.setSortOrder(sortOrder);
        modifierGroup.setJumpGroup(jumpSelected);
        return true;
    }

    @Override
    public String getDisplayText() {
        MenuItemModifierSpec modifierGroup = this.getBean();
        if (modifierGroup.getId() == null) {
            return POSConstants.ADD_NEW_MODIFIER_GROUP_IN_MENU_ITEM_;
        }
        return POSConstants.EDIT_MODIFIER_GROUP_IN_MENU_ITEM_;
    }

    public MenuItemModifierSpec getBean() {
        MenuItemModifierSpec modifierGroup = (MenuItemModifierSpec)super.getBean();
        if (modifierGroup == null) {
            modifierGroup = new MenuItemModifierSpec();
            this.setBean(modifierGroup);
        }
        return modifierGroup;
    }

    public class ModifierTableModel
    extends ListTableModel {
        private String[] columns = new String[]{"MODIFIER_NAME", "ACTIVE", "DEFAULT"};

        @Override
        public int getColumnCount() {
            return this.columns.length;
        }

        @Override
        public String[] getColumnNames() {
            return this.columns;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 1: 
                case 2: {
                    return Boolean.class;
                }
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1 || columnIndex == 2;
        }

        @Override
        public String getColumnName(int column) {
            return this.columns[column];
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            MenuModifier menuModifier = (MenuModifier)this.getRowData(rowIndex);
            MenuItemModifierSpec modifierGroup = MenuItemModifierGroupForm.this.getBean();
            switch (columnIndex) {
                case 0: {
                    return menuModifier.getName();
                }
                case 1: {
                    return "";
                }
                case 2: {
                    return modifierGroup.getDefaultModifiers() != null && modifierGroup.getDefaultModifiers().contains(menuModifier);
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            MenuModifier menuModifier = (MenuModifier)this.getRowData(rowIndex);
            MenuItemModifierSpec modifierGroup = MenuItemModifierGroupForm.this.getBean();
            boolean selected = (Boolean)aValue;
            switch (columnIndex) {
                case 1: {
                    break;
                }
                case 2: {
                    if (selected) {
                        if (MenuItemModifierGroupForm.this.tfMaxQuantity.getInteger() == 0) {
                            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("MenuItemModifierGroupForm.24"));
                            break;
                        }
                        if (modifierGroup.getDefaultModifiers() == null || modifierGroup.getDefaultModifiers().size() < MenuItemModifierGroupForm.this.tfMaxQuantity.getInteger()) break;
                        POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("MenuItemModifierGroupForm.25"));
                        break;
                    }
                    Set<MenuModifier> modifiers = modifierGroup.getDefaultModifiers();
                    if (modifiers == null) break;
                    modifiers.remove(menuModifier);
                }
            }
            super.setValueAt(aValue, rowIndex, columnIndex);
        }
    }
}

