/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.model.DayPart;
import com.floreantpos.model.FinancialAccount;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.PriceByShiftAndSalesArea;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.Shift;
import com.floreantpos.model.dao.FinancialAccountDAO;
import com.floreantpos.model.dao.SalesAreaDAO;
import com.floreantpos.model.dao.ShiftDAO;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.FinancialAccountEntryForm;
import com.floreantpos.ui.model.SalesAreaEntryForm;
import com.floreantpos.ui.model.ShiftEntryDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;

public class MenuItemPriceByShiftAndSalesAreaForm
extends BeanEditor<PriceByShiftAndSalesArea> {
    private JPanel contentPane;
    private JComboBox cbShift;
    private JComboBox cbSalesArea;
    private JComboBox cbFinancialAccount;
    private JTextField tfPrice;
    private MenuItem menuItem;

    public MenuItemPriceByShiftAndSalesAreaForm(Frame owner, MenuItem item, PriceByShiftAndSalesArea bean) {
        this.menuItem = item;
        this.init();
        this.setBean(bean);
    }

    private void init() {
        this.initUI();
        this.cbSalesArea.setModel(new ComboBoxModel(SalesAreaDAO.getInstance().findAll()));
        this.cbShift.setModel(new ComboBoxModel(ShiftDAO.getInstance().findAll()));
        this.cbFinancialAccount.setModel(new ComboBoxModel(FinancialAccountDAO.getInstance().findAll()));
    }

    private void initUI() {
        this.contentPane = new JPanel(new BorderLayout());
        this.cbShift = new JComboBox();
        this.cbSalesArea = new JComboBox();
        this.cbFinancialAccount = new JComboBox();
        this.tfPrice = new JTextField(20);
        JButton btnNewShift = new JButton("New");
        btnNewShift.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuItemPriceByShiftAndSalesAreaForm.this.addNewShift();
            }
        });
        JButton btnNewSalesArea = new JButton("New");
        btnNewSalesArea.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuItemPriceByShiftAndSalesAreaForm.this.addNewSalesArea();
            }
        });
        JButton btnNewFinancialAccount = new JButton("New");
        btnNewFinancialAccount.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuItemPriceByShiftAndSalesAreaForm.this.addNewFinancialAccount();
            }
        });
        JPanel panel = new JPanel((LayoutManager)new MigLayout("", "grow", ""));
        panel.add((Component)new JLabel("Shift"), "right");
        panel.add((Component)this.cbShift, "grow,split 2");
        panel.add((Component)btnNewShift, "wrap");
        panel.add((Component)new JLabel("Sales Area"), "right");
        panel.add((Component)this.cbSalesArea, "grow,split 2");
        panel.add((Component)btnNewSalesArea, "wrap");
        panel.add((Component)new JLabel("Financial account"), "right");
        panel.add((Component)this.cbFinancialAccount, "grow,split 2");
        panel.add((Component)btnNewFinancialAccount, "wrap");
        panel.add((Component)new JLabel("Price"), "right");
        panel.add((Component)this.tfPrice, "grow,wrap");
        this.contentPane.add((Component)panel, "Center");
        this.add(this.contentPane);
    }

    private void addNewSalesArea() {
        SalesArea item = new SalesArea();
        SalesAreaEntryForm editor = new SalesAreaEntryForm(item);
        BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
        dialog.open();
        if (dialog.isCanceled()) {
            return;
        }
        SalesArea salesArea = (SalesArea)editor.getBean();
        this.cbSalesArea.addItem(salesArea);
        this.cbSalesArea.setSelectedItem(salesArea);
    }

    private void addNewFinancialAccount() {
        FinancialAccountEntryForm form = new FinancialAccountEntryForm(new FinancialAccount());
        BeanEditorDialog dialog = new BeanEditorDialog();
        dialog.setBeanEditor(form);
        dialog.open();
        if (dialog.isCanceled()) {
            return;
        }
        FinancialAccount department = (FinancialAccount)form.getBean();
        ComboBoxModel model = (ComboBoxModel)this.cbFinancialAccount.getModel();
        model.addElement(department);
        this.cbFinancialAccount.setSelectedItem(department);
    }

    private void addNewShift() {
        ShiftEntryDialog dialog = new ShiftEntryDialog();
        dialog.open();
        if (dialog.isCanceled()) {
            return;
        }
        if (dialog.isCanceled()) {
            return;
        }
        DayPart shift = dialog.getShift();
        ComboBoxModel model = (ComboBoxModel)this.cbShift.getModel();
        model.addElement(shift);
        this.cbShift.setSelectedItem(shift);
    }

    @Override
    public boolean save() {
        if (!this.updateModel()) {
            return false;
        }
        PriceByShiftAndSalesArea bean = (PriceByShiftAndSalesArea)this.getBean();
        this.menuItem.addToshiftAndSalesAreaPriceList(bean);
        return true;
    }

    @Override
    protected void updateView() {
        if (this.menuItem == null) {
            return;
        }
        PriceByShiftAndSalesArea bean = (PriceByShiftAndSalesArea)this.getBean();
        this.cbShift.setSelectedItem(bean.getShift());
        this.cbSalesArea.setSelectedItem(bean.getSalesArea());
        this.cbFinancialAccount.setSelectedItem(bean.getFinancialAccount());
        this.tfPrice.setText(String.valueOf(bean.getPrice()));
    }

    @Override
    public String getDisplayText() {
        return "Add/Edit- Shift and Sales Area Price";
    }

    @Override
    protected boolean updateModel() {
        double price = 0.0;
        try {
            price = Double.parseDouble(this.tfPrice.getText());
        }
        catch (Exception x) {
            POSMessageDialog.showError(this, POSConstants.PRICE_IS_NOT_VALID_);
            return false;
        }
        SalesArea salesArea = (SalesArea)this.cbSalesArea.getSelectedItem();
        Shift shift = (Shift)this.cbShift.getSelectedItem();
        FinancialAccount financialAccount = (FinancialAccount)this.cbFinancialAccount.getSelectedItem();
        if (shift == null || salesArea == null || financialAccount == null) {
            BOMessageDialog.showError(POSUtil.getFocusedWindow(), "Required field cannot be empty.");
            return false;
        }
        if (this.hasDuplicateBeanItem(salesArea, shift, financialAccount)) {
            return false;
        }
        ((PriceByShiftAndSalesArea)this.bean).setShift(shift);
        ((PriceByShiftAndSalesArea)this.bean).setFinancialAccount(financialAccount);
        ((PriceByShiftAndSalesArea)this.bean).setSalesArea(salesArea);
        ((PriceByShiftAndSalesArea)this.bean).setPrice(Double.valueOf(this.tfPrice.getText()));
        return true;
    }

    private boolean hasDuplicateBeanItem(SalesArea area, Shift shift, FinancialAccount account) {
        List<PriceByShiftAndSalesArea> existingItems = this.menuItem.getShiftAndSalesAreaPriceList();
        if (existingItems == null) {
            return false;
        }
        for (PriceByShiftAndSalesArea item : existingItems) {
            if (!item.getSalesArea().getName().equals(area.getName()) || !shift.getName().equals(item.getShift().getName()) || item.getId() == ((PriceByShiftAndSalesArea)this.getBean()).getId()) continue;
            BOMessageDialog.showError("Already exists");
            return true;
        }
        return false;
    }
}

