/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.modifierdesigner.ModifierGroupPageDesigner;
import com.floreantpos.bo.ui.modifierdesigner.ModifierSelectionDialog;
import com.floreantpos.model.MenuItemModifierPage;
import com.floreantpos.model.MenuItemModifierPageItem;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.model.dao.MenuItemModifierPageDAO;
import com.floreantpos.model.dao.MenuItemModifierSpecDAO;
import com.floreantpos.model.dao.MenuModifierDAO;
import com.floreantpos.model.dao.ModifierGroupDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.ModifierPricingRule;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.jidesoft.range.IntegerRange;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.StaleStateException;
import org.jdesktop.swingx.JXTable;

public class ModifierGroupForm
extends BeanEditor
implements RefreshableView,
ChangeListener {
    private JLabel jLabel1;
    private FixedLengthTextField tfName;
    private FixedLengthTextField tfTranslatedName;
    private JList listModifiers;
    private ComboBoxModel modifierListModel;
    private Boolean pizzaModifierGroup;
    private JTabbedPane tabbedPane = new JTabbedPane();
    private JPanel tabModifierGroup = new JPanel();
    private JPanel tabGroupMenuPage = new JPanel();
    private JLabel lblMin;
    private JLabel lblMax;
    private JLabel lblSortOrder;
    private IntegerTextField tfMaxQuantity = new IntegerTextField();
    private IntegerTextField tfMinQuantity = new IntegerTextField();
    private IntegerTextField tfSortOrder = new IntegerTextField();
    private JCheckBox chkVisible;
    private JCheckBox chkAutoShow;
    private JCheckBox chkJumbToNextGroup;
    private JCheckBox chkEnableGroupWisePricing;
    private ModifierGroupPageDesigner modifierDesigner;
    private JPanel groupPricingPanel;
    private JXTable groupPricingTable;
    private BeanTableModel<ModifierPricingRule> groupPricingTableModel;
    private JPanel priceInputPanel;
    private IntegerTextField tfFromQty;
    private IntegerTextField tfToQty;
    private DoubleTextField tfPrice;
    private ModifierGroup modifierGroup;

    public ModifierGroupForm() throws Exception {
        this(new ModifierGroup());
    }

    public ModifierGroupForm(ModifierGroup group) throws Exception {
        this(group, (Boolean)false);
    }

    public ModifierGroupForm(ModifierGroup group, Boolean pizzaModifierGroup) throws Exception {
        this.modifierGroup = group;
        this.initComponents();
        this.setBean(group);
        this.pizzaModifierGroup = pizzaModifierGroup;
    }

    private void initComponents() {
        this.createModifierGroupTab();
        this.createGroupMenuPageTab();
        Dimension mainPanelSize = PosUIManager.getSize(700, 460);
        this.tabbedPane.setPreferredSize(mainPanelSize);
        this.tabbedPane.addChangeListener(this);
        this.add(this.tabbedPane);
    }

    private void createModifierGroupTab() {
        this.setLayout(new BorderLayout());
        this.tabModifierGroup.setLayout(new BorderLayout(5, 5));
        JPanel mainFormPanel = new JPanel();
        mainFormPanel.setLayout(new BorderLayout());
        mainFormPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        JPanel formPanel = new JPanel();
        formPanel.setLayout((LayoutManager)new MigLayout("", "[45px][369px,grow]", "[19px][]"));
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout((LayoutManager)new MigLayout("fillx,inset 5 0 0 0", "[][grow]", ""));
        this.jLabel1 = new JLabel();
        this.tfName = new FixedLengthTextField();
        this.tfName.setLength(60);
        this.jLabel1.setText(POSConstants.NAME);
        JLabel lblTranslatedName = new JLabel(POSConstants.TRANSLATED_NAME);
        this.tfTranslatedName = new FixedLengthTextField();
        this.tfTranslatedName.setLength(60);
        this.lblMin = new JLabel(Messages.getString("MenuItemModifierGroupForm.6"));
        this.lblMax = new JLabel(Messages.getString("MenuItemModifierGroupForm.7"));
        this.lblSortOrder = new JLabel(Messages.getString("MenuItemModifierSpecForm.0"));
        this.chkVisible = new JCheckBox(Messages.getString("MenuItemModifierSpecForm.1"));
        this.chkAutoShow = new JCheckBox(Messages.getString("MenuItemModifierSpecForm.2"));
        this.chkJumbToNextGroup = new JCheckBox(Messages.getString("MenuItemModifierSpecForm.3"));
        this.chkEnableGroupWisePricing = new JCheckBox(Messages.getString("MenuItemModifierSpecForm.4"));
        this.tfMinQuantity.setColumns(10);
        this.tfMaxQuantity.setColumns(10);
        this.tfSortOrder.setColumns(10);
        this.tfMinQuantity.setText("1");
        this.tfMaxQuantity.setText("1");
        this.chkVisible.setSelected(true);
        formPanel.add((Component)this.jLabel1, "cell 0 0,alignx trailing,aligny center");
        formPanel.add((Component)this.tfName, "cell 1 0,growx,aligny top");
        formPanel.add((Component)lblTranslatedName, "cell 0 1,alignx trailing");
        formPanel.add((Component)this.tfTranslatedName, "cell 1 1,growx");
        contentPanel.add((Component)this.lblMax, "cell 0 2,alignx trailing");
        contentPanel.add((Component)this.tfMaxQuantity, "cell 1 2,growx");
        contentPanel.add((Component)this.lblMin, "cell 0 3,alignx trailing");
        contentPanel.add((Component)this.tfMinQuantity, "cell 1 3,growx");
        contentPanel.add((Component)this.lblSortOrder, "cell 0 4,alignx trailing");
        contentPanel.add((Component)this.tfSortOrder, "cell 1 4,growx");
        contentPanel.add((Component)this.chkJumbToNextGroup, "cell 1 5,growx");
        contentPanel.add((Component)this.chkAutoShow, "cell 1 6,growx");
        contentPanel.add((Component)this.chkEnableGroupWisePricing, "cell 1 7,growx");
        contentPanel.add((Component)this.chkVisible, "cell 1 8,growx");
        JPanel modifierPanel = new JPanel((LayoutManager)new MigLayout("fill"));
        JPanel listPanel = new JPanel((LayoutManager)new MigLayout("fill"));
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout());
        Border loweredetched = BorderFactory.createEtchedBorder(1);
        TitledBorder title = BorderFactory.createTitledBorder(loweredetched, "Modifier List");
        title.setTitleJustification(1);
        JButton btnAddModifier = new JButton(Messages.getString("ModifierGroupForm.2"));
        btnAddModifier.addActionListener(e -> this.doAddModifiers());
        JButton btnRemoveModifier = new JButton(Messages.getString("ModifierGroupForm.3"));
        btnRemoveModifier.addActionListener(e -> {
            MenuModifier modifier = (MenuModifier)this.listModifiers.getSelectedValue();
            if (modifier == null) {
                return;
            }
            this.modifierListModel.removeElement(modifier);
        });
        this.listModifiers = new JList();
        JScrollPane scrollPane = new JScrollPane(this.listModifiers);
        listPanel.setBorder(title);
        listPanel.add((Component)scrollPane, "grow");
        buttonPanel.add(btnAddModifier);
        buttonPanel.add(btnRemoveModifier);
        modifierPanel.add((Component)listPanel, "grow");
        modifierPanel.add((Component)buttonPanel, "South");
        mainFormPanel.add((Component)formPanel, "North");
        mainFormPanel.add(this.createModifierGroupPricingPanel());
        mainFormPanel.add((Component)contentPanel, "West");
        this.createPriceInputPanel();
        this.tabModifierGroup.add((Component)mainFormPanel, "North");
        this.tabModifierGroup.add(modifierPanel);
        this.tabbedPane.addTab(POSConstants.MODIFIER_GROUP, this.tabModifierGroup);
    }

    public void createGroupMenuPageTab() {
        this.modifierDesigner = new ModifierGroupPageDesigner(this.modifierGroup);
        this.tabGroupMenuPage.setLayout(new BorderLayout(10, 10));
        this.tabGroupMenuPage.add(this.modifierDesigner);
        this.tabbedPane.addTab(Messages.getString("ModifierGroupForm.0"), this.modifierDesigner);
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            ModifierGroupDAO dao = ModifierGroupDAO.getInstance();
            ModifierGroup group = (ModifierGroup)this.getBean();
            if (StringUtils.isBlank((String)group.getId())) {
                dao.save(group);
            }
            this.modifierDesigner.updateModel();
            List<MenuItemModifierPage> menuItemModifierPages = this.modifierDesigner.getAllGroupModifierPages();
            if (menuItemModifierPages != null) {
                for (MenuItemModifierPage menuItemModifierPage : menuItemModifierPages) {
                    String id = menuItemModifierPage.getId();
                    List<MenuItemModifierPageItem> pageItems = menuItemModifierPage.getPageItems();
                    menuItemModifierPage.setModifierGroupId(group.getId());
                    if (StringUtils.isBlank((String)id)) {
                        MenuItemModifierPageDAO.getInstance().save(menuItemModifierPage);
                        id = menuItemModifierPage.getId();
                    }
                    if (pageItems == null) continue;
                    for (MenuItemModifierPageItem menuItemModifierPageItem : pageItems) {
                        menuItemModifierPageItem.setParentPageId(id);
                    }
                    MenuItemModifierPageDAO.getInstance().saveOrUpdate(menuItemModifierPage);
                }
            }
            String createStringByField = POSUtil.createStringByField(menuItemModifierPages, MenuItemModifierPage.class, "getId");
            group.setModifierPageIds(createStringByField);
            dao.saveOrUpdate(group);
            this.doUpdateAllModifierSpec(group);
        }
        catch (StaleStateException e) {
            POSMessageDialog.showMessageDialogWithReloadButton(this, this);
            return false;
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage(), e);
            return false;
        }
        return true;
    }

    private void doUpdateAllModifierSpec(ModifierGroup group) throws Exception {
        List<MenuItemModifierSpec> allSpacByGroups = MenuItemModifierSpecDAO.getInstance().findMenuItemModifierSpecsByGroup(group);
        if (allSpacByGroups != null) {
            for (MenuItemModifierSpec itemModifierSpec : allSpacByGroups) {
                if (!itemModifierSpec.isEnableModifierGroupSettings()) continue;
                MenuItemModifierSpecDAO.getInstance().initialize(itemModifierSpec);
                itemModifierSpec.setMinQuantity(group.getMinQuantity());
                itemModifierSpec.setMaxQuantity(group.getMaxQuantity());
                itemModifierSpec.setSortOrder(group.getSortOrder());
                itemModifierSpec.setEnable(group.isEnable());
                itemModifierSpec.setJumpGroup(group.isJumpGroup());
                itemModifierSpec.setAutoShow(group.isAutoShow());
                itemModifierSpec.addProperty("enableGroupPricing", String.valueOf(group.isEnableGroupPricing()));
                List pricingRules = group.getPriceRules();
                if (pricingRules == null || pricingRules.isEmpty()) {
                    itemModifierSpec.removeProperty("priceRules");
                } else {
                    JsonArray groupPricingRulesJsonArray = new JsonArray();
                    for (ModifierPricingRule priceRule : pricingRules) {
                        JsonObject orderTypeObject = new JsonObject();
                        orderTypeObject.addProperty("fromQty", (Number)priceRule.getFromQty());
                        orderTypeObject.addProperty("toQty", (Number)priceRule.getToQty());
                        orderTypeObject.addProperty("price", (Number)priceRule.getPrice());
                        groupPricingRulesJsonArray.add((JsonElement)orderTypeObject);
                    }
                    itemModifierSpec.getPropertyStore().add("priceRules", (JsonElement)groupPricingRulesJsonArray);
                }
                itemModifierSpec.getModifierPages().clear();
                List<MenuItemModifierPage> pages = group.getModifierGroupPages();
                if (pages != null) {
                    for (MenuItemModifierPage menuItemModifierPage : pages) {
                        itemModifierSpec.addTomodifierPages(menuItemModifierPage.deepClone());
                    }
                }
                MenuItemModifierSpecDAO.getInstance().saveOrUpdate(itemModifierSpec);
            }
        }
    }

    @Override
    protected void updateView() {
        ModifierGroup group = (ModifierGroup)this.getBean();
        if (group.getId() != null && !Hibernate.isInitialized(group.getModifiers())) {
            Session session = MenuModifierDAO.getInstance().getSession();
            group = (ModifierGroup)session.merge((Object)group);
            Hibernate.initialize(group.getModifiers());
            session.close();
        }
        this.tfName.setText(group.getName());
        this.tfTranslatedName.setText(group.getTranslatedName());
        this.modifierListModel = new ComboBoxModel();
        if (group.getModifiers() != null) {
            this.modifierListModel.setDataList(group.getModifiers());
        } else {
            this.modifierListModel.setDataList(new ArrayList());
        }
        this.listModifiers.setModel(this.modifierListModel);
        this.tfMinQuantity.setText(String.valueOf(group.getMinQuantity()));
        Integer maxQuantity = group.getMaxQuantity();
        this.tfMaxQuantity.setText(String.valueOf(maxQuantity == 0 ? 1 : maxQuantity));
        this.tfSortOrder.setText(String.valueOf(group.getSortOrder()));
        this.chkVisible.setSelected(group.isEnable());
        this.chkJumbToNextGroup.setSelected(group.isJumpGroup());
        this.chkAutoShow.setSelected(group.isAutoShow());
        this.chkEnableGroupWisePricing.setSelected(group.isEnableGroupPricing());
        ArrayList priceRules = group.getPriceRules();
        if (priceRules == null) {
            priceRules = new ArrayList();
        }
        this.groupPricingTableModel.setRows(priceRules);
        this.setVisibleGroupWisePricePanel(this.chkEnableGroupWisePricing.isSelected());
    }

    @Override
    protected boolean updateModel() {
        ModifierGroup group = (ModifierGroup)this.getBean();
        String name = this.tfName.getText();
        if (POSUtil.isBlankOrNull(name)) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.NAME_REQUIRED);
            return false;
        }
        group.setName(name);
        group.setTranslatedName(this.tfTranslatedName.getText());
        group.setModifiers(this.modifierListModel.getDataList());
        group.setPizzaModifierGroup(this.pizzaModifierGroup);
        int maxQty = this.tfMaxQuantity.getInteger();
        int minQty = this.tfMinQuantity.getInteger();
        if (maxQty < 1) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("MenuItemModifierSpecForm.111"));
            return false;
        }
        if (minQty > maxQty) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("ComboGroupItemSelectionDialog.15"));
            return false;
        }
        group.setMinQuantity(minQty);
        group.setMaxQuantity(maxQty);
        group.setSortOrder(this.tfSortOrder.getInteger());
        group.setEnable(this.chkVisible.isSelected());
        group.setJumpGroup(this.chkJumbToNextGroup.isSelected());
        group.setAutoShow(this.chkAutoShow.isSelected());
        group.addProperty("enableGroupPricing", String.valueOf(this.chkEnableGroupWisePricing.isSelected()));
        List<ModifierPricingRule> pricingRules = this.groupPricingTableModel.getRows();
        if (pricingRules == null || pricingRules.isEmpty()) {
            group.removeProperty("priceRules");
        } else {
            JsonArray groupPricingRulesJsonArray = new JsonArray();
            for (ModifierPricingRule priceRule : pricingRules) {
                JsonObject orderTypeObject = new JsonObject();
                orderTypeObject.addProperty("fromQty", (Number)priceRule.getFromQty());
                orderTypeObject.addProperty("toQty", (Number)priceRule.getToQty());
                orderTypeObject.addProperty("price", (Number)priceRule.getPrice());
                groupPricingRulesJsonArray.add((JsonElement)orderTypeObject);
            }
            group.getPropertyStore().add("priceRules", (JsonElement)groupPricingRulesJsonArray);
        }
        return true;
    }

    @Override
    public String getDisplayText() {
        ModifierGroup modifierGroup = (ModifierGroup)this.getBean();
        if (modifierGroup.getId() == null) {
            return POSConstants.NEW_MODIFIER_GROUP;
        }
        return POSConstants.EDIT_MODIFIER_GROUP;
    }

    private void doAddModifiers() {
        ModifierSelectionDialog modifierSelectionDialog = new ModifierSelectionDialog(this.modifierListModel.getDataList(), (boolean)this.pizzaModifierGroup);
        modifierSelectionDialog.setSize(PosUIManager.getSize(800, 600));
        modifierSelectionDialog.open();
        if (modifierSelectionDialog.isCanceled()) {
            return;
        }
        List<MenuModifier> selectedMenuModifierList = modifierSelectionDialog.getSelectedMenuModifierList();
        this.modifierListModel.removeAllElements();
        for (MenuModifier menuModifier : selectedMenuModifierList) {
            this.modifierListModel.addElement(menuModifier);
        }
    }

    @Override
    public void refresh() {
        ModifierGroup mGroup = (ModifierGroup)this.getBean();
        ModifierGroup modifierGroup = ModifierGroupDAO.getInstance().get(mGroup.getId());
        this.setBean(modifierGroup);
    }

    private JPanel createModifierGroupPricingPanel() {
        this.chkEnableGroupWisePricing.addActionListener(e -> this.setVisibleGroupWisePricePanel(this.chkEnableGroupWisePricing.isSelected()));
        this.groupPricingTableModel = new BeanTableModel(ModifierPricingRule.class){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                if (columnIndex == 2) {
                    ModifierPricingRule selectedPriceRule = (ModifierPricingRule)ModifierGroupForm.this.groupPricingTableModel.getRow(rowIndex);
                    return NumberUtil.formatNumber(selectedPriceRule.getPrice());
                }
                return super.getValueAt(rowIndex, columnIndex);
            }

            @Override
            public void setValueAt(Object value, int rowIndex, int columnIndex) {
                if (value == null) {
                    value = 0.0;
                }
                if (columnIndex == 0) {
                    int selectedRow = ModifierGroupForm.this.groupPricingTable.getSelectedRow();
                    if (selectedRow == -1) {
                        return;
                    }
                    ModifierPricingRule selectedPriceRule = (ModifierPricingRule)ModifierGroupForm.this.groupPricingTableModel.getRow(ModifierGroupForm.this.groupPricingTable.convertRowIndexToModel(selectedRow));
                    if (!ModifierGroupForm.this.isValidQtyRange(selectedPriceRule, POSUtil.parseInteger(value.toString()), selectedPriceRule.getToQty())) {
                        ModifierGroupForm.this.groupPricingTable.getSelectionModel().setSelectionInterval(selectedRow, selectedRow);
                        return;
                    }
                    value = POSUtil.parseInteger(value.toString());
                } else if (columnIndex == 1) {
                    int selectedRow = ModifierGroupForm.this.groupPricingTable.getSelectedRow();
                    if (selectedRow == -1) {
                        return;
                    }
                    ModifierPricingRule selectedPriceRule = (ModifierPricingRule)ModifierGroupForm.this.groupPricingTableModel.getRow(ModifierGroupForm.this.groupPricingTable.convertRowIndexToModel(selectedRow));
                    if (!ModifierGroupForm.this.isValidQtyRange(selectedPriceRule, selectedPriceRule.getFromQty(), POSUtil.parseInteger(value.toString()))) {
                        ModifierGroupForm.this.groupPricingTable.getSelectionModel().setSelectionInterval(selectedRow, selectedRow);
                        return;
                    }
                    value = POSUtil.parseInteger(value.toString());
                } else if (columnIndex == 2) {
                    value = POSUtil.parseDouble(value.toString());
                }
                super.setValueAt(value, rowIndex, columnIndex);
            }
        };
        this.groupPricingTableModel.setNumRows(5);
        this.groupPricingTableModel.addColumn(POSConstants.FROM, "fromQty", BeanTableModel.EditMode.EDITABLE);
        this.groupPricingTableModel.addColumn(POSConstants.TO, "toQty", BeanTableModel.EditMode.EDITABLE);
        this.groupPricingTableModel.addColumn(POSConstants.PRICE, "price", BeanTableModel.EditMode.EDITABLE, 4, BeanTableModel.DataType.MONEY);
        this.groupPricingTable = new JXTable(this.groupPricingTableModel){

            public void changeSelection(int row, int column, boolean toggle, boolean extend) {
                super.changeSelection(row, column, toggle, extend);
                this.editCellAt(row, column);
                DefaultCellEditor editor = (DefaultCellEditor)this.getCellEditor(row, column);
                JTextField textField = (JTextField)editor.getComponent();
                textField.requestFocus();
                textField.selectAll();
            }
        };
        IntegerTextField tfFromQty = new IntegerTextField();
        IntegerTextField tfToQty = new IntegerTextField();
        DoubleTextField tfGroupPrice = new DoubleTextField();
        tfFromQty.setHorizontalAlignment(4);
        tfToQty.setHorizontalAlignment(4);
        tfGroupPrice.setHorizontalAlignment(4);
        this.groupPricingTable.getColumnModel().getColumn(0).setCellEditor(new DefaultCellEditor(tfFromQty));
        this.groupPricingTable.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(tfToQty));
        this.groupPricingTable.getColumnModel().getColumn(2).setCellEditor(new DefaultCellEditor(tfGroupPrice));
        this.groupPricingPanel = new JPanel((LayoutManager)new MigLayout("fill,ins 0 5 0 0", "[grow]", "[grow][]"));
        JScrollPane groupPricingScrollPane = new JScrollPane((Component)this.groupPricingTable);
        groupPricingScrollPane.setBorder(BorderFactory.createTitledBorder(null, Messages.getString("PriceExplorer.0"), 2, 2));
        JButton btnAdd = new JButton(Messages.getString("MenuItemForm.9"));
        JButton btnEdit = new JButton(POSConstants.EDIT);
        JButton btnDelete = new JButton(POSConstants.DELETE);
        btnDelete.setFocusable(true);
        btnAdd.addActionListener(e -> this.doAddPriceRule());
        btnEdit.addActionListener(e -> this.doEditPriceRule());
        btnDelete.addActionListener(e -> this.doDeletePriceRule());
        this.groupPricingPanel.add((Component)groupPricingScrollPane, "growx,span");
        this.groupPricingPanel.add((Component)btnAdd, "newline,split 3,right");
        this.groupPricingPanel.add(btnEdit);
        this.groupPricingPanel.add(btnDelete);
        this.groupPricingPanel.setPreferredSize(PosUIManager.getSize(0, 150));
        return this.groupPricingPanel;
    }

    private void setVisibleGroupWisePricePanel(boolean selected) {
        this.groupPricingPanel.setVisible(selected);
    }

    protected boolean isValidQtyRange(ModifierPricingRule pricing, int fromQty, int toQty) {
        if (toQty < fromQty) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), Messages.getString("MenuItemModifierSpecForm.32"));
            this.tfFromQty.requestFocus();
            this.tfFromQty.selectAll();
            return false;
        }
        if (fromQty <= 0) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), Messages.getString("MenuItemModifierSpecForm.33"));
            this.tfFromQty.requestFocus();
            this.tfFromQty.selectAll();
            return false;
        }
        if (toQty <= 0) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), Messages.getString("MenuItemModifierSpecForm.33"));
            this.tfToQty.requestFocus();
            this.tfToQty.selectAll();
            return false;
        }
        if ((double)toQty > POSUtil.parseDouble(this.tfMaxQuantity.getText())) {
            this.showQuantityExceedMessage();
            this.tfToQty.requestFocus();
            this.tfToQty.selectAll();
            return false;
        }
        if (this.groupPricingTableModel.getRowCount() > 0) {
            for (ModifierPricingRule price : this.groupPricingTableModel.getRows()) {
                IntegerRange range;
                if (price == pricing || !(range = new IntegerRange(price.getFromQty().intValue(), price.getToQty().intValue())).contains(Integer.valueOf(fromQty)) && !range.contains(Integer.valueOf(toQty))) continue;
                POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), Messages.getString("MenuItemModifierSpecForm.35"));
                return false;
            }
        }
        return true;
    }

    private void showQuantityExceedMessage() {
        POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), Messages.getString("MenuItemModifierSpecForm.31"));
        this.tfMaxQuantity.requestFocus();
        this.tfMaxQuantity.selectAll();
    }

    private void createPriceInputPanel() {
        this.priceInputPanel = new JPanel((LayoutManager)new MigLayout("fill,wrap 2", "[][grow]", ""));
        this.tfFromQty = new IntegerTextField(5);
        this.tfToQty = new IntegerTextField(5);
        this.tfPrice = new DoubleTextField(5);
        this.priceInputPanel.add(new JLabel(POSConstants.FROM));
        this.priceInputPanel.add((Component)this.tfFromQty, "growx");
        this.priceInputPanel.add(new JLabel(POSConstants.TO));
        this.priceInputPanel.add((Component)this.tfToQty, "growx");
        this.priceInputPanel.add(new JLabel(POSConstants.PRICE));
        this.priceInputPanel.add((Component)this.tfPrice, "growx");
    }

    private void doAddPriceRule() {
        this.openPriceRuleInputDialog(new ModifierPricingRule(), false);
    }

    private void doEditPriceRule() {
        ModifierPricingRule selectedPriceRule = this.getSelectedPriceRule();
        if (selectedPriceRule == null) {
            return;
        }
        this.openPriceRuleInputDialog(selectedPriceRule, true);
    }

    private void doDeletePriceRule() {
        if (this.groupPricingTable.isEditing()) {
            return;
        }
        ModifierPricingRule selectedPriceRule = this.getSelectedPriceRule();
        if (selectedPriceRule == null) {
            return;
        }
        this.groupPricingTableModel.removeRow(selectedPriceRule);
    }

    private void openPriceRuleInputDialog(final ModifierPricingRule pricing, final boolean editMode) {
        if (!editMode) {
            pricing.setFromQty(this.getNextQty());
            pricing.setToQty(POSUtil.parseInteger(this.tfMaxQuantity.getText()));
            pricing.setPrice(this.getFirstModifierPrice());
        }
        this.tfFromQty.setText(String.valueOf(pricing.getFromQty()));
        this.tfToQty.setText(String.valueOf(pricing.getToQty()));
        this.tfPrice.setText(NumberUtil.formatAmount(pricing.getPrice()));
        this.tfFromQty.requestFocus();
        this.tfFromQty.selectAll();
        OkCancelOptionDialog dialog = new OkCancelOptionDialog(){

            @Override
            public void doOk() {
                int toQty;
                double price = ModifierGroupForm.this.tfPrice.getDoubleOrZero();
                int fromQty = ModifierGroupForm.this.tfFromQty.getInteger();
                if (!ModifierGroupForm.this.isValidQtyRange(pricing, fromQty, toQty = ModifierGroupForm.this.tfToQty.getInteger())) {
                    return;
                }
                pricing.setFromQty(fromQty);
                pricing.setToQty(toQty);
                pricing.setPrice(price);
                if (!editMode) {
                    ModifierGroupForm.this.groupPricingTableModel.addRow(pricing);
                } else {
                    ModifierGroupForm.this.groupPricingTable.repaint();
                }
                super.doCancel();
            }
        };
        String caption = editMode ? Messages.getString("MenuItemModifierSpecForm.29") : Messages.getString("MenuItemModifierSpecForm.30");
        dialog.setTitle(caption);
        dialog.setCaption(caption);
        dialog.getContentPanel().add(this.priceInputPanel);
        dialog.pack();
        dialog.open();
    }

    private ModifierPricingRule getSelectedPriceRule() {
        int selectedRow = this.groupPricingTable.getSelectedRow();
        if (selectedRow == -1) {
            POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), Messages.getString("MenuItemModifierSpecForm.36"));
            return null;
        }
        return this.groupPricingTableModel.getRow(this.groupPricingTable.convertRowIndexToModel(selectedRow));
    }

    private Integer getNextQty() {
        if (this.groupPricingTableModel.getRowCount() == 0) {
            return 1;
        }
        int nextQty = 1;
        for (ModifierPricingRule pricingRule : this.groupPricingTableModel.getRows()) {
            if (pricingRule.getToQty() <= nextQty) continue;
            nextQty = pricingRule.getToQty();
        }
        if ((double)(nextQty + 1) > POSUtil.parseDouble(this.tfMaxQuantity.getText())) {
            return 1;
        }
        return nextQty + 1;
    }

    private Double getFirstModifierPrice() {
        return 0.0;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Component selectedComponent = this.tabbedPane.getSelectedComponent();
        if (!(selectedComponent instanceof ModifierGroupPageDesigner)) {
            return;
        }
        ModifierGroupPageDesigner view = (ModifierGroupPageDesigner)selectedComponent;
        ModifierGroup group = (ModifierGroup)this.getBean();
        group.setModifiers(this.modifierListModel.getDataList());
        view.setSelectedGroup(group);
    }
}

