/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.OrderServiceExtension;
import com.floreantpos.model.CreditBookType;
import com.floreantpos.model.Department;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.TerminalType;
import com.floreantpos.model.dao.CreditBookTypeDAO;
import com.floreantpos.model.dao.DepartmentDAO;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.OrderTypeDAO;
import com.floreantpos.model.dao.SalesAreaDAO;
import com.floreantpos.model.dao.TaxGroupDAO;
import com.floreantpos.model.dao.TerminalTypeDAO;
import com.floreantpos.swing.CheckBoxList;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.MessageDialog;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.SalesAreaEntryForm;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;

public class OrderTypeForm
extends BeanEditor<OrderType> {
    private JLabel jLabel1;
    private FixedLengthTextField tfName;
    private JCheckBox chkEnabled;
    private JCheckBox chkShowTableSelection;
    private JCheckBox chkShowFreeTextTableSelection;
    private JCheckBox chkPromt;
    private JCheckBox chkShowGuestSelection;
    private JCheckBox chkShouldPrintToKitchen;
    private JCheckBox chkCloseOnPaid;
    private JCheckBox chkPrepaid;
    private JCheckBox chkRequiredCustomerData;
    private JCheckBox chkRequiredDeliveryData;
    private JCheckBox chkAssignDriver;
    private JCheckBox chkShowInLoginScreen;
    private JCheckBox chkConsolidateItemsInReceipt;
    private JCheckBox chkAllowSeatBasedOrder;
    private JCheckBox chkHideItemWithEmptyInventory;
    private JCheckBox chkHasForHereAndToGo;
    private JCheckBox chkBarTab;
    private JComboBox<SalesArea> cbSalesArea;
    private List<Department> deptList;
    private ArrayList<Department> selectedDeptList;
    private JCheckBox chkRetailOrder;
    private JCheckBox chkPreAuthCreditCard;
    private CheckBoxList<Department> chkbDeptList = new CheckBoxList();
    private CheckBoxList<TerminalType> chkbTerminalTypeList = new CheckBoxList();
    private CheckBoxList<MenuCategory> chkbCategoryList = new CheckBoxList();
    private CheckBoxList<CreditBookType> chkCreditBookTypeList = new CheckBoxList();
    private JCheckBox chkEnableCourse;
    private JCheckBox chkServiceChargeExempt;
    private JCheckBox chkApplyCreditCardSurcharge;
    private JCheckBox chkForHereTaxApplicable;
    private JCheckBox chkTogoTaxApplicable;

    public OrderTypeForm() throws Exception {
        this(new OrderType());
    }

    public OrderTypeForm(OrderType orderType) throws Exception {
        this.initComponents();
        this.initData();
        ArrayList<SalesArea> salesareaList = new ArrayList<SalesArea>();
        salesareaList.add(null);
        salesareaList.addAll(SalesAreaDAO.getInstance().findAll());
        this.cbSalesArea.setModel(new ComboBoxModel(salesareaList));
        this.setBean(orderType);
    }

    @Override
    public String getDisplayText() {
        OrderType orderType = (OrderType)this.getBean();
        if (orderType.getId() == null) {
            return POSConstants.ORDER_TYPE;
        }
        return POSConstants.ORDER_TYPE;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        TransparentPanel generalPanel = new TransparentPanel();
        JPanel column1 = new JPanel((LayoutManager)new MigLayout("fillx, hidemode 3", "[][grow]", ""));
        JPanel column2 = new JPanel((LayoutManager)new MigLayout("fillx, hidemode 3", "[][grow]", ""));
        Dimension preferredSize = PosUIManager.getSize(300, 600);
        column1.setPreferredSize(preferredSize);
        column2.setPreferredSize(preferredSize);
        this.jLabel1 = new JLabel(POSConstants.NAME + ":");
        this.jLabel1.setHorizontalAlignment(11);
        this.tfName = new FixedLengthTextField();
        this.tfName.setLength(120);
        this.chkEnabled = new JCheckBox(POSConstants.ENABLED);
        this.chkShowTableSelection = new JCheckBox(Messages.getString("OrderTypeForm.1"));
        this.chkShowFreeTextTableSelection = new JCheckBox(Messages.getString("OrderTypeForm.45"));
        this.chkPromt = new JCheckBox(Messages.getString("OrderTypeForm.47"));
        this.chkShowGuestSelection = new JCheckBox(Messages.getString("OrderTypeForm.2"));
        this.chkShouldPrintToKitchen = new JCheckBox(Messages.getString("OrderTypeForm.3"));
        this.chkCloseOnPaid = new JCheckBox(Messages.getString("OrderTypeForm.4"));
        this.chkPrepaid = new JCheckBox(Messages.getString("OrderTypeForm.5"));
        this.chkRequiredCustomerData = new JCheckBox(Messages.getString("OrderTypeForm.6"));
        this.chkRequiredDeliveryData = new JCheckBox(Messages.getString("OrderTypeForm.7"));
        this.chkAssignDriver = new JCheckBox(Messages.getString("OrderTypeForm.8"));
        this.chkShowInLoginScreen = new JCheckBox(Messages.getString("OrderTypeForm.10"));
        this.chkEnableCourse = new JCheckBox("Enable " + POSConstants.ORGANIZE_COURSE.toLowerCase());
        this.chkConsolidateItemsInReceipt = new JCheckBox(Messages.getString("OrderTypeForm.11"));
        this.chkAllowSeatBasedOrder = new JCheckBox("Allow seat based order");
        this.chkHideItemWithEmptyInventory = new JCheckBox(Messages.getString("OrderTypeForm.12"));
        this.chkHasForHereAndToGo = new JCheckBox(Messages.getString("OrderTypeForm.13"));
        this.chkBarTab = new JCheckBox("Bar Tab");
        this.chkRetailOrder = new JCheckBox("Retail");
        this.chkPreAuthCreditCard = new JCheckBox(Messages.getString("OrderTypeForm.0"));
        this.chkServiceChargeExempt = new JCheckBox("Service charge exempt");
        this.chkApplyCreditCardSurcharge = new JCheckBox("Apply credit card surcharge");
        this.chkForHereTaxApplicable = new JCheckBox("For Here tax applicable");
        this.chkTogoTaxApplicable = new JCheckBox("To Go tax applicable");
        this.cbSalesArea = new JComboBox();
        JButton btnCreateSalesArea = new JButton("New");
        btnCreateSalesArea.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    SalesArea item = new SalesArea();
                    SalesAreaEntryForm editor = new SalesAreaEntryForm(item);
                    BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
                    dialog.open();
                    if (dialog.isCanceled()) {
                        return;
                    }
                    SalesArea salesArea = (SalesArea)editor.getBean();
                    OrderTypeForm.this.cbSalesArea.addItem(salesArea);
                    OrderTypeForm.this.cbSalesArea.setSelectedItem(salesArea);
                }
                catch (Throwable x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        generalPanel.setLayout(new GridLayout(1, 1, 40, 5));
        column1.add((Component)this.jLabel1, "right");
        column1.add((Component)this.tfName, "growx, wrap");
        column1.add((Component)new JLabel("Sales Area"), "right");
        column1.add(this.cbSalesArea, "grow, wrap");
        column1.add((Component)this.chkEnabled, "skip 1,wrap");
        column1.add((Component)this.chkShowTableSelection, "skip 1,wrap");
        column1.add((Component)this.chkShowFreeTextTableSelection, "skip 1,wrap");
        column1.add((Component)this.chkPromt, "gapleft 20, skip 1,wrap");
        column1.add((Component)this.chkShowGuestSelection, "skip 1,wrap");
        column1.add((Component)this.chkShouldPrintToKitchen, "skip 1,wrap");
        column1.add((Component)this.chkPrepaid, "skip 1,wrap");
        column1.add((Component)this.chkCloseOnPaid, "skip 1,wrap");
        OrderServiceExtension orderServiceExtension = (OrderServiceExtension)ExtensionManager.getPlugin(OrderServiceExtension.class);
        column1.add((Component)this.chkRequiredCustomerData, "skip 1,wrap");
        if (orderServiceExtension != null) {
            // empty if block
        }
        column1.add((Component)this.chkShowInLoginScreen, "skip 1,wrap");
        column1.add((Component)this.chkConsolidateItemsInReceipt, "skip 1,wrap");
        column1.add((Component)this.chkEnableCourse, "skip 1,wrap");
        column1.add((Component)this.chkAllowSeatBasedOrder, "skip 1,wrap");
        column1.add((Component)this.chkHideItemWithEmptyInventory, "skip 1,wrap");
        column1.add((Component)this.chkHasForHereAndToGo, "skip 1,wrap");
        column1.add((Component)this.chkForHereTaxApplicable, "gapleft 20, skip 1, wrap");
        column1.add((Component)this.chkTogoTaxApplicable, "gapleft 20, skip 1, wrap");
        column1.add((Component)this.chkRetailOrder, "skip 1,wrap");
        column1.add((Component)this.chkPreAuthCreditCard, "skip 1,wrap");
        column1.add((Component)this.chkServiceChargeExempt, "skip 1,wrap");
        column1.add((Component)this.chkApplyCreditCardSurcharge, "skip 1,wrap");
        TitledBorder titledBorderTerminalTypes = new TitledBorder("Terminal types");
        JScrollPane terminalTypesScrollPanel = new JScrollPane(this.chkbTerminalTypeList);
        terminalTypesScrollPanel.setBorder(titledBorderTerminalTypes);
        column2.add((Component)terminalTypesScrollPanel, "w 300!,h 140!,skip 1, wrap,right");
        TitledBorder titledBorderOrderTypes = new TitledBorder("Departments");
        JScrollPane deptScrollPanel = new JScrollPane(this.chkbDeptList);
        deptScrollPanel.setBorder(titledBorderOrderTypes);
        column2.add((Component)deptScrollPanel, "w 300!,h 140!,skip 1, wrap ,right");
        TitledBorder titledBorderCategories = new TitledBorder("Categories");
        JScrollPane categoriesScrollPanel = new JScrollPane(this.chkbCategoryList);
        categoriesScrollPanel.setBorder(titledBorderCategories);
        column2.add((Component)categoriesScrollPanel, "w 300!,h 140!,skip 1, wrap,right");
        TitledBorder titledBorderCreditBookType = new TitledBorder("Credit Book Type");
        JScrollPane creditBookTypesScrollPane = new JScrollPane(this.chkCreditBookTypeList);
        creditBookTypesScrollPane.setBorder(titledBorderCreditBookType);
        column2.add((Component)creditBookTypesScrollPane, "w 300!,h 140!,skip 1, wrap,right");
        this.chkShowTableSelection.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                OrderTypeForm.this.chkAllowSeatBasedOrder.setEnabled(OrderTypeForm.this.chkShowTableSelection.isSelected());
                OrderTypeForm.this.chkShowFreeTextTableSelection.setEnabled(!OrderTypeForm.this.chkShowTableSelection.isSelected());
                if (!OrderTypeForm.this.chkShowTableSelection.isSelected()) {
                    OrderTypeForm.this.chkAllowSeatBasedOrder.setSelected(false);
                } else {
                    OrderTypeForm.this.chkShowFreeTextTableSelection.setSelected(false);
                }
            }
        });
        this.chkShowFreeTextTableSelection.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                OrderTypeForm.this.chkShowTableSelection.setEnabled(!OrderTypeForm.this.chkShowFreeTextTableSelection.isSelected());
                OrderTypeForm.this.chkPromt.setEnabled(OrderTypeForm.this.chkShowFreeTextTableSelection.isSelected());
                if (OrderTypeForm.this.chkShowFreeTextTableSelection.isSelected()) {
                    OrderTypeForm.this.chkShowTableSelection.setSelected(false);
                } else {
                    OrderTypeForm.this.chkPromt.setSelected(false);
                }
            }
        });
        generalPanel.add((Component)column1, "grow, wrap");
        generalPanel.add((Component)column2, "grow, wrap");
        JScrollPane mainScrollPanel = new JScrollPane(generalPanel, 20, 30);
        Dimension preferredSizeMain = PosUIManager.getSize(700, 450);
        mainScrollPanel.setPreferredSize(preferredSizeMain);
        this.add(mainScrollPanel);
        this.chkHasForHereAndToGo.addActionListener(e -> this.setForHereTogoTaxVisible(this.chkHasForHereAndToGo.isSelected()));
        this.chkRetailOrder.addActionListener(e -> this.setRetailSelectedAndEnabled(this.chkRetailOrder.isSelected()));
    }

    private void initData() {
        this.deptList = DepartmentDAO.getInstance().findAll();
        if (this.deptList == null) {
            this.deptList = new ArrayList<Department>();
        }
        this.chkbDeptList.setModel(this.deptList);
        List<TerminalType> terminalTypeList = TerminalTypeDAO.getInstance().findAll();
        if (terminalTypeList == null) {
            terminalTypeList = new ArrayList<TerminalType>();
        }
        this.chkbTerminalTypeList.setModel(terminalTypeList);
        List<MenuCategory> categoryList = MenuCategoryDAO.getInstance().findAll();
        if (categoryList == null) {
            categoryList = new ArrayList<MenuCategory>();
        }
        this.chkbCategoryList.setModel(categoryList);
        List<CreditBookType> creditBookTypes = CreditBookTypeDAO.getInstance().findAll();
        if (creditBookTypes == null) {
            creditBookTypes = new ArrayList<CreditBookType>();
        }
        this.chkCreditBookTypeList.setModel(creditBookTypes);
        ArrayList<TaxGroup> taxGroups = new ArrayList<TaxGroup>();
        taxGroups.add(null);
        taxGroups.addAll(TaxGroupDAO.getInstance().findAll());
    }

    @Override
    protected void updateView() {
        OrderType ordersType = (OrderType)this.getBean();
        if (ordersType == null) {
            this.tfName.setText("");
            this.chkEnabled.setSelected(false);
            this.chkAllowSeatBasedOrder.setEnabled(false);
            this.chkPromt.setEnabled(false);
            return;
        }
        this.tfName.setText(ordersType.getName());
        this.chkPromt.setEnabled(false);
        if (ordersType.getId() == null) {
            this.chkEnabled.setSelected(true);
            this.chkAllowSeatBasedOrder.setEnabled(false);
        } else {
            OrderTypeDAO.getInstance().initialize(ordersType);
            this.chkEnabled.setSelected(ordersType.isEnabled());
            this.chkAllowSeatBasedOrder.setEnabled(ordersType.isShowTableSelection());
            this.chkShowTableSelection.setSelected(ordersType.isShowTableSelection());
            this.chkShowFreeTextTableSelection.setSelected(Boolean.valueOf(ordersType.getProperty("tableSelection.freeTextInput")));
            this.chkPromt.setSelected(Boolean.valueOf(ordersType.getProperty("tableSelection.freeTextInput.prompt")));
            this.chkShowGuestSelection.setSelected(ordersType.isShowGuestSelection());
            this.chkShouldPrintToKitchen.setSelected(ordersType.isShouldPrintToKitchen());
            this.chkPrepaid.setSelected(ordersType.isPrepaid());
            this.chkCloseOnPaid.setSelected(ordersType.isCloseOnPaid());
            this.chkRequiredCustomerData.setSelected(ordersType.isRequiredCustomerData());
            this.chkRequiredDeliveryData.setSelected(ordersType.isDelivery());
            this.chkAssignDriver.setSelected(ordersType.isAssignDriver());
            this.chkShowInLoginScreen.setSelected(ordersType.isShowInLoginScreen());
            this.chkConsolidateItemsInReceipt.setSelected(ordersType.isConsolidateItemsInReceipt());
            this.chkEnableCourse.setSelected(ordersType.isEnableCourse());
            this.chkAllowSeatBasedOrder.setSelected(ordersType.isAllowSeatBasedOrder());
            this.chkHideItemWithEmptyInventory.setSelected(ordersType.isHideItemWithEmptyInventory());
            this.chkHasForHereAndToGo.setSelected(ordersType.isHasForHereAndToGo());
            this.chkBarTab.setSelected(ordersType.isBarTab());
            this.cbSalesArea.setSelectedItem(ordersType.getSalesArea());
            this.chkRetailOrder.setSelected(ordersType.isRetailOrder());
            this.chkPreAuthCreditCard.setSelected(ordersType.isPreAuthCreditCard());
            this.chkServiceChargeExempt.setSelected(ordersType.isServiceChargeApplicable() == false);
            this.chkApplyCreditCardSurcharge.setSelected(ordersType.isApplyCreditCardSurcharge());
            List<Department> departments = DepartmentDAO.getInstance().findByOrderType(ordersType);
            if (departments != null) {
                this.selectedDeptList = new ArrayList<Department>(departments);
                this.chkbDeptList.selectItems(this.selectedDeptList);
            }
            ArrayList<TerminalType> selectedTerminalTypes = new ArrayList<TerminalType>(ordersType.getTerminalTypes());
            this.chkbTerminalTypeList.selectItems(selectedTerminalTypes);
            ArrayList<MenuCategory> selectedCategories = new ArrayList<MenuCategory>(ordersType.getCategories());
            this.chkbCategoryList.selectItems(selectedCategories);
            List<CreditBookType> creditBookTypes = ordersType.getCreditBookTypes();
            this.chkCreditBookTypeList.selectItems(creditBookTypes);
            this.setForHereTogoTaxVisible(this.chkHasForHereAndToGo.isSelected());
            boolean selected = this.chkRetailOrder.isSelected();
            if (selected) {
                this.setRetailSelectedAndEnabled(selected);
            } else {
                this.updateRetailSelectedView(selected);
            }
            this.chkForHereTaxApplicable.setSelected(Boolean.valueOf(ordersType.getProperty("for_here_tax_applicable")));
            this.chkTogoTaxApplicable.setSelected(Boolean.valueOf(ordersType.getProperty("togo_tax_applicable")));
        }
    }

    @Override
    protected boolean updateModel() {
        OrderType orderType = (OrderType)this.getBean();
        if (orderType == null) {
            return false;
        }
        String orderTypeName = this.tfName.getText();
        if (POSUtil.isBlankOrNull(orderTypeName)) {
            MessageDialog.showError(Messages.getString("MenuCategoryForm.26"));
            return false;
        }
        SalesArea salesArea = (SalesArea)this.cbSalesArea.getSelectedItem();
        if (salesArea != null) {
            orderType.setSalesAreaId(salesArea.getId());
        } else {
            orderType.setSalesAreaId(null);
        }
        orderType.setName(orderTypeName);
        orderType.setEnabled(this.chkEnabled.isSelected());
        orderType.setImageData(null);
        if (!this.chkBarTab.isSelected()) {
            orderType.setShowTableSelection(this.chkShowTableSelection.isSelected());
            if (this.chkShowFreeTextTableSelection.isSelected()) {
                orderType.addProperty("tableSelection.freeTextInput", String.valueOf(true));
            } else {
                orderType.addProperty("tableSelection.freeTextInput", String.valueOf(false));
            }
            if (this.chkPromt.isSelected()) {
                orderType.addProperty("tableSelection.freeTextInput.prompt", String.valueOf(true));
            } else {
                orderType.addProperty("tableSelection.freeTextInput.prompt", String.valueOf(false));
            }
            orderType.setShowGuestSelection(this.chkShowGuestSelection.isSelected());
            orderType.setShouldPrintToKitchen(this.chkShouldPrintToKitchen.isSelected());
            orderType.setPrepaid(this.chkPrepaid.isSelected());
            orderType.setCloseOnPaid(this.chkCloseOnPaid.isSelected());
            orderType.setRequiredCustomerData(this.chkRequiredCustomerData.isSelected());
            orderType.setDelivery(this.chkRequiredDeliveryData.isSelected());
            orderType.setAssignDriver(this.chkAssignDriver.isSelected());
            orderType.setShowInLoginScreen(this.chkShowInLoginScreen.isSelected());
            orderType.setConsolidateItemsInReceipt(this.chkConsolidateItemsInReceipt.isSelected());
            orderType.setEnableCourse(this.chkEnableCourse.isSelected());
            orderType.setAllowSeatBasedOrder(this.chkAllowSeatBasedOrder.isSelected());
            orderType.setHideItemWithEmptyInventory(this.chkHideItemWithEmptyInventory.isSelected());
            orderType.setHasForHereAndToGo(this.chkHasForHereAndToGo.isSelected());
            orderType.setRetailOrder(this.chkRetailOrder.isSelected());
            orderType.setPreAuthCreditCard(this.chkPreAuthCreditCard.isSelected());
            orderType.setServiceChargeApplicable(!this.chkServiceChargeExempt.isSelected());
            orderType.setApplyCreditCardSurcharge(this.chkApplyCreditCardSurcharge.isSelected());
        }
        orderType.setBarTab(this.chkBarTab.isSelected());
        orderType.setForHereTaxGroup(null);
        orderType.setToGoTaxGroup(null);
        if (this.chkHasForHereAndToGo.isSelected()) {
            orderType.addProperty("for_here_tax_applicable", String.valueOf(this.chkForHereTaxApplicable.isSelected()));
            orderType.addProperty("togo_tax_applicable", String.valueOf(this.chkTogoTaxApplicable.isSelected()));
        } else {
            orderType.addProperty("for_here_tax_applicable", String.valueOf(true));
            orderType.addProperty("togo_tax_applicable", String.valueOf(true));
        }
        return true;
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            OrderType ordersType = (OrderType)this.getBean();
            ordersType.setDepartments(POSUtil.copySelectedValues(ordersType.getDepartments(), this.chkbDeptList.getCheckedValuesAsSet()));
            ordersType.setTerminalTypes(POSUtil.copySelectedValues(ordersType.getTerminalTypes(), this.chkbTerminalTypeList.getCheckedValuesAsSet()));
            ordersType.setCategories(POSUtil.copySelectedValues(ordersType.getCategories(), this.chkbCategoryList.getCheckedValuesAsSet()));
            ordersType.setCreditBookTypes(POSUtil.copySelectedValuesWithoutDuplicate(ordersType.getCreditBookTypes(), this.chkCreditBookTypeList.getCheckedValues()));
            OrderTypeDAO.getInstance().saveOrUpdate(ordersType);
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("TerminalConfigurationView.40"));
            return true;
        }
        catch (Exception x) {
            MessageDialog.showError(x);
            return false;
        }
    }

    private void setForHereTogoTaxVisible(boolean visible) {
        this.chkForHereTaxApplicable.setVisible(visible);
        this.chkTogoTaxApplicable.setVisible(visible);
    }

    private void updateRetailSelectedView(boolean enabled) {
        this.chkShowTableSelection.setSelected(this.chkShowTableSelection.isSelected());
        this.chkShowGuestSelection.setSelected(this.chkShowGuestSelection.isSelected());
        this.chkRequiredCustomerData.setSelected(this.chkRequiredCustomerData.isSelected());
        this.chkPrepaid.setSelected(this.chkPrepaid.isSelected());
        this.chkAllowSeatBasedOrder.setSelected(this.chkAllowSeatBasedOrder.isSelected());
        this.chkEnableCourse.setSelected(this.chkEnableCourse.isSelected());
    }

    private void setRetailSelectedAndEnabled(boolean enabled) {
        this.chkShowTableSelection.setSelected(false);
        this.chkShowGuestSelection.setSelected(false);
        this.chkRequiredCustomerData.setSelected(false);
        this.chkPrepaid.setSelected(false);
        this.chkAllowSeatBasedOrder.setSelected(false);
        this.chkEnableCourse.setSelected(false);
        this.chkShowTableSelection.setEnabled(!enabled);
        this.chkShowGuestSelection.setEnabled(!enabled);
        this.chkRequiredCustomerData.setEnabled(!enabled);
        this.chkPrepaid.setEnabled(!enabled);
        this.chkAllowSeatBasedOrder.setEnabled(this.chkShowTableSelection.isSelected());
        this.chkEnableCourse.setEnabled(!enabled);
    }
}

