/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.modifierdesigner.ModifierPageDesigner;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.InventoryPlugin;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.MenuItemShift;
import com.floreantpos.model.MenuItemSize;
import com.floreantpos.model.PizzaCrust;
import com.floreantpos.model.PizzaPrice;
import com.floreantpos.model.PrinterGroup;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.MenuItemSizeDAO;
import com.floreantpos.model.dao.PizzaCrustDAO;
import com.floreantpos.model.dao.PrinterGroupDAO;
import com.floreantpos.model.dao.TaxGroupDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.FixedLengthDocument;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.IUpdatebleView;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.MessageDialog;
import com.floreantpos.swing.OverflowCombobox;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.ConfirmDeleteDialog;
import com.floreantpos.ui.dialog.ImageGalleryDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.MenuGroupForm;
import com.floreantpos.ui.model.MenuItemModifierSpecForm;
import com.floreantpos.ui.model.PizzaItemPriceDialog;
import com.floreantpos.ui.model.TaxForm;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.PosGuiUtil;
import com.floreantpos.util.ShiftUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;
import org.hibernate.Hibernate;
import org.hibernate.Session;

public class PizzaItemForm
extends BeanEditor<MenuItem>
implements ActionListener,
ChangeListener {
    private JTabbedPane tabbedPane;
    private JTable priceTable;
    private FixedLengthTextField tfName;
    private FixedLengthTextField tfTranslatedName;
    private DoubleTextField tfPrice;
    private FixedLengthTextField tfBarcode;
    private JCheckBox chkVisible;
    private JCheckBox cbDisableStockCount;
    private JButton btnDeleteModifierGroup;
    private JButton btnEditModifierGroup;
    private JButton btnNewModifierGroup;
    private IntegerTextField tfDefaultSellPortion;
    private OverflowCombobox cbPrinterGroup;
    private OverflowCombobox cbTaxGroup;
    private JTextArea tfDescription;
    private JTable modifierSpecTable;
    private List<MenuItemModifierSpec> menuItemModifierGroups;
    private MenuItemMGListModel menuItemMGListModel;
    private JLabel lblImagePreview;
    private JButton btnClearImage;
    private JCheckBox cbShowTextWithImage;
    private JLabel lblKitchenPrinter;
    private JButton btnButtonColor;
    private JButton btnTextColor;
    private IntegerTextField tfSortOrder;
    private BeanTableModel<PizzaPrice> priceTableModel;
    private final MenuItem menuItem;
    private ModifierPageDesigner modifierDesigner;
    private JPanel tabModifier;
    private JScrollPane jScrollPane1;
    private ImageResource imageResource;
    private JComboBox<MenuGroup> cbGroup;

    public PizzaItemForm() throws Exception {
        this(new MenuItem());
    }

    public PizzaItemForm(MenuItem menuItem) throws Exception {
        this.menuItem = menuItem;
        menuItem.setPizzaType(true);
        this.initComponents();
        this.initData();
    }

    private void initData() {
        List<MenuGroup> menuGroups = MenuGroupDAO.getInstance().findAll();
        ComboBoxModel menuGroupModel = new ComboBoxModel();
        menuGroupModel.addElement((Object)null);
        for (MenuGroup menuGroup : menuGroups) {
            menuGroupModel.addElement(menuGroup);
        }
        this.cbGroup.setModel(menuGroupModel);
        List<TaxGroup> taxGroups = TaxGroupDAO.getInstance().findAll();
        ComboBoxModel taxGroupModel = new ComboBoxModel();
        taxGroupModel.addElement((Object)null);
        for (TaxGroup taxGroup : taxGroups) {
            taxGroupModel.addElement(taxGroup);
        }
        this.cbTaxGroup.setModel(taxGroupModel);
        this.menuItemModifierGroups = this.menuItem.getMenuItemModiferSpecs();
        this.priceTableModel = new BeanTableModel<PizzaPrice>(PizzaPrice.class){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return columnIndex == 2;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                if (columnIndex == 2) {
                    return Double.class;
                }
                return super.getColumnClass(columnIndex);
            }

            @Override
            public void setValueAt(Object value, int rowIndex, int columnIndex) {
                PizzaPrice price = (PizzaPrice)PizzaItemForm.this.priceTableModel.getRow(rowIndex);
                if (columnIndex == 2) {
                    String priceString = (String)value;
                    if (priceString.isEmpty()) {
                        return;
                    }
                    double priceValue = Double.parseDouble(priceString);
                    price.setPrice(priceValue);
                } else {
                    super.setValueAt(value, rowIndex, columnIndex);
                }
            }
        };
        this.priceTableModel.addColumn(Messages.getString("PizzaItemForm.0"), "size");
        this.priceTableModel.addColumn(Messages.getString("PizzaItemForm.2"), "crust");
        this.priceTableModel.addColumn(Messages.getString("PizzaItemForm.4"), "price");
        List<PizzaPrice> pizzaPriceList = this.menuItem.getPizzaPriceList();
        if (pizzaPriceList == null || pizzaPriceList.isEmpty()) {
            this.priceTableModel.addRows(this.generatedPossiblePizzaItemSizeAndPriceList());
        } else {
            this.priceTableModel.addRows(pizzaPriceList);
        }
        this.priceTable.setModel(this.priceTableModel);
        this.setBean(this.menuItem);
        this.priceTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 2) {
                    PizzaItemForm.this.editEvent();
                }
            }
        });
        DoubleTextField tfPrice = new DoubleTextField();
        tfPrice.setAllowNegativeValue(true);
        tfPrice.setHorizontalAlignment(4);
        DefaultCellEditor editorPrice = new DefaultCellEditor(tfPrice);
        editorPrice.setClickCountToStart(1);
        this.priceTable.setDefaultEditor(this.priceTable.getColumnClass(2), editorPrice);
    }

    protected void doSelectImageFile() {
        ImageGalleryDialog dialog = ImageGalleryDialog.getInstance();
        dialog.setSelectBtnVisible(true);
        dialog.setTitle(Messages.getString("PizzaItemForm.6"));
        dialog.setSize(PosUIManager.getSize(650, 600));
        dialog.setResizable(false);
        dialog.open();
        if (dialog.isCanceled()) {
            return;
        }
        this.imageResource = dialog.getImageResource();
        if (this.imageResource != null) {
            this.lblImagePreview.setIcon(this.imageResource.getAsIcon());
        }
    }

    protected void doClearImage() {
        this.lblImagePreview.setIcon(null);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        JLabel lblButtonColor = new JLabel(Messages.getString("MenuItemForm.19"));
        this.tabbedPane = new JTabbedPane();
        JPanel tabGeneral = new JPanel();
        JLabel lblName = new JLabel();
        lblName.setHorizontalAlignment(11);
        this.tfName = new FixedLengthTextField(20);
        this.tfDescription = new JTextArea(new FixedLengthDocument(120));
        JLabel lblTaxGroup = new JLabel();
        lblTaxGroup.setHorizontalAlignment(11);
        this.cbPrinterGroup = new OverflowCombobox();
        this.cbTaxGroup = new OverflowCombobox();
        JButton btnNewTax = new JButton();
        this.tabModifier = new JPanel();
        this.btnNewModifierGroup = new JButton();
        this.btnDeleteModifierGroup = new JButton();
        this.btnEditModifierGroup = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.modifierSpecTable = new JTable();
        JPanel tabPrice = new JPanel();
        JPanel tabButtonStyle = new JPanel();
        JButton btnDeleteShift = new JButton();
        JButton btnAddShift = new JButton();
        JButton btnNewPrice = new JButton();
        JButton btnUpdatePrice = new JButton();
        JButton btnDeletePrice = new JButton();
        JButton btnDeleteAll = new JButton();
        JButton btnDefaultValue = new JButton();
        JButton btnAutoGenerate = new JButton();
        JScrollPane priceTabScrollPane = new JScrollPane();
        this.priceTable = new JTable(){

            @Override
            public void changeSelection(int row, int column, boolean toggle, boolean extend) {
                super.changeSelection(row, column, toggle, extend);
                PizzaItemForm.this.priceTable.editCellAt(row, column);
                PizzaItemForm.this.priceTable.transferFocus();
                DefaultCellEditor editor = (DefaultCellEditor)PizzaItemForm.this.priceTable.getCellEditor(row, column);
                if (column == 2) {
                    DoubleTextField textField = (DoubleTextField)editor.getComponent();
                    textField.requestFocus();
                    textField.selectAll();
                }
            }
        };
        this.priceTable.setRowHeight(PosUIManager.getSize(22));
        this.priceTable.setCellSelectionEnabled(true);
        this.priceTable.setSelectionMode(0);
        this.priceTable.setSurrendersFocusOnKeystroke(true);
        ArrayList<PrinterGroup> printerList = new ArrayList<PrinterGroup>();
        printerList.add(null);
        List<PrinterGroup> printerGroupList = PrinterGroupDAO.getInstance().findAll();
        if (printerGroupList != null && printerGroupList.size() > 0) {
            printerList.addAll(printerGroupList);
        }
        ComboBoxModel defaultComboxModel = new ComboBoxModel(printerList);
        this.cbPrinterGroup.setModel(defaultComboxModel);
        this.cbPrinterGroup.setMaximumSize(PosUIManager.getSize(226, 40));
        this.tfDefaultSellPortion = new IntegerTextField(10);
        this.tfTranslatedName = new FixedLengthTextField(20);
        this.tfTranslatedName.setLength(120);
        this.tfPrice = new DoubleTextField();
        this.lblKitchenPrinter = new JLabel(Messages.getString("MenuItemForm.27"));
        lblName.setText(Messages.getString("NAME"));
        this.tfName.setLength(120);
        JLabel lblTranslatedName = new JLabel(Messages.getString("MenuItemForm.lblTranslatedName.text"));
        this.tfSortOrder = new IntegerTextField(20);
        this.tfSortOrder.setText("");
        this.cbTaxGroup.setPreferredSize(new Dimension(198, 0));
        this.btnButtonColor = new JButton();
        this.btnButtonColor.setPreferredSize(new Dimension(228, 40));
        JLabel lblTextColor = new JLabel(Messages.getString("MenuItemForm.lblTextColor.text"));
        this.btnTextColor = new JButton(Messages.getString("MenuItemForm.SAMPLE_TEXT"));
        this.cbShowTextWithImage = new JCheckBox(Messages.getString("MenuItemForm.40"));
        this.cbShowTextWithImage.setActionCommand(Messages.getString("MenuItemForm.41"));
        lblTaxGroup.setText(Messages.getString("PizzaItemForm.1"));
        btnNewTax.setText("...");
        btnNewTax.setText("...");
        btnNewTax.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PizzaItemForm.this.btnNewTaxdoCreateNewTax(evt);
            }
        });
        this.tabbedPane.addTab(POSConstants.GENERAL, tabGeneral);
        this.tabbedPane.setPreferredSize(new Dimension(750, 470));
        this.btnNewModifierGroup.setText(POSConstants.ADD);
        this.btnNewModifierGroup.setActionCommand("AddModifierGroup");
        this.btnDeleteModifierGroup.setText(POSConstants.DELETE);
        this.btnDeleteModifierGroup.setActionCommand("DeleteModifierGroup");
        this.btnEditModifierGroup.setText(POSConstants.EDIT);
        this.btnEditModifierGroup.setActionCommand("EditModifierGroup");
        this.menuItemMGListModel = new MenuItemMGListModel();
        this.modifierSpecTable.setModel(this.menuItemMGListModel);
        this.modifierSpecTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int index = PizzaItemForm.this.modifierSpecTable.getSelectedRow();
                if (index < 0) {
                    return;
                }
                MenuItemModifierSpec menuItemModifierSpec = PizzaItemForm.this.menuItemMGListModel.get(index);
                PizzaItemForm.this.modifierDesigner.setMenuItemModifierSpec(menuItemModifierSpec);
            }
        });
        this.modifierSpecTable.setAutoResizeMode(0);
        this.modifierSpecTable.setModel(this.menuItemMGListModel);
        this.modifierSpecTable.setRowHeight(PosUIManager.getSize(30));
        this.btnNewModifierGroup.addActionListener(this);
        this.btnEditModifierGroup.addActionListener(this);
        this.btnDeleteModifierGroup.addActionListener(this);
        btnAddShift.addActionListener(this);
        btnDeleteShift.addActionListener(this);
        tabGeneral.setLayout((LayoutManager)new MigLayout("insets 20,center,hidemode 3", "[][]20px[][]", "[][][][][][][][][][][][][]"));
        tabGeneral.setBorder(BorderFactory.createTitledBorder("-"));
        tabGeneral.add((Component)lblName, "cell 0 1 ,right");
        tabGeneral.add((Component)this.tfName, "cell 1 1,grow");
        tabGeneral.add((Component)lblTranslatedName, "cell 0 2,right");
        tabGeneral.add((Component)this.tfTranslatedName, "cell 1 2,grow");
        tabGeneral.add((Component)new JLabel(Messages.getString("PizzaItemForm.5") + CurrencyUtil.getCurrencySymbol()), "cell 0 3,right");
        tabGeneral.add((Component)this.tfPrice, "cell 1 3,grow");
        JLabel lgroup = new JLabel();
        lgroup.setHorizontalAlignment(11);
        lgroup.setText(Messages.getString("LABEL_GROUP"));
        tabGeneral.add((Component)lgroup, "cell 0 4,alignx right");
        this.cbGroup = new JComboBox();
        this.cbGroup.setPreferredSize(new Dimension(198, 0));
        tabGeneral.add(this.cbGroup, "flowx,cell 1 4");
        JButton btnNewGroup = new JButton();
        btnNewGroup.setText("...");
        btnNewGroup.addActionListener(event -> this.doCreateNewGroup(event));
        tabGeneral.add((Component)btnNewGroup, "cell 1 4");
        JLabel lblBarcode = new JLabel(Messages.getString("MenuItemForm.lblBarcode.text"));
        tabGeneral.add((Component)lblBarcode, "cell 0 5,alignx right");
        this.tfBarcode = new FixedLengthTextField(20);
        tabGeneral.add((Component)this.tfBarcode, "cell 1 5,grow");
        tabGeneral.add((Component)new JLabel(Messages.getString("PizzaItemForm.11")), "cell 0 7");
        tabGeneral.add((Component)this.tfDefaultSellPortion, "cell 1 7,grow");
        this.chkVisible = new JCheckBox();
        this.chkVisible.setText(POSConstants.VISIBLE);
        this.chkVisible.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chkVisible.setMargin(new Insets(0, 0, 0, 0));
        tabGeneral.add((Component)this.chkVisible, "cell 1 8");
        this.cbDisableStockCount = new JCheckBox(Messages.getString("MenuItemForm.18"));
        tabGeneral.add((Component)this.cbDisableStockCount, "cell 1 9");
        tabGeneral.add((Component)this.lblKitchenPrinter, "cell 2 1,right");
        tabGeneral.add((Component)this.cbPrinterGroup, "cell 3 1");
        tabGeneral.add((Component)lblTaxGroup, "cell 2 2,right");
        tabGeneral.add((Component)this.cbTaxGroup, "cell 3 2");
        tabGeneral.add((Component)btnNewTax, "cell 3 2,grow");
        tabGeneral.add((Component)new JLabel(Messages.getString("MenuItemForm.29")), "cell 2 3,alignx right");
        JScrollPane scrlDescription = new JScrollPane(this.tfDescription, 20, 30);
        scrlDescription.setPreferredSize(new Dimension(228, 70));
        this.tfDescription.setLineWrap(true);
        tabGeneral.add((Component)scrlDescription, "cell 3 3 3 3, grow");
        this.add(this.tabbedPane);
        this.addRecepieExtension();
        this.jScrollPane1.setViewportView(this.modifierSpecTable);
        this.resizeColumnWidth(this.modifierSpecTable);
        this.tabModifier.setLayout(new BorderLayout(10, 10));
        JPanel newpanel1 = new JPanel(new BorderLayout());
        newpanel1.setPreferredSize(PosUIManager.getSize(350, 0));
        TitledBorder titledBorder = BorderFactory.createTitledBorder(Messages.getString("PizzaItemForm.13"));
        titledBorder.setTitleJustification(2);
        CompoundBorder titel = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 10, 10, 0), titledBorder);
        newpanel1.setBorder(titel);
        newpanel1.add(this.jScrollPane1);
        JPanel btmpanel = new JPanel();
        newpanel1.add((Component)btmpanel, "South");
        btmpanel.add(this.btnNewModifierGroup);
        btmpanel.add(this.btnEditModifierGroup);
        btmpanel.add(this.btnDeleteModifierGroup);
        this.tabModifier.add((Component)newpanel1, "West");
        this.modifierDesigner = new ModifierPageDesigner(this.menuItem);
        this.tabModifier.add(this.modifierDesigner);
        this.tabbedPane.addTab(POSConstants.MODIFIER_GROUPS, this.tabModifier);
        this.modifierSpecTable.getColumnModel().getColumn(0).setPreferredWidth(150);
        this.modifierSpecTable.getColumnModel().getColumn(1).setPreferredWidth(100);
        this.modifierSpecTable.getColumnModel().getColumn(2).setPreferredWidth(100);
        this.modifierSpecTable.setAutoResizeMode(3);
        btnDeleteShift.setText(POSConstants.DELETE_SHIFT);
        btnAddShift.setText(POSConstants.ADD_SHIFT);
        btnNewPrice.setText(Messages.getString("MenuItemForm.9"));
        btnNewPrice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PizzaItemForm.this.addNewPrice();
            }
        });
        btnUpdatePrice.setText(Messages.getString("MenuItemForm.13"));
        btnUpdatePrice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PizzaItemForm.this.updatePrice();
            }
        });
        btnDeletePrice.setText(Messages.getString("MenuItemForm.14"));
        btnDeletePrice.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PizzaItemForm.this.deletePrice();
            }
        });
        btnAutoGenerate.setText("Auto Generate");
        btnAutoGenerate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PizzaItemForm.this.autoGeneratePizzaItemSizeAndPrice();
            }
        });
        btnDeleteAll.setText(Messages.getString("MenuItemForm.15"));
        btnDeleteAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PizzaItemForm.this.deleteAll();
            }
        });
        btnDefaultValue.setText(Messages.getString("MenuItemForm.7"));
        priceTabScrollPane.setViewportView(this.priceTable);
        tabPrice.setLayout(new BorderLayout());
        tabPrice.add((Component)priceTabScrollPane, "Center");
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(btnNewPrice);
        buttonPanel.add(btnUpdatePrice);
        buttonPanel.add(btnDeletePrice);
        buttonPanel.add(btnAutoGenerate);
        tabPrice.add((Component)buttonPanel, "South");
        tabGeneral.add((Component)tabPrice, "cell 0 10,grow,span");
        this.tabbedPane.addChangeListener(this);
        tabButtonStyle.setLayout((LayoutManager)new MigLayout("insets 10", "[][]100[][][][]", "[][][center][][][]"));
        JLabel lblImage = new JLabel(Messages.getString("MenuItemForm.28"));
        lblImage.setHorizontalAlignment(11);
        tabButtonStyle.add((Component)lblImage, "cell 0 0,right");
        this.lblImagePreview = new JLabel("");
        this.lblImagePreview.setHorizontalAlignment(0);
        this.lblImagePreview.setBorder(new EtchedBorder(1, null, null));
        this.lblImagePreview.setPreferredSize(new Dimension(100, 100));
        tabButtonStyle.add((Component)this.lblImagePreview, "cell 1 0");
        JButton btnSelectImage = new JButton("...");
        this.btnClearImage = new JButton(Messages.getString("MenuItemForm.34"));
        tabButtonStyle.add((Component)this.btnClearImage, "cell  1 0");
        tabButtonStyle.add((Component)btnSelectImage, "cell 1 0");
        tabButtonStyle.add((Component)lblButtonColor, "cell 0 2,right");
        tabButtonStyle.add((Component)this.btnButtonColor, "cell 1 2,grow");
        tabButtonStyle.add((Component)lblTextColor, "cell 0 3,right");
        tabButtonStyle.add((Component)this.btnTextColor, "cell 1 3");
        tabButtonStyle.add((Component)this.cbShowTextWithImage, "cell 1 4");
        this.btnTextColor.setPreferredSize(new Dimension(228, 50));
        btnSelectImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PizzaItemForm.this.doSelectImageFile();
            }
        });
        this.btnClearImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PizzaItemForm.this.doClearImage();
            }
        });
        this.btnButtonColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color color = JColorChooser.showDialog(POSUtil.getBackOfficeWindow(), Messages.getString("MenuItemForm.42"), PizzaItemForm.this.btnButtonColor.getBackground());
                PizzaItemForm.this.btnButtonColor.setBackground(color);
                PizzaItemForm.this.btnTextColor.setBackground(color);
            }
        });
        this.btnTextColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color color = JColorChooser.showDialog(POSUtil.getBackOfficeWindow(), Messages.getString("MenuItemForm.43"), PizzaItemForm.this.btnTextColor.getForeground());
                PizzaItemForm.this.btnTextColor.setForeground(color);
            }
        });
        this.tabbedPane.addTab(Messages.getString("MenuItemForm.26"), tabButtonStyle);
    }

    private void autoGeneratePizzaItemSizeAndPrice() {
        List<PizzaPrice> pizzaPriceList = this.generatedPossiblePizzaItemSizeAndPriceList();
        this.filterDuplicateItemSizesAndPrices(pizzaPriceList);
        this.priceTableModel.addRows(pizzaPriceList);
        this.priceTable.repaint();
    }

    public void resizeColumnWidth(JTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        for (int column = 0; column < table.getColumnCount(); ++column) {
            columnModel.getColumn(column).setPreferredWidth((Integer)this.getColumnWidth().get(column));
        }
    }

    private List getColumnWidth() {
        ArrayList<Integer> columnWidth = new ArrayList<Integer>();
        columnWidth.add(100);
        columnWidth.add(50);
        columnWidth.add(50);
        return columnWidth;
    }

    public void addRecepieExtension() {
        InventoryPlugin plugin = (InventoryPlugin)ExtensionManager.getPlugin(InventoryPlugin.class);
        if (plugin == null) {
            return;
        }
        plugin.addRecepieView(this.tabbedPane);
    }

    private void btnNewTaxdoCreateNewTax(ActionEvent evt) {
        TaxForm editor = new TaxForm();
        BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
        dialog.open();
        if (dialog.isCanceled()) {
            return;
        }
        ComboBoxModel model = (ComboBoxModel)this.cbTaxGroup.getModel();
        model.setDataList(TaxGroupDAO.getInstance().findAll());
    }

    private void doCreateNewGroup(ActionEvent evt) {
        MenuGroupForm editor = new MenuGroupForm();
        BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
        dialog.open();
        if (!dialog.isCanceled()) {
            MenuGroup menuGroup = (MenuGroup)editor.getBean();
            ComboBoxModel model = (ComboBoxModel)this.cbGroup.getModel();
            model.addElement(menuGroup);
            model.setSelectedItem(menuGroup);
        }
    }

    private void addMenuItemModifierGroup() {
        try {
            MenuItemModifierSpecForm form = new MenuItemModifierSpecForm(new MenuItemModifierSpec(), this.menuItem, false);
            BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)form);
            dialog.getButtonPanel().add((Component)form.getAutoBuildButton(), 0);
            dialog.openWithScale(500, 500);
            if (dialog.isCanceled()) {
                return;
            }
            this.menuItemMGListModel.add(form.getBean());
            this.modifierSpecTable.getSelectionModel().setSelectionInterval(this.menuItemMGListModel.getRowCount() - 1, this.menuItemMGListModel.getRowCount() - 1);
            if (form.isAutoBuildSelected()) {
                this.modifierDesigner.doGenenateMenuItemModifierPageItems();
            }
        }
        catch (Exception x) {
            MessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void editMenuItemModifierGroup() {
        try {
            int index = this.modifierSpecTable.getSelectedRow();
            if (index < 0) {
                return;
            }
            MenuItemModifierSpec menuItemModifierGroup = this.menuItemMGListModel.get(index);
            MenuItemModifierSpecForm form = new MenuItemModifierSpecForm(menuItemModifierGroup, this.menuItem, true);
            BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)form);
            dialog.openWithScale(500, 500);
            if (!dialog.isCanceled()) {
                this.menuItemMGListModel.fireTableRowsUpdated(index, index);
            }
        }
        catch (Exception x) {
            MessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void deleteMenuItemModifierGroup() {
        try {
            int index = this.modifierSpecTable.getSelectedRow();
            if (index < 0) {
                return;
            }
            if (ConfirmDeleteDialog.showMessage(POSUtil.getBackOfficeWindow(), POSConstants.CONFIRM_DELETE, POSConstants.CONFIRM) == 0) {
                this.menuItemMGListModel.remove(index);
                if (this.menuItemMGListModel.getRowCount() > 0) {
                    this.modifierSpecTable.getSelectionModel().setSelectionInterval(this.menuItemMGListModel.getRowCount() - 1, this.menuItemMGListModel.getRowCount() - 1);
                } else {
                    this.modifierDesigner.reset();
                }
            }
        }
        catch (Exception x) {
            MessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            MenuItem menuItem = (MenuItem)this.getBean();
            MenuItemDAO menuItemDAO = new MenuItemDAO();
            menuItemDAO.saveOrUpdate(menuItem);
        }
        catch (Exception e) {
            MessageDialog.showError(POSConstants.ERROR_MESSAGE, e);
            return false;
        }
        return true;
    }

    @Override
    protected void updateView() {
        Color buttonColor;
        MenuItem menuItem = (MenuItem)this.getBean();
        if (menuItem.getId() != null && !Hibernate.isInitialized(menuItem.getMenuItemModiferSpecs())) {
            MenuItemDAO dao = new MenuItemDAO();
            Session session = dao.getSession();
            menuItem = (MenuItem)session.merge((Object)menuItem);
            Hibernate.initialize(menuItem.getMenuItemModiferSpecs());
            session.close();
        }
        this.tfName.setText(menuItem.getName());
        this.tfDescription.setText(menuItem.getDescription());
        this.tfTranslatedName.setText(menuItem.getTranslatedName());
        this.tfPrice.setText(String.valueOf(menuItem.getPrice()));
        this.tfBarcode.setText(menuItem.getBarcode());
        this.chkVisible.setSelected(menuItem.isVisible());
        this.cbShowTextWithImage.setSelected(menuItem.isShowImageOnly());
        this.cbDisableStockCount.setSelected(menuItem.isDisableWhenStockAmountIsZero());
        ImageIcon menuItemImage = menuItem.getImage();
        if (menuItemImage != null) {
            this.lblImagePreview.setIcon(menuItemImage);
        }
        if (menuItem.getId() == null) {
            this.tfDefaultSellPortion.setText(String.valueOf(100));
        } else {
            this.tfDefaultSellPortion.setText(String.valueOf(menuItem.getDefaultSellPortion()));
        }
        PosGuiUtil.selectComboItemById(this.cbGroup, menuItem.getMenuGroupId());
        this.cbTaxGroup.setSelectedItem(menuItem.getTaxGroup());
        this.cbPrinterGroup.setSelectedItem(menuItem.getPrinterGroup());
        if (menuItem.getSortOrder() != null) {
            this.tfSortOrder.setText(menuItem.getSortOrder().toString());
        }
        if ((buttonColor = menuItem.getButtonColor()) != null) {
            this.btnButtonColor.setBackground(buttonColor);
            this.btnTextColor.setBackground(buttonColor);
        }
        if (menuItem.getTextColor() != null) {
            this.btnTextColor.setForeground(menuItem.getTextColor());
        }
    }

    @Override
    protected boolean updateModel() {
        String itemName = this.tfName.getText();
        if (POSUtil.isBlankOrNull(itemName)) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.NAME_REQUIRED);
            return false;
        }
        double price = this.tfPrice.getDouble();
        if (price < 0.0) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("PizzaItemForm.7"));
            return false;
        }
        MenuItem menuItem = (MenuItem)this.getBean();
        menuItem.setName(itemName);
        menuItem.setDescription(this.tfDescription.getText());
        menuItem.setBarcode(this.tfBarcode.getText());
        menuItem.setMenuGroup((MenuGroup)this.cbGroup.getSelectedItem());
        menuItem.setTaxGroup((TaxGroup)this.cbTaxGroup.getSelectedItem());
        menuItem.setVisible(this.chkVisible.isSelected());
        menuItem.setShowImageOnly(this.cbShowTextWithImage.isSelected());
        menuItem.setDisableWhenStockAmountIsZero(this.cbDisableStockCount.isSelected());
        menuItem.setDefaultSellPortion(this.tfDefaultSellPortion.getInteger());
        menuItem.setTranslatedName(this.tfTranslatedName.getText());
        menuItem.setSortOrder(this.tfSortOrder.getInteger());
        menuItem.setPrice(price);
        menuItem.setButtonColorCode(this.btnButtonColor.getBackground().getRGB());
        menuItem.setTextColorCode(this.btnTextColor.getForeground().getRGB());
        menuItem.setMenuItemModiferSpecs(this.menuItemModifierGroups);
        menuItem.setHasModifiers(this.menuItemModifierGroups != null && this.menuItemModifierGroups.size() > 0);
        menuItem.setHasMandatoryModifiers(false);
        if (menuItem.hasModifiers()) {
            for (MenuItemModifierSpec menuItemModifierSpec : this.menuItemModifierGroups) {
                if (menuItemModifierSpec.getMinQuantity() <= 0 && !menuItemModifierSpec.isAutoShow().booleanValue()) continue;
                menuItem.setHasMandatoryModifiers(true);
                break;
            }
        }
        List<PizzaPrice> pizzaPriceList = this.priceTableModel.getRows();
        if (menuItem.getPizzaPriceList() != null) {
            menuItem.getPizzaPriceList().clear();
        }
        for (PizzaPrice pizzaPrice : pizzaPriceList) {
            menuItem.addTopizzaPriceList(pizzaPrice);
        }
        int n = this.tabbedPane.getTabCount();
        for (int i = 0; i < n; ++i) {
            IUpdatebleView view;
            Component componentAt = this.tabbedPane.getComponent(i);
            if (!(componentAt instanceof IUpdatebleView) || (view = (IUpdatebleView)((Object)componentAt)).updateModel(menuItem)) continue;
            return false;
        }
        menuItem.setPrinterGroup((PrinterGroup)this.cbPrinterGroup.getSelectedItem());
        menuItem.setPizzaType(true);
        if (this.imageResource != null) {
            menuItem.setImageId(this.imageResource.getId());
        }
        return true;
    }

    @Override
    public String getDisplayText() {
        MenuItem foodItem = (MenuItem)this.getBean();
        if (foodItem.getId() == null) {
            return Messages.getString("PizzaItemForm.15");
        }
        return Messages.getString("PizzaItemForm.16");
    }

    private void addNewPrice() {
        List<PizzaPrice> pizzaPriceList = this.priceTableModel.getRows();
        PizzaItemPriceDialog dialog = new PizzaItemPriceDialog(this.getParentFrame(), null, pizzaPriceList);
        dialog.setTitle(Messages.getString("PizzaItemForm.17"));
        dialog.setSize(PosUIManager.getSize(350, 220));
        dialog.open();
        if (dialog.isCanceled()) {
            return;
        }
        PizzaPrice pizzaPrice = dialog.getPizzaPrice();
        this.priceTableModel.addRow(pizzaPrice);
    }

    private void deletePrice() {
        int selectedRow = this.priceTable.getSelectedRow();
        if (selectedRow == -1) {
            POSMessageDialog.showMessage(this.getParentFrame(), Messages.getString("MenuItemForm.32"));
            return;
        }
        int option = POSMessageDialog.showYesNoQuestionDialog(this.getParentFrame(), Messages.getString("MenuItemForm.33"), Messages.getString("CONFIRM"));
        if (option != 0) {
            return;
        }
        this.priceTableModel.removeRow(selectedRow);
    }

    private void deleteAll() {
        int option = POSMessageDialog.showYesNoQuestionDialog(this.getParentFrame(), Messages.getString("MenuItemForm.36"), Messages.getString("CONFIRM"));
        if (option != 0) {
            return;
        }
        this.priceTableModel.removeAll();
    }

    private void updatePrice() {
        this.editEvent();
    }

    private void editEvent() {
        List<PizzaPrice> pizzaPriceList = this.priceTableModel.getRows();
        int selectedRow = this.priceTable.getSelectedRow();
        if (selectedRow == -1) {
            POSMessageDialog.showMessage(this.getParentFrame(), Messages.getString("MenuItemForm.38"));
            return;
        }
        PizzaPrice pizzaPrice = this.priceTableModel.getRow(selectedRow);
        PizzaItemPriceDialog pizzaItemPriceDialog = new PizzaItemPriceDialog(this.getParentFrame(), pizzaPrice, pizzaPriceList);
        pizzaItemPriceDialog.setTitle("Edit Pizza Price");
        pizzaItemPriceDialog.setSize(PosUIManager.getSize(350, 220));
        pizzaItemPriceDialog.open();
        if (pizzaItemPriceDialog.isCanceled()) {
            return;
        }
        this.priceTableModel.fireTableRowsUpdated(selectedRow, selectedRow);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (actionCommand.equals("AddModifierGroup")) {
            this.addMenuItemModifierGroup();
        } else if (actionCommand.equals("EditModifierGroup")) {
            this.editMenuItemModifierGroup();
        } else if (actionCommand.equals("DeleteModifierGroup")) {
            this.deleteMenuItemModifierGroup();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Component selectedComponent = this.tabbedPane.getSelectedComponent();
        if (!(selectedComponent instanceof IUpdatebleView)) {
            return;
        }
        IUpdatebleView view = (IUpdatebleView)((Object)selectedComponent);
        MenuItem menuItem = (MenuItem)this.getBean();
        view.initView(menuItem);
    }

    private void filterDuplicateItemSizesAndPrices(List<PizzaPrice> pizzaPriceList) {
        List<PizzaPrice> existedPizzaPriceValueList = this.priceTableModel.getRows();
        if (existedPizzaPriceValueList != null) {
            for (PizzaPrice existingPizzaPrice : existedPizzaPriceValueList) {
                Iterator<PizzaPrice> iterator2 = pizzaPriceList.iterator();
                while (iterator2.hasNext()) {
                    PizzaPrice pizzaPrice = iterator2.next();
                    if (!existingPizzaPrice.getSize().equals(pizzaPrice.getSize()) || !existingPizzaPrice.getCrust().equals(pizzaPrice.getCrust())) continue;
                    iterator2.remove();
                }
            }
        }
    }

    private List<PizzaPrice> generatedPossiblePizzaItemSizeAndPriceList() {
        List<MenuItemSize> menuItemSizeList = MenuItemSizeDAO.getInstance().findAll();
        List<PizzaCrust> crustList = PizzaCrustDAO.getInstance().findAll();
        ArrayList<PizzaPrice> pizzaPriceList = new ArrayList<PizzaPrice>();
        for (int i = 0; i < menuItemSizeList.size(); ++i) {
            for (int j = 0; j < crustList.size(); ++j) {
                PizzaPrice pizzaPrice = new PizzaPrice();
                pizzaPrice.setSize(menuItemSizeList.get(i));
                pizzaPrice.setCrust(crustList.get(j));
                pizzaPrice.setPrice(0.0);
                pizzaPriceList.add(pizzaPrice);
            }
        }
        return pizzaPriceList;
    }

    class ShiftTableModel
    extends AbstractTableModel {
        List<MenuItemShift> shifts;
        String[] cn = new String[]{POSConstants.START_TIME, POSConstants.END_TIME, POSConstants.PRICE};
        Calendar calendar = Calendar.getInstance();

        ShiftTableModel(List<MenuItemShift> shifts) {
            this.shifts = shifts == null ? new ArrayList<MenuItemShift>() : new ArrayList<MenuItemShift>(shifts);
        }

        public MenuItemShift get(int index) {
            return this.shifts.get(index);
        }

        public void add(MenuItemShift group) {
            if (this.shifts == null) {
                this.shifts = new ArrayList<MenuItemShift>();
            }
            this.shifts.add(group);
            this.fireTableDataChanged();
        }

        public void remove(int index) {
            if (this.shifts == null) {
                return;
            }
            this.shifts.remove(index);
            this.fireTableDataChanged();
        }

        public void remove(MenuItemShift group) {
            if (this.shifts == null) {
                return;
            }
            this.shifts.remove(group);
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            if (this.shifts == null) {
                return 0;
            }
            return this.shifts.size();
        }

        @Override
        public int getColumnCount() {
            return this.cn.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.cn[column];
        }

        public List<MenuItemShift> getShifts() {
            return this.shifts;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            MenuItemShift shift = this.shifts.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return ShiftUtil.buildShiftTimeRepresentation(shift.getShift().getStartTime());
                }
                case 1: {
                    return ShiftUtil.buildShiftTimeRepresentation(shift.getShift().getEndTime());
                }
                case 2: {
                    return String.valueOf(shift.getShiftPrice());
                }
            }
            return null;
        }
    }

    class MenuItemMGListModel
    extends AbstractTableModel {
        String[] cn = new String[]{POSConstants.GROUP_NAME, POSConstants.MIN_QUANTITY, POSConstants.MAX_QUANTITY};

        MenuItemMGListModel() {
        }

        public MenuItemModifierSpec get(int index) {
            return (MenuItemModifierSpec)PizzaItemForm.this.menuItemModifierGroups.get(index);
        }

        public void add(MenuItemModifierSpec group) {
            if (PizzaItemForm.this.menuItemModifierGroups == null) {
                PizzaItemForm.this.menuItemModifierGroups = new ArrayList();
            }
            PizzaItemForm.this.menuItemModifierGroups.add(group);
            this.fireTableDataChanged();
        }

        public void remove(int index) {
            if (PizzaItemForm.this.menuItemModifierGroups == null) {
                return;
            }
            PizzaItemForm.this.menuItemModifierGroups.remove(index);
            this.fireTableDataChanged();
        }

        public void remove(MenuItemModifierSpec group) {
            if (PizzaItemForm.this.menuItemModifierGroups == null) {
                return;
            }
            PizzaItemForm.this.menuItemModifierGroups.remove(group);
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            if (PizzaItemForm.this.menuItemModifierGroups == null) {
                return 0;
            }
            return PizzaItemForm.this.menuItemModifierGroups.size();
        }

        @Override
        public int getColumnCount() {
            return this.cn.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.cn[column];
        }

        public List<MenuItemModifierSpec> getItems() {
            return PizzaItemForm.this.menuItemModifierGroups;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            MenuItemModifierSpec menuItemModifierGroup = (MenuItemModifierSpec)PizzaItemForm.this.menuItemModifierGroups.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return menuItemModifierGroup.getName();
                }
                case 1: {
                    return (int)menuItemModifierGroup.getMinQuantity();
                }
                case 2: {
                    return (int)menuItemModifierGroup.getMaxQuantity();
                }
            }
            return null;
        }
    }
}

