/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.model.Department;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.dao.DepartmentDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.SalesAreaDAO;
import com.floreantpos.model.util.IllegalModelStateException;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.MessageDialog;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class SalesAreaEntryForm
extends BeanEditor<SalesArea> {
    private SalesArea salesArea;
    private FixedLengthTextField txtName;
    JLabel lblDeptName = new JLabel(Messages.getString("SalesAreaEntryForm.0"));
    JComboBox cbDeptName = new JComboBox();

    public SalesAreaEntryForm(SalesArea salesArea) {
        this.salesArea = salesArea;
        DepartmentDAO deptDAO = new DepartmentDAO();
        List<Department> deptList = deptDAO.findAll();
        this.cbDeptName.setModel(new ComboBoxModel(deptList));
        this.initComponents();
        this.setBean(salesArea);
    }

    public void initComponents() {
        JPanel mainPanel = new JPanel((LayoutManager)new MigLayout("fill,alignx center", "[][]", ""));
        JLabel lblName = new JLabel(Messages.getString("NAME"));
        this.txtName = new FixedLengthTextField(20);
        mainPanel.add(lblName);
        mainPanel.add((Component)this.txtName, "wrap");
        mainPanel.add(this.lblDeptName);
        mainPanel.add((Component)this.cbDeptName, "grow");
        this.add(mainPanel);
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            SalesArea item = (SalesArea)this.getBean();
            SalesAreaDAO salesAreaDAO = new SalesAreaDAO();
            salesAreaDAO.saveOrUpdate(item);
        }
        catch (PosException e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage());
            return false;
        }
        catch (Exception e) {
            MessageDialog.showError(POSConstants.ERROR_MESSAGE, e);
            return false;
        }
        return true;
    }

    @Override
    protected void updateView() {
        SalesArea item = (SalesArea)this.getBean();
        this.txtName.setText(item.getName());
        this.cbDeptName.setSelectedItem(item.getDepartment());
    }

    @Override
    protected boolean updateModel() throws IllegalModelStateException {
        SalesArea term = (SalesArea)this.getBean();
        if (term == null) {
            return false;
        }
        String name = this.txtName.getText();
        GenericDAO.getInstance().checkIdOrNameExists(term.getId(), name, SalesArea.class);
        this.salesArea.setName(name);
        term.setDepartment((Department)this.cbDeptName.getSelectedItem());
        return true;
    }

    @Override
    public String getDisplayText() {
        SalesArea item = (SalesArea)this.getBean();
        if (item.getId() == null) {
            return Messages.getString("SalesAreaEntryForm.7");
        }
        return Messages.getString("SalesAreaEntryForm.8");
    }
}

