/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.order;

import com.floreantpos.POSConstants;
import com.floreantpos.actions.SendToKitchenAction;
import com.floreantpos.model.Course;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.PosButton;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.order.CourseOrganizeTableView;
import com.floreantpos.ui.order.TableDataTransferHandler;
import com.floreantpos.ui.views.order.OrderController;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.hibernate.StaleStateException;

public class CourseOrganizeDialog
extends OkCancelOptionDialog
implements RefreshableView {
    private final TableDataTransferHandler handler = new TableDataTransferHandler();
    private JPanel coursePanel;
    private long version;
    private Ticket ticket;

    public CourseOrganizeDialog(Ticket ticket) {
        this.version = ticket.getVersion();
        this.ticket = ticket;
        this.version = ticket.getVersion();
        this.setDefaultCloseOperation(2);
        this.setCaption(POSConstants.ORGANIZE_COURSE);
        this.setOkButtonText(POSConstants.SAVE_BUTTON_TEXT.toUpperCase());
        LinkedHashMap courseItemMap = new LinkedHashMap();
        List<Course> courses = DataProvider.get().getCourses();
        int size = courses.size();
        if (courses != null && size > 0) {
            Collections.sort(courses, new Comparator<Course>(){

                @Override
                public int compare(Course o1, Course o2) {
                    return o1.getSortOrder().compareTo(o2.getSortOrder());
                }
            });
            for (Course course : courses) {
                courseItemMap.put(course.getId(), new ArrayList());
            }
        }
        for (TicketItem ticketItem : ticket.getTicketItems()) {
            String courseId = ticketItem.getCourseId();
            if (StringUtils.isEmpty((String)courseId)) {
                List nonCourseItems = (List)courseItemMap.get(courses.get(0).getId());
                nonCourseItems.add(ticketItem);
                continue;
            }
            List courseItems = (List)courseItemMap.get(courseId);
            if (courseItems != null) {
                courseItems.add(ticketItem);
                continue;
            }
            List nonCourseItems = (List)courseItemMap.get(courses.get(0).getId());
            nonCourseItems.add(ticketItem);
        }
        int wrap = 5;
        if (size == 6 || size == 5) {
            wrap = 3;
        } else if (size == 8 || size == 7) {
            wrap = 4;
        }
        this.coursePanel = new JPanel((LayoutManager)new MigLayout("fill,wrap " + wrap, "sg,fill", ""));
        for (String course : courseItemMap.keySet()) {
            CourseOrganizeTableView tableView = new CourseOrganizeTableView(DataProvider.get().getCourse(course), (List)courseItemMap.get(course));
            tableView.setDataTransferHandler(this.handler);
            tableView.setTicket(ticket);
            this.coursePanel.add((Component)tableView, "grow");
        }
        JPanel jPanel = this.getContentPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.coursePanel);
        PosButton btnSendAllToKit = new PosButton(POSConstants.SEND_TO_KITCHEN + " " + POSConstants.ALL);
        btnSendAllToKit.addActionListener(e -> this.doSentToKitchen());
        this.getButtonPanel().add((Component)btnSendAllToKit, 0);
    }

    private void doSentToKitchen() {
        try {
            CourseOrganizeTableView tableView;
            SendToKitchenAction sendAction = new SendToKitchenAction();
            if (!sendAction.isPrintableToKitchen(this.ticket)) {
                return;
            }
            for (Component c : this.coursePanel.getComponents()) {
                tableView = (CourseOrganizeTableView)c;
                tableView.updateModel();
            }
            OrderController.saveOrder(this.ticket);
            sendAction.doSendNewItemsToKitchen(this.ticket);
            for (Component c : this.coursePanel.getComponents()) {
                tableView = (CourseOrganizeTableView)c;
                tableView.updateView();
            }
        }
        catch (StaleStateException e) {
            POSMessageDialog.showMessageDialogWithReloadButton(this, this);
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }

    @Override
    public void doOk() {
        for (Component c : this.coursePanel.getComponents()) {
            CourseOrganizeTableView tableView = (CourseOrganizeTableView)c;
            tableView.updateModel();
        }
        this.setCanceled(false);
        this.dispose();
    }

    @Override
    public void doCancel() {
        if (this.ticket.getVersion() > this.version) {
            this.setCanceled(false);
        } else {
            this.setCanceled(true);
        }
        this.dispose();
    }

    static Image iconToImage(Icon icon) {
        if (icon instanceof ImageIcon) {
            return ((ImageIcon)icon).getImage();
        }
        int w = icon.getIconWidth();
        int h = icon.getIconHeight();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gd.getDefaultConfiguration();
        BufferedImage image = gc.createCompatibleImage(w, h);
        Graphics2D g = image.createGraphics();
        icon.paintIcon(null, g, 0, 0);
        g.dispose();
        return image;
    }

    public Ticket getTicket() {
        return this.ticket;
    }

    @Override
    public void refresh() {
        this.ticket = TicketDAO.getInstance().loadFullTicket(this.ticket.getId());
    }
}

