/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.order;

import com.floreantpos.Messages;
import com.floreantpos.actions.SendToKitchenAction;
import com.floreantpos.model.Course;
import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.order.CourseOrganizeTableModel;
import com.floreantpos.ui.order.TableDataTransferHandler;
import com.floreantpos.ui.ticket.TicketViewerTableCellRenderer;
import com.floreantpos.ui.views.order.OrderController;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.DropMode;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import net.miginfocom.swing.MigLayout;

public class CourseOrganizeTableView
extends TransparentPanel {
    private JTable table;
    private CourseOrganizeTableModel model;
    private Course course;
    protected boolean pressed;
    private Ticket ticket;

    public CourseOrganizeTableView(Course course, List<ITicketItem> items) {
        this.course = course;
        this.initComponents();
        ArrayList<ITicketItem> ticketItems = new ArrayList<ITicketItem>();
        for (ITicketItem iTicketItem : items) {
            TicketItem ticketItem = (TicketItem)iTicketItem;
            if (iTicketItem instanceof TicketItem && (ticketItem.isTreatAsSeat().booleanValue() || ticketItem.isReturned() || ticketItem.isVoided().booleanValue())) continue;
            ticketItems.add(iTicketItem);
        }
        this.model.setItems(ticketItems);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.table = new JTable();
        this.model = new CourseOrganizeTableModel();
        this.table.setModel(this.model);
        this.table.getSelectionModel().setSelectionMode(2);
        this.table.setDropMode(DropMode.INSERT_ROWS);
        this.table.setDragEnabled(true);
        this.table.setRowSelectionAllowed(true);
        this.table.setFillsViewportHeight(true);
        this.table.setFocusable(false);
        this.table.setAutoResizeMode(4);
        this.table.setAutoCreateRowSorter(false);
        this.table.setRowHeight(40);
        this.table.getTableHeader().setPreferredSize(new Dimension(0, 35));
        this.table.setAutoscrolls(true);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                CourseOrganizeTableView.this.pressed = true;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                CourseOrganizeTableView.this.pressed = false;
                CourseOrganizeTableView.this.table.setCursor(Cursor.getPredefinedCursor(0));
                super.mouseReleased(e);
            }
        });
        PosScrollPane comp = new PosScrollPane(this.table);
        this.add(comp);
        PosButton btnSendToKit = new PosButton("Fire");
        btnSendToKit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CourseOrganizeTableView.this.doSendItemsToKitchen();
            }
        });
        JPanel bottomPanel = new JPanel((LayoutManager)new MigLayout("center"));
        bottomPanel.add(btnSendToKit);
        this.add((Component)bottomPanel, "South");
    }

    private void doSendItemsToKitchen() {
        if (this.model.getRows() == null || this.model.getRowCount() == 0) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("TransferTicketDialog.10"));
            return;
        }
        SendToKitchenAction sendAction = new SendToKitchenAction();
        if (!sendAction.isPrintableToKitchen(this.ticket)) {
            return;
        }
        this.updateModel();
        boolean shouldKdsPrint = false;
        ArrayList<TicketItem> ticketItems = new ArrayList<TicketItem>();
        for (TicketItem ticketItem : this.model.getRows()) {
            if (!shouldKdsPrint && ticketItem.isShouldPrintToKitchen().booleanValue() && !ticketItem.isPrintedToKitchen().booleanValue()) {
                shouldKdsPrint = true;
            }
            ticketItems.add(ticketItem);
        }
        OrderController.saveOrder(this.ticket);
        ReceiptPrintService.printCourseItemsToKitchen(this.ticket, ticketItems, shouldKdsPrint);
        this.model.fireTableDataChanged();
    }

    public void setDataTransferHandler(TableDataTransferHandler handler) {
        this.table.setTransferHandler(handler);
        this.table.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component rendererComponent = null;
                ListTableModel model = (ListTableModel)table.getModel();
                Object object = model.getRowData(row);
                rendererComponent = super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
                if (isSelected) {
                    return rendererComponent;
                }
                rendererComponent.setBackground(table.getBackground());
                if (object instanceof ITicketItem) {
                    ITicketItem ticketItem = (ITicketItem)object;
                    if (ticketItem.isPrintedToKitchen().booleanValue()) {
                        rendererComponent.setBackground(Color.YELLOW);
                    } else if (ticketItem.isSaved()) {
                        rendererComponent.setBackground(TicketViewerTableCellRenderer.SAVED_ITEM_COLOR);
                    }
                }
                return rendererComponent;
            }
        });
        ActionMap map = this.table.getActionMap();
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        map.put(TransferHandler.getCutAction().getValue("Name"), action);
        map.put(TransferHandler.getCopyAction().getValue("Name"), action);
        map.put(TransferHandler.getPasteAction().getValue("Name"), action);
        TableColumn col = this.table.getColumnModel().getColumn(0);
        col.setHeaderRenderer(new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int vColIndex) {
                JLabel lblCourse = new JLabel(CourseOrganizeTableView.this.course.getShortName() + " - " + CourseOrganizeTableView.this.course.getName(), 0);
                lblCourse.setBorder(table.getBorder());
                return lblCourse;
            }
        });
    }

    public void updateView() {
        this.model.fireTableDataChanged();
    }

    public void updateModel() {
        for (ITicketItem item : this.model.getRows()) {
            TicketItem ticketItem = (TicketItem)item;
            ticketItem.setCourseId(this.course == null ? null : this.course.getId());
            ticketItem.setCourseName(this.course == null ? null : this.course.getShortName());
            ticketItem.setSortOrder(this.course == null ? null : this.course.getSortOrder());
        }
    }

    public void setTicket(Ticket ticket) {
        this.ticket = ticket;
    }
}

