/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.order;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.main.Application;
import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.ShopSeat;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemSeat;
import com.floreantpos.model.dao.ShopSeatDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.swing.HorizontalSimpleScrollPane;
import com.floreantpos.swing.HorizontalTouchScrollPanel;
import com.floreantpos.swing.PaginatedListModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.floorplan.SeatSelectionDialog;
import com.floreantpos.ui.order.SeatOrganizeTableView;
import com.floreantpos.ui.order.SeatTransferDataHandler;
import com.floreantpos.util.GlobalIdGenerator;
import com.floreantpos.versioning.VersionInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;

public class SeatOrganizeDialog
extends OkCancelOptionDialog
implements RefreshableView {
    private final SeatTransferDataHandler handler = new SeatTransferDataHandler();
    private JPanel seatPanel;
    private JPanel sharedPanel;
    HorizontalSimpleScrollPane seatPanelScrollPane;
    private long version;
    private Ticket ticket;
    private PaginatedListModel dataModel = new PaginatedListModel();
    private Map<String, List<ITicketItem>> seatItemMap;
    private List<ITicketItem> nonSeatItems;
    private ShopSeat seat;
    private boolean addToOrder;

    public SeatOrganizeDialog(Ticket ticket) {
        this.version = ticket.getVersion();
        this.ticket = ticket;
        this.version = ticket.getVersion();
        this.setDefaultCloseOperation(2);
        this.setCaption(Messages.getString("SeatOrganizeDialog.0"));
        this.setOkButtonText(POSConstants.SAVE_BUTTON_TEXT);
        this.seatPanel = new HorizontalTouchScrollPanel((LayoutManager)new MigLayout("ins 0, fill, gap 5"));
        this.seatPanelScrollPane = new HorizontalSimpleScrollPane(this.seatPanel);
        this.sharedPanel = new JPanel((LayoutManager)new MigLayout("ins 0, fill"));
        JPanel contentPanel = this.getContentPanel();
        contentPanel.setLayout(new BorderLayout(10, 10));
        contentPanel.add((Component)this.sharedPanel, "West");
        contentPanel.add((Component)((Object)this.seatPanelScrollPane));
        PosButton btnAddSeat = new PosButton(Messages.getString("SeatSelectionDialog.4"));
        btnAddSeat.addActionListener(e -> this.insertMiscSeat());
        this.getButtonPanel().add((Component)btnAddSeat, 0);
        PosButton btnTableLayout = new PosButton(Messages.getString("SeatOrganizeDialog.1"));
        btnTableLayout.addActionListener(e -> this.showTableLayout());
        this.getButtonPanel().add((Component)btnTableLayout, 0);
        this.seatItemMap = new HashMap<String, List<ITicketItem>>();
        this.nonSeatItems = new ArrayList<ITicketItem>();
        for (TicketItem ticketItem : ticket.getTicketItems()) {
            TicketItemSeat ticketItemSeat = ticketItem.getSeat();
            if (ticketItemSeat == null) {
                this.nonSeatItems.add(ticketItem);
                continue;
            }
            List<ITicketItem> seatItems = this.seatItemMap.get(ticketItemSeat.getSeatId());
            if (seatItems == null) {
                seatItems = new ArrayList<ITicketItem>();
                this.seatItemMap.put(ticketItemSeat.getSeatId(), seatItems);
            }
            seatItems.add(ticketItem);
        }
        this.updateView();
    }

    private void insertMiscSeat() {
        int seatNumber = (int)NumberSelectionDialog2.takeIntInput(Messages.getString("SeatSelectionDialog.14"));
        if (seatNumber == -1) {
            return;
        }
        if (seatNumber == 0) {
            POSMessageDialog.showError(Messages.getString("SeatSelectionDialog.6"));
            return;
        }
        List<ShopSeat> extraSeats = this.ticket.getExtraSeats();
        if (!this.isExtraSeatNumberAvailable(extraSeats, seatNumber)) {
            POSMessageDialog.showError(Messages.getString("SeatSelectionDialog.13"));
            return;
        }
        ShopSeat shopSeat = new ShopSeat();
        shopSeat.setId(GlobalIdGenerator.generateGlobalId());
        shopSeat.setSeatNumber(seatNumber);
        shopSeat.setMember(this.ticket.getCustomer());
        extraSeats.add(shopSeat);
        this.ticket.addExtraSeats(extraSeats);
        SeatOrganizeTableView tableView = new SeatOrganizeTableView(shopSeat, this.seatItemMap.get(shopSeat.getId()), this.ticket){

            @Override
            public void doAddToOrder() {
                SeatOrganizeDialog.this.doFinishAddToOrder(this.getShopSeat());
            }
        };
        tableView.setDataTransferHandler(this.handler);
        this.seatPanel.add((Component)tableView, "grow");
        JSeparator separator = new JSeparator(0);
        separator.setPreferredSize(PosUIManager.getSize(30, 10));
        this.seatPanel.add(separator);
        this.repaint();
        this.revalidate();
        this.seatPanelScrollPane.getViewport().scrollRectToVisible(tableView.getBounds());
    }

    private void showTableLayout() {
        SeatSelectionDialog seatDialog = new SeatSelectionDialog(this.ticket);
        seatDialog.setTitle(Messages.getString("SeatOrganizeDialog.1"));
        seatDialog.setDialogTitle(VersionInfo.getAppName());
        seatDialog.setSize(PosUIManager.getSize(900, 650));
        seatDialog.open();
    }

    @Override
    public void doOk() {
        this.updateModel();
        this.setCanceled(false);
        this.dispose();
    }

    @Override
    public void doCancel() {
        if (this.ticket.getVersion() > this.version) {
            this.setCanceled(false);
        } else {
            this.setCanceled(true);
        }
        this.dispose();
    }

    public Ticket getTicket() {
        return this.ticket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateView() {
        this.reset();
        try {
            ArrayList<ShopSeat> seats = new ArrayList<ShopSeat>();
            for (ShopTable shopTable : this.ticket.getTables()) {
                List<ShopSeat> shopSeats = ShopSeatDAO.getInstance().getShopSeats(shopTable.getId());
                if (shopSeats == null) continue;
                seats.addAll(shopSeats);
            }
            List<ShopSeat> extraSeats = this.ticket.getExtraSeats();
            seats.addAll(extraSeats);
            if (seats != null && seats.size() > 0) {
                for (ShopSeat seat : seats) {
                    SeatOrganizeTableView tableView = new SeatOrganizeTableView(seat, this.seatItemMap.get(seat.getId()), this.ticket){

                        @Override
                        public void doAddToOrder() {
                            SeatOrganizeDialog.this.doFinishAddToOrder(this.getShopSeat());
                        }
                    };
                    tableView.setDataTransferHandler(this.handler);
                    this.seatPanel.add((Component)tableView, "grow");
                    JSeparator separator = new JSeparator(0);
                    separator.setPreferredSize(PosUIManager.getSize(20, 10));
                    this.seatPanel.add((Component)separator, "align center");
                }
            }
            SeatOrganizeTableView seatOrganizeTableView = new SeatOrganizeTableView(null, this.nonSeatItems, this.ticket){

                @Override
                public void doAddToOrder() {
                    SeatOrganizeDialog.this.doFinishAddToOrder(this.getShopSeat());
                }
            };
            seatOrganizeTableView.setDataTransferHandler(this.handler);
            this.sharedPanel.add((Component)seatOrganizeTableView, "grow");
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
    }

    protected void scrollDown() {
        this.updateModel();
        if (!this.dataModel.hasNext()) {
            return;
        }
        this.dataModel.setCurrentRowIndex(this.dataModel.getNextRowIndex());
        this.updateView();
    }

    private void updateModel() {
        SeatOrganizeTableView seatOrganizeTableView;
        Component[] components;
        for (Component component : components = this.seatPanel.getComponents()) {
            if (!(component instanceof SeatOrganizeTableView)) continue;
            seatOrganizeTableView = (SeatOrganizeTableView)component;
            seatOrganizeTableView.updateModel();
            if (seatOrganizeTableView.getShopSeat() == null) continue;
            this.seatItemMap.put(seatOrganizeTableView.getShopSeat().getId(), seatOrganizeTableView.getModel().getRows());
        }
        for (Component component : components = this.sharedPanel.getComponents()) {
            if (!(component instanceof SeatOrganizeTableView)) continue;
            seatOrganizeTableView = (SeatOrganizeTableView)component;
            seatOrganizeTableView.updateModel();
            this.nonSeatItems.clear();
            this.nonSeatItems.addAll(seatOrganizeTableView.getModel().getRows());
        }
    }

    public void reset() {
        this.seatPanel.removeAll();
        this.seatPanel.repaint();
    }

    protected void setDataModel(PaginatedListModel listModel) {
        this.dataModel = listModel;
    }

    public PaginatedListModel getDataModel() {
        return this.dataModel;
    }

    @Override
    public void refresh() {
        this.ticket = TicketDAO.getInstance().loadFullTicket(this.ticket.getId());
    }

    private boolean isExtraSeatNumberAvailable(List<ShopSeat> extraSeats, Integer seatNumber) {
        List<ShopSeat> seats = this.ticket.getExtraSeats();
        if (seats == null || seats.isEmpty()) {
            return true;
        }
        for (ShopSeat shopSeat : seats) {
            if (!shopSeat.getSeatNumber().equals(seatNumber)) continue;
            return false;
        }
        return true;
    }

    private void doFinishAddToOrder(ShopSeat shopSeat) {
        this.seat = shopSeat;
        this.addToOrder = true;
        this.doOk();
    }

    public ShopSeat getSeat() {
        return this.seat;
    }

    public boolean isAddToOrder() {
        return this.addToOrder;
    }
}

