/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.order;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.customer.CustomerSelectorDialog;
import com.floreantpos.customer.CustomerSelectorFactory;
import com.floreantpos.model.Customer;
import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.ShopSeat;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemSeat;
import com.floreantpos.model.ext.KitchenStatus;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.order.SeatOrganizeTableModel;
import com.floreantpos.ui.order.SeatTransferDataHandler;
import com.floreantpos.ui.ticket.MultiLineTableCellRenderer;
import com.floreantpos.ui.ticket.TicketViewerTableCellRenderer;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DropMode;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import net.miginfocom.swing.MigLayout;

public class SeatOrganizeTableView
extends TransparentPanel {
    private JTable table;
    private SeatOrganizeTableModel model;
    private ShopSeat shopSeat;
    private TicketItemSeat seatItem;
    protected boolean pressed;
    private Ticket ticket;
    private Customer selectedMember;
    private PosButton btnSelectMember;
    private JLabel tfSeatTotal;

    public SeatOrganizeTableView(ShopSeat shopSeat, List<ITicketItem> items, Ticket ticket) {
        this.ticket = ticket;
        this.shopSeat = shopSeat;
        if (shopSeat != null) {
            this.selectedMember = shopSeat.getMember();
        }
        this.initComponents();
        ArrayList<ITicketItem> ticketItems = new ArrayList<ITicketItem>();
        if (items != null) {
            for (ITicketItem item : items) {
                if (item instanceof TicketItem && (((TicketItem)item).isTreatAsSeat().booleanValue() || ((TicketItem)item).isVoided().booleanValue() || ((TicketItem)item).isReturned())) continue;
                ticketItems.add(item);
                TicketItemSeat seat = ((TicketItem)item).getSeat();
                if (this.selectedMember == null && seat != null) {
                    this.selectedMember = seat.getMember();
                }
                if (this.seatItem != null) continue;
                this.seatItem = seat;
            }
        }
        this.model.setItems(ticketItems);
        this.updateView();
        this.setPreferredSize(PosUIManager.getSize(300, 200));
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        String label = "";
        if (this.shopSeat != null) {
            if (this.shopSeat.getShopTable() != null) {
                label = label + POSConstants.TABLE + " " + this.shopSeat.getShopTable().getNameOrNumber() + ", ";
            }
            label = label + Messages.getString("ShopTableForm.30") + " " + this.shopSeat.getSeatNumber();
        } else {
            label = Messages.getString("SeatSelectionDialog.2");
        }
        JLabel lblHeader = new JLabel(label, 0);
        this.table = new JTable();
        this.model = new SeatOrganizeTableModel();
        this.model.addTableModelListener(e -> this.updateSeatTotal());
        this.table.setModel(this.model);
        this.table.setTableHeader(null);
        this.table.getSelectionModel().setSelectionMode(2);
        this.table.setDropMode(DropMode.INSERT_ROWS);
        this.table.setDragEnabled(true);
        this.table.setRowSelectionAllowed(true);
        this.table.setFillsViewportHeight(true);
        this.table.setFocusable(false);
        this.table.setAutoResizeMode(2);
        this.table.setAutoCreateRowSorter(false);
        this.table.setRowHeight(40);
        TableColumn column = this.table.getColumnModel().getColumn(1);
        int size = PosUIManager.getSize(100);
        column.setPreferredWidth(size);
        column.setMaxWidth(size);
        column.setMinWidth(size);
        this.table.setAutoscrolls(true);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                SeatOrganizeTableView.this.pressed = true;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                SeatOrganizeTableView.this.pressed = false;
                SeatOrganizeTableView.this.table.setCursor(Cursor.getPredefinedCursor(0));
                super.mouseReleased(e);
            }
        });
        lblHeader.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        this.add((Component)lblHeader, "North");
        this.add(new PosScrollPane(this.table));
        this.btnSelectMember = new PosButton(Messages.getString("SelectMember"));
        this.btnSelectMember.setBackground(Color.WHITE);
        this.btnSelectMember.addActionListener(e -> this.doSelectMember());
        PosButton btnAddToOrder = new PosButton(Messages.getString("SeatOrganizeTableView.0"));
        btnAddToOrder.addActionListener(e -> this.doAddToOrder());
        JPanel bottomPanel = new JPanel((LayoutManager)new MigLayout("ins 2,fill"));
        JLabel lblSeatTotal = new JLabel(Messages.getString("SeatOrganizeTableView.3"));
        Font newLabelFont = new Font(lblSeatTotal.getFont().getName(), 1, lblSeatTotal.getFont().getSize());
        this.tfSeatTotal = new JLabel();
        lblSeatTotal.setFont(newLabelFont);
        this.tfSeatTotal.setFont(newLabelFont);
        bottomPanel.add((Component)lblSeatTotal, "grow");
        bottomPanel.add((Component)this.tfSeatTotal, "right,wrap");
        if (this.shopSeat != null) {
            bottomPanel.add((Component)this.btnSelectMember, "span,split 3,grow,center");
        }
        bottomPanel.add((Component)btnAddToOrder, "center,span, grow");
        List<ShopSeat> extraSeats = this.ticket.getExtraSeats();
        if (extraSeats != null && extraSeats.contains(this.shopSeat)) {
            PosButton btnDeleteSeat = new PosButton(POSConstants.DELETE);
            btnDeleteSeat.addActionListener(e -> this.doDeleteSeat());
            bottomPanel.add((Component)btnDeleteSeat, "center,span");
        }
        this.add((Component)bottomPanel, "South");
    }

    private void doDeleteSeat() {
        List<ShopSeat> extraSeats = this.ticket.getExtraSeats();
        if (extraSeats.contains(this.shopSeat)) {
            List rows = this.model.getRows();
            if (rows.size() > 0) {
                String message = Messages.getString("ShopTableForm.34");
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), message);
                return;
            }
            extraSeats.remove(this.shopSeat);
            this.ticket.addExtraSeats(extraSeats);
            Container seatPanel = this.getParent();
            seatPanel.remove(this);
            seatPanel.revalidate();
            seatPanel.repaint();
        }
    }

    private void doSelectMember() {
        CustomerSelectorDialog dialog = CustomerSelectorFactory.createCustomerSelectorDialog(this.ticket.getOrderType());
        dialog.setCreateNewTicket(false);
        if (this.ticket != null) {
            dialog.setTicket(this.ticket);
        }
        dialog.openUndecoratedFullScreen();
        if (dialog.isCanceled()) {
            return;
        }
        this.selectedMember = dialog.getSelectedCustomer();
        if (this.shopSeat != null) {
            this.shopSeat.setMember(this.selectedMember);
        }
        this.updateView();
    }

    public void doAddToOrder() {
    }

    public void setDataTransferHandler(SeatTransferDataHandler handler) {
        this.table.setTransferHandler(handler);
        this.table.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){
            private MultiLineTableCellRenderer multiLineTableCellRenderer = new MultiLineTableCellRenderer();

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component rendererComponent = null;
                ListTableModel model = (ListTableModel)table.getModel();
                Object object = model.getRowData(row);
                if (column == 0) {
                    rendererComponent = this.multiLineTableCellRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                } else {
                    rendererComponent = super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
                    this.setHorizontalAlignment(4);
                }
                if (isSelected) {
                    return rendererComponent;
                }
                rendererComponent.setBackground(table.getBackground());
                if (object instanceof ITicketItem) {
                    ITicketItem ticketItem = (ITicketItem)object;
                    if (ticketItem.getKitchenStatusValue() == KitchenStatus.BUMP) {
                        rendererComponent.setBackground(Color.GREEN);
                    } else if (ticketItem.isPrintedToKitchen().booleanValue()) {
                        rendererComponent.setBackground(Color.YELLOW);
                    } else if (ticketItem.isSaved()) {
                        rendererComponent.setBackground(TicketViewerTableCellRenderer.SAVED_ITEM_COLOR);
                    }
                }
                return rendererComponent;
            }
        });
        ActionMap map = this.table.getActionMap();
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        map.put(TransferHandler.getCutAction().getValue("Name"), action);
        map.put(TransferHandler.getCopyAction().getValue("Name"), action);
        map.put(TransferHandler.getPasteAction().getValue("Name"), action);
    }

    public void updateView() {
        this.model.fireTableDataChanged();
        if (this.selectedMember != null) {
            String customerLabel = this.doGenarateCustomerLabel(this.selectedMember);
            this.btnSelectMember.setText(customerLabel);
        }
    }

    private void updateSeatTotal() {
        double seatTotal = 0.0;
        for (ITicketItem item : this.model.getRows()) {
            TicketItem ticketItem = (TicketItem)item;
            seatTotal += ticketItem.getTotalAmount().doubleValue();
        }
        String dueAmountString = NumberUtil.formatNumber(seatTotal, true);
        this.tfSeatTotal.setText(CurrencyUtil.getCurrencySymbol() + dueAmountString);
    }

    public void updateModel() {
        for (ITicketItem item : this.model.getRows()) {
            TicketItem ticketItem = (TicketItem)item;
            if (this.shopSeat == null) {
                ticketItem.setSeat(null);
                ticketItem.setSeatNumber(null);
                continue;
            }
            if (this.seatItem != null) {
                this.seatItem.setShopSeat(this.shopSeat);
                this.seatItem.setMember(this.selectedMember);
                ticketItem.setSeat(this.seatItem);
                ticketItem.setSeatNumber(this.seatItem.getSeatNumber());
                continue;
            }
            this.seatItem = this.shopSeat.convertTicketItemSeat();
            this.seatItem.setMember(this.selectedMember);
            ticketItem.setSeat(this.seatItem);
            ticketItem.setSeatNumber(this.seatItem.getSeatNumber());
        }
    }

    private String doGenarateCustomerLabel(Customer selectedCustomer) {
        String labelCustomer = "";
        if (selectedCustomer != null) {
            labelCustomer = "<html><center>" + selectedCustomer.getName();
            if (selectedCustomer.getMemberShipType() != null) {
                labelCustomer = labelCustomer + "<br/>" + selectedCustomer.getMemberShipType();
            }
            labelCustomer = labelCustomer + "</center></html>";
        }
        return labelCustomer;
    }

    public ShopSeat getShopSeat() {
        return this.shopSeat;
    }

    public SeatOrganizeTableModel getModel() {
        return this.model;
    }

    public JTable getTable() {
        return this.table;
    }
}

