/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.tableselection;

import com.floreantpos.PosLog;
import com.floreantpos.extension.OrderServiceFactory;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.ext.ReorderType;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.util.TicketAlreadyExistsException;
import java.util.List;
import javax.swing.JPanel;

public abstract class TableSelectionView
extends JPanel
implements RefreshableView {
    protected OrderType orderType;
    protected Ticket ticket;
    private boolean createNewTicket = true;
    private boolean ticketTransferMode;
    private boolean homeViewMode;
    private boolean shouldReorder;
    private ReorderType reorderType;

    public void tablesSelected(OrderType orderType, List<ShopTable> selectedTables) {
        try {
            OrderServiceFactory.getOrderService().createNewTicket(orderType, selectedTables, null);
        }
        catch (TicketAlreadyExistsException e) {
            PosLog.error(this.getClass(), e);
        }
    }

    public abstract void rendererTables();

    public abstract List<ShopTable> getSelectedTables();

    public abstract void updateButtonsVisibility();

    public OrderType getOrderType() {
        return this.orderType;
    }

    public void setOrderType(OrderType orderType) {
        this.orderType = orderType;
    }

    public boolean isCreateNewTicket() {
        return this.createNewTicket;
    }

    public void setCreateNewTicket(boolean createNewTicket) {
        this.createNewTicket = createNewTicket;
    }

    public void setTicket(Ticket ticket) {
        this.ticket = ticket;
    }

    public Ticket getTicket() {
        return this.ticket;
    }

    public boolean isTicketTransferMode() {
        return this.ticketTransferMode;
    }

    public void setTicketTransferMode(boolean ticketTransferMode) {
        this.ticketTransferMode = ticketTransferMode;
    }

    public boolean isHomeViewMode() {
        return this.homeViewMode;
    }

    public void setHomeViewMode(boolean homeViewMode) {
        this.homeViewMode = homeViewMode;
    }

    public boolean shouldGuestCheck() {
        return false;
    }

    public void setShouldReorder(boolean shouldReorder) {
        this.shouldReorder = shouldReorder;
    }

    public boolean shouldReorder() {
        return this.shouldReorder;
    }

    public boolean shouldSettle() {
        return false;
    }

    public ReorderType getReorderType() {
        return this.reorderType;
    }

    public void setReorderType(ReorderType reorderType) {
        this.reorderType = reorderType;
    }

    public void clearSelection() {
    }
}

