/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.ticket;

import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemCookingInstruction;
import com.floreantpos.model.TicketItemDiscount;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.util.DataProvider;
import java.util.List;
import java.util.Map;

public class TicketItemRowCreator {
    public static void calculateTicketRows(Ticket ticket, Map<String, ITicketItem> tableRows) {
        TicketItemRowCreator.calculateTicketRows(ticket, tableRows, true, true, true);
    }

    public static void calculateTicketRows(Ticket ticket, Map<String, ITicketItem> tableRows, boolean includeVoidItems) {
        TicketItemRowCreator.calculateTicketRows(ticket, tableRows, true, true, true, includeVoidItems);
    }

    public static void calculateTicketRows(Ticket ticket, Map<String, ITicketItem> tableRows, boolean includeModifiers, boolean includeCookingInstructions) {
        TicketItemRowCreator.calculateTicketRows(ticket, tableRows, true, true, true);
    }

    public static void calculateTicketRows(Ticket ticket, Map<String, ITicketItem> tableRows, boolean includeModifiers, boolean includeCookingInstructions, boolean includeDiscounts) {
        TicketItemRowCreator.calculateTicketRows(ticket, tableRows, includeModifiers, includeCookingInstructions, includeDiscounts, true);
    }

    public static void calculateTicketRows(Ticket ticket, Map<String, ITicketItem> tableRows, boolean includeModifiers, boolean includeCookingInstructions, boolean includeDiscounts, boolean includeVoidItems) {
        TicketItemRowCreator.calculateTicketRows(ticket, tableRows, includeModifiers, includeCookingInstructions, includeDiscounts, includeVoidItems, true, false);
    }

    public static void calculateTicketRows(Ticket ticket, Map<String, ITicketItem> tableRows, boolean includeModifiers, boolean includeCookingInstructions, boolean includeDiscounts, boolean includeVoidItems, boolean includeSeat, boolean suppressZerocostModifiers) {
        TicketItemRowCreator.calculateTicketRows(ticket, tableRows, includeModifiers, includeCookingInstructions, includeDiscounts, includeVoidItems, true, false, false);
    }

    public static void calculateTicketRows(Ticket ticket, Map<String, ITicketItem> tableRows, boolean includeModifiers, boolean includeCookingInstructions, boolean includeDiscounts, boolean includeVoidItems, boolean includeSeat, boolean suppressZerocostModifiers, boolean isCustomerReceipt) {
        tableRows.clear();
        int rowNum = 0;
        if (ticket == null || ticket.getTicketItems() == null) {
            return;
        }
        boolean showVoidedItemsOnTicket = DataProvider.get().getStore().isShowVoidedItemsOnTicket();
        List<TicketItem> ticketItems = ticket.getTicketItems();
        for (TicketItem ticketItem : ticketItems) {
            if (ticketItem == null || ticketItem.isTreatAsSeat().booleanValue() && !includeSeat || ticketItem.isVoided().booleanValue() && (!ticketItem.isItemReturned().booleanValue() || !includeVoidItems) && !showVoidedItemsOnTicket || isCustomerReceipt && ticketItem.isHideFromCustomerReceipt()) continue;
            ticketItem.setTableRowNum(rowNum);
            tableRows.put(String.valueOf(rowNum), ticketItem);
            ++rowNum;
            if (includeModifiers) {
                rowNum = TicketItemRowCreator.includeModifiers(ticketItem, tableRows, rowNum, false, suppressZerocostModifiers);
            }
            if (includeDiscounts) {
                rowNum = TicketItemRowCreator.includeDiscounts(ticketItem, tableRows, rowNum);
            }
            if (!includeCookingInstructions) continue;
            rowNum = TicketItemRowCreator.includeCookintInstructions(ticketItem, tableRows, rowNum);
        }
    }

    private static int includeCookintInstructions(TicketItem ticketItem, Map<String, ITicketItem> tableRows, int rowNum) {
        List<TicketItemCookingInstruction> cookingInstructions = ticketItem.getCookingInstructions();
        if (cookingInstructions != null) {
            for (TicketItemCookingInstruction ticketItemCookingInstruction : cookingInstructions) {
                ticketItemCookingInstruction.setTableRowNum(rowNum);
                tableRows.put(String.valueOf(rowNum), ticketItemCookingInstruction);
                ++rowNum;
            }
        }
        return rowNum;
    }

    private static int includeDiscounts(TicketItem ticketItem, Map<String, ITicketItem> tableRows, int rowNum) {
        List<TicketItemDiscount> discounts = ticketItem.getDiscounts();
        if (discounts != null) {
            for (TicketItemDiscount ticketItemDiscount : discounts) {
                if (ticketItemDiscount.getType() == 2) continue;
                ticketItemDiscount.setTableRowNum(rowNum);
                tableRows.put(String.valueOf(rowNum), ticketItemDiscount);
                ++rowNum;
            }
        }
        return rowNum;
    }

    private static int includeModifiers(TicketItem ticketItem, Map<String, ITicketItem> tableRows, int rowNum, boolean kitchenPrint, boolean suppreesZerocostModifiers) {
        List<TicketItemModifier> ticketItemModifiers = ticketItem.getTicketItemModifiers();
        if (ticketItemModifiers != null && ticketItemModifiers.size() > 0) {
            for (TicketItemModifier itemModifier : ticketItemModifiers) {
                if (kitchenPrint && (itemModifier.isPrintedToKitchen().booleanValue() || !itemModifier.isShouldPrintToKitchen().booleanValue()) || suppreesZerocostModifiers && itemModifier.getUnitPrice() == 0.0) continue;
                itemModifier.setTableRowNum(rowNum);
                tableRows.put(String.valueOf(rowNum), itemModifier);
                ++rowNum;
            }
        }
        return rowNum;
    }
}

