/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.ticket;

import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.ui.ticket.VoidTicketItemViewerTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class VoidTicketItemViewerTable
extends JTable {
    private VoidTicketItemViewerTableModel model = new VoidTicketItemViewerTableModel(this);
    private DefaultListSelectionModel selectionModel;
    private final DefaultTableCellRenderer cellRenderer;

    public VoidTicketItemViewerTable() {
        this((Ticket)null);
    }

    public VoidTicketItemViewerTable(Ticket ticket) {
        this.setModel(this.model);
        this.selectionModel = new DefaultListSelectionModel();
        this.selectionModel.setSelectionMode(0);
        this.setGridColor(Color.LIGHT_GRAY);
        this.setSelectionModel(this.selectionModel);
        this.setAutoscrolls(true);
        this.setShowGrid(true);
        this.setBorder(null);
        this.setFocusable(false);
        this.cellRenderer = new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                ITicketItem ticketItem;
                Component rendererComponent = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                VoidTicketItemViewerTableModel model = (VoidTicketItemViewerTableModel)table.getModel();
                Object object = model.get(row);
                if (column == 0) {
                    this.setHorizontalAlignment(2);
                } else {
                    this.setHorizontalAlignment(4);
                }
                if (isSelected) {
                    return rendererComponent;
                }
                rendererComponent.setBackground(table.getBackground());
                if (object instanceof ITicketItem && (ticketItem = (ITicketItem)object).isPrintedToKitchen().booleanValue()) {
                    rendererComponent.setBackground(Color.YELLOW);
                }
                return rendererComponent;
            }
        };
        this.setRowHeight(50);
        this.resizeTableColumns();
        this.setTicket(ticket);
    }

    private void resizeTableColumns() {
        this.setAutoResizeMode(4);
    }

    public void setTicket(Ticket ticket) {
        this.model.setTicket(ticket);
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        return this.cellRenderer;
    }

    public DefaultTableCellRenderer getRenderer() {
        return this.cellRenderer;
    }

    public Ticket getTicket() {
        return this.model.getTicket();
    }

    public void updateView() {
        int selectedRow = this.getSelectedRow();
        this.model.update();
        try {
            this.getSelectionModel().setSelectionInterval(selectedRow, selectedRow);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean isTicketNull() {
        Ticket ticket = this.getTicket();
        if (ticket == null) {
            return true;
        }
        return ticket.getTicketItems() == null;
    }

    public void scrollUp() {
        int rowCount;
        if (this.isTicketNull()) {
            return;
        }
        int selectedRow = this.getSelectedRow();
        if (selectedRow > (rowCount = this.model.getItemCount()) - 1) {
            return;
        }
        if (--selectedRow < 0) {
            selectedRow = 0;
        }
        this.selectionModel.addSelectionInterval(selectedRow, selectedRow);
        Rectangle cellRect = this.getCellRect(selectedRow, 0, false);
        this.scrollRectToVisible(cellRect);
    }

    public void scrollDown() {
        if (this.isTicketNull()) {
            return;
        }
        int selectedRow = this.getSelectedRow();
        if (selectedRow >= this.model.getItemCount() - 1) {
            return;
        }
        this.selectionModel.addSelectionInterval(++selectedRow, selectedRow);
        Rectangle cellRect = this.getCellRect(selectedRow, 0, false);
        this.scrollRectToVisible(cellRect);
    }

    public ITicketItem get(int index) {
        return (ITicketItem)this.model.get(index);
    }

    public ITicketItem getSelected() {
        int index = this.getSelectedRow();
        return (ITicketItem)this.model.get(index);
    }

    public void addTicketItem(TicketItem ticketItem) {
        int addTicketItem;
        ticketItem.setTicket(this.getTicket());
        int actualRowCount = addTicketItem = this.model.addTicketItem(ticketItem);
        this.selectionModel.addSelectionInterval(actualRowCount, actualRowCount);
        Rectangle cellRect = this.getCellRect(actualRowCount, 0, false);
        this.scrollRectToVisible(cellRect);
    }

    public void delete(int index, boolean itemWasted) {
        this.model.delete(index, itemWasted);
    }

    public void deleteFromTicket(TicketItem ticketItem) {
        this.model.deleteFromTicket(ticketItem);
    }
}

