/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.ticket;

import com.floreantpos.Messages;
import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.ui.ticket.TicketItemRowCreator;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.lang.StringUtils;

public class VoidTicketItemViewerTableModel
extends AbstractTableModel {
    private JTable table;
    protected Ticket ticket;
    private double previousFractionalItemQuantity;
    protected final HashMap<String, ITicketItem> tableRows = new LinkedHashMap<String, ITicketItem>();
    private boolean priceIncludesTax = false;
    protected String[] columnNames = new String[]{Messages.getString("TicketViewerTableModel.0"), Messages.getString("TicketViewerTableModel.2"), Messages.getString("TicketViewerTableModel.3")};

    public VoidTicketItemViewerTableModel(JTable table) {
        this(table, null);
    }

    public VoidTicketItemViewerTableModel(JTable table, Ticket ticket) {
        this.table = table;
        this.setTicket(ticket);
    }

    public int getItemCount() {
        return this.tableRows.size();
    }

    @Override
    public int getRowCount() {
        int size = this.tableRows.size();
        return size;
    }

    public int getActualRowCount() {
        return this.tableRows.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ITicketItem ticketItem = this.tableRows.get(String.valueOf(rowIndex));
        if (ticketItem == null) {
            return null;
        }
        switch (columnIndex) {
            case 0: {
                return ticketItem.getNameDisplay();
            }
            case 1: {
                return ticketItem.getItemQuantityDisplay();
            }
            case 2: {
                return ticketItem.getSubTotalAmountDisplay();
            }
        }
        return null;
    }

    private void calculateRows() {
        TicketItemRowCreator.calculateTicketRows(this.ticket, this.tableRows, true);
        Collection<ITicketItem> items = this.tableRows.values();
        Iterator<ITicketItem> iterator = items.iterator();
        while (iterator.hasNext()) {
            ITicketItem item = iterator.next();
            if (this.ticket.isPaid().booleanValue() || this.ticket.isClosed().booleanValue() || item.isPrintedToKitchen().booleanValue()) continue;
            iterator.remove();
        }
    }

    public int addTicketItem(TicketItem ticketItem) {
        if (ticketItem.isHasModifiers().booleanValue()) {
            return this.addTicketItemToTicket(ticketItem);
        }
        Object[] values = this.tableRows.values().toArray();
        if (values == null || values.length == 0) {
            this.previousFractionalItemQuantity = ticketItem.getQuantity();
            return this.addTicketItemToTicket(ticketItem);
        }
        Object object = values[values.length - 1];
        if (object instanceof TicketItem) {
            TicketItem item = (TicketItem)object;
            if (StringUtils.isEmpty((String)ticketItem.getMenuItemId())) {
                return this.addTicketItemToTicket(ticketItem);
            }
            if (ticketItem.getMenuItemId().equals(item.getMenuItemId())) {
                this.previousFractionalItemQuantity = item.getQuantity();
                if (ticketItem.isFractionalUnit().booleanValue()) {
                    item.setFractionalUnit(true);
                    item.setQuantity(this.previousFractionalItemQuantity + ticketItem.getQuantity());
                    this.previousFractionalItemQuantity = item.getQuantity();
                } else {
                    item.setQuantity(item.getQuantity() + 1.0);
                }
                return values.length - 1;
            }
        }
        this.previousFractionalItemQuantity = ticketItem.getQuantity();
        return this.addTicketItemToTicket(ticketItem);
    }

    private int addTicketItemToTicket(TicketItem ticketItem) {
        this.ticket.addToticketItems(ticketItem);
        this.calculateRows();
        this.fireTableDataChanged();
        return this.tableRows.size() - 1;
    }

    public void addAllTicketItem(TicketItem ticketItem) {
        if (ticketItem.isHasModifiers().booleanValue()) {
            List<TicketItem> ticketItems = this.ticket.getTicketItems();
            ticketItems.add(ticketItem);
            this.calculateRows();
            this.fireTableDataChanged();
        } else {
            List<TicketItem> ticketItems = this.ticket.getTicketItems();
            boolean exists = false;
            for (TicketItem item : ticketItems) {
                if (!item.getName().equals(ticketItem.getName())) continue;
                double itemCount = item.getQuantity();
                item.setQuantity(itemCount += ticketItem.getQuantity().doubleValue());
                exists = true;
                this.table.repaint();
                return;
            }
            if (!exists) {
                this.ticket.addToticketItems(ticketItem);
                this.calculateRows();
                this.fireTableDataChanged();
            }
        }
    }

    public boolean containsTicketItem(TicketItem ticketItem) {
        if (ticketItem.isHasModifiers().booleanValue()) {
            return false;
        }
        List<TicketItem> ticketItems = this.ticket.getTicketItems();
        for (TicketItem item : ticketItems) {
            if (!item.getName().equals(ticketItem.getName())) continue;
            return true;
        }
        return false;
    }

    public Object delete(int index, boolean itemWasted) {
        if (index < 0 || index >= this.tableRows.size()) {
            return null;
        }
        ITicketItem object = this.tableRows.get(String.valueOf(index));
        if (object instanceof TicketItem) {
            TicketItem ticketItem = (TicketItem)object;
            int rowNum = ticketItem.getTableRowNum();
            List<TicketItem> ticketItems = this.ticket.getTicketItems();
            Iterator<TicketItem> iter = ticketItems.iterator();
            while (iter.hasNext()) {
                TicketItem item = iter.next();
                if (item.getTableRowNum() != rowNum) continue;
                iter.remove();
                if (itemWasted) break;
                this.ticket.addDeletedItems(item);
                break;
            }
        }
        this.calculateRows();
        this.fireTableDataChanged();
        return object;
    }

    public Object get(int index) {
        if (index < 0 || index >= this.tableRows.size()) {
            return null;
        }
        return this.tableRows.get(String.valueOf(index));
    }

    public Ticket getTicket() {
        return this.ticket;
    }

    public void setTicket(Ticket ticket) {
        this.ticket = ticket;
        this.update();
    }

    public void update() {
        this.calculateRows();
        this.fireTableDataChanged();
    }

    public boolean isPriceIncludesTax() {
        return this.priceIncludesTax;
    }

    public void setPriceIncludesTax(boolean priceIncludesTax) {
        this.priceIncludesTax = priceIncludesTax;
    }

    public void deleteFromTicket(TicketItem ticketItem) {
        if (this.ticket != null) {
            this.ticket.addDeletedItems(ticketItem);
        }
    }
}

