/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.ticket.returnui;

import com.floreantpos.PosException;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.ticket.returnui.TicketPanel;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.RootView;
import java.awt.BorderLayout;
import java.awt.HeadlessException;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class ItemReturnDialog
extends OkCancelOptionDialog {
    private TicketPanel ticketPanel;

    public ItemReturnDialog(Ticket ticket) throws HeadlessException {
        this.setTitle("Return");
        this.setCaption("Please select items to return");
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.add(contentPane);
        ticket = TicketDAO.getInstance().loadFullTicket(ticket.getId());
        this.ticketPanel = new TicketPanel(ticket);
        contentPane.add(this.ticketPanel);
        this.setDefaultCloseOperation(2);
        this.setSize(700, 750);
    }

    @Override
    public void doOk() {
        try {
            Ticket ticket = this.ticketPanel.performReturn();
            if (ticket.getDueAmount() > 0.0) {
                throw new PosException("Please select item to return");
            }
            ticket.calculatePrice();
            ticket.setClosed(false);
            ticket.setReOpened(true);
            OrderView.getInstance().setCurrentTicket(ticket);
            RootView rootView = RootView.getInstance();
            rootView.showView("ORDER_VIEW");
            rootView.getHeaderPanel().setReturnMode(true);
            this.setCanceled(false);
            this.dispose();
        }
        catch (PosException e) {
            POSMessageDialog.showError(e.getMessage());
        }
        catch (Exception e) {
            POSMessageDialog.showError(e.getMessage(), e);
        }
    }
}

