/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.ticket.returnui;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.Store;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.ticket.returnui.TicketItemPanel;
import com.floreantpos.ui.views.voidticket.VoidTicketItemDialog;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;

public class TicketPanel
extends JPanel {
    private Ticket ticket;
    private JPanel itemsPanel;
    private boolean itemSelected;
    private JCheckBox chkReturnCreditCardSurcharge;

    public TicketPanel(Ticket ticket) {
        this.ticket = ticket;
        this.setLayout(new BorderLayout(5, 5));
        JPanel header = new JPanel((LayoutManager)new MigLayout("ins 0"));
        header.add((Component)new JLabel("Item"), "grow, w " + PosUIManager.getSize(200) + "!");
        header.add((Component)new JLabel("Quantity", 0), "grow, w " + PosUIManager.getSize(200) + "!");
        header.add((Component)new JSeparator(0), "newline, grow, span 2, w " + PosUIManager.getSize(430) + "!");
        this.add((Component)header, "North");
        this.itemsPanel = new JPanel((LayoutManager)new MigLayout("wrap 1, ins 0"));
        PosScrollPane scrollPane = new PosScrollPane(this.itemsPanel);
        scrollPane.setBorder(null);
        this.add((Component)scrollPane, "Center");
        boolean hasCreditCardTransaction = ticket.hasCreditCardTransaction();
        this.chkReturnCreditCardSurcharge = new JCheckBox("Return credit card surcharge");
        this.chkReturnCreditCardSurcharge.setVisible(hasCreditCardTransaction);
        this.chkReturnCreditCardSurcharge.setSelected(hasCreditCardTransaction);
        this.add((Component)this.chkReturnCreditCardSurcharge, "South");
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(1, 2020);
        calendar.set(2, 3);
        calendar.set(5, 15);
        List<TicketItem> ticketItems = ticket.getTicketItems();
        for (TicketItem ticketItem : ticketItems) {
            if (ticketItem.isTreatAsSeat().booleanValue() || ticketItem.isVoided().booleanValue() || ticketItem.isItemReturned().booleanValue()) continue;
            if (!ticketItem.isPaid() && ticket.getDueAmount() <= 0.0) {
                ticketItem.setPaid(true);
            }
            if (ticketItem.getMenuItemName().equals("CC Surcharge")) continue;
            TicketItemPanel ticketItemPanel = new TicketItemPanel(ticketItem);
            this.itemsPanel.add(ticketItemPanel);
        }
    }

    public Ticket performReturn() {
        Component[] components = this.itemsPanel.getComponents();
        ArrayList<TicketItem> toBeReturnedItems = new ArrayList<TicketItem>();
        this.itemSelected = false;
        for (Component component : components) {
            TicketItemPanel ticketItemPanel;
            if (!(component instanceof TicketItemPanel) || !(ticketItemPanel = (TicketItemPanel)component).isReturnSelected()) continue;
            TicketItem ticketItem = ticketItemPanel.getTicketItem();
            double returnQuantity = ticketItemPanel.getReturnQuantity();
            TicketItem returnItem = VoidTicketItemDialog.returnItem(this.ticket, ticketItem, returnQuantity, "Return", false);
            returnItem.calculatePrice();
            toBeReturnedItems.add(returnItem);
        }
        Double totalReturnAmount = 0.0;
        this.itemSelected = toBeReturnedItems.size() > 0;
        for (TicketItem ticketItem : toBeReturnedItems) {
            totalReturnAmount = totalReturnAmount + Math.abs(ticketItem.getTotalAmount());
            this.ticket.addToticketItems(ticketItem);
        }
        if (!toBeReturnedItems.isEmpty()) {
            String stringTicketItemIds = POSUtil.createStringByField(toBeReturnedItems, TicketItem.class, "getVoidedItemId", true);
            if (this.chkReturnCreditCardSurcharge.isSelected()) {
                this.calculateSurchargeReturnAmount(totalReturnAmount, stringTicketItemIds);
            }
        }
        return this.ticket;
    }

    private double calculateSurchargeReturnAmount(double tenderAmount, String ticketItemIds) {
        if (this.ticket == null) {
            return 0.0;
        }
        Store store = DataProvider.get().getStore();
        if (this.ticket.getOrderType().isApplyCreditCardSurcharge() && store.isEnableCreditCardSurcharge()) {
            Double percentagesAmountByCardType = store.getPercentagesAmountByCardType(this.ticket.getCreditCardType());
            double surchargeAmount = NumberUtil.round(tenderAmount * (percentagesAmountByCardType / 100.0));
            if (surchargeAmount > this.ticket.getTotalSurchargeAmount()) {
                surchargeAmount = this.ticket.getTotalSurchargeAmount();
            }
            this.ticket.setTotalSurchargeAmount(this.ticket.getTotalSurchargeAmount() - surchargeAmount);
            this.ticket.addToticketItems(this.createTicketItem(surchargeAmount, ticketItemIds));
            this.ticket.calculatePrice();
            return surchargeAmount;
        }
        return 0.0;
    }

    public boolean isItemSelected() {
        return this.itemSelected;
    }

    public TicketItem createTicketItem(double surchargeAmount, String ticketItemIds) {
        TicketItem ticketItem = new TicketItem();
        ticketItem.setTaxIncluded(false);
        ticketItem.setQuantity(-1.0);
        MenuItem menuItem = MenuItemDAO.getInstance().findByName("CC Surcharge");
        if (menuItem == null) {
            throw new PosException(Messages.getString("NO_ITEM_FOUND_WITH_NAME") + "CC Surcharge");
        }
        ticketItem.setMenuItemId(menuItem.getId());
        ticketItem.setName(menuItem.getName());
        ticketItem.setUnitPrice(surchargeAmount);
        ticketItem.setSubtotalAmount(surchargeAmount);
        ticketItem.setTotalAmount(surchargeAmount);
        ticketItem.setRefundItemIds(ticketItemIds);
        ticketItem.setTicket(this.ticket);
        return ticketItem;
    }
}

