/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views;

import com.floreantpos.Messages;
import com.floreantpos.actions.PosAction;
import com.floreantpos.actions.ShowGiftCardAction;
import com.floreantpos.actions.ShowKitchenDisplayAction;
import com.floreantpos.actions.ShowLineDisplayAction;
import com.floreantpos.actions.ShowPriceCheckAction;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.FloreantPlugin;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;

public class ExtraFunctionalitiesDialog
extends POSDialog {
    private static ExtraFunctionalitiesDialog instance = null;
    private JPanel contentPanel;

    public ExtraFunctionalitiesDialog() {
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout(10, 10));
        this.contentPanel = new JPanel(new FlowLayout(1, 10, 10));
        this.contentPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        ArrayList<PosAction> actions = new ArrayList<PosAction>();
        if (DataProvider.get().getStore().isKDSenabled()) {
            actions.add((PosAction)new ShowKitchenDisplayAction());
        }
        actions.add((PosAction)new ShowLineDisplayAction());
        actions.add(new ShowGiftCardAction());
        actions.add(new ShowPriceCheckAction());
        this.pluginActions(actions);
        Dimension size = PosUIManager.getSize(150, 150);
        for (final PosAction action : actions) {
            PosButton button = new PosButton("<html><p style='text-align: center;'>" + (String)action.getValue("Name") + "</p></html>");
            button.setPreferredSize(size);
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        ExtraFunctionalitiesDialog.this.dispose();
                        action.execute();
                    }
                    catch (Exception e2) {
                        POSMessageDialog.showError(e2.getMessage(), e2);
                    }
                }
            });
            this.contentPanel.add(button);
        }
        JScrollPane scrollPane = new JScrollPane(this.contentPanel);
        scrollPane.setBorder(null);
        this.add(scrollPane);
        PosButton btnClose = new PosButton(Messages.getString("Close"));
        btnClose.addActionListener(this.dialogCloseAction());
        this.add((Component)btnClose, "South");
    }

    private void pluginActions(List<PosAction> actions) {
        List plugins = ExtensionManager.getPlugins();
        if (plugins != null) {
            for (FloreantPlugin plugin : plugins) {
                List posActions = plugin.getSpecialFunctionActions();
                if (posActions == null) continue;
                for (AbstractAction action : posActions) {
                    actions.add((PosAction)action);
                }
            }
        }
    }

    private ActionListener dialogCloseAction() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtraFunctionalitiesDialog.this.dispose();
            }
        };
    }

    public JPanel getContentPanel() {
        return this.contentPanel;
    }

    public static ExtraFunctionalitiesDialog getInstance() {
        if (instance == null) {
            instance = new ExtraFunctionalitiesDialog();
        }
        return instance;
    }
}

