/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.actions.CloseDialogAction;
import com.floreantpos.actions.SettleTicketAction;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.GiftCard;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.OrderTypeDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.LargeComboBoxRenderer;
import com.floreantpos.swing.MessageDialog;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.QwertyKeyPad;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.payment.GiftCardProcessor;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class GiftCardAddBalanceView
extends POSDialog {
    private JTextField txtCardNumber;
    private DoubleTextField txtBalance;
    private GiftCard giftCard;
    private GiftCardProcessor giftCardProcessor;
    private JComboBox<OrderType> cbOrderType;

    public GiftCardAddBalanceView(GiftCardProcessor giftCardProcessor) {
        this(giftCardProcessor, null);
    }

    public GiftCardAddBalanceView(GiftCardProcessor giftCardProcessor, GiftCard giftCard) {
        this.giftCardProcessor = giftCardProcessor;
        this.giftCard = giftCard;
        this.init();
        this.initData();
        this.updateView();
    }

    public GiftCardAddBalanceView(JFrame parent) {
        super(parent);
        this.init();
        this.initData();
        this.updateView();
    }

    private void updateView() {
        String orderTypeId = TerminalConfig.getGiftOrdertype();
        ComboBoxModel model = (ComboBoxModel)this.cbOrderType.getModel();
        List dataList = model.getDataList();
        for (OrderType orderType : dataList) {
            if (!orderType.getId().equals(orderTypeId)) continue;
            this.cbOrderType.setSelectedItem(orderType);
            break;
        }
        if (this.giftCard != null) {
            this.txtCardNumber.setText(this.giftCard.getCardNumber());
        }
    }

    private void initData() {
        List<OrderType> orderTypes = OrderTypeDAO.getInstance().findAll();
        ComboBoxModel cbModel = new ComboBoxModel();
        for (OrderType orderType : orderTypes) {
            cbModel.addElement(orderType);
        }
        this.cbOrderType.setModel(cbModel);
    }

    private void init() {
        JPanel topPanel = new JPanel((LayoutManager)new MigLayout("fillx"));
        TitlePanel titlePanel = new TitlePanel();
        this.cbOrderType = new JComboBox();
        this.cbOrderType.setRenderer(new LargeComboBoxRenderer(50));
        titlePanel.setTitle(Messages.getString("AddBalance"));
        topPanel.add((Component)titlePanel, "span, grow, wrap");
        topPanel.add((Component)new JLabel(Messages.getString("OrderType")), "gapleft 40,split");
        topPanel.add(this.cbOrderType, "w 250!, left");
        this.add((Component)topPanel, "North");
        JPanel centerPanel = new JPanel((LayoutManager)new MigLayout("fillx", "[][]", ""));
        JLabel lblNumberOfCard = new JLabel(Messages.getString("CardNumber"));
        this.txtCardNumber = new JTextField(20);
        JLabel lblBalance = new JLabel(Messages.getString("Balance"));
        this.txtBalance = new DoubleTextField(20);
        centerPanel.add((Component)lblNumberOfCard, "alignx right");
        centerPanel.add((Component)this.txtCardNumber, "w 250!, wrap");
        centerPanel.add((Component)lblBalance, "alignx right");
        centerPanel.add((Component)this.txtBalance, "w 250!,wrap");
        QwertyKeyPad keyPad = new QwertyKeyPad();
        centerPanel.add((Component)((Object)keyPad), "gaptop 10, growx, span 2, wrap");
        this.add((Component)centerPanel, "Center");
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("al center", "sg, fill", ""));
        PosButton btnGenerate = new PosButton(Messages.getString("DONE"));
        buttonPanel.add((Component)btnGenerate, "grow");
        btnGenerate.addActionListener(e -> this.doGenerate());
        buttonPanel.add(new PosButton(new CloseDialogAction(this, Messages.getString("CANCEL"))));
        this.add((Component)buttonPanel, "South");
    }

    public void doGenerate() {
        try {
            if (this.save()) {
                this.dispose();
            }
        }
        catch (PosException e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage());
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage());
        }
    }

    private boolean save() {
        String cardNo = this.txtCardNumber.getText();
        double balance = this.txtBalance.getDoubleOrZero();
        OrderType orderType = (OrderType)this.cbOrderType.getSelectedItem();
        this.giftCard = this.giftCardProcessor.getCard(cardNo);
        if (this.giftCard == null) {
            POSMessageDialog.showMessage(this, Messages.getString("GiftCardAddBalanceView.16"));
            return false;
        }
        if (StringUtils.isEmpty((String)cardNo)) {
            MessageDialog.showError(Messages.getString("EnterCardNumber"));
            return false;
        }
        if (this.giftCard.isExpried()) {
            MessageDialog.showError(Messages.getString("GiftCardAddBalanceView.0"));
            return false;
        }
        if (balance == 0.0) {
            MessageDialog.showError(Messages.getString("GiftCardAddBalanceView.18"));
            return false;
        }
        if (!this.giftCard.isActive().booleanValue()) {
            MessageDialog.showError(Messages.getString("GiftCardAddBalanceView.19"));
            return false;
        }
        if (orderType == null) {
            POSMessageDialog.showMessage(this, Messages.getString("GiftCardAddBalanceView.5"));
            return false;
        }
        TerminalConfig.setGiftOrdertype(orderType.getId());
        Ticket ticket = new Ticket(true);
        ticket.setOrderType(orderType);
        ticket.addTable(0);
        ticket.setHasGiftCard(true);
        ticket.setShouldIncludeInSales(false);
        if (orderType.getSalesArea() != null) {
            ticket.setSalesArea(orderType.getSalesArea());
        } else if (DataProvider.get().getCurrentTerminal().getSalesArea() != null) {
            ticket.setSalesArea(DataProvider.get().getCurrentTerminal().getSalesArea());
        }
        MenuItem giftCard = MenuItemDAO.getInstance().findByName("Gift Card");
        TicketItem ticketItem = null;
        if (giftCard != null) {
            ticketItem = giftCard.convertToTicketItem(ticket, 1.0);
        }
        if (ticketItem == null) {
            ticketItem = new TicketItem();
            ticketItem.setTicket(ticket);
        }
        ticketItem.setItemIsGiftCard(cardNo, balance);
        ticket.addToticketItems(ticketItem);
        ticket.calculatePrice();
        return new SettleTicketAction(ticket).performSettle();
    }
}

