/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views;

import com.floreantpos.Messages;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.dao.OrderTypeDAO;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.PosTable;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableColumnModel;

public class OrderTypeSelectionView
extends JPanel {
    private PosTable table;
    private OrderTypeTableModel tableModel;
    private Map<String, OrderType> addedOrderTypeMap = new HashMap<String, OrderType>();
    private POSDialog dialog;

    public OrderTypeSelectionView(List<OrderType> addedOrderTypes, POSDialog dialog) {
        this.dialog = dialog;
        this.initComponents();
        this.setSelectedItems(addedOrderTypes);
        List<OrderType> values = OrderTypeDAO.getInstance().findAll();
        this.tableModel.setRows(values);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout(5, 5));
        this.tableModel = new OrderTypeTableModel();
        this.tableModel.setColumnNames(new String[]{"-", Messages.getString("ORDER_TYPE")});
        this.table = new PosTable();
        this.table.setModel(this.tableModel);
        this.table.setSelectionMode(2);
        this.table.setRowHeight(PosUIManager.getSize(40));
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 2) {
                    OrderTypeSelectionView.this.doSelectedRowOnDubbleClick();
                } else {
                    OrderTypeSelectionView.this.selectItem();
                }
            }
        });
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.setBorder(new EmptyBorder(10, 5, 10, 5));
        JScrollPane scroll = new JScrollPane((Component)((Object)this.table));
        scroll.setPreferredSize(PosUIManager.getSize(500, 400));
        contentPanel.add(scroll);
        this.add(contentPanel);
        this.resizeColumnWidth((JTable)((Object)this.table));
    }

    public List<OrderType> getSelectedOrderTypeList() {
        return new ArrayList<OrderType>(this.addedOrderTypeMap.values());
    }

    public void setSelectedItems(List<OrderType> orderTypes) {
        if (orderTypes != null) {
            for (OrderType item : orderTypes) {
                this.addedOrderTypeMap.put(item.getId(), item);
            }
        }
    }

    public void resizeColumnWidth(JTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        for (int column = 0; column < table.getColumnCount(); ++column) {
            columnModel.getColumn(column).setPreferredWidth((Integer)this.getColumnWidth().get(column));
        }
    }

    private List getColumnWidth() {
        ArrayList<Integer> columnWidth = new ArrayList<Integer>();
        columnWidth.add(30);
        columnWidth.add(280);
        return columnWidth;
    }

    private void doSelectedRowOnDubbleClick() {
        try {
            if (this.dialog != null) {
                if (this.table.getSelectedRow() < 0) {
                    return;
                }
                this.dialog.setCanceled(false);
                this.dialog.dispose();
            }
        }
        catch (Throwable x) {
            POSMessageDialog.showError(this, x.getMessage(), x);
        }
    }

    private void selectItem() {
        if (this.table.getSelectedRow() < 0) {
            return;
        }
        int selectedRow = this.table.getSelectedRow();
        OrderType item = (OrderType)this.tableModel.getRowData(selectedRow = this.table.convertRowIndexToModel(selectedRow));
        if (this.addedOrderTypeMap.containsKey(item.getId())) {
            this.addedOrderTypeMap.remove(item.getId());
        } else {
            this.addedOrderTypeMap.put(item.getId(), item);
        }
        this.table.repaint();
    }

    public class OrderTypeTableModel
    extends ListTableModel<OrderType> {
        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            OrderType orderType = (OrderType)this.getRowData(rowIndex);
            OrderType storedItem = (OrderType)OrderTypeSelectionView.this.addedOrderTypeMap.get(orderType.getId());
            switch (columnIndex) {
                case 0: {
                    return storedItem != null;
                }
                case 1: {
                    return orderType.getName();
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 0;
        }

        public Class getColumnClass(int col) {
            switch (col) {
                case 0: {
                    return Boolean.class;
                }
                case 1: {
                    return String.class;
                }
            }
            throw new InternalError();
        }
    }
}

