/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views;

import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.FloorLayoutPlugin;
import com.floreantpos.model.OrderType;
import com.floreantpos.ui.tableselection.DefaultTableSelectionView;
import com.floreantpos.ui.tableselection.TableSelectionView;
import com.floreantpos.ui.views.order.ViewPanel;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.util.Locale;

public class TableLayoutView
extends ViewPanel {
    public static final String VIEW_NAME = "TABLE_MAP";
    private TableSelectionView tableSelectionView = null;
    private static TableLayoutView instance;

    private TableLayoutView() {
        this.initComponents();
        this.applyComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        FloorLayoutPlugin floorLayoutPlugin = (FloorLayoutPlugin)ExtensionManager.getPlugin(FloorLayoutPlugin.class);
        this.tableSelectionView = floorLayoutPlugin == null ? DefaultTableSelectionView.getInstance() : floorLayoutPlugin.createTableSelector();
        this.tableSelectionView.setCreateNewTicket(true);
        this.tableSelectionView.updateButtonsVisibility();
        this.add((Component)this.tableSelectionView, "Center");
    }

    @Override
    public DataChangeListener getDataChangeListener() {
        return (DataChangeListener)((Object)this.tableSelectionView);
    }

    public void updateView() {
        this.tableSelectionView.rendererTables();
    }

    public static TableLayoutView getInstance() {
        if (instance == null) {
            instance = new TableLayoutView();
        }
        return instance;
    }

    private void ensureCorrectParent() {
        if (this.tableSelectionView.getParent() != this) {
            this.add((Component)this.tableSelectionView, "Center");
            this.revalidate();
            this.repaint();
        }
    }

    public static TableLayoutView getInstance(OrderType orderType) {
        TableLayoutView instance2 = TableLayoutView.getInstance();
        instance2.ensureCorrectParent();
        instance2.tableSelectionView.setOrderType(orderType);
        return instance2;
    }

    @Override
    public void refresh() {
        this.ensureCorrectParent();
        this.tableSelectionView.setHomeViewMode(Boolean.TRUE);
        this.tableSelectionView.setTicketTransferMode(Boolean.FALSE);
        this.tableSelectionView.updateButtonsVisibility();
        this.tableSelectionView.refresh();
    }

    @Override
    public String getViewName() {
        return VIEW_NAME;
    }

    public boolean shouldGuestCheck() {
        return this.tableSelectionView.shouldGuestCheck();
    }

    public boolean shouldSettle() {
        return this.tableSelectionView.shouldSettle();
    }

    public void clearSelection() {
        this.tableSelectionView.clearSelection();
    }
}

