/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.order;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuPage;
import com.floreantpos.model.MenuPageItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.MenuPageDAO;
import com.floreantpos.swing.PaginatedListModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.ScrollableFlowPanel;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.SelectionView;
import com.floreantpos.ui.views.order.actions.ItemSelectionListener;
import com.floreantpos.ui.views.order.actions.TicketEditListener;
import com.floreantpos.util.AsyncAction;
import com.floreantpos.versioning.VersionInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import org.hibernate.exception.JDBCConnectionException;

public class MenuItemView
extends SelectionView
implements TicketEditListener {
    public static final String VIEW_NAME = "ITEM_VIEW";
    private Vector<ItemSelectionListener> listenerList = new Vector();
    private MenuGroup menuGroup;
    private ScrollableFlowPanel variantsPanel;

    public MenuItemView() {
        super(POSConstants.ITEMS, new FlowLayout(), PosUIManager.getSize(TerminalConfig.getMenuItemButtonWidth()), PosUIManager.getSize(TerminalConfig.getMenuItemButtonHeight()));
        this.dataModel = new PaginatedListModel();
        this.btnPrev.setText("<< " + Messages.getString("MenuItemView.1"));
        this.btnNext.setText(Messages.getString("MenuItemView.2") + ">>");
    }

    public MenuGroup getMenuGroup() {
        return this.menuGroup;
    }

    public void setMenuGroup(final MenuGroup menuGroup) {
        if (menuGroup != null && menuGroup.equals(this.menuGroup)) {
            return;
        }
        this.menuGroup = menuGroup;
        this.reset();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Application.getPosWindow().setCursor(Cursor.getPredefinedCursor(3));
                    MenuItemView.this.loadAndRenderItems(menuGroup);
                }
                finally {
                    Application.getPosWindow().setCursor(Cursor.getDefaultCursor());
                }
            }
        });
    }

    private void loadAndRenderItems(MenuGroup menuGroup) {
        if (menuGroup == null) {
            return;
        }
        try {
            Terminal terminal = Application.getInstance().getTerminal();
            this.dataModel.setPageSize(1);
            this.dataModel.setCurrentRowIndex(0);
            MenuPageDAO.getInstance().loadItems(terminal, menuGroup, this.getOrderType(), null, this.dataModel);
            this.setDataModel(this.dataModel);
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
    }

    @Override
    protected void renderItems() {
        this.reset();
        if (this.dataModel.getSize() == 0) {
            this.setTitle(POSConstants.ITEMS);
            this.revalidate();
            this.repaint();
            return;
        }
        this.btnPrev.setText("<< " + POSConstants.CAPITAL_PREV);
        MenuPage menuPage = (MenuPage)this.dataModel.getElementAt(0);
        this.setTitle(menuPage.getName());
        int rows = menuPage.getRows();
        int cols = menuPage.getCols();
        double widthPercentage = 100.0 / (double)rows;
        double heightPercentage = 100.0 / (double)cols;
        MigLayout migLayout = new MigLayout("hidemode 0, center,wrap " + cols);
        if (menuPage.isFlixibleButtonSize().booleanValue()) {
            migLayout.setLayoutConstraints((Object)"fill");
            migLayout.setColumnConstraints((Object)"fill,grow");
            migLayout.setRowConstraints((Object)"fill,grow");
        }
        this.selectionButtonsPanel.setLayout((LayoutManager)migLayout);
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < cols; ++col) {
                AbstractButton itemButton;
                String constraint = String.format("cell %s %s", col, row);
                constraint = menuPage.isFlixibleButtonSize() != false ? constraint + String.format(", w %s, h %s", widthPercentage, heightPercentage) : constraint + String.format(", w %s!, h %s!", menuPage.getButtonWidth(), menuPage.getButtonHeight());
                MenuPageItem itemForCell = menuPage.getItemForCell(col, row);
                if (itemForCell == null) {
                    this.selectionButtonsPanel.add((Component)new JLabel(), constraint);
                    continue;
                }
                if (!itemForCell.isVisible().booleanValue() || (itemButton = this.createItemButton(itemForCell)) == null) continue;
                this.selectionButtonsPanel.add((Component)itemButton, constraint);
            }
        }
        this.revalidate();
        this.repaint();
        this.btnNext.setVisible(this.dataModel.hasNext());
        this.btnPrev.setVisible(this.dataModel.hasPrevious());
    }

    public void rendererVariants(MenuItem parentItem) {
        List<MenuItem> variants = parentItem.getVariants();
        this.reset();
        this.variantsPanel = new ScrollableFlowPanel();
        this.selectionButtonsPanel.setLayout((LayoutManager)new MigLayout("fill"));
        for (MenuItem variant : variants) {
            AbstractButton itemButton = this.createItemButton(variant);
            if (itemButton == null) continue;
            this.variantsPanel.add(itemButton);
        }
        PosScrollPane scrollPane = new PosScrollPane(this.variantsPanel);
        scrollPane.setBorder(null);
        this.selectionButtonsPanel.add((Component)scrollPane, "span,grow");
        this.revalidate();
        this.repaint();
        this.btnNext.setVisible(false);
        this.btnPrev.setVisible(true);
        this.btnPrev.setText(Messages.getString("MenuItemView.10"));
        this.setTitle(parentItem.getName());
    }

    @Override
    protected AbstractButton createItemButton(Object item) {
        if (item instanceof MenuPageItem) {
            return new PageItemButton((MenuPageItem)item);
        }
        if (item instanceof MenuItem) {
            MenuItem menuItem = (MenuItem)item;
            if (!menuItem.isVisible().booleanValue()) {
                return null;
            }
            menuItem.setMenuGroup(this.menuGroup);
            ItemButton itemButton = new ItemButton(menuItem);
            return itemButton;
        }
        return null;
    }

    public void addItemSelectionListener(ItemSelectionListener listener) {
        this.listenerList.add(listener);
    }

    public void removeItemSelectionListener(ItemSelectionListener listener) {
        this.listenerList.remove(listener);
    }

    private void fireItemSelected(MenuItem foodItem) {
        for (ItemSelectionListener listener : this.listenerList) {
            listener.itemSelected(foodItem);
        }
    }

    @Override
    protected void scrollDown() {
        this.dataModel.setCurrentRowIndex(this.dataModel.getNextRowIndex());
        OrderType orderType = OrderView.getInstance().getCurrentTicket().getOrderType();
        MenuPageDAO.getInstance().loadItems(Application.getInstance().getTerminal(), this.menuGroup, orderType, (Boolean)false, this.dataModel);
        this.setDataModel(this.dataModel);
    }

    @Override
    protected void scrollUp() {
        if (this.btnPrev.getText().equals(Messages.getString("MenuItemView.10"))) {
            this.renderItems();
            return;
        }
        this.dataModel.setCurrentRowIndex(this.dataModel.getPreviousRowIndex());
        OrderType orderType = OrderView.getInstance().getCurrentTicket().getOrderType();
        MenuPageDAO.getInstance().loadItems(Application.getInstance().getTerminal(), this.menuGroup, orderType, (Boolean)false, this.dataModel);
        this.setDataModel(this.dataModel);
    }

    @Override
    public void itemAdded(Ticket ticket, ITicketItem item) {
        this.updateButtonStatus(item);
    }

    @Override
    public void itemRemoved(ITicketItem item) {
        this.updateButtonStatus(item);
    }

    private void updateButtonStatus(ITicketItem item) {
        if (item instanceof TicketItem) {
            TicketItem ticketItem = (TicketItem)item;
            if (ticketItem.isTreatAsSeat().booleanValue()) {
                return;
            }
            MenuItem menuItem = ticketItem.getMenuItem();
            if (menuItem == null) {
                return;
            }
            MenuItemDAO.getInstance().refresh(menuItem);
            if (menuItem.isAuto86Enabled()) {
                Component[] components;
                for (Component component : components = this.selectionButtonsPanel.getComponents()) {
                    if (component instanceof PageItemButton) {
                        PageItemButton button = (PageItemButton)component;
                        if (!button.pageItem.getMenuItem().equals(menuItem)) continue;
                        button.setEnabled(menuItem.isEnable());
                        break;
                    }
                    if (!(component instanceof PosScrollPane)) continue;
                    block1: for (Component panelComponent : this.variantsPanel.getComponents()) {
                        if (!(panelComponent instanceof JPanel)) continue;
                        JPanel panel = (JPanel)panelComponent;
                        for (Component variantComponent : panel.getComponents()) {
                            if (!(variantComponent instanceof ItemButton)) continue;
                            ItemButton button = (ItemButton)variantComponent;
                            if (!button.menuItem.equals(menuItem)) continue;
                            button.setEnabled(menuItem.isEnable());
                            continue block1;
                        }
                    }
                }
            }
        }
    }

    private class PageItemButton
    extends PosButton
    implements ActionListener,
    MouseListener {
        MenuItem menuItem;
        MenuPageItem pageItem;

        PageItemButton(MenuPageItem pageItem) {
            Color textColor;
            this.pageItem = pageItem;
            if (pageItem == null) {
                this.setVisible(false);
                return;
            }
            String buttonText = "<html><body><center>" + pageItem.getDisplayName() + "</center></body></html>";
            this.setText(buttonText);
            this.setVerticalTextPosition(3);
            this.setHorizontalTextPosition(0);
            this.setPreferredSize(MenuItemView.this.getButtonSize());
            Color buttonColor = pageItem.getButtonColor();
            if (buttonColor != null) {
                this.setBackground(buttonColor);
            }
            if ((textColor = pageItem.getTextColor()) != null) {
                this.setForeground(textColor);
            }
            this.addActionListener(this);
            this.addMouseListener(this);
            MenuItem item = this.pageItem.getMenuItem();
            this.setEnabled(item != null && item.isEnable() != false);
            AsyncAction.execute(() -> {
                ImageIcon image = pageItem.getImage();
                String text = "<html><body><center>" + pageItem.getDisplayName() + "</center></body></html>";
                if (image != null) {
                    if (pageItem.isShowImageOnly().booleanValue()) {
                        this.setIcon(image);
                        this.setText("");
                    } else {
                        this.setIcon(image);
                        this.setText(text);
                    }
                } else {
                    this.setText(text);
                }
            });
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (OrderView.getInstance().is_86Mode()) {
                return;
            }
            try {
                if (this.menuItem == null) {
                    this.menuItem = new MenuItem(this.pageItem.getMenuItemId());
                }
                this.menuItem.setEnable(true);
                MenuItemView.this.fireItemSelected(this.menuItem);
                this.setEnabled(this.menuItem.isEnable());
            }
            catch (JDBCConnectionException x) {
                POSMessageDialog.showError(Messages.getString("MenuItemView.12"));
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (OrderView.getInstance().is_86Mode()) {
                MenuItem menuItem = this.pageItem.getMenuItem();
                MenuItemDAO.getInstance().refresh(menuItem);
                if (menuItem.isEnable().booleanValue()) {
                    String option = POSMessageDialog.showOptionDialog(Application.getPosWindow(), Messages.getString("MenuItemView.0"), Messages.getString("PosMessage.297"), Messages.getString("MenuItemView.4"), Messages.getString("MenuItemView.5"), POSConstants.CANCEL);
                    if (option == null || option.equals(POSConstants.CANCEL)) {
                        return;
                    }
                    if (option.equals(Messages.getString("MenuItemView.4"))) {
                        menuItem.setEnable(menuItem.isEnable() == false);
                        this.setEnabled(menuItem.isEnable());
                        MenuItemDAO.getInstance().update(menuItem);
                        return;
                    }
                    if (option.equals(Messages.getString("MenuItemView.5"))) {
                        if (menuItem.isFractionalUnit().booleanValue()) {
                            POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("MenuItemView.6"));
                            return;
                        }
                        int value = (int)NumberSelectionDialog2.takeIntInput(VersionInfo.getAppName(), Messages.getString("OrderController.10"), menuItem.get86Countdown());
                        if (value == -1) {
                            return;
                        }
                        if (value == 0) {
                            POSMessageDialog.showError(Messages.getString("MenuItemForm.156"));
                            return;
                        }
                        menuItem.setAuto86Enabled(true);
                        menuItem.set86Countdown(value);
                        menuItem.set86CountdownSetTime(new Date());
                        menuItem.setEnable(value > 0);
                        MenuItemDAO.getInstance().update(menuItem);
                    }
                } else {
                    menuItem.setEnable(true);
                    menuItem.clearAuto86Settings();
                    MenuItemDAO.getInstance().update(menuItem);
                    this.setEnabled(menuItem.isEnable());
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    private class ItemButton
    extends PosButton
    implements ActionListener,
    MouseListener {
        MenuItem menuItem;

        ItemButton(MenuItem menuItem) {
            Color textColor;
            this.menuItem = menuItem;
            if (menuItem == null) {
                this.setVisible(false);
                return;
            }
            this.setText("<html><body><center>" + menuItem.getDisplayName() + "</center></body></html>");
            this.setVerticalTextPosition(3);
            this.setHorizontalTextPosition(0);
            this.setPreferredSize(MenuItemView.this.getButtonSize());
            Color buttonColor = menuItem.getButtonColor();
            if (buttonColor != null) {
                this.setBackground(buttonColor);
            }
            if ((textColor = menuItem.getTextColor()) != null) {
                this.setForeground(textColor);
            }
            this.addActionListener(this);
            this.addMouseListener(this);
            this.setEnabled(menuItem != null && menuItem.isEnable() != false);
            AsyncAction.execute(() -> {
                ImageIcon image = menuItem.getImage();
                String text = "<html><body><center>" + menuItem.getDisplayName() + "</center></body></html>";
                if (image != null) {
                    if (menuItem.isShowImageOnly().booleanValue()) {
                        this.setIcon(image);
                        this.setText("");
                    } else {
                        this.setIcon(image);
                        this.setText(text);
                    }
                } else {
                    this.setText(text);
                }
            });
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (OrderView.getInstance().is_86Mode()) {
                return;
            }
            try {
                this.menuItem.setEnable(true);
                MenuItemView.this.fireItemSelected(this.menuItem);
                this.setEnabled(this.menuItem.isEnable());
            }
            catch (JDBCConnectionException x) {
                POSMessageDialog.showError(Messages.getString("MenuItemView.12"));
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (OrderView.getInstance().is_86Mode()) {
                MenuItemDAO.getInstance().refresh(this.menuItem);
                if (this.menuItem.isEnable().booleanValue()) {
                    String option = POSMessageDialog.showOptionDialog(Application.getPosWindow(), Messages.getString("MenuItemView.0"), Messages.getString("PosMessage.297"), Messages.getString("MenuItemView.4"), Messages.getString("MenuItemView.5"), POSConstants.CANCEL);
                    if (option == null || option.equals(POSConstants.CANCEL)) {
                        return;
                    }
                    if (option.equals(Messages.getString("MenuItemView.4"))) {
                        this.menuItem.setEnable(this.menuItem.isEnable() == false);
                        this.setEnabled(this.menuItem.isEnable());
                        MenuItemDAO.getInstance().update(this.menuItem);
                        return;
                    }
                    if (option.equals(Messages.getString("MenuItemView.5"))) {
                        if (this.menuItem.isFractionalUnit().booleanValue()) {
                            POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("MenuItemView.6"));
                            return;
                        }
                        int value = (int)NumberSelectionDialog2.takeIntInput(VersionInfo.getAppName(), Messages.getString("OrderController.10"), this.menuItem.get86Countdown());
                        if (value == -1) {
                            return;
                        }
                        if (value == 0) {
                            POSMessageDialog.showError(Messages.getString("MenuItemForm.156"));
                            return;
                        }
                        this.menuItem.setAuto86Enabled(true);
                        this.menuItem.set86Countdown(value);
                        this.menuItem.set86CountdownSetTime(new Date());
                        this.menuItem.setEnable(value > 0);
                        MenuItemDAO.getInstance().update(this.menuItem);
                    }
                } else {
                    this.menuItem.setEnable(true);
                    this.menuItem.clearAuto86Settings();
                    MenuItemDAO.getInstance().update(this.menuItem);
                    this.setEnabled(this.menuItem.isEnable());
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }
}

