/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.order;

import com.floreantpos.Messages;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.ComboItem;
import com.floreantpos.model.ComboTicketItem;
import com.floreantpos.model.Customer;
import com.floreantpos.model.CustomerGroup;
import com.floreantpos.model.Department;
import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.IUnit;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.TicketItemSeat;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.AutomatedWeightInputDialog;
import com.floreantpos.ui.dialog.ComboTicketItemSelectionDialog;
import com.floreantpos.ui.dialog.ItemQtySelectionDialog;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.GroupView;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.TicketView;
import com.floreantpos.ui.views.order.actions.CategorySelectionListener;
import com.floreantpos.ui.views.order.actions.GroupSelectionListener;
import com.floreantpos.ui.views.order.actions.ItemSelectionListener;
import com.floreantpos.ui.views.order.actions.TicketEditListener;
import com.floreantpos.ui.views.order.modifier.ModifierSelectionDialog;
import com.floreantpos.ui.views.order.modifier.ModifierSelectionModel;
import com.floreantpos.ui.views.order.multipart.PizzaModifierSelectionDialog;
import com.floreantpos.ui.views.voidticket.VoidInfoInputDialog;
import com.floreantpos.webservice.CloudDataUploader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;

public class OrderController
implements CategorySelectionListener,
GroupSelectionListener,
ItemSelectionListener {
    protected OrderView orderView;
    List<TicketEditListener> ticketEditListenerList;

    public OrderController(OrderView orderView) {
        this.orderView = orderView;
        orderView.getCategoryView().addCategorySelectionListener(this);
        orderView.getGroupView().addGroupSelectionListener(this);
        orderView.getItemView().addItemSelectionListener(this);
        this.ticketEditListenerList = new ArrayList<TicketEditListener>();
    }

    @Override
    public void categorySelected(MenuCategory foodCategory) {
        try {
            this.orderView.showView("GROUP_VIEW");
            this.orderView.getGroupView().setMenuCategory(foodCategory);
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
    }

    @Override
    public void groupSelected(MenuGroup foodGroup) {
        try {
            this.orderView.showView("ITEM_VIEW");
            this.orderView.getItemView().setMenuGroup(foodGroup);
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
    }

    @Override
    public void itemSelected(MenuItem originalMenuItem) {
        try (Session session = MenuItemDAO.getInstance().createNewSession();){
            MenuItem menuItem = MenuItemDAO.getInstance().get(originalMenuItem.getId(), session);
            if (!this.hasAvailableStock(menuItem, 1.0)) {
                return;
            }
            if (!this.orderView.isReturnMode() && menuItem.isAuto86Enabled() && menuItem.get86Countdown() <= 0 && !menuItem.isFractionalUnit().booleanValue()) {
                originalMenuItem.setEnable(false);
                menuItem.setEnable(false);
                MenuItemDAO.getInstance().updateUsingTransaction(menuItem, session);
                POSMessageDialog.showError(Messages.getString("OrderController.11"));
                return;
            }
            if (menuItem.isVariant().booleanValue()) {
                MenuItem parentMenuItem = MenuItemDAO.getInstance().get(menuItem.getParentMenuItemId(), session);
                menuItem.setParentMenuItem(parentMenuItem);
            }
            if (menuItem.isHasVariant().booleanValue() && menuItem.getVariants() != null && menuItem.getVariants().size() > 0) {
                this.orderView.getItemView().rendererVariants(menuItem);
                return;
            }
            TicketView ticketView = this.orderView.getTicketView();
            Ticket ticket = this.orderView.getCurrentTicket();
            double itemQuantity = 1.0;
            IUnit destinationUnit = null;
            if (menuItem.isFractionalUnit().booleanValue() || menuItem.isAllowUnitSelection()) {
                if (TerminalConfig.getScaleActivationValue().equals("cas10")) {
                    itemQuantity = AutomatedWeightInputDialog.takeDoubleInput(menuItem.getName(), 1.0);
                } else {
                    ItemQtySelectionDialog qtyDialog = ItemQtySelectionDialog.getQtyAndUnit(menuItem, Messages.getString("OrderController.2"), 1.0);
                    qtyDialog.pack();
                    qtyDialog.open();
                    itemQuantity = qtyDialog.isCanceled() ? -1.0 : qtyDialog.getValue();
                    destinationUnit = qtyDialog.getSelectedUnit();
                }
                if (itemQuantity <= -1.0) {
                    return;
                }
                if (itemQuantity == 0.0) {
                    POSMessageDialog.showError(Messages.getString("OrderController.3"));
                    return;
                }
            }
            double itemPrice = 0.0;
            if (menuItem.isEditablePrice().booleanValue()) {
                itemPrice = NumberSelectionDialog2.takeDoubleInput(Messages.getString("OrderController.5"), menuItem.getPrice());
                if (itemPrice <= -1.0) {
                    return;
                }
                menuItem.setPrice(itemPrice);
            }
            TicketItem ticketItem = menuItem.convertToTicketItem(ticket, itemQuantity, destinationUnit);
            String voidReason = null;
            boolean itemWasted = false;
            double voidQuantity = 0.0;
            if (this.orderView.isReturnMode()) {
                VoidInfoInputDialog dialog = new VoidInfoInputDialog(ticketItem);
                dialog.setSize(PosUIManager.getSize(400, 600));
                dialog.open();
                if (dialog.isCanceled()) {
                    return;
                }
                voidReason = dialog.getVoidReason();
                itemWasted = dialog.isItemWasted();
                voidQuantity = dialog.getVoidQuantity();
            }
            if (menuItem.isAuto86Enabled() && !menuItem.isFractionalUnit().booleanValue()) {
                int countdown86 = 0;
                if (this.orderView.isReturnMode()) {
                    if (!itemWasted) {
                        countdown86 = menuItem.get86Countdown() + (int)Math.ceil(voidQuantity);
                    }
                } else {
                    countdown86 = menuItem.get86Countdown() - (int)Math.ceil(itemQuantity);
                }
                menuItem.set86Countdown(Math.max(0, countdown86));
                menuItem.setEnable(countdown86 > 0);
                MenuItemDAO.getInstance().updateUsingTransaction(menuItem, session);
                originalMenuItem.setEnable(menuItem.isEnable());
            }
            if (menuItem.isVariant().booleanValue()) {
                menuItem = menuItem.getParentMenuItem();
            }
            if (menuItem.isComboItem().booleanValue()) {
                if (this.orderView.isReturnMode() && voidQuantity > 1.0) {
                    ticketItem.setQuantity(voidQuantity);
                }
                if (!this.addComboItemsToTicketItem(menuItem, ticketItem)) {
                    return;
                }
            }
            if (this.orderView.isReturnMode()) {
                ticketItem.markVoided(voidReason, itemWasted, voidQuantity, true);
            }
            ticketItem.setTicket(ticket);
            Object selectedSeat = this.orderView.getSelectedSeatNumber();
            if (selectedSeat instanceof Integer) {
                ticketItem.setSeatNumber((Integer)selectedSeat);
            } else if (selectedSeat instanceof TicketItemSeat) {
                TicketItemSeat seat = (TicketItemSeat)selectedSeat;
                ticketItem.setSeat(seat);
                ticketItem.setSeatNumber(seat.getSeatNumber());
            }
            if (menuItem.isPizzaType().booleanValue()) {
                PizzaModifierSelectionDialog dialog = new PizzaModifierSelectionDialog(ticket, ticketItem, menuItem, false);
                dialog.setResizable(false);
                if (TerminalConfig.isKioskMode()) {
                    dialog.openUndecoratedFullScreen();
                } else {
                    dialog.openFullScreen();
                }
                if (dialog.isCanceled()) {
                    return;
                }
                List pizzaModifierList = dialog.getPizzzItemList();
                for (TicketItem ticketItemPizza : pizzaModifierList) {
                    ticketView.addTicketItem(ticketItemPizza);
                }
                this.fireTicketItemUpdated(ticket, ticketItem);
            } else if (menuItem.hasMandatoryModifiers()) {
                ModifierSelectionModel modifierSelectionModel = new ModifierSelectionModel(ticket, ticketItem, menuItem);
                ModifierSelectionDialog dialog = new ModifierSelectionDialog(modifierSelectionModel);
                dialog.open();
                if (!dialog.isCanceled()) {
                    ticketView.addTicketItem(ticketItem);
                    this.fireTicketItemUpdated(ticket, ticketItem);
                }
            } else {
                ticketView.addTicketItem(ticketItem);
                this.fireTicketItemUpdated(ticket, ticketItem);
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
    }

    private boolean hasAvailableStock(MenuItem menuItem, double selectedQty) {
        List<TicketItem> ticketItems;
        if (menuItem == null || !menuItem.isDisableWhenStockAmountIsZero().booleanValue() || menuItem.isHasVariant().booleanValue()) {
            return true;
        }
        Ticket ticket = this.orderView.getCurrentTicket();
        double qty = 0.0;
        if (ticket != null && (ticketItems = ticket.getTicketItems()) != null) {
            for (TicketItem item : ticketItems) {
                if (!item.getMenuItemId().equals(menuItem.getId())) continue;
                qty += item.getQuantity() - item.getInventoryAdjustQty();
            }
        }
        qty += selectedQty;
        return !(menuItem.getAvailableUnit() < qty) || POSMessageDialog.showYesNoQuestionDialog(Application.getPosWindow(), Messages.getString("OrderController.6"), Messages.getString("CONFIRM"), Messages.getString("OrderController.8"), Messages.getString("OrderController.9")) == 0;
    }

    public void doEditTicketItemQuantity(Object selectedObject) {
        TicketItem ticketItem = (TicketItem)selectedObject;
        MenuItem menuItem = ticketItem.getMenuItem();
        IUnit destinationUnit = null;
        double quantity = 0.0;
        if (ticketItem.isFractionalUnit().booleanValue() || ticketItem.isAllowUnitSelection()) {
            ItemQtySelectionDialog qtyDialog = ItemQtySelectionDialog.getQtyAndUnit(menuItem, DataProvider.get().getUnitByCode(ticketItem.getUnitName()), Messages.getString("OrderController.2"), ticketItem.getQuantity());
            qtyDialog.pack();
            qtyDialog.open();
            quantity = qtyDialog.isCanceled() ? -1.0 : qtyDialog.getValue();
            destinationUnit = qtyDialog.getSelectedUnit();
        } else {
            quantity = NumberSelectionDialog2.takeIntInput(Messages.getString("OrderController.10"), Math.abs(ticketItem.getQuantity()));
        }
        if (quantity <= 0.0) {
            return;
        }
        if (quantity > ticketItem.getQuantity() && !this.hasAvailableStock(menuItem, quantity - ticketItem.getQuantity())) {
            return;
        }
        if (this.orderView.isReturnMode()) {
            ticketItem.markVoided(Messages.getString("OrderController.12"), false, ticketItem.getQuantity(), true);
        } else {
            if (menuItem != null) {
                MenuItemDAO.getInstance().initialize(menuItem);
                int countdown86 = menuItem.get86Countdown();
                if (menuItem.isAuto86Enabled() && (double)countdown86 - (quantity - ticketItem.getQuantity()) < 0.0 && !menuItem.isFractionalUnit().booleanValue()) {
                    String message = (int)quantity + " " + Messages.getString("OrderController.15") + " " + (int)Math.ceil(ticketItem.getQuantity() + (double)countdown86) + " " + Messages.getString("OrderController.18");
                    POSMessageDialog.showError(message);
                    return;
                }
                if (menuItem.isComboItem().booleanValue()) {
                    this.updateComboTicketItemQuantity(ticketItem, quantity);
                }
                if (destinationUnit != null) {
                    double unitQuantity = menuItem.getUnitQuantity(menuItem.getUnit(), destinationUnit);
                    String key = "unit.{name}.price";
                    key = key.replace("{name}", destinationUnit.getUniqueCode());
                    String priceProperty = menuItem.getProperty(key);
                    OrderType orderType = ticketItem.getTicket().getOrderType();
                    Department department = Application.getInstance().getTerminal().getDepartment();
                    SalesArea salesArea = ticketItem.getTicket().getSalesArea();
                    Customer customer = ticketItem.getTicket().getCustomer();
                    CustomerGroup customerGroup = customer == null ? null : customer.getCustomerGroup();
                    Double unitPrice = DataProvider.get().getPriceFromPriceRule(menuItem, orderType, department, salesArea, customerGroup);
                    unitPrice = StringUtils.isNotEmpty((String)priceProperty) ? Double.valueOf(menuItem.getPrice() / unitPrice * Double.parseDouble(priceProperty)) : Double.valueOf(unitPrice / unitQuantity);
                    Double unitCost = menuItem.getCost() / unitQuantity;
                    ticketItem.setUnitName(destinationUnit.getUniqueCode());
                    ticketItem.setUnitCost(unitCost);
                    ticketItem.setUnitPrice(unitPrice);
                }
                if (menuItem.isAuto86Enabled() && !menuItem.isFractionalUnit().booleanValue()) {
                    menuItem.set86Countdown(Math.max(0, countdown86 -= (int)Math.ceil(quantity - ticketItem.getQuantity())));
                    menuItem.setEnable(countdown86 > 0);
                    MenuItemDAO.getInstance().update(menuItem);
                }
            }
            ticketItem.setQuantity(quantity);
        }
        this.fireTicketItemUpdated(ticketItem.getTicket(), ticketItem);
    }

    public void updateComboTicketItemQuantity(TicketItem ticketItem, double quantity) {
        List<TicketItem> comboticketItems = ticketItem.getComboItems();
        double ticketItemQuantity = ticketItem.getQuantity();
        double adjustQuantity = quantity - ticketItemQuantity;
        if (comboticketItems != null) {
            for (TicketItem comboTicketItem : comboticketItems) {
                comboTicketItem.setQuantity(comboTicketItem.getQuantity() + adjustQuantity * comboTicketItem.getQuantity() / ticketItemQuantity);
            }
        }
    }

    private boolean addComboItemsToTicketItem(MenuItem menuItem, TicketItem ticketItemObj) {
        ComboTicketItem ticketItem = (ComboTicketItem)ticketItemObj;
        Ticket currentTicket = this.orderView.getCurrentTicket();
        if (menuItem.getComboItems() != null && !menuItem.getComboItems().isEmpty()) {
            for (ComboItem item : menuItem.getComboItems()) {
                ModifierSelectionDialog dialog;
                MenuItemDAO menuItemDAO;
                MenuItem comboMenuItem;
                if (item.getQuantity() == 0.0 || item.getItemId() == null || (comboMenuItem = (menuItemDAO = MenuItemDAO.getInstance()).get(item.getItemId())) == null) continue;
                menuItemDAO.initialize(comboMenuItem);
                if (comboMenuItem.isVariant().booleanValue()) {
                    menuItemDAO.initialize(comboMenuItem.getParentMenuItem());
                }
                TicketItem comboTicketItem = comboMenuItem.convertToTicketItem(currentTicket, item.getQuantity());
                comboTicketItem.setMenuItem(comboMenuItem);
                if (comboMenuItem.hasMandatoryModifiers()) {
                    dialog = new ModifierSelectionDialog(new ModifierSelectionModel(currentTicket, comboTicketItem, comboMenuItem));
                    dialog.open();
                    if (dialog.isCanceled()) {
                        return false;
                    }
                } else if (menuItem.isPizzaType().booleanValue()) {
                    dialog = new PizzaModifierSelectionDialog(currentTicket, comboTicketItem, comboMenuItem, false);
                    dialog.openFullScreen();
                    if (dialog.isCanceled()) {
                        return false;
                    }
                }
                comboTicketItem.setMenuItemId(comboMenuItem.getId());
                comboTicketItem.setName(comboMenuItem.getName());
                comboTicketItem.setQuantity(ticketItem.getQuantity() * item.getQuantity());
                comboTicketItem.setParentTicketItem(ticketItem);
                comboTicketItem.setTicket(null);
                comboTicketItem.setGroupId(null);
                ticketItem.addTocomboItems(comboTicketItem);
            }
        }
        if (menuItem.getComboGroups() != null && !menuItem.getComboGroups().isEmpty()) {
            ComboTicketItemSelectionDialog dialog = new ComboTicketItemSelectionDialog(menuItem, ticketItem);
            dialog.setTitle(Messages.getString("OrderController.13"));
            dialog.setSize(PosUIManager.getSize(1024, 700));
            dialog.open();
            if (dialog.isCanceled()) {
                return false;
            }
            if (menuItem.isModifiablePriceForComboItem()) {
                ticketItem.doCalculateComboItemPrice();
            }
        }
        return true;
    }

    public void itemSelectionFinished(MenuGroup parent) {
        GroupView groupView;
        MenuCategory menuCategory = parent.getParent();
        if (!menuCategory.equals((groupView = this.orderView.getGroupView()).getMenuCategory())) {
            groupView.setMenuCategory(menuCategory);
        }
        this.orderView.showView("GROUP_VIEW");
    }

    public static void openModifierDialog(ITicketItem ticketItemObject) {
        try {
            Object dialog;
            List<TicketItemModifier> ticketItemModifiers;
            TicketItemModifier ticketItemModifier;
            Ticket ticket = OrderView.getInstance().getCurrentTicket();
            TicketItem ticketItem = null;
            if (ticketItemObject instanceof TicketItem) {
                ticketItem = (TicketItem)ticketItemObject;
            } else if (ticketItemObject instanceof TicketItemModifier && (ticketItem = (ticketItemModifier = (TicketItemModifier)ticketItemObject).getTicketItem()) == null) {
                ticketItem = ticketItemModifier.getTicketItem();
            }
            MenuItem menuItem = ticketItem.getMenuItem();
            MenuItemDAO.getInstance().initialize(menuItem);
            if (menuItem.isVariant().booleanValue()) {
                menuItem = menuItem.getParentMenuItem();
                MenuItemDAO.getInstance().initialize(menuItem);
            }
            if ((ticketItemModifiers = ticketItem.getTicketItemModifiers()) == null) {
                ticketItemModifiers = new ArrayList<TicketItemModifier>();
            }
            TicketItem cloneTicketItem = ticketItem.clone();
            boolean pizzaType = ticketItem.isPizzaType();
            if (pizzaType) {
                dialog = new PizzaModifierSelectionDialog(ticket, cloneTicketItem, menuItem, true);
                dialog.openFullScreen();
                if (dialog.isCanceled()) {
                    return;
                }
                TicketItemModifier sizeModifier = cloneTicketItem.getSizeModifier();
                sizeModifier.setTicketItem(ticketItem);
                ticketItem.setSizeModifier(sizeModifier);
                ticketItem.setQuantity(cloneTicketItem.getQuantity());
                ticketItem.setUnitPrice(cloneTicketItem.getUnitPrice());
            } else {
                dialog = new ModifierSelectionDialog(new ModifierSelectionModel(ticket, cloneTicketItem, menuItem));
                ((POSDialog)dialog).open();
                if (((POSDialog)dialog).isCanceled()) {
                    return;
                }
            }
            List<TicketItemModifier> addedTicketItemModifiers = cloneTicketItem.getTicketItemModifiers();
            if (addedTicketItemModifiers == null) {
                addedTicketItemModifiers = new ArrayList<TicketItemModifier>();
            }
            ticketItemModifiers.clear();
            for (TicketItemModifier ticketItemModifier2 : addedTicketItemModifiers) {
                ticketItemModifier2.setTicketItem(ticketItem);
                ticketItem.addToticketItemModifiers(ticketItemModifier2);
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
        OrderView.getInstance().getTicketView().getTicketViewerTable().updateView();
    }

    public static synchronized void saveOrder(Ticket ticket) {
        if (ticket == null) {
            return;
        }
        TicketDAO.getInstance().saveOrUpdate(ticket);
    }

    public static synchronized void closeOrder(Ticket ticket) {
        ticket.setClosed(true);
        ticket.setClosingDate(StoreDAO.getServerTimestamp());
        TicketDAO.getInstance().saveOrUpdate(ticket);
        User driver = ticket.getAssignedDriver();
        if (driver != null) {
            driver.setAvailableForDelivery(true);
            UserDAO.getInstance().saveOrUpdate(driver);
        }
        CloudDataUploader.get().uploadToCloudIfOnlineOrder(ticket);
    }

    public void addTicketUpdateListener(TicketEditListener l) {
        this.ticketEditListenerList.add(l);
    }

    public void removeTicketUpdateListener(TicketEditListener l) {
        this.ticketEditListenerList.remove(l);
    }

    public void fireTicketItemUpdated(Ticket ticket, TicketItem ticketItem) {
        for (TicketEditListener listener : this.ticketEditListenerList) {
            listener.itemAdded(ticket, ticketItem);
        }
    }

    public void fireTicketEditingStart(Ticket ticket) {
        for (TicketEditListener listener : this.ticketEditListenerList) {
            listener.ticketEditingStart(ticket);
        }
    }

    public void fireTicketEditingFinish(Ticket ticket) {
        for (TicketEditListener listener : this.ticketEditListenerList) {
            listener.ticketEditingFinish(ticket);
        }
    }
}

