/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.payment;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.actions.ActionCommand;
import com.floreantpos.actions.CloseDialogAction;
import com.floreantpos.actions.PosAction;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.config.CardConfig;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.OrderTypeDAO;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.swing.MultiSelectComboBox;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosButton;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.TransactionListView;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.ui.views.payment.AuthorizationDialog;
import com.floreantpos.ui.views.payment.CardProcessor;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXDatePicker;

public class AuthorizableTicketBrowser
extends POSDialog {
    private TransactionListView authClosedListView = new TransactionListView();
    private TransactionListView authWaitingListView = new TransactionListView();
    private JPanel tabbedPane;
    private POSToggleButton btnShowCaptureWaiting = new POSToggleButton(Messages.getString("AuthorizableTicketBrowser.12"));
    private POSToggleButton btnShowCaptured = new POSToggleButton(Messages.getString("AuthorizableTicketBrowser.13"));
    private User currentUser;
    private Terminal drawerTerminal;
    private PosButton bttnHide;
    private JPanel buttonPanel;
    private PosButton btnEditTips;
    private PosButton btnCapture;
    private PosButton btnCaptureAll;
    private JTextField tfTicketOrServer;
    private MultiSelectComboBox<OrderType> cbMultiOrderType;
    private JXDatePicker dpTransactionDate;

    public AuthorizableTicketBrowser(JFrame parent, User currentUser, Terminal drawerTerminal) {
        super(POSUtil.getFocusedWindow(), Dialog.ModalityType.APPLICATION_MODAL);
        this.currentUser = currentUser;
        this.drawerTerminal = drawerTerminal;
        this.init();
    }

    private void init() {
        this.setTitle(POSConstants.AUTHORIZE_BUTTON_TEXT);
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle(Messages.getString("TicketAuthorizationDialog.0"));
        this.add((Component)titlePanel, "North");
        this.tabbedPane = new JPanel(new BorderLayout());
        JPanel toggleButtonActionPanel = new JPanel((LayoutManager)new MigLayout("", "", ""));
        ButtonGroup group = new ButtonGroup();
        group.add(this.btnShowCaptureWaiting);
        group.add(this.btnShowCaptured);
        this.btnShowCaptureWaiting.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AuthorizableTicketBrowser.this.tabbedPane.remove(AuthorizableTicketBrowser.this.authClosedListView);
                AuthorizableTicketBrowser.this.tabbedPane.add(AuthorizableTicketBrowser.this.authWaitingListView);
                AuthorizableTicketBrowser.this.tabbedPane.revalidate();
                AuthorizableTicketBrowser.this.tabbedPane.repaint();
                AuthorizableTicketBrowser.this.bttnHide.setVisible(true);
                AuthorizableTicketBrowser.this.buttonPanel.revalidate();
                AuthorizableTicketBrowser.this.buttonPanel.repaint();
                AuthorizableTicketBrowser.this.btnEditTips.setVisible(true);
                AuthorizableTicketBrowser.this.btnCapture.setVisible(true);
                AuthorizableTicketBrowser.this.btnCaptureAll.setVisible(true);
            }
        });
        this.btnShowCaptured.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AuthorizableTicketBrowser.this.tabbedPane.remove(AuthorizableTicketBrowser.this.authWaitingListView);
                AuthorizableTicketBrowser.this.tabbedPane.add(AuthorizableTicketBrowser.this.authClosedListView);
                AuthorizableTicketBrowser.this.tabbedPane.revalidate();
                AuthorizableTicketBrowser.this.tabbedPane.repaint();
                AuthorizableTicketBrowser.this.bttnHide.setVisible(false);
                AuthorizableTicketBrowser.this.buttonPanel.revalidate();
                AuthorizableTicketBrowser.this.buttonPanel.repaint();
                AuthorizableTicketBrowser.this.btnEditTips.setVisible(false);
                AuthorizableTicketBrowser.this.btnCapture.setVisible(false);
                AuthorizableTicketBrowser.this.btnCaptureAll.setVisible(false);
            }
        });
        toggleButtonActionPanel.add(this.btnShowCaptureWaiting);
        toggleButtonActionPanel.add(this.btnShowCaptured);
        JPanel buildSearchForm = this.buildSearchForm();
        toggleButtonActionPanel.add(buildSearchForm);
        this.btnShowCaptureWaiting.setSelected(true);
        this.tabbedPane.add((Component)toggleButtonActionPanel, "North");
        this.tabbedPane.add(this.authWaitingListView);
        this.authWaitingListView.setBorder(BorderFactory.createEmptyBorder(5, 8, 5, 8));
        this.authClosedListView.setBorder(BorderFactory.createEmptyBorder(5, 8, 5, 8));
        this.bttnHide = new PosButton(Messages.getString("ActionCommand.6"));
        this.bttnHide.addActionListener(this.hideAction());
        ActionHandler actionHandler = new ActionHandler();
        this.buttonPanel = new JPanel((LayoutManager)new MigLayout("al center,hidemode 3", "sg, fill", ""));
        this.btnEditTips = new PosButton(ActionCommand.EDIT_TIPS, actionHandler);
        this.btnEditTips.setText(ActionCommand.EDIT_TIPS.toString());
        this.buttonPanel.add((Component)this.btnEditTips, "grow");
        this.btnCapture = new PosButton(ActionCommand.CAPTURE, actionHandler);
        this.btnCapture.setText(ActionCommand.CAPTURE.getDisplayString());
        this.buttonPanel.add((Component)this.btnCapture, "grow");
        this.btnCaptureAll = new PosButton(ActionCommand.CAPTURE_ALL, actionHandler);
        this.btnCaptureAll.setText(ActionCommand.CAPTURE_ALL.toString());
        this.buttonPanel.add((Component)this.btnCaptureAll, "grow");
        this.buttonPanel.add((Component)this.bttnHide, "grow");
        PosButton btnVoidTrans = new PosButton(ActionCommand.VOID_TRANS, actionHandler);
        btnVoidTrans.setText(ActionCommand.VOID_TRANS.toString());
        this.buttonPanel.add((Component)btnVoidTrans, "grow");
        this.buttonPanel.add(new PosButton(new CloseDialogAction(this)));
        this.tabbedPane.add((Component)this.buttonPanel, "South");
        JPanel authClosedTab = new JPanel(new BorderLayout());
        JPanel buttonPanel2 = new JPanel((LayoutManager)new MigLayout("al center", "sg, fill", ""));
        buttonPanel2.add((Component)btnVoidTrans, "grow");
        buttonPanel2.add(new PosButton(new CloseDialogAction(this)));
        authClosedTab.add(this.authClosedListView);
        authClosedTab.add((Component)buttonPanel2, "South");
        this.add(this.tabbedPane);
        this.updateTransactiontList();
    }

    private JPanel buildSearchForm() {
        JPanel panel = new JPanel();
        try {
            panel.setLayout((LayoutManager)new MigLayout("", "[][]15[][]15[][]15[]", "[]5[]"));
            JLabel lblTicketOrServer = new JLabel(Messages.getString("AuthorizableTicketBrowser.1"));
            this.tfTicketOrServer = new JTextField(15);
            JLabel lblOrderType = new JLabel(POSConstants.ORDER_TYPE);
            this.cbMultiOrderType = new MultiSelectComboBox();
            this.cbMultiOrderType.setItems(OrderTypeDAO.getInstance().findAll());
            JLabel lblDate = new JLabel(POSConstants.DATE);
            this.dpTransactionDate = UiUtil.getDeafultDate();
            JButton btnSearch = new JButton(Messages.getString("Search"));
            JButton btnClear = new JButton(Messages.getString("MenuItemForm.34"));
            panel.add((Component)lblTicketOrServer, "align label");
            panel.add(this.tfTicketOrServer);
            panel.add(lblOrderType);
            panel.add(this.cbMultiOrderType, "width 120!");
            panel.add(lblDate);
            panel.add((Component)this.dpTransactionDate);
            panel.add(btnSearch);
            panel.add(btnClear);
            btnSearch.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AuthorizableTicketBrowser.this.updateTransactiontList();
                }
            });
            btnClear.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    AuthorizableTicketBrowser.this.doClear(evt);
                }
            });
            KeyListener keyListener = new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    if (AuthorizableTicketBrowser.this.tfTicketOrServer.getText().length() > 3) {
                        AuthorizableTicketBrowser.this.updateTransactiontList();
                    }
                }

                @Override
                public void keyPressed(KeyEvent e) {
                    int key = e.getKeyCode();
                    if (key == 10) {
                        AuthorizableTicketBrowser.this.updateTransactiontList();
                    }
                }
            };
            this.tfTicketOrServer.addKeyListener(keyListener);
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
        return panel;
    }

    private ActionListener hideAction() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new HideAction().actionPerformed(null);
            }
        };
    }

    public void updateTransactiontList() {
        User owner = null;
        boolean hasPermissionForAllTicket = this.currentUser.hasPermission(UserPermission.AUTHORIZE_TICKETS);
        boolean hasPermissionForOwnTicket = this.currentUser.hasPermission(UserPermission.AUTHORIZE_OWN_TICKETS);
        if (!hasPermissionForAllTicket && hasPermissionForOwnTicket) {
            owner = this.currentUser;
        }
        String ticketOrServer = this.tfTicketOrServer.getText();
        List<OrderType> selectedOrderTypes = this.cbMultiOrderType.getSelectedItems();
        Date transactionDate = this.dpTransactionDate.getDate();
        this.authWaitingListView.setTransactions(PosTransactionDAO.getInstance().findUnauthorizedTransactions(owner, ticketOrServer, selectedOrderTypes, transactionDate));
        this.authClosedListView.setTransactions(PosTransactionDAO.getInstance().findCapturedTransactions(owner, ticketOrServer, selectedOrderTypes, transactionDate));
    }

    public void doClear(ActionEvent evt) {
        this.tfTicketOrServer.setText("");
        this.cbMultiOrderType.setSelectedIndex(0);
        this.cbMultiOrderType.unselectAllItems();
        this.dpTransactionDate.setDate(null);
        this.updateTransactiontList();
    }

    private boolean confirmAuthorize(String message) {
        int option = JOptionPane.showConfirmDialog(this, message, Messages.getString("CONFIRM"), 2);
        return option == 0;
    }

    private void doAuthorize() {
        try {
            List<PosTransaction> transactions = null;
            transactions = this.btnShowCaptured.isSelected() ? this.authClosedListView.getSelectedTransactions() : this.authWaitingListView.getSelectedTransactions();
            if (transactions == null || transactions.size() == 0) {
                POSMessageDialog.showMessage(this, Messages.getString("TicketAuthorizationDialog.2"));
                return;
            }
            if (!this.confirmAuthorize(Messages.getString("TicketAuthorizationDialog.3"))) {
                return;
            }
            AuthorizationDialog authorizingDialog = new AuthorizationDialog(this, transactions);
            authorizingDialog.setVisible(true);
            this.updateTransactiontList();
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, Messages.getString("AuthorizableTicketBrowser.5"));
            PosLog.error(this.getClass(), e);
        }
    }

    public void doAuthorizeAll() {
        try {
            List<PosTransaction> transactions = this.authWaitingListView.getAllTransactions();
            if (transactions == null || transactions.size() == 0) {
                POSMessageDialog.showMessage(this, Messages.getString("TicketAuthorizationDialog.5"));
                return;
            }
            if (!this.confirmAuthorize(Messages.getString("TicketAuthorizationDialog.6"))) {
                return;
            }
            AuthorizationDialog authorizingDialog = new AuthorizationDialog(this, transactions);
            authorizingDialog.setVisible(true);
            this.updateTransactiontList();
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, Messages.getString("AuthorizableTicketBrowser.5"));
            PosLog.error(this.getClass(), e);
        }
    }

    private void doEditTips() {
        try {
            PosTransaction transaction = null;
            transaction = this.btnShowCaptured.isSelected() ? this.authClosedListView.getFirstSelectedTransaction() : this.authWaitingListView.getFirstSelectedTransaction();
            if (transaction == null) {
                return;
            }
            Ticket ticket = TicketDAO.getInstance().loadFullTicket(transaction.getTicket().getId());
            Set<PosTransaction> transactions = ticket.getTransactions();
            for (PosTransaction posTransaction : transactions) {
                if (!transaction.getId().equals(posTransaction.getId())) continue;
                transaction = posTransaction;
                break;
            }
            double oldTipsAmount = transaction.getTipsAmount();
            double newTipsAmount = NumberSelectionDialog2.show(this, Messages.getString("EnterTipsAmount"), oldTipsAmount);
            if (Double.isNaN(newTipsAmount)) {
                return;
            }
            transaction.setTipsAmount(newTipsAmount);
            transaction.setAmount(transaction.getAmount() - oldTipsAmount + newTipsAmount);
            if (ticket.hasGratuity()) {
                double ticketTipsAmount = ticket.getGratuity().getAmount();
                double ticketPaidAmount = ticket.getPaidAmount();
                double newTicketTipsAmount = ticketTipsAmount - oldTipsAmount + newTipsAmount;
                double newTicketPaidAmount = ticketPaidAmount - oldTipsAmount + newTipsAmount;
                ticket.setGratuityAmount(newTicketTipsAmount);
                ticket.setPaidAmount(newTicketPaidAmount);
            } else {
                ticket.setGratuityAmount(newTipsAmount);
                ticket.setPaidAmount(ticket.getPaidAmount() + newTipsAmount);
            }
            ticket.calculatePrice();
            TicketDAO.getInstance().saveOrUpdate(ticket);
            this.updateTransactiontList();
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, Messages.getString("AuthorizableTicketBrowser.5"));
            PosLog.error(this.getClass(), e);
        }
    }

    private void doVoidTransaction() {
        try {
            PosTransaction transaction = this.authWaitingListView.getSelectedTransaction();
            if (this.btnShowCaptured.isSelected()) {
                transaction = this.authClosedListView.getSelectedTransaction();
            }
            if (transaction == null) {
                POSMessageDialog.showMessage(this, Messages.getString("AuthorizableTicketBrowser.6"));
                return;
            }
            int option = POSMessageDialog.showYesNoQuestionDialog(this, Messages.getString("AuthorizableTicketBrowser.14"), Messages.getString("CONFIRM"));
            if (option != 0) {
                return;
            }
            CardProcessor cardProcessor = CardConfig.getPaymentGateway().getProcessor();
            cardProcessor.voidTransaction(transaction);
            PosTransactionDAO.getInstance().saveOrUpdate(transaction);
            POSMessageDialog.showMessage(this, Messages.getString("AuthorizableTicketBrowser.9"));
            this.updateTransactiontList();
        }
        catch (PosException e) {
            POSMessageDialog.showError(this, e.getMessage());
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, Messages.getString("AuthorizableTicketBrowser.10"));
            PosLog.error(this.getClass(), e);
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ActionCommand command = ActionCommand.valueOf(e.getActionCommand());
            try {
                switch (command) {
                    case EDIT_TIPS: {
                        AuthorizableTicketBrowser.this.doEditTips();
                        break;
                    }
                    case CAPTURE: {
                        AuthorizableTicketBrowser.this.doAuthorize();
                        break;
                    }
                    case CAPTURE_ALL: {
                        AuthorizableTicketBrowser.this.doAuthorizeAll();
                        break;
                    }
                    case VOID_TRANS: {
                        AuthorizableTicketBrowser.this.doVoidTransaction();
                        break;
                    }
                }
            }
            catch (Exception e2) {
                POSMessageDialog.showError(AuthorizableTicketBrowser.this, e2.getMessage(), e2);
            }
        }
    }

    private class HideAction
    extends PosAction {
        public HideAction() {
            this.setRequiredPermission(UserPermission.PERFORM_MANAGER_TASK);
            this.setMandatoryPermission(true);
        }

        @Override
        public void execute() {
            try {
                List<PosTransaction> transactions = AuthorizableTicketBrowser.this.authWaitingListView.getSelectedTransactions();
                if (transactions.isEmpty()) {
                    POSMessageDialog.showMessage(Messages.getString("AuthorizableTicketBrowser.11"));
                    return;
                }
                int option = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("AuthorizableTicketBrowser.16"), Messages.getString("AuthorizableTicketBrowser.17"));
                if (option == 0) {
                    for (PosTransaction posTransaction : transactions) {
                        posTransaction.setMarkedCaptured(true);
                        PosTransactionDAO.getInstance().saveOrUpdate(posTransaction);
                    }
                }
                AuthorizableTicketBrowser.this.updateTransactiontList();
            }
            catch (Exception e) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
                PosLog.error(this.getClass(), e);
            }
        }

        @Override
        protected User getCurrentUser() {
            return AuthorizableTicketBrowser.this.currentUser;
        }
    }
}

