/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.payment;

import com.floreantpos.IconFactory;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.ext.CardTypeEnum;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.TransparentPanel;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;

public class CardPannelUI
extends TransparentPanel {
    private POSToggleButton btnVisaCard;
    private POSToggleButton btnMasterCard;
    private POSToggleButton btnAmericanExpress;
    private POSToggleButton btnDiscoverCard;

    public CardPannelUI() {
        this.initUi();
        this.btnVisaCard.setSelected(true);
    }

    private void initUi() {
        this.setLayout((LayoutManager)new MigLayout("fill"));
        this.btnVisaCard = new POSToggleButton();
        this.btnVisaCard.setIcon(IconFactory.getIcon("/ui_icons/", "visa_card.png"));
        this.btnMasterCard = new POSToggleButton("");
        this.btnMasterCard.setIcon(IconFactory.getIcon("/ui_icons/", "master_card.png"));
        this.btnAmericanExpress = new POSToggleButton();
        this.btnAmericanExpress.setIcon(IconFactory.getIcon("/ui_icons/", "am_ex_card.png"));
        this.btnDiscoverCard = new POSToggleButton();
        this.btnDiscoverCard.setIcon(IconFactory.getIcon("/ui_icons/", "discover_card.png"));
        ButtonGroup group = new ButtonGroup();
        group.add(this.btnVisaCard);
        group.add(this.btnMasterCard);
        group.add(this.btnAmericanExpress);
        group.add(this.btnDiscoverCard);
        JPanel creditCardPanel = new JPanel(new GridLayout(1, 0, 10, 10));
        creditCardPanel.setBorder(new CompoundBorder(new TitledBorder("Card type"), new EmptyBorder(0, 0, 0, 0)));
        creditCardPanel.add(this.btnVisaCard);
        creditCardPanel.add(this.btnMasterCard);
        creditCardPanel.add(this.btnAmericanExpress);
        creditCardPanel.add(this.btnDiscoverCard);
        JPanel cardPanel = new JPanel((LayoutManager)new MigLayout("fill, ins 2", "sg, fill", ""));
        cardPanel.add((Component)creditCardPanel, "grow");
        this.add((Component)cardPanel, "grow");
    }

    public PaymentType getPaymentType() {
        if (this.btnVisaCard.isSelected()) {
            return PaymentType.CREDIT_CARD;
        }
        if (this.btnMasterCard.isSelected()) {
            return PaymentType.CREDIT_CARD;
        }
        if (this.btnAmericanExpress.isSelected()) {
            return PaymentType.CREDIT_CARD;
        }
        if (this.btnDiscoverCard.isSelected()) {
            return PaymentType.CREDIT_CARD;
        }
        return PaymentType.CREDIT_CARD;
    }

    public String getCardType() {
        if (this.btnVisaCard.isSelected()) {
            return CardTypeEnum.VISA.name();
        }
        if (this.btnMasterCard.isSelected()) {
            return CardTypeEnum.MASTER_CARD.name();
        }
        if (this.btnAmericanExpress.isSelected()) {
            return CardTypeEnum.AMERICAN_EXPRESS.name();
        }
        if (this.btnDiscoverCard.isSelected()) {
            return CardTypeEnum.DISCOVER.name();
        }
        return CardTypeEnum.VISA.name();
    }
}

