/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.payment.creditbook;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.CreditBook;
import com.floreantpos.model.dao.CreditBookDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosTable;
import com.floreantpos.ui.TitlePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.commons.lang.StringUtils;

public class CreditBookExplorer
extends JPanel {
    private BeanTableModel<CreditBook> creditBookTableModel;
    private PosTable creditBookTable;

    public CreditBookExplorer() {
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout(5, 5));
        this.creditBookTableModel = new BeanTableModel(CreditBook.class);
        this.creditBookTableModel.addColumn(Messages.getString("CreditBookExplorer.0"), "creditBookTypeLabel");
        this.creditBookTableModel.addColumn(POSConstants.NAME, CreditBook.PROP_NAME);
        this.creditBookTableModel.addColumn(Messages.getString("CreditBookExplorer.2"), CreditBook.PROP_CREATED_DATE);
        this.creditBookTableModel.addColumn(Messages.getString("CreditBookExplorer.3"), CreditBook.PROP_LAST_MODIFIED_DATE);
        this.creditBookTableModel.addColumn(Messages.getString("CreditBookExplorer.4"), CreditBook.PROP_EXPIRY_DATE);
        this.creditBookTableModel.addColumn(Messages.getString("CreditBookExplorer.5"), CreditBook.PROP_EXPIRED);
        this.creditBookTableModel.addColumn(POSConstants.AMOUNT, CreditBook.PROP_AMOUNT, 11, BeanTableModel.DataType.MONEY);
        this.creditBookTableModel.addColumn(Messages.getString("CreditBookExplorer.6"), CreditBook.PROP_BALANCE, 11, BeanTableModel.DataType.MONEY);
        this.creditBookTable = new PosTable(this.creditBookTableModel);
        this.creditBookTable.setSelectionMode(0);
        this.creditBookTable.setRowHeight(30);
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle(Messages.getString("CreditBookExplorer.7"));
        this.add((Component)new JScrollPane((Component)((Object)this.creditBookTable)), "Center");
    }

    public void setMemberId(String memberId) {
        if (StringUtils.isEmpty((String)memberId)) {
            return;
        }
        List<CreditBook> creditBooks = CreditBookDAO.getInstance().findByMemberId(memberId);
        if (creditBooks != null) {
            this.creditBookTableModel.setRows(creditBooks);
        }
    }

    public CreditBook getSelectedCreditBook() {
        int index = this.creditBookTable.getSelectedRow();
        if (index < 0) {
            return null;
        }
        index = this.creditBookTable.convertRowIndexToModel(index);
        return this.creditBookTableModel.getRow(index);
    }

    public void repaintTable() {
        this.creditBookTable.repaint();
    }

    public void removeRow() {
        int index = this.creditBookTable.getSelectedRow();
        if (index < 0) {
            return;
        }
        index = this.creditBookTable.convertRowIndexToModel(index);
        this.creditBookTableModel.removeRow(index);
    }
}

