/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.util;

import com.floreantpos.model.Currency;
import com.floreantpos.model.util.DataProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

public class CurrencyUtil {
    public static Currency getMainCurrency() {
        return DataProvider.get().getMainCurrency();
    }

    public static List<Currency> getAllCurrency() {
        return DataProvider.get().getCurrencies();
    }

    public static String getCurrencyName() {
        return CurrencyUtil.getMainCurrency().getName();
    }

    public static String getCurrencySymbol() {
        Currency mainCurrency = CurrencyUtil.getMainCurrency();
        if (mainCurrency == null) {
            return "";
        }
        return mainCurrency.getSymbol();
    }

    public static String getCurrencySymbolWithBracket() {
        return " (" + CurrencyUtil.getCurrencySymbol() + ")";
    }

    public static List<Currency> getAllPreFillCurrencies() {
        Set currencies = com.ibm.icu.util.Currency.getAvailableCurrencies();
        ArrayList<Currency> currencyList = new ArrayList<Currency>();
        for (com.ibm.icu.util.Currency ibmCurrency : currencies) {
            Currency currency = new Currency();
            currency.setName(ibmCurrency.getDisplayName());
            currency.setCode(ibmCurrency.getCurrencyCode());
            String symbol = ibmCurrency.getSymbol();
            currency.setSymbol(symbol);
            currencyList.add(currency);
        }
        Collections.sort(currencyList, new Comparator<Currency>(){

            @Override
            public int compare(Currency o1, Currency o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return currencyList;
    }
}

