/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.util;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.swing.PosSmallButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerDateModel;
import javax.swing.border.EmptyBorder;
import javax.swing.text.DateFormatter;
import javax.swing.text.DefaultFormatterFactory;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.calendar.DateSelectionModel;
import org.jdesktop.swingx.calendar.SingleDaySelectionModel;

public class DateTimePicker
extends JXDatePicker {
    private JSpinner timeSpinner;
    private JPanel timePanel;
    private DateFormat timeFormat;
    private boolean isShowSecond = Boolean.FALSE;

    public DateTimePicker() {
        this.getMonthView().setSelectionModel((DateSelectionModel)new SingleDaySelectionModel());
        this.updateTextFieldFormat();
    }

    public DateTimePicker(Date d) {
        this();
        this.setDate(d);
    }

    public DateTimePicker(Date d, boolean isShowSecond) {
        this.isShowSecond = isShowSecond;
        this.getMonthView().setSelectionModel((DateSelectionModel)new SingleDaySelectionModel());
        this.setDate(d);
        this.updateTextFieldFormat();
    }

    public void commitEdit() throws ParseException {
        this.commitTime();
    }

    public void cancelEdit() {
        super.cancelEdit();
        this.setTimeSpinners();
    }

    public JPanel getLinkPanel() {
        super.getLinkPanel();
        if (this.timePanel == null) {
            this.timePanel = this.createTimePanel();
        }
        this.setTimeSpinners();
        return this.timePanel;
    }

    private JPanel createTimePanel() {
        JPanel footerPannl = new JPanel(new BorderLayout(5, 5));
        footerPannl.setBorder(new EmptyBorder(5, 5, 5, 5));
        JPanel centerPanel = new JPanel((LayoutManager)new MigLayout("fill", "[][grow]", ""));
        SpinnerDateModel dateModel = new SpinnerDateModel();
        this.timeSpinner = new JSpinner(dateModel);
        centerPanel.add((Component)new JLabel(Messages.getString("DateTimePicker.0")), "growy");
        centerPanel.add((Component)this.timeSpinner, "grow");
        centerPanel.setBackground(Color.WHITE);
        PosSmallButton btnDone = new PosSmallButton(POSConstants.DONE);
        footerPannl.add((Component)centerPanel, "Center");
        footerPannl.add((Component)btnDone, "East");
        btnDone.addActionListener(e -> this.getMonthView().commitSelection());
        return footerPannl;
    }

    private void updateTextFieldFormat() {
        if (this.timeSpinner == null) {
            return;
        }
        this.timeFormat = this.isShowSecond ? DateFormat.getTimeInstance(2) : DateFormat.getTimeInstance(3);
        JFormattedTextField tf = ((JSpinner.DefaultEditor)this.timeSpinner.getEditor()).getTextField();
        DefaultFormatterFactory factory = (DefaultFormatterFactory)tf.getFormatterFactory();
        DateFormatter formatter = (DateFormatter)factory.getDefaultFormatter();
        formatter.setFormat(this.timeFormat);
    }

    private void commitTime() {
        Date date = this.getDate();
        if (date != null) {
            Date time = (Date)this.timeSpinner.getValue();
            GregorianCalendar timeCalendar = new GregorianCalendar();
            timeCalendar.setTime(time);
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(date);
            calendar.set(11, timeCalendar.get(11));
            calendar.set(12, timeCalendar.get(12));
            if (this.isShowSecond) {
                calendar.set(13, timeCalendar.get(13));
            } else {
                calendar.set(13, 0);
            }
            calendar.set(14, 0);
            Date newDate = calendar.getTime();
            this.setDate(newDate);
        }
    }

    private void setTimeSpinners() {
        Date date = this.getDate();
        if (date != null) {
            this.timeSpinner.setValue(date);
        }
    }

    public DateFormat getTimeFormat() {
        return this.timeFormat;
    }

    public void setTimeFormat(DateFormat timeFormat) {
        this.timeFormat = timeFormat;
        this.updateTextFieldFormat();
    }

    public void setLowerBound(Date lowerDate) {
        Calendar calendar = this.getMonthView().getCalendar();
        calendar.setTime(lowerDate);
        this.getMonthView().setLowerBound(calendar.getTime());
    }
}

