/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.util;

import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketDiscount;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemDiscount;
import com.floreantpos.util.NumberUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class DiscountUtil {
    public static Double calculateDiscountAmount(TicketItemDiscount ticketItemDiscount, double subtotalAmount) {
        TicketItem ticketItem = ticketItemDiscount.getTicketItem();
        if (ticketItemDiscount.getType() == 2) {
            return ticketItemDiscount.getValue();
        }
        if (ticketItemDiscount.getMinimumAmount() > 1.0) {
            double minQuantity = ticketItemDiscount.getMinimumAmount();
            double itemCount = ticketItem.getQuantity();
            switch (ticketItemDiscount.getType()) {
                case 0: {
                    return Math.floor(itemCount / minQuantity) * ticketItemDiscount.getValue();
                }
                case 1: {
                    if (ticketItem.isReturned()) {
                        double returnItemCount = itemCount * -1.0;
                        if (minQuantity > returnItemCount) {
                            return 0.0;
                        }
                        return Math.floor(returnItemCount / minQuantity) * (subtotalAmount / returnItemCount * ticketItemDiscount.getValue() / 100.0);
                    }
                    return Math.floor(itemCount / minQuantity) * (subtotalAmount / itemCount * ticketItemDiscount.getValue() / 100.0);
                }
            }
        }
        switch (ticketItemDiscount.getType()) {
            case 0: {
                return ticketItemDiscount.getValue();
            }
            case 1: {
                return subtotalAmount * ticketItemDiscount.getValue() / 100.0;
            }
        }
        return 0.0;
    }

    public static BigDecimal calculateDiscountAmount(TicketItemDiscount ticketItemDiscount, BigDecimal subtotalAmount) {
        TicketItem ticketItem = ticketItemDiscount.getTicketItem();
        BigDecimal discountValue = NumberUtil.convertToBigDecimal(ticketItemDiscount.getValue());
        BigDecimal percentage = discountValue.divide(NumberUtil.convertToBigDecimal("100.0"), 4, RoundingMode.FLOOR);
        if (ticketItemDiscount.getType() == 2) {
            return discountValue;
        }
        if (ticketItemDiscount.getMinimumAmount() > 1.0) {
            BigDecimal minQuantity = NumberUtil.convertToBigDecimal(ticketItemDiscount.getMinimumAmount());
            BigDecimal itemCount = NumberUtil.convertToBigDecimal(ticketItem.getQuantity());
            switch (ticketItemDiscount.getType()) {
                case 0: {
                    return itemCount.divide(minQuantity, 4, RoundingMode.FLOOR).multiply(discountValue);
                }
                case 1: {
                    BigDecimal itemCountDivideQuantity = itemCount.divide(minQuantity, 4, RoundingMode.FLOOR);
                    BigDecimal subtotalDivideItemCount = subtotalAmount.divide(itemCount, 4, RoundingMode.FLOOR);
                    return itemCountDivideQuantity.multiply(subtotalDivideItemCount).multiply(percentage);
                }
            }
        }
        switch (ticketItemDiscount.getType()) {
            case 0: {
                return discountValue;
            }
            case 1: {
                return subtotalAmount.multiply(percentage);
            }
        }
        return new BigDecimal("0");
    }

    public static Double calculateDiscountAmount(double price, TicketDiscount discount) {
        switch (discount.getType()) {
            case 0: 
            case 2: {
                return discount.getValue();
            }
            case 1: {
                return price * discount.getValue() / 100.0;
            }
        }
        return price * discount.getValue() / 100.0;
    }

    public static TicketItemDiscount getMaxDiscount(List<TicketItemDiscount> discounts) {
        if (discounts == null || discounts.isEmpty()) {
            return null;
        }
        TicketItemDiscount maxDiscount = Collections.max(discounts, new Comparator<TicketItemDiscount>(){

            @Override
            public int compare(TicketItemDiscount o1, TicketItemDiscount o2) {
                return (int)(o1.getAmount() - o2.getAmount());
            }
        });
        return maxDiscount;
    }

    public static TicketDiscount getMaxDiscount(List<TicketDiscount> discounts, final double price) {
        if (discounts == null || discounts.isEmpty()) {
            return null;
        }
        TicketDiscount maxDiscount = Collections.max(discounts, new Comparator<TicketDiscount>(){

            @Override
            public int compare(TicketDiscount o1, TicketDiscount o2) {
                return (int)(DiscountUtil.calculateDiscountAmount(price, o1) - DiscountUtil.calculateDiscountAmount(price, o2));
            }
        });
        return maxDiscount;
    }

    public static Double calculateRepriceDiscount(Ticket ticket, double repriceValue) {
        Double ticketTotalAmount = ticket.getTotalAmount();
        Double ticketTaxAmount = ticket.getTaxAmount();
        if (ticketTotalAmount == 0.0) {
            return 0.0;
        }
        double repricedTaxAmount = repriceValue * ticketTaxAmount / ticketTotalAmount;
        Double discountValue = ticket.getSubtotalAmount() - ticket.getItemDiscountAmount() - (repriceValue - repricedTaxAmount);
        return discountValue;
    }
}

