/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.util;

import com.floreantpos.config.AppConfig;
import com.floreantpos.ui.dialog.PinNumberInputDialog;
import com.orocube.licensemanager.OroLicense;
import org.apache.commons.lang.StringUtils;

public class LicenseValidationUtil {
    public static boolean doCheckPinNumber(OroLicense license, String filePinConstant) {
        return LicenseValidationUtil.doCheckPinNumber(license, filePinConstant, false);
    }

    public static boolean doCheckPinNumber(OroLicense license, String filePinConstant, boolean isDispose) {
        if (license == null) {
            return true;
        }
        if (StringUtils.isEmpty((String)filePinConstant)) {
            return true;
        }
        if (!license.isDemoLicense()) {
            return true;
        }
        String oroposLicensePin = AppConfig.getString(filePinConstant, "");
        String hashCode = String.valueOf(license.getHolderEmail().hashCode());
        if (hashCode.length() >= 5) {
            hashCode = hashCode.substring(hashCode.length() - 5);
        }
        if (StringUtils.isEmpty((String)oroposLicensePin) || !oroposLicensePin.equals(hashCode)) {
            PinNumberInputDialog dialog = new PinNumberInputDialog(hashCode, license.getHolderEmail());
            dialog.open();
            if (dialog.isCanceled()) {
                if (isDispose) {
                    dialog.dispose();
                } else {
                    System.exit(1);
                }
                return false;
            }
            oroposLicensePin = dialog.getPinNumber();
        }
        AppConfig.put(filePinConstant, oroposLicensePin);
        return true;
    }
}

