/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.util;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.main.Application;
import com.floreantpos.model.CardReader;
import com.floreantpos.model.Course;
import com.floreantpos.model.Customer;
import com.floreantpos.model.Department;
import com.floreantpos.model.ModifiableTicketItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosPrinters;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Printer;
import com.floreantpos.model.PrinterGroup;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemCookingInstruction;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.TicketItemSeat;
import com.floreantpos.model.TicketItemTax;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.User;
import com.floreantpos.model.VirtualPrinter;
import com.floreantpos.model.ext.CardTypeEnum;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.util.GlobalIdGenerator;
import com.floreantpos.util.NumericGlobalIdGenerator;
import com.floreantpos.util.ShiftUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class PreviewTicketUtil {
    public static Ticket createPreviewTicket(OrderType ticketType, String guestCheckType) {
        SalesArea salesArea;
        int numberOfGuests = 4;
        Date deliveryDate = null;
        boolean customerWillPickUp = false;
        String shippingAddress = null;
        String extraDeliveryInfo = null;
        String phoneExtension = null;
        String extraManagerInstruction = null;
        Double deliveryChargeAmount = 0.0;
        Customer customer = new Customer();
        customer.setFirstName("Firstname");
        customer.setLastName("Lastname");
        customer.setMobileNo("+02............");
        customer.setZipCode("565656");
        customer.setMemberId(Messages.getString("ReceiptConfigurationView.97"));
        customer.setSignatureImageId(Messages.getString("ReceiptConfigurationView.98"));
        customer.setLoyaltyPoint(100);
        if (ticketType.isDelivery().booleanValue()) {
            deliveryDate = new Date();
            shippingAddress = "Customer address.....";
            extraDeliveryInfo = Messages.getString("ReceiptConfigurationView.70");
            phoneExtension = "Phone extension..";
            extraManagerInstruction = "Manager instructions..";
            customerWillPickUp = false;
            deliveryChargeAmount = 0.0;
        }
        Application application = Application.getInstance();
        Ticket ticket = new Ticket(true);
        ticket.setTaxIncluded(Application.getInstance().isPriceIncludesTax());
        ticket.setOrderType(ticketType);
        ticket.setNote(Messages.getString("ReceiptConfigurationView.4"));
        ticket.setNumberOfGuests(numberOfGuests);
        ticket.addExtraProperty("ticket.sub_order_type", POSConstants.FOR_HERE_TO_GO_BUTTON_TEXT);
        ticket.addProperty("reciprocal_member.note", Messages.getString("ReceiptConfigurationView.5"));
        if (customerWillPickUp) {
            ticket.setCustomerWillPickup(true);
        } else {
            ticket.setDeliveryDate(deliveryDate);
            ticket.setDeliveryAddress(shippingAddress);
            ticket.setExtraDeliveryInfo(extraDeliveryInfo);
            ticket.addProperty("PHONE_EXTENSION", phoneExtension);
            ticket.addProperty("MANAGER_INSTRUCTION", extraManagerInstruction);
            ticket.setDeliveryCharge(deliveryChargeAmount);
            ticket.setCustomerWillPickup(false);
        }
        if (customer != null) {
            ticket.setCustomer(customer);
        }
        Terminal terminal = application.getTerminal();
        ticket.setTerminal(terminal);
        Department department = terminal.getDepartment();
        if (department != null) {
            ticket.setDepartmentId(department.getId());
        }
        if ((salesArea = terminal.getSalesArea()) != null) {
            ticket.setSalesAreaId(salesArea.getId());
        }
        User currentUser = Application.getCurrentUser();
        ticket.setOwner(currentUser);
        ticket.setShift(ShiftUtil.getCurrentShift());
        if (ticketType.isShowTableSelection().booleanValue()) {
            ArrayList<Integer> tables = new ArrayList<Integer>();
            tables.add(1);
            tables.add(2);
            ticket.setTableNumbers(tables);
        }
        Calendar currentTime = DateUtil.getServerTimeCalendar();
        ticket.setCreateDate(currentTime.getTime());
        ticket.setCreationHour(currentTime.get(11));
        ticket.addProperty("printCount", String.valueOf(1));
        ticket.addProperty("previewTicket", String.valueOf(Boolean.TRUE));
        ticket.setId(NumericGlobalIdGenerator.generateGlobalId());
        ticket.setTokenNo(1);
        TicketItemTax ticketItemTax1 = new TicketItemTax();
        ticketItemTax1.setId(GlobalIdGenerator.generateGlobalId());
        ticketItemTax1.setName(Messages.getString("ReceiptConfigurationView.99"));
        ticketItemTax1.setRate(6.0);
        TicketItemTax ticketItemTax2 = new TicketItemTax();
        ticketItemTax2.setId(GlobalIdGenerator.generateGlobalId());
        ticketItemTax2.setName(Messages.getString("ReceiptConfigurationView.100"));
        ticketItemTax2.setRate(15.0);
        for (int i = 0; i < 5; ++i) {
            TicketItemSeat seatItem;
            PreviewTicketItem item = new PreviewTicketItem();
            item.setId(NumericGlobalIdGenerator.generateGlobalId());
            item.setMenuItemId("0");
            item.setName("Item " + (i + 1));
            item.setQuantity((double)i + 1.0);
            item.setUnitPrice(2.5);
            item.setShouldPrintToKitchen(true);
            item.setTaxes(Arrays.asList(ticketItemTax1, ticketItemTax2));
            if (ticketType.isEnableCourse().booleanValue()) {
                Course course = new Course(Messages.getString("ReceiptConfigurationView.101") + (i + 1));
                course.setShortName(Messages.getString("ReceiptConfigurationView.101") + (i + 1));
                item.setCourseId(Messages.getString("ReceiptConfigurationView.101") + (i + 1));
                item.setCourseName(Messages.getString("ReceiptConfigurationView.101") + (i + 1));
            }
            ticket.addToticketItems(item);
            item.setTicket(ticket);
            if (i == 1) {
                for (int j = 0; j <= 1; ++j) {
                    TicketItemModifier newModifier = new TicketItemModifier();
                    newModifier.setId(NumericGlobalIdGenerator.generateGlobalId());
                    newModifier.setItemId("0");
                    newModifier.setGroupId("0");
                    newModifier.setItemQuantity(2.0);
                    newModifier.setName("Modifier " + (j + 1));
                    newModifier.setUnitPrice(1.5);
                    newModifier.setShouldPrintToKitchen(true);
                    newModifier.setTicketItem(item);
                    item.addToticketItemModifiers(newModifier);
                }
            } else if (i == 2) {
                TicketItemCookingInstruction cookingInstruction = new TicketItemCookingInstruction();
                cookingInstruction.setDescription("Fry (Cooking Ins.)");
                item.addCookingInstruction(cookingInstruction);
            }
            if (i == 2) {
                TicketItem seatTicketItem = new TicketItem();
                seatItem = new TicketItemSeat();
                seatTicketItem.setName("Seat** 1");
                seatTicketItem.setShouldPrintToKitchen(true);
                seatTicketItem.setTreatAsSeat(true);
                seatTicketItem.setSeatNumber(1);
                seatTicketItem.setPrintedToKitchen(false);
                seatTicketItem.setShouldPrintToKitchen(true);
                seatTicketItem.setSeat(seatItem);
                seatTicketItem.setTicket(ticket);
                seatItem.setSeatNumber(1);
                ticket.addToticketItems(seatTicketItem);
                continue;
            }
            if (i != 3) continue;
            TicketItem seatTicketItem = new TicketItem();
            seatItem = new TicketItemSeat();
            seatTicketItem.setName("Seat** Shared");
            seatTicketItem.setShouldPrintToKitchen(true);
            seatTicketItem.setTreatAsSeat(true);
            seatTicketItem.setSeatNumber(null);
            seatTicketItem.setPrintedToKitchen(false);
            seatTicketItem.setShouldPrintToKitchen(true);
            seatTicketItem.setSeat(seatItem);
            seatTicketItem.setTicket(ticket);
            seatItem.setSeatNumber(1);
            ticket.addToticketItems(seatTicketItem);
        }
        ticket.calculatePrice();
        PosTransaction transaction = null;
        PaymentType paymentType = null;
        if (guestCheckType != null && guestCheckType.equals("creditCard")) {
            paymentType = PaymentType.CREDIT_CARD;
            transaction = paymentType.createTransaction();
            transaction.setCaptured(false);
            transaction.setCardMerchantGateway("Payment gateway name..");
            transaction.setCardReader(CardReader.MANUAL.name());
            transaction.setCardHolderName("Card holder name");
            transaction.setCardNumber("4111111111111111");
            transaction.setCardExpMonth("12");
            transaction.setCardExpYear("2020");
            transaction.setCardType(CardTypeEnum.VISA.name());
            transaction.setCardAuthCode("00000");
            transaction.setTransactionType(TransactionType.CREDIT.name());
            ticket.setCashier(currentUser);
        } else {
            paymentType = PaymentType.CASH;
            transaction = paymentType.createTransaction();
        }
        transaction.setTenderAmount(ticket.getDueAmount());
        transaction.setAmount(ticket.getDueAmount());
        transaction.setTicket(ticket);
        ticket.addTotransactions(transaction);
        ticket.setVoided(false);
        ticket.setTerminal(terminal);
        ticket.setPaidAmount(ticket.getPaidAmount() + transaction.getAmount());
        if (ticket.isSourceOnline()) {
            ticket.setDueAmount(ticket.getTotalAmountWithTips() - ticket.getPaidAmount());
        } else {
            ticket.calculatePrice();
        }
        Date currentDate = new Date();
        if (ticket.getDueAmount() == 0.0) {
            ticket.setPaid(true);
        } else {
            ticket.setPaid(false);
            ticket.setClosed(false);
        }
        transaction.setTerminal(terminal);
        transaction.setUser(ticket.getOwner());
        transaction.setTransactionTime(currentDate);
        return ticket;
    }

    public static class PreviewTicketItem
    extends ModifiableTicketItem {
        private static final long serialVersionUID = 1L;

        @Override
        public List<Printer> getPrinters(OrderType orderType) {
            PrinterGroup printerGroup = this.getPrinterGroup();
            ArrayList<Printer> printerAll = new ArrayList<Printer>();
            printerAll.add(VirtualPrinter.getKdsPrinter());
            PosPrinters printers = DataProvider.get().getPrinters();
            printerAll.addAll(printers.getStickerPrinters());
            if (printerGroup == null) {
                printerAll.addAll(printers.getKitchenPrinters());
                return printerAll;
            }
            List<String> printerNames = printerGroup.getPrinterNames();
            List<Printer> kitchenPrinters = printers.getKitchenPrinters();
            for (Printer printer : kitchenPrinters) {
                if (!printerNames.contains(printer.getVirtualPrinter().getName())) continue;
                printerAll.add(printer);
            }
            return printerAll;
        }
    }
}

