/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.util;

import com.floreantpos.Messages;
import com.floreantpos.StoreAlreadyOpenException;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.SequenceNumber;
import com.floreantpos.model.Store;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.StoreSessionControl;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.SequenceNumberDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.StoreSessionControlDAO;
import com.floreantpos.model.dao.StoreSessionDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.POSUtil;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class StoreUtil {
    public static StoreSession getCurrentStoreSession() {
        return DataProvider.get().getStoreSession();
    }

    @Deprecated
    public static StoreSessionControl getCurrentStoreOperation() {
        return StoreSessionControlDAO.getInstance().getCurrent();
    }

    public static boolean isStoreOpen() {
        StoreSession currentStoreSession = StoreUtil.getCurrentStoreSession();
        return currentStoreSession != null && currentStoreSession.isOpen();
    }

    public static void openStore(User openByUser) {
        Outlet outlet = DataProvider.get().getOutlet();
        StoreUtil.openStore(openByUser, outlet == null ? null : outlet.getId());
    }

    public static void openStore(User openByUser, String outletId) {
        if (StoreUtil.isStoreOpen()) {
            throw new StoreAlreadyOpenException(Messages.getString("StoreUtil.0"));
        }
        StoreSession data = new StoreSession();
        data.setId(StoreUtil.generateGlobalId(0));
        data.setOpenedBy(openByUser);
        data.setOpenTime(new Date());
        data.setOutletId(outletId);
        SequenceNumber sequenceNumber = SequenceNumberDAO.getInstance().get("TICKET_TOKEN_NUMBER");
        if (sequenceNumber == null) {
            sequenceNumber = new SequenceNumber("TICKET_TOKEN_NUMBER");
        }
        Store store = DataProvider.get().getStore();
        boolean isResetToken = store.getBooleanProperty("reset.token", true);
        String startTokenNo = store.getProperty("token_no.start");
        Integer tokenNO = POSUtil.parseInteger(startTokenNo);
        if (isResetToken) {
            if (tokenNO > 0) {
                sequenceNumber.setNextSequenceNumber(tokenNO);
            } else {
                sequenceNumber.setNextSequenceNumber(1);
            }
        }
        StoreSessionDAO.getInstance().save(data);
        DataProvider.get().setStoreSession(data);
        StoreSessionControl storeOperation = StoreUtil.getCurrentStoreOperation();
        if (storeOperation != null) {
            storeOperation.setCurrentData(data);
        }
        TerminalDAO.getInstance().performBatchSave(sequenceNumber, storeOperation);
    }

    private static String generateGlobalId(Integer randomNumber) {
        String randomString = new DecimalFormat("000").format(randomNumber);
        String globalId = new SimpleDateFormat("ddMMyyyy").format(new Date()) + randomString;
        if (StoreSessionDAO.getInstance().get(globalId) == null) {
            return globalId;
        }
        return StoreUtil.generateGlobalId(randomNumber + 1);
    }

    public static void closeStore(User closeByUser) throws Exception {
        StoreDAO.getInstance().closeStore(closeByUser);
        StoreSessionControl storeOperation = StoreUtil.getCurrentStoreOperation();
        if (storeOperation != null) {
            storeOperation.setCurrentData(null);
            StoreSessionControlDAO.getInstance().update(storeOperation);
        }
    }
}

